/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestMiniYarnClusterNodeUtilization {
    private static final int NUM_RM = 1;
    private static final int NUM_NM = 1;
    private static final int CONTAINER_PMEM_1 = 1024;
    private static final int CONTAINER_VMEM_1 = 2048;
    private static final float CONTAINER_CPU_1 = 11.0f;
    private static final int NODE_PMEM_1 = 10240;
    private static final int NODE_VMEM_1 = 20480;
    private static final float NODE_CPU_1 = 51.0f;
    private static final int CONTAINER_PMEM_2 = 2048;
    private static final int CONTAINER_VMEM_2 = 4096;
    private static final float CONTAINER_CPU_2 = 22.0f;
    private static final int NODE_PMEM_2 = 20480;
    private static final int NODE_VMEM_2 = 40960;
    private static final float NODE_CPU_2 = 61.0f;
    private MiniYARNCluster cluster;
    private MiniYARNCluster.CustomNodeManager nm;
    private Configuration conf;
    private NodeStatus nodeStatus;

    @BeforeEach
    public void setup() {
        this.conf = new YarnConfiguration();
        this.conf.set("yarn.resourcemanager.webapp.address", "localhost:0");
        this.conf.setInt("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 100);
        this.conf.setBoolean("yarn.webapp.api-service.enable", false);
        String name = TestMiniYarnClusterNodeUtilization.class.getName();
        this.cluster = new MiniYARNCluster(name, 1, 1, 1, 1);
        this.cluster.init(this.conf);
        this.cluster.start();
        Assertions.assertFalse((-1 == this.cluster.getActiveRMIndex() ? 1 : 0) != 0, (String)"RM never turned active");
        this.nm = (MiniYARNCluster.CustomNodeManager)this.cluster.getNodeManager(0);
        this.nodeStatus = this.createNodeStatus(this.nm.getNMContext().getNodeId(), 0, 1024, 2048, 11.0f, 10240, 20480, 51.0f);
        this.nm.setNodeStatus(this.nodeStatus);
    }

    @Test
    @Timeout(value=60000L)
    void testUpdateNodeUtilization() throws InterruptedException, IOException, YarnException {
        Assertions.assertTrue((boolean)this.cluster.waitForNodeManagersToConnect(10000L), (String)"NMs fail to connect to the RM");
        this.verifySimulatedUtilization();
        this.nodeStatus = this.createNodeStatus(this.nm.getNMContext().getNodeId(), 0, 2048, 4096, 22.0f, 20480, 40960, 61.0f);
        this.nm.setNodeStatus(this.nodeStatus);
        this.verifySimulatedUtilization();
    }

    @Test
    @Timeout(value=60000L)
    void testMockNodeStatusHeartbeat() throws InterruptedException, YarnException {
        Assertions.assertTrue((boolean)this.cluster.waitForNodeManagersToConnect(10000L), (String)"NMs fail to connect to the RM");
        NodeStatusUpdater updater = this.nm.getNodeStatusUpdater();
        updater.sendOutofBandHeartBeat();
        this.verifySimulatedUtilization();
        this.nodeStatus = this.createNodeStatus(this.nm.getNMContext().getNodeId(), 0, 2048, 4096, 22.0f, 20480, 40960, 61.0f);
        this.nm.setNodeStatus(this.nodeStatus);
        updater.sendOutofBandHeartBeat();
        this.verifySimulatedUtilization();
    }

    private NodeStatus createNodeStatus(NodeId nodeId, int responseId, int containerPMem, int containerVMem, float containerCPU, int nodePMem, int nodeVMem, float nodeCPU) {
        ResourceUtilization containersUtilization = ResourceUtilization.newInstance((int)containerPMem, (int)containerVMem, (float)containerCPU);
        ResourceUtilization nodeUtilization = ResourceUtilization.newInstance((int)nodePMem, (int)nodeVMem, (float)nodeCPU);
        NodeStatus status = NodeStatus.newInstance((NodeId)nodeId, (int)responseId, new ArrayList(), null, (NodeHealthStatus)NodeHealthStatus.newInstance((boolean)true, null, (long)0L), (ResourceUtilization)containersUtilization, (ResourceUtilization)nodeUtilization, null);
        return status;
    }

    private void verifySimulatedUtilization() throws InterruptedException {
        ResourceManager rm = this.cluster.getResourceManager(0);
        RMContext rmContext = rm.getRMContext();
        ResourceUtilization containersUtilization = this.nodeStatus.getContainersUtilization();
        ResourceUtilization nodeUtilization = this.nodeStatus.getNodeUtilization();
        for (int i = 0; i < 100; ++i) {
            RMNode ni;
            Iterator iterator = rmContext.getRMNodes().values().iterator();
            while (iterator.hasNext() && ((ni = (RMNode)iterator.next()).getNodeUtilization() == null || !ni.getNodeUtilization().equals((Object)nodeUtilization))) {
            }
            Thread.sleep(100L);
        }
        for (RMNode ni : rmContext.getRMNodes().values()) {
            ResourceUtilization cu = ni.getAggregatedContainersUtilization();
            Assertions.assertEquals((Object)containersUtilization, (Object)cu, (String)"Containers Utillization not propagated to RMNode");
            ResourceUtilization nu = ni.getNodeUtilization();
            Assertions.assertEquals((Object)nodeUtilization, (Object)nu, (String)"Node Utillization not propagated to RMNode");
            SchedulerNode scheduler = rmContext.getScheduler().getSchedulerNode(ni.getNodeID());
            cu = scheduler.getAggregatedContainersUtilization();
            Assertions.assertEquals((Object)containersUtilization, (Object)cu, (String)"Containers Utillization not propagated to SchedulerNode");
            nu = scheduler.getNodeUtilization();
            Assertions.assertEquals((Object)nodeUtilization, (Object)nu, (String)"Node Utillization not propagated to SchedulerNode");
        }
    }
}

