/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.yarn.server.resourcemanager.placement.VariableContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleResult;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleResultType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.MappingRuleCreator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.schema.MappingRulesDescription;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.schema.Rule;
import org.assertj.core.util.Sets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestMappingRuleCreator {
    private static final String MATCH_ALL = "*";
    private static final String DEFAULT_QUEUE = "root.default";
    private static final String SECONDARY_GROUP = "users";
    private static final String PRIMARY_GROUP = "superuser";
    private static final String APPLICATION_NAME = "testapplication";
    private static final String SPECIFIED_QUEUE = "root.users.hadoop";
    private static final String USER_NAME = "testuser";
    private MappingRuleCreator ruleCreator;
    private VariableContext variableContext;
    private MappingRulesDescription description;
    private Rule rule;
    @org.junit.Rule
    public ExpectedException expected = ExpectedException.none();

    @Before
    public void setup() {
        this.ruleCreator = new MappingRuleCreator();
        this.prepareMappingRuleDescription();
        this.variableContext = new VariableContext();
        this.variableContext.put("%user", USER_NAME);
        this.variableContext.put("%specified", SPECIFIED_QUEUE);
        this.variableContext.put("%application", APPLICATION_NAME);
        this.variableContext.put("%primary_group", PRIMARY_GROUP);
        this.variableContext.put("%secondary_group", SECONDARY_GROUP);
        this.variableContext.put("%default", DEFAULT_QUEUE);
        this.variableContext.putExtraDataset("groups", (Set)Sets.newLinkedHashSet((Object[])new String[]{PRIMARY_GROUP, SECONDARY_GROUP}));
    }

    @Test
    public void testAllUserMatcher() {
        this.variableContext.put("%user", USER_NAME);
        this.verifyPlacementSucceeds(USER_NAME);
        this.variableContext.put("%user", "dummyuser");
        this.verifyPlacementSucceeds("dummyuser");
    }

    @Test
    public void testSpecificUserMatcherPasses() {
        this.rule.setMatches(USER_NAME);
        this.verifyPlacementSucceeds(USER_NAME);
    }

    @Test
    public void testSpecificUserMatcherFails() {
        this.rule.setMatches(USER_NAME);
        this.variableContext.put("%user", "dummyuser");
        this.verifyNoPlacementOccurs();
    }

    @Test
    public void testSpecificGroupMatcher() {
        this.rule.setMatches(PRIMARY_GROUP);
        this.rule.setType(Rule.Type.GROUP);
        this.verifyPlacementSucceeds();
    }

    @Test
    public void testAllGroupMatcherFailsDueToMatchString() {
        this.rule.setType(Rule.Type.GROUP);
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Cannot match '*' for groups");
        this.ruleCreator.getMappingRules(this.description);
    }

    @Test
    public void testApplicationNameMatcherPasses() {
        this.rule.setType(Rule.Type.APPLICATION);
        this.rule.setMatches(APPLICATION_NAME);
        this.verifyPlacementSucceeds();
    }

    @Test
    public void testApplicationNameMatcherFails() {
        this.rule.setType(Rule.Type.APPLICATION);
        this.rule.setMatches("dummyApplication");
        this.verifyNoPlacementOccurs();
    }

    @Test
    public void testDefaultRule() {
        this.rule.setPolicy(Rule.Policy.DEFAULT_QUEUE);
        this.verifyPlacementSucceeds(DEFAULT_QUEUE, false);
    }

    @Test
    public void testSpecifiedRule() {
        this.rule.setPolicy(Rule.Policy.SPECIFIED);
        this.verifyPlacementSucceeds(SPECIFIED_QUEUE);
    }

    @Test
    public void testSpecifiedRuleWithNoCreate() {
        this.rule.setPolicy(Rule.Policy.SPECIFIED);
        this.rule.setCreate(Boolean.valueOf(false));
        this.verifyPlacementSucceeds(SPECIFIED_QUEUE, false);
    }

    @Test
    public void testRejectRule() {
        this.rule.setPolicy(Rule.Policy.REJECT);
        this.verifyPlacementRejected();
    }

    @Test
    public void testSetDefaultRule() {
        this.rule.setPolicy(Rule.Policy.SET_DEFAULT_QUEUE);
        this.rule.setValue("root.users.default");
        this.verifyNoPlacementOccurs();
        Assert.assertEquals((String)"Default queue", (Object)"root.users.default", (Object)this.variableContext.get("%default"));
    }

    @Test
    public void testSetDefaultRuleWithMissingQueue() {
        this.rule.setPolicy(Rule.Policy.SET_DEFAULT_QUEUE);
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("default queue is undefined");
        this.ruleCreator.getMappingRules(this.description);
    }

    @Test
    public void testPrimaryGroupRule() {
        this.rule.setPolicy(Rule.Policy.PRIMARY_GROUP);
        this.verifyPlacementSucceeds(PRIMARY_GROUP);
    }

    @Test
    public void testPrimaryGroupRuleWithNoCreate() {
        this.rule.setPolicy(Rule.Policy.PRIMARY_GROUP);
        this.rule.setCreate(Boolean.valueOf(false));
        this.verifyPlacementSucceeds(PRIMARY_GROUP, false);
    }

    @Test
    public void testPrimaryGroupRuleWithParent() {
        this.rule.setPolicy(Rule.Policy.PRIMARY_GROUP);
        this.rule.setParentQueue("root");
        this.verifyPlacementSucceeds("root.superuser");
    }

    @Test
    public void testSecondaryGroupRule() {
        this.rule.setPolicy(Rule.Policy.SECONDARY_GROUP);
        this.verifyPlacementSucceeds(SECONDARY_GROUP);
    }

    @Test
    public void testSecondaryGroupRuleWithNoCreate() {
        this.rule.setPolicy(Rule.Policy.SECONDARY_GROUP);
        this.rule.setCreate(Boolean.valueOf(false));
        this.verifyPlacementSucceeds(SECONDARY_GROUP, false);
    }

    @Test
    public void testSecondaryGroupRuleWithParent() {
        this.rule.setPolicy(Rule.Policy.SECONDARY_GROUP);
        this.rule.setParentQueue("root");
        this.verifyPlacementSucceeds("root.users");
    }

    @Test
    public void testUserRule() {
        this.rule.setPolicy(Rule.Policy.USER);
        this.verifyPlacementSucceeds(USER_NAME);
    }

    @Test
    public void testUserRuleWithParent() {
        this.rule.setPolicy(Rule.Policy.USER);
        this.rule.setParentQueue("root.users");
        this.verifyPlacementSucceeds("root.users.testuser");
    }

    @Test
    public void testCustomRule() {
        this.rule.setPolicy(Rule.Policy.CUSTOM);
        this.rule.setCustomPlacement("root.%primary_group.%secondary_group");
        this.verifyPlacementSucceeds(String.format("root.%s.%s", PRIMARY_GROUP, SECONDARY_GROUP));
    }

    @Test
    public void testCustomRuleWithNoCreate() {
        this.rule.setPolicy(Rule.Policy.CUSTOM);
        this.rule.setCustomPlacement("root.%primary_group.%secondary_group");
        this.rule.setCreate(Boolean.valueOf(false));
        this.verifyPlacementSucceeds(String.format("root.%s.%s", PRIMARY_GROUP, SECONDARY_GROUP), false);
    }

    @Test
    public void testCustomRuleWithMissingQueue() {
        this.rule.setPolicy(Rule.Policy.CUSTOM);
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("custom queue is undefined");
        this.ruleCreator.getMappingRules(this.description);
    }

    @Test
    public void testPrimaryGroupUserRule() {
        this.rule.setPolicy(Rule.Policy.PRIMARY_GROUP_USER);
        this.verifyPlacementSucceeds("superuser.testuser");
    }

    @Test
    public void testPrimaryGroupUserRuleWithNoCreate() {
        this.rule.setPolicy(Rule.Policy.PRIMARY_GROUP_USER);
        this.rule.setCreate(Boolean.valueOf(false));
        this.verifyPlacementSucceeds("superuser.testuser", false);
    }

    @Test
    public void testPrimaryGroupNestedRuleWithParent() {
        this.rule.setPolicy(Rule.Policy.PRIMARY_GROUP_USER);
        this.rule.setParentQueue("root");
        this.verifyPlacementSucceeds("root.superuser.testuser");
    }

    @Test
    public void testSecondaryGroupNestedRule() {
        this.rule.setPolicy(Rule.Policy.SECONDARY_GROUP_USER);
        this.verifyPlacementSucceeds("users.testuser");
    }

    @Test
    public void testSecondaryGroupNestedRuleWithNoCreate() {
        this.rule.setPolicy(Rule.Policy.SECONDARY_GROUP_USER);
        this.rule.setCreate(Boolean.valueOf(false));
        this.verifyPlacementSucceeds("users.testuser", false);
    }

    @Test
    public void testSecondaryGroupNestedRuleWithParent() {
        this.rule.setPolicy(Rule.Policy.SECONDARY_GROUP_USER);
        this.rule.setParentQueue("root");
        this.verifyPlacementSucceeds("root.users.testuser");
    }

    @Test
    public void testApplicationNamePlacement() {
        this.rule.setPolicy(Rule.Policy.APPLICATION_NAME);
        this.verifyPlacementSucceeds(APPLICATION_NAME);
    }

    @Test
    public void testApplicationNamePlacementWithParent() {
        this.rule.setPolicy(Rule.Policy.APPLICATION_NAME);
        this.rule.setParentQueue("root.applications");
        this.verifyPlacementSucceeds("root.applications.testapplication");
    }

    @Test
    public void testDefaultQueueFallback() {
        this.rule.setFallbackResult(Rule.FallbackResult.PLACE_DEFAULT);
        this.testFallback(MappingRuleResultType.PLACE_TO_DEFAULT);
    }

    @Test
    public void testRejectFallback() {
        this.rule.setFallbackResult(Rule.FallbackResult.REJECT);
        this.testFallback(MappingRuleResultType.REJECT);
    }

    @Test
    public void testSkipFallback() {
        this.rule.setFallbackResult(Rule.FallbackResult.SKIP);
        this.testFallback(MappingRuleResultType.SKIP);
    }

    private void testFallback(MappingRuleResultType expectedType) {
        List rules = this.ruleCreator.getMappingRules(this.description);
        MappingRule mpr = (MappingRule)rules.get(0);
        Assert.assertEquals((String)"Fallback result", (Object)expectedType, (Object)mpr.getFallback().getResult());
    }

    @Test
    public void testFallbackResultUnset() {
        this.rule.setFallbackResult(null);
        List rules = this.ruleCreator.getMappingRules(this.description);
        MappingRule mpr = (MappingRule)rules.get(0);
        Assert.assertEquals((String)"Fallback result", (Object)MappingRuleResultType.SKIP, (Object)mpr.getFallback().getResult());
    }

    @Test
    public void testTypeUnset() {
        this.rule.setType(null);
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Rule type is undefined");
        this.ruleCreator.getMappingRules(this.description);
    }

    @Test
    public void testMatchesUnset() {
        this.rule.setMatches(null);
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Match string is undefined");
        this.ruleCreator.getMappingRules(this.description);
    }

    @Test
    public void testMatchesEmpty() {
        this.rule.setMatches("");
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Match string is empty");
        this.ruleCreator.getMappingRules(this.description);
    }

    @Test
    public void testPolicyUnset() {
        this.rule.setPolicy(null);
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Rule policy is undefined");
        this.ruleCreator.getMappingRules(this.description);
    }

    private void prepareMappingRuleDescription() {
        this.description = new MappingRulesDescription();
        this.rule = new Rule();
        this.rule.setType(Rule.Type.USER);
        this.rule.setFallbackResult(Rule.FallbackResult.SKIP);
        this.rule.setPolicy(Rule.Policy.USER);
        this.rule.setMatches(MATCH_ALL);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule);
        this.description.setRules(rules);
    }

    private void verifyPlacementSucceeds() {
        this.verifyPlacement(MappingRuleResultType.PLACE, null, true);
    }

    private void verifyPlacementSucceeds(String expectedQueue) {
        this.verifyPlacement(MappingRuleResultType.PLACE, expectedQueue, true);
    }

    private void verifyPlacementSucceeds(String expectedQueue, boolean allowCreate) {
        this.verifyPlacement(MappingRuleResultType.PLACE, expectedQueue, allowCreate);
    }

    private void verifyPlacementRejected() {
        this.verifyPlacement(MappingRuleResultType.REJECT, null, true);
    }

    private void verifyNoPlacementOccurs() {
        this.verifyPlacement(null, null, true);
    }

    private void verifyPlacement(MappingRuleResultType expectedResultType, String expectedQueue, boolean allowCreate) {
        List rules = this.ruleCreator.getMappingRules(this.description);
        Assert.assertEquals((String)"Number of rules", (long)1L, (long)rules.size());
        MappingRule mpr = (MappingRule)rules.get(0);
        MappingRuleResult result = mpr.evaluate(this.variableContext);
        Assert.assertEquals((String)"Create flag", (Object)allowCreate, (Object)result.isCreateAllowed());
        if (expectedResultType != null) {
            Assert.assertEquals((String)"Mapping rule result", (Object)expectedResultType, (Object)result.getResult());
        } else {
            Assert.assertEquals((String)"Mapping rule result", (Object)MappingRuleResultType.SKIP, (Object)result.getResult());
        }
        if (expectedQueue != null) {
            Assert.assertEquals((String)"Evaluated queue", (Object)expectedQueue, (Object)result.getQueue());
        }
    }
}

