/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueCalculationTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueAssertionBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Test;

public class TestUniformQueueResourceCalculation
extends CapacitySchedulerQueueCalculationTestBase {
    private static final Resource QUEUE_A_RES = Resource.newInstance((int)81920, (int)10);
    private static final Resource QUEUE_B_RES = Resource.newInstance((int)174080, (int)30);
    private static final Resource QUEUE_A1_RES = Resource.newInstance((int)51200, (int)4);
    private static final Resource QUEUE_A2_RES = Resource.newInstance((int)30720, (int)6);
    private static final Resource QUEUE_A11_RES = Resource.newInstance((int)40960, (int)2);
    private static final Resource QUEUE_A12_RES = Resource.newInstance((int)10240, (int)2);
    private static final Resource UPDATE_RES = Resource.newInstance((int)256000, (int)40);
    private static final Resource PERCENTAGE_ALL_RES = Resource.newInstance((int)10240, (int)20);
    public static final double A_CAPACITY = 0.3;
    public static final double B_CAPACITY = 0.7;
    public static final double A1_CAPACITY = 0.17;
    public static final double A11_CAPACITY = 0.25;
    public static final double A12_CAPACITY = 0.75;
    public static final double A2_CAPACITY = 0.83;
    public static final float A_WEIGHT = 3.0f;
    public static final float B_WEIGHT = 6.0f;
    public static final float A1_WEIGHT = 2.0f;
    public static final float A11_WEIGHT = 5.0f;
    public static final float A12_WEIGHT = 8.0f;
    public static final float A2_WEIGHT = 3.0f;
    public static final double A_NORMALIZED_WEIGHT = 0.3333333432674408;
    public static final double B_NORMALIZED_WEIGHT = 0.6666666865348816;
    public static final double A1_NORMALIZED_WEIGHT = (double)0.4f;
    public static final double A2_NORMALIZED_WEIGHT = (double)0.6f;
    public static final double A11_NORMALIZED_WEIGHT = (double)0.3846154f;
    public static final double A12_NORMALIZED_WEIGHT = 0.6153846383094788;

    @Test
    public void testWeightResourceCalculation() throws IOException {
        this.csConf.setNonLabeledQueueWeight("root.a", 3.0f);
        this.csConf.setNonLabeledQueueWeight("root.b", 6.0f);
        this.csConf.setNonLabeledQueueWeight("root.a.a1", 2.0f);
        this.csConf.setNonLabeledQueueWeight("root.a.a1.a11", 5.0f);
        this.csConf.setNonLabeledQueueWeight("root.a.a1.a12", 8.0f);
        this.csConf.setNonLabeledQueueWeight("root.a.a2", 3.0f);
        QueueAssertionBuilder queueAssertionBuilder = this.createAssertionBuilder().withQueue("root.a").assertEffectiveMinResource(ResourceUtils.multiplyRound((Resource)UPDATE_RES, (double)0.3333333432674408)).assertAbsoluteCapacity(0.3333333432674408).withQueue("root.b").assertEffectiveMinResource(ResourceUtils.multiplyRound((Resource)UPDATE_RES, (double)0.6666666865348816)).assertAbsoluteCapacity(0.6666666865348816).withQueue("root.a.a1").assertEffectiveMinResource(ResourceUtils.multiplyRound((Resource)UPDATE_RES, (double)0.13333333929379787)).assertAbsoluteCapacity(0.13333333929379787).withQueue("root.a.a2").assertEffectiveMinResource(ResourceUtils.multiplyRound((Resource)UPDATE_RES, (double)0.20000001390775068)).assertAbsoluteCapacity(0.20000001390775068).withQueue("root.a.a1.a11").assertEffectiveMinResource(ResourceUtils.multiplyRound((Resource)UPDATE_RES, (double)0.05128205449153222)).assertAbsoluteCapacity(0.05128205449153222).withQueue("root.a.a1.a12").assertEffectiveMinResource(ResourceUtils.multiplyRound((Resource)UPDATE_RES, (double)0.08205128877590881)).assertAbsoluteCapacity(0.08205128877590881).build();
        this.update(queueAssertionBuilder, UPDATE_RES);
    }

    @Test
    public void testPercentageResourceCalculation() throws IOException {
        this.csConf.setCapacity("root.a", 30.0f);
        this.csConf.setCapacity("root.b", 70.0f);
        this.csConf.setCapacity("root.a.a1", 17.0f);
        this.csConf.setCapacity("root.a.a1.a11", 25.0f);
        this.csConf.setCapacity("root.a.a1.a12", 75.0f);
        this.csConf.setCapacity("root.a.a2", 83.0f);
        QueueAssertionBuilder queueAssertionBuilder = this.createAssertionBuilder().withQueue("root.a").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)PERCENTAGE_ALL_RES, (double)0.3)).assertCapacity(0.3).assertAbsoluteCapacity(0.3).withQueue("root.b").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)PERCENTAGE_ALL_RES, (double)0.7)).assertCapacity(0.7).assertAbsoluteCapacity(0.7).withQueue("root.a.a1").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)PERCENTAGE_ALL_RES, (double)0.051000000000000004)).assertCapacity(0.17).assertAbsoluteCapacity(0.051000000000000004).withQueue("root.a.a2").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)PERCENTAGE_ALL_RES, (double)0.24899999999999997)).assertCapacity(0.83).assertAbsoluteCapacity(0.24899999999999997).withQueue("root.a.a1.a11").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)PERCENTAGE_ALL_RES, (double)0.012750000000000001)).assertCapacity(0.25).assertAbsoluteCapacity(0.012750000000000001).withQueue("root.a.a1.a12").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)PERCENTAGE_ALL_RES, (double)0.03825)).assertCapacity(0.75).assertAbsoluteCapacity(0.03825).build();
        this.update(queueAssertionBuilder, PERCENTAGE_ALL_RES);
    }

    @Test
    public void testAbsoluteResourceCalculation() throws IOException {
        this.csConf.setMinimumResourceRequirement("", new QueuePath("root.a"), QUEUE_A_RES);
        this.csConf.setMinimumResourceRequirement("", new QueuePath("root.b"), QUEUE_B_RES);
        this.csConf.setMinimumResourceRequirement("", new QueuePath("root.a.a1"), QUEUE_A1_RES);
        this.csConf.setMinimumResourceRequirement("", new QueuePath("root.a.a2"), QUEUE_A2_RES);
        this.csConf.setMinimumResourceRequirement("", new QueuePath("root.a.a1.a11"), QUEUE_A11_RES);
        this.csConf.setMinimumResourceRequirement("", new QueuePath("root.a.a1.a12"), QUEUE_A12_RES);
        QueueAssertionBuilder queueAssertionBuilder = this.createAssertionBuilder().withQueue("root.a").assertEffectiveMinResource(QUEUE_A_RES).withQueue("root.b").assertEffectiveMinResource(QUEUE_B_RES).withQueue("root.a.a1").assertEffectiveMinResource(QUEUE_A1_RES).withQueue("root.a.a2").assertEffectiveMinResource(QUEUE_A2_RES).withQueue("root.a.a1.a11").assertEffectiveMinResource(QUEUE_A11_RES).withQueue("root.a.a1.a12").assertEffectiveMinResource(QUEUE_A12_RES).build();
        this.update(queueAssertionBuilder, UPDATE_RES);
        QueueAssertionBuilder queueAssertionHalfClusterResource = this.createAssertionBuilder().withQueue("root.a").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)QUEUE_A_RES, (double)0.5)).withQueue("root.b").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)QUEUE_B_RES, (double)0.5)).withQueue("root.a.a1").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)QUEUE_A1_RES, (double)0.5)).withQueue("root.a.a2").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)QUEUE_A2_RES, (double)0.5)).withQueue("root.a.a1.a11").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)QUEUE_A11_RES, (double)0.5)).withQueue("root.a.a1.a12").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)QUEUE_A12_RES, (double)0.5)).build();
        this.update(queueAssertionHalfClusterResource, ResourceUtils.multiplyFloor((Resource)UPDATE_RES, (double)0.5));
    }
}

