/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.PriorityUtilizationQueueOrderingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestQueueParsing {
    private static final Logger LOG = LoggerFactory.getLogger(TestQueueParsing.class);
    private static final double DELTA = 0.001;
    private static final int GB = 1024;
    private RMNodeLabelsManager nodeLabelManager;

    @Before
    public void setup() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        Resource clusterResource = Resources.createResource((int)16384, (int)32);
        this.nodeLabelManager = new NullRMNodeLabelsManager();
        this.nodeLabelManager.init((Configuration)conf);
        ((NullRMNodeLabelsManager)this.nodeLabelManager).setResourceForLabel("", clusterResource);
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b", "c"});
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 20.0f);
        String C = "root.c";
        conf.setCapacity("root.c", 70.0f);
        conf.setMaximumCapacity("root.c", 70.0f);
        LOG.info("Setup top-level queues");
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setMaximumCapacity("root.a.a1", 45.0f);
        conf.setCapacity("root.a.a2", 70.0f);
        conf.setMaximumCapacity("root.a.a2", 85.0f);
        String B1 = "root.b.b1";
        String B2 = "root.b.b2";
        String B3 = "root.b.b3";
        conf.setQueues("root.b", new String[]{"b1", "b2", "b3"});
        conf.setCapacity("root.b.b1", 50.0f);
        conf.setMaximumCapacity("root.b.b1", 85.0f);
        conf.setCapacity("root.b.b2", 30.0f);
        conf.setMaximumCapacity("root.b.b2", 35.0f);
        conf.setCapacity("root.b.b3", 20.0f);
        conf.setMaximumCapacity("root.b.b3", 35.0f);
        String C1 = "root.c.c1";
        String C2 = "root.c.c2";
        String C3 = "root.c.c3";
        String C4 = "root.c.c4";
        conf.setQueues("root.c", new String[]{"c1", "c2", "c3", "c4"});
        conf.setCapacity("root.c.c1", 50.0f);
        conf.setMaximumCapacity("root.c.c1", 55.0f);
        conf.setCapacity("root.c.c2", 10.0f);
        conf.setMaximumCapacity("root.c.c2", 25.0f);
        conf.setCapacity("root.c.c3", 35.0f);
        conf.setMaximumCapacity("root.c.c3", 38.0f);
        conf.setCapacity("root.c.c4", 5.0f);
        conf.setMaximumCapacity("root.c.c4", 5.0f);
        LOG.info("Setup 2nd-level queues");
        String C11 = "root.c.c1.c11";
        String C12 = "root.c.c1.c12";
        String C13 = "root.c.c1.c13";
        conf.setQueues("root.c.c1", new String[]{"c11", "c12", "c13"});
        conf.setCapacity("root.c.c1.c11", 15.0f);
        conf.setMaximumCapacity("root.c.c1.c11", 30.0f);
        conf.setCapacity("root.c.c1.c12", 45.0f);
        conf.setMaximumCapacity("root.c.c1.c12", 70.0f);
        conf.setCapacity("root.c.c1.c13", 40.0f);
        conf.setMaximumCapacity("root.c.c1.c13", 40.0f);
        LOG.info("Setup 3rd-level queues");
    }

    private void setupQueueConfigurationWithSpacesShouldBeTrimmed(CapacitySchedulerConfiguration conf) {
        conf.set(CapacitySchedulerConfiguration.getQueuePrefix((String)"root") + "queues", " a ,b, c");
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 20.0f);
        String C = "root.c";
        conf.setCapacity("root.c", 70.0f);
        conf.setMaximumCapacity("root.c", 70.0f);
    }

    private void setupNestedQueueConfigurationWithSpacesShouldBeTrimmed(CapacitySchedulerConfiguration conf) {
        conf.set(CapacitySchedulerConfiguration.getQueuePrefix((String)"root") + "queues", " a ,b, c");
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 20.0f);
        String C = "root.c";
        conf.setCapacity("root.c", 70.0f);
        conf.setMaximumCapacity("root.c", 70.0f);
        conf.set(CapacitySchedulerConfiguration.getQueuePrefix((String)"root.a") + "queues", "a1, a2 ");
        String A1 = "root.a.a1";
        conf.setCapacity("root.a.a1", 60.0f);
        String A2 = "root.a.a2";
        conf.setCapacity("root.a.a2", 40.0f);
    }

    private void setupQueueConfigurationWithoutLabels(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 90.0f);
        LOG.info("Setup top-level queues");
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setMaximumCapacity("root.a.a1", 45.0f);
        conf.setCapacity("root.a.a2", 70.0f);
        conf.setMaximumCapacity("root.a.a2", 85.0f);
        String B1 = "root.b.b1";
        String B2 = "root.b.b2";
        String B3 = "root.b.b3";
        conf.setQueues("root.b", new String[]{"b1", "b2", "b3"});
        conf.setCapacity("root.b.b1", 50.0f);
        conf.setMaximumCapacity("root.b.b1", 85.0f);
        conf.setCapacity("root.b.b2", 30.0f);
        conf.setMaximumCapacity("root.b.b2", 35.0f);
        conf.setCapacity("root.b.b3", 20.0f);
        conf.setMaximumCapacity("root.b.b3", 35.0f);
    }

    private void setupQueueConfigurationWithLabels(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        conf.setCapacityByLabel("root", "red", 100.0f);
        conf.setCapacityByLabel("root", "blue", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 90.0f);
        LOG.info("Setup top-level queues");
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setAccessibleNodeLabels("root.a", (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel("root.a", "red", 50.0f);
        conf.setMaximumCapacityByLabel("root.a", "red", 50.0f);
        conf.setCapacityByLabel("root.a", "blue", 50.0f);
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setMaximumCapacity("root.a.a1", 45.0f);
        conf.setCapacityByLabel("root.a.a1", "red", 50.0f);
        conf.setCapacityByLabel("root.a.a1", "blue", 100.0f);
        conf.setCapacity("root.a.a2", 70.0f);
        conf.setMaximumCapacity("root.a.a2", 85.0f);
        conf.setAccessibleNodeLabels("root.a.a2", (Set)ImmutableSet.of((Object)"red"));
        conf.setCapacityByLabel("root.a.a2", "red", 50.0f);
        conf.setMaximumCapacityByLabel("root.a.a2", "red", 60.0f);
        String B1 = "root.b.b1";
        String B2 = "root.b.b2";
        String B3 = "root.b.b3";
        conf.setQueues("root.b", new String[]{"b1", "b2", "b3"});
        conf.setAccessibleNodeLabels("root.b", (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel("root.b", "red", 50.0f);
        conf.setCapacityByLabel("root.b", "blue", 50.0f);
        conf.setCapacity("root.b.b1", 50.0f);
        conf.setMaximumCapacity("root.b.b1", 85.0f);
        conf.setCapacityByLabel("root.b.b1", "red", 50.0f);
        conf.setCapacityByLabel("root.b.b1", "blue", 50.0f);
        conf.setCapacity("root.b.b2", 30.0f);
        conf.setMaximumCapacity("root.b.b2", 35.0f);
        conf.setCapacityByLabel("root.b.b2", "red", 25.0f);
        conf.setCapacityByLabel("root.b.b2", "blue", 25.0f);
        conf.setCapacity("root.b.b3", 20.0f);
        conf.setMaximumCapacity("root.b.b3", 35.0f);
        conf.setCapacityByLabel("root.b.b3", "red", 25.0f);
        conf.setCapacityByLabel("root.b.b3", "blue", 25.0f);
    }

    private void setupQueueConfigurationWithLabelsAndReleaseCheck(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        conf.setCapacityByLabel("root", "red", 100.0f);
        conf.setCapacityByLabel("root", "blue", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 50.0f);
        conf.setMaximumCapacity("root.a", 100.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 50.0f);
        conf.setMaximumCapacity("root.b", 100.0f);
        LOG.info("Setup top-level queues");
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setAccessibleNodeLabels("root.a", (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel("root.a", "red", 50.0f);
        conf.setMaximumCapacityByLabel("root.a", "red", 100.0f);
        conf.setCapacityByLabel("root.a", "blue", 30.0f);
        conf.setMaximumCapacityByLabel("root.a", "blue", 50.0f);
        conf.setCapacity("root.a.a1", 60.0f);
        conf.setMaximumCapacity("root.a.a1", 60.0f);
        conf.setCapacityByLabel("root.a.a1", "red", 60.0f);
        conf.setMaximumCapacityByLabel("root.a.a1", "red", 30.0f);
        conf.setCapacityByLabel("root.a.a1", "blue", 100.0f);
        conf.setMaximumCapacityByLabel("root.a.a1", "blue", 100.0f);
        conf.setCapacity("root.a.a2", 40.0f);
        conf.setMaximumCapacity("root.a.a2", 85.0f);
        conf.setAccessibleNodeLabels("root.a.a2", (Set)ImmutableSet.of((Object)"red"));
        conf.setCapacityByLabel("root.a.a2", "red", 40.0f);
        conf.setMaximumCapacityByLabel("root.a.a2", "red", 60.0f);
        String B1 = "root.b.b1";
        String B2 = "root.b.b2";
        String B3 = "root.b.b3";
        conf.setQueues("root.b", new String[]{"b1", "b2", "b3"});
        conf.setAccessibleNodeLabels("root.b", (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel("root.b", "red", 50.0f);
        conf.setMaximumCapacityByLabel("root.b", "red", 100.0f);
        conf.setCapacityByLabel("root.b", "blue", 70.0f);
        conf.setMaximumCapacityByLabel("root.b", "blue", 100.0f);
        conf.setCapacity("root.b.b1", 10.0f);
        conf.setMaximumCapacity("root.b.b1", 10.0f);
        conf.setCapacityByLabel("root.b.b1", "red", 60.0f);
        conf.setMaximumCapacityByLabel("root.b.b1", "red", 30.0f);
        conf.setCapacityByLabel("root.b.b1", "blue", 50.0f);
        conf.setMaximumCapacityByLabel("root.b.b1", "blue", 100.0f);
        conf.setCapacity("root.b.b2", 80.0f);
        conf.setMaximumCapacity("root.b.b2", 40.0f);
        conf.setCapacityByLabel("root.b.b2", "red", 30.0f);
        conf.setCapacityByLabel("root.b.b2", "blue", 25.0f);
        conf.setCapacity("root.b.b3", 10.0f);
        conf.setMaximumCapacity("root.b.b3", 25.0f);
        conf.setCapacityByLabel("root.b.b3", "red", 10.0f);
        conf.setCapacityByLabel("root.b.b3", "blue", 25.0f);
    }

    private void setupQueueConfigurationWithLabelsInherit(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        conf.setCapacityByLabel("root", "red", 100.0f);
        conf.setCapacityByLabel("root", "blue", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setAccessibleNodeLabels("root.a", (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel("root.a", "red", 100.0f);
        conf.setCapacityByLabel("root.a", "blue", 100.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 90.0f);
        conf.setAccessibleNodeLabels("root.b", CommonNodeLabelsManager.EMPTY_STRING_SET);
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setMaximumCapacity("root.a.a1", 45.0f);
        conf.setCapacityByLabel("root.a.a1", "red", 50.0f);
        conf.setCapacityByLabel("root.a.a1", "blue", 100.0f);
        conf.setCapacity("root.a.a2", 70.0f);
        conf.setMaximumCapacity("root.a.a2", 85.0f);
        conf.setAccessibleNodeLabels("root.a.a2", (Set)ImmutableSet.of((Object)"red"));
        conf.setCapacityByLabel("root.a.a2", "red", 50.0f);
    }

    private void setupQueueConfigurationWithSingleLevel(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        conf.setAccessibleNodeLabels("root.a", (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel("root.a", "red", 90.0f);
        conf.setCapacityByLabel("root.a", "blue", 90.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 90.0f);
        conf.setAccessibleNodeLabels("root.b", (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel("root.b", "red", 10.0f);
        conf.setCapacityByLabel("root.b", "blue", 10.0f);
    }

    public MockRM createMockRMWithoutLabels(YarnConfiguration conf) throws Exception {
        return this.createMockRMWithLabels(conf, Collections.emptySet());
    }

    public MockRM createMockRMWithLabels(YarnConfiguration conf, Set<String> nodeLabels) throws Exception {
        this.nodeLabelManager.addToCluserNodeLabelsWithDefaultExclusivity(nodeLabels);
        HashMap<NodeId, Set<String>> nodeIdMap = new HashMap<NodeId, Set<String>>();
        int i = 0;
        for (String label : nodeLabels) {
            nodeIdMap.put(NodeId.newInstance((String)("h" + ++i), (int)0), TestUtils.toSet(label));
        }
        this.nodeLabelManager.addLabelsToNode(nodeIdMap);
        MockRM rm = new MockRM((Configuration)conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return TestQueueParsing.this.nodeLabelManager;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.nodeLabelManager);
        rm.start();
        for (NodeId key : nodeIdMap.keySet()) {
            rm.registerNode(key.toString(), 8192);
        }
        return rm;
    }

    @Test
    public void testQueueParsing() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue a = capacityScheduler.getQueue("a");
        Assert.assertEquals((double)0.1, (double)a.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.15, (double)a.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue b1 = capacityScheduler.getQueue("b1");
        Assert.assertEquals((double)0.1, (double)b1.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((String)"Parent B has no MAX_CAP", (double)0.85, (double)b1.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue c12 = capacityScheduler.getQueue("c12");
        Assert.assertEquals((double)0.1575, (double)c12.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.26949999999999996, (double)c12.getAbsoluteMaximumCapacity(), (double)0.001);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRootQueueParsing() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setCapacity("root", 90.0f);
    }

    @Test
    public void testQueueParsingReinitializeWithLabels() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithoutLabels(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabels(csConf);
        conf = new YarnConfiguration((Configuration)csConf);
        capacityScheduler.reinitialize((Configuration)conf, rm.getRMContext());
        this.checkQueueLabels(capacityScheduler);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueParsingWithLabels() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabels(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        this.checkQueueLabels(capacityScheduler);
        ServiceOperations.stopQuietly((Service)rm);
    }

    private void checkQueueLabels(CapacityScheduler capacityScheduler) {
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a1").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertEquals((long)1L, (long)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().size());
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().contains("red"));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("b").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("b2").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        CSQueue qA2 = capacityScheduler.getQueue("a2");
        Assert.assertEquals((double)0.7, (double)qA2.getCapacity(), (double)0.001);
        Assert.assertEquals((double)0.5, (double)qA2.getQueueCapacities().getCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.07, (double)qA2.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.25, (double)qA2.getQueueCapacities().getAbsoluteCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.1275, (double)qA2.getAbsoluteMaximumCapacity(), (double)0.001);
        Assert.assertEquals((double)0.3, (double)qA2.getQueueCapacities().getAbsoluteMaximumCapacity("red"), (double)0.001);
        CSQueue qB3 = capacityScheduler.getQueue("b3");
        Assert.assertEquals((double)0.18, (double)qB3.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.125, (double)qB3.getQueueCapacities().getAbsoluteCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.35, (double)qB3.getAbsoluteMaximumCapacity(), (double)0.001);
        Assert.assertEquals((double)1.0, (double)qB3.getQueueCapacities().getAbsoluteMaximumCapacity("red"), (double)0.001);
    }

    @Test
    public void testQueueParsingWithLeafQueueDisableElasticity() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabelsAndReleaseCheck(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        this.checkQueueLabelsWithLeafQueueDisableElasticity(capacityScheduler);
        ServiceOperations.stopQuietly((Service)rm);
    }

    private void checkQueueLabelsWithLeafQueueDisableElasticity(CapacityScheduler capacityScheduler) {
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a1").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertEquals((long)1L, (long)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().size());
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().contains("red"));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("b").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("b2").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        CSQueue qA2 = capacityScheduler.getQueue("a2");
        Assert.assertEquals((double)0.4, (double)qA2.getCapacity(), (double)0.001);
        Assert.assertEquals((double)0.4, (double)qA2.getQueueCapacities().getCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.2, (double)qA2.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.2, (double)qA2.getQueueCapacities().getAbsoluteCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.85, (double)qA2.getAbsoluteMaximumCapacity(), (double)0.001);
        Assert.assertEquals((double)0.6, (double)qA2.getQueueCapacities().getAbsoluteMaximumCapacity("red"), (double)0.001);
        CSQueue qB2 = capacityScheduler.getQueue("b2");
        Assert.assertEquals((double)0.4, (double)qB2.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.4, (double)qB2.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue qA1 = capacityScheduler.getQueue("a1");
        Assert.assertEquals((double)0.3, (double)qA1.getQueueCapacities().getAbsoluteCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.3, (double)qA1.getQueueCapacities().getAbsoluteMaximumCapacity("red"), (double)0.001);
        CSQueue qB1 = capacityScheduler.getQueue("b1");
        Assert.assertEquals((double)0.3, (double)qB1.getQueueCapacities().getAbsoluteCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.3, (double)qB1.getQueueCapacities().getAbsoluteMaximumCapacity("red"), (double)0.001);
        CSQueue qB3 = capacityScheduler.getQueue("b3");
        Assert.assertEquals((double)0.05, (double)qB3.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.175, (double)qB3.getQueueCapacities().getAbsoluteCapacity("blue"), (double)0.001);
        Assert.assertEquals((double)0.25, (double)qB3.getAbsoluteMaximumCapacity(), (double)0.001);
        Assert.assertEquals((double)1.0, (double)qB3.getQueueCapacities().getAbsoluteMaximumCapacity("blue"), (double)0.001);
    }

    @Test
    public void testQueueParsingWithLabelsInherit() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabelsInherit(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        this.checkQueueLabelsInheritConfig(capacityScheduler);
        ServiceOperations.stopQuietly((Service)rm);
    }

    private void checkQueueLabelsInheritConfig(CapacityScheduler capacityScheduler) {
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a1").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertEquals((long)1L, (long)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().size());
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().contains("red"));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("b").getAccessibleNodeLabels().isEmpty());
    }

    @Test
    public void testQueueParsingWhenLabelsNotExistedInNodeLabelManager() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabels(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueParsingWhenLabelsInheritedNotExistedInNodeLabelManager() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabelsInherit(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testSingleLevelQueueParsingWhenLabelsNotExistedInNodeLabelManager() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithSingleLevel(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueParsingWhenLabelsNotExist() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabels(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueParsingWithUnusedLabels() throws Exception {
        ImmutableSet labels = ImmutableSet.of((Object)"red", (Object)"blue");
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        csConf.setAccessibleNodeLabels("root", (Set)labels);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)labels);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        capacityScheduler.reinitialize((Configuration)csConf, rm.getRMContext());
        CSQueue root = capacityScheduler.getQueue("root");
        Assert.assertEquals((double)0.0, (double)root.getQueueCapacities().getCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.0, (double)root.getQueueCapacities().getCapacity("blue"), (double)0.001);
        CSQueue a = capacityScheduler.getQueue("a");
        Assert.assertEquals((double)0.1, (double)a.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.15, (double)a.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue b1 = capacityScheduler.getQueue("b1");
        Assert.assertEquals((double)0.1, (double)b1.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((String)"Parent B has no MAX_CAP", (double)0.85, (double)b1.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue c12 = capacityScheduler.getQueue("c12");
        Assert.assertEquals((double)0.1575, (double)c12.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.26949999999999996, (double)c12.getAbsoluteMaximumCapacity(), (double)0.001);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueParsingShouldTrimSpaces() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithSpacesShouldBeTrimmed(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue a = capacityScheduler.getQueue("a");
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((double)0.1, (double)a.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.15, (double)a.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue c = capacityScheduler.getQueue("c");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((double)0.7, (double)c.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.7, (double)c.getAbsoluteMaximumCapacity(), (double)0.001);
    }

    @Test
    public void testNestedQueueParsingShouldTrimSpaces() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupNestedQueueConfigurationWithSpacesShouldBeTrimmed(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue a = capacityScheduler.getQueue("a");
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((double)0.1, (double)a.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.15, (double)a.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue c = capacityScheduler.getQueue("c");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((double)0.7, (double)c.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.7, (double)c.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue a1 = capacityScheduler.getQueue("a1");
        Assert.assertNotNull((Object)a1);
        Assert.assertEquals((double)0.06, (double)a1.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.15, (double)a1.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue a2 = capacityScheduler.getQueue("a2");
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((double)0.04000000000000001, (double)a2.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.15, (double)a2.getAbsoluteMaximumCapacity(), (double)0.001);
    }

    @Test(expected=ServiceStateException.class)
    public void testQueueParsingFailWhenSumOfChildrenNonLabeledCapacityNot100Percent() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        Assume.assumeThat((Object)csConf.isLegacyQueueMode(), (Matcher)CoreMatchers.is((Object)true));
        this.setupQueueConfiguration(csConf);
        csConf.setCapacity("root.c.c2", 5.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test(expected=ServiceStateException.class)
    public void testQueueParsingFailWhenSumOfChildrenLabeledCapacityNot100Percent() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        Assume.assumeThat((Object)csConf.isLegacyQueueMode(), (Matcher)CoreMatchers.is((Object)true));
        this.setupQueueConfigurationWithLabels(csConf);
        csConf.setCapacityByLabel("root.b.b3", "red", 24.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test(expected=ServiceStateException.class)
    public void testQueueParsingWithSumOfChildLabelCapacityNot100PercentWithWildCard() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        Assume.assumeThat((Object)csConf.isLegacyQueueMode(), (Matcher)CoreMatchers.is((Object)true));
        this.setupQueueConfigurationWithLabels(csConf);
        csConf.setCapacityByLabel("root.b.b3", "red", 24.0f);
        csConf.setAccessibleNodeLabels("root", (Set)ImmutableSet.of((Object)"*"));
        csConf.setAccessibleNodeLabels("root.b", (Set)ImmutableSet.of((Object)"*"));
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test(expected=IOException.class)
    public void testQueueParsingWithMoveQueue() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{"a"});
        csConf.setQueues("root.a", new String[]{"x", "y"});
        csConf.setCapacity("root.a", 100.0f);
        csConf.setCapacity("root.a.x", 50.0f);
        csConf.setCapacity("root.a.y", 50.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        csConf.setQueues("root", new String[]{"a", "x"});
        csConf.setQueues("root.a", new String[]{"y"});
        csConf.setCapacity("root.x", 50.0f);
        csConf.setCapacity("root.a", 50.0f);
        csConf.setCapacity("root.a.y", 100.0f);
        capacityScheduler.reinitialize((Configuration)csConf, rm.getRMContext());
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test(timeout=60000L, expected=ServiceStateException.class)
    public void testRMStartWrongNodeCapacity() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        ImmutableSet labels = ImmutableSet.of((Object)"x", (Object)"y", (Object)"z");
        Assume.assumeThat((Object)csConf.isLegacyQueueMode(), (Matcher)CoreMatchers.is((Object)true));
        csConf.setQueues("root", new String[]{"a"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        csConf.setCapacityByLabel("root", "y", 100.0f);
        csConf.setCapacityByLabel("root", "z", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 100.0f);
        csConf.setAccessibleNodeLabels("root.a", (Set)labels);
        csConf.setCapacityByLabel("root.a", "x", 100.0f);
        csConf.setCapacityByLabel("root.a", "y", 100.0f);
        csConf.setCapacityByLabel("root.a", "z", 70.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)labels);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueOrderingPolicyUpdatedAfterReinitialize() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithoutLabels(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        csConf.setQueues("root.b", new String[]{"b1", "b2", "b3", "b4"});
        csConf.setCapacity("root.b.b4", 0.0f);
        ParentQueue bQ = (ParentQueue)capacityScheduler.getQueue("b");
        this.checkEqualsToQueueSet(bQ.getChildQueues(), new String[]{"b1", "b2", "b3"});
        capacityScheduler.reinitialize((Configuration)csConf, rm.getRMContext());
        this.checkEqualsToQueueSet(bQ.getChildQueues(), new String[]{"b1", "b2", "b3", "b4"});
        PriorityUtilizationQueueOrderingPolicy queueOrderingPolicy = (PriorityUtilizationQueueOrderingPolicy)bQ.getQueueOrderingPolicy();
        this.checkEqualsToQueueSet(queueOrderingPolicy.getQueues(), new String[]{"b1", "b2", "b3", "b4"});
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test(timeout=60000L)
    public void testQueueCapacityWithWeight() throws Exception {
        ImmutableSet labels = ImmutableSet.of((Object)"x", (Object)"y", (Object)"z");
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{"a"});
        csConf.setLabeledQueueWeight("root", "x", 100.0f);
        csConf.setLabeledQueueWeight("root", "y", 100.0f);
        csConf.setLabeledQueueWeight("root", "z", 100.0f);
        String A = "root.a";
        csConf.setNonLabeledQueueWeight("root.a", 100.0f);
        csConf.setAccessibleNodeLabels("root.a", (Set)labels);
        csConf.setLabeledQueueWeight("root.a", "x", 100.0f);
        csConf.setLabeledQueueWeight("root.a", "y", 100.0f);
        csConf.setLabeledQueueWeight("root.a", "z", 70.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)labels);
        this.verifyQueueAbsCapacity(rm, "root", "", 1.0f);
        this.verifyQueueAbsCapacity(rm, "root", "x", 1.0f);
        this.verifyQueueAbsCapacity(rm, "root", "y", 1.0f);
        this.verifyQueueAbsCapacity(rm, "root", "z", 1.0f);
        this.verifyQueueAbsCapacity(rm, "root.a", "", 1.0f);
        this.verifyQueueAbsCapacity(rm, "root.a", "x", 1.0f);
        this.verifyQueueAbsCapacity(rm, "root.a", "y", 1.0f);
        this.verifyQueueAbsCapacity(rm, "root.a", "z", 1.0f);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueParsingWithDefaultUserLimitValues() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        String queueA = "root.a";
        String queueB = "root.b";
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setDefaultUserLimit(20.0f);
        csConf.setDefaultUserLimitFactor(2.0f);
        csConf.setCapacity("root.a", 50.0f);
        csConf.setUserLimit("root.a", 15.0f);
        csConf.setUserLimitFactor("root.a", 1.5f);
        csConf.setCapacity("root.b", 50.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        Assert.assertEquals((double)15.0, (double)((LeafQueue)capacityScheduler.getQueue("root.a")).getUserLimit(), (double)0.001);
        Assert.assertEquals((double)1.5, (double)((LeafQueue)capacityScheduler.getQueue("root.a")).getUserLimitFactor(), (double)0.001);
        Assert.assertEquals((double)20.0, (double)((LeafQueue)capacityScheduler.getQueue("root.b")).getUserLimit(), (double)0.001);
        Assert.assertEquals((double)2.0, (double)((LeafQueue)capacityScheduler.getQueue("root.b")).getUserLimitFactor(), (double)0.001);
        csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacity("root.a", 50.0f);
        csConf.setUserLimit("root.a", 15.0f);
        csConf.setUserLimitFactor("root.a", 1.5f);
        csConf.setCapacity("root.b", 50.0f);
        capacityScheduler.reinitialize((Configuration)csConf, rm.getRMContext());
        Assert.assertEquals((double)15.0, (double)((LeafQueue)capacityScheduler.getQueue("root.a")).getUserLimit(), (double)0.001);
        Assert.assertEquals((double)1.5, (double)((LeafQueue)capacityScheduler.getQueue("root.a")).getUserLimitFactor(), (double)0.001);
        Assert.assertEquals((double)100.0, (double)((LeafQueue)capacityScheduler.getQueue("root.b")).getUserLimit(), (double)0.001);
        Assert.assertEquals((double)1.0, (double)((LeafQueue)capacityScheduler.getQueue("root.b")).getUserLimitFactor(), (double)0.001);
    }

    private void verifyQueueAbsCapacity(MockRM rm, String queuePath, String label, float expectedAbsCapacity) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue queue = cs.getQueue(queuePath);
        Assert.assertEquals((double)expectedAbsCapacity, (double)queue.getQueueCapacities().getAbsoluteCapacity(label), (double)1.0E-6);
    }

    private void checkEqualsToQueueSet(List<CSQueue> queues, String[] queueNames) {
        HashSet<String> existedQueues = new HashSet<String>();
        for (CSQueue q : queues) {
            existedQueues.add(q.getQueueShortName());
        }
        for (String q : queueNames) {
            Assert.assertTrue((boolean)existedQueues.remove(q));
        }
        Assert.assertTrue((boolean)existedQueues.isEmpty());
    }
}

