/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestApplicationLimitsByPartition {
    static final int GB = 1024;
    LeafQueue queue;
    RMNodeLabelsManager mgr;
    private YarnConfiguration conf;
    private final ResourceCalculator resourceCalculator = new DefaultResourceCalculator();

    @Before
    public void setUp() throws IOException {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    private void simpleNodeLabelMappingToManager() throws IOException {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), TestUtils.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), TestUtils.toSet("y")));
    }

    private void complexNodeLabelMappingToManager() throws IOException {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), TestUtils.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), TestUtils.toSet("y"), (Object)NodeId.newInstance((String)"h3", (int)0), TestUtils.toSet("y"), (Object)NodeId.newInstance((String)"h4", (int)0), TestUtils.toSet("z"), (Object)NodeId.newInstance((String)"h5", (int)0), (Object)RMNodeLabelsManager.EMPTY_STRING_SET));
    }

    @Test(timeout=120000L)
    public void testAMResourceLimitWithLabels() throws Exception {
        this.simpleNodeLabelMappingToManager();
        CapacitySchedulerConfiguration config = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf);
        String A1 = "root.a.a1";
        String C1 = "root.c.c1";
        config.setMaximumAMResourcePercentPerPartition("root.a.a1", "x", 0.2f);
        config.setMaximumApplicationMasterResourcePerQueuePercent("root.c.c1", 0.2f);
        MockRM rm1 = new MockRM((Configuration)config){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestApplicationLimitsByPartition.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        rm1.registerNode("h2:1234", 10240);
        MockNM nm3 = rm1.registerNode("h3:1234", 10240);
        MockRMAppSubmissionData data5 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data5);
        MockRMAppSubmissionData data4 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data4);
        MockRMAppSubmissionData data3 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp pendingApp = MockRMAppSubmitter.submit(rm1, data3);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)2L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)app1.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.ACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)app2.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.ACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.INACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains("Queue's AM resource limit exceeded. "));
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("c1").withUnmanagedAM(false).build();
        RMApp app3 = MockRMAppSubmitter.submit(rm1, data2);
        MockRM.launchAndRegisterAM(app3, rm1, nm3);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("c1").withUnmanagedAM(false).build();
        RMApp app4 = MockRMAppSubmitter.submit(rm1, data1);
        MockRM.launchAndRegisterAM(app4, rm1, nm3);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("c1").withUnmanagedAM(false).build();
        pendingApp = MockRMAppSubmitter.submit(rm1, data);
        leafQueue = (LeafQueue)cs.getQueue("c1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)2L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.INACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains("Queue's AM resource limit exceeded. "));
        rm1.killApp(app3.getApplicationId());
        Thread.sleep(1000L);
        Assert.assertEquals((long)2L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)leafQueue.getNumPendingApplications());
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testAtleastOneAMRunPerPartition() throws Exception {
        this.simpleNodeLabelMappingToManager();
        CapacitySchedulerConfiguration config = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf);
        String A1 = "root.a.a1";
        String C1 = "root.c.c1";
        config.setMaximumAMResourcePercentPerPartition("root.a.a1", "x", 0.15f);
        config.setMaximumApplicationMasterResourcePerQueuePercent("root.c.c1", 0.15f);
        MockRM rm1 = new MockRM((Configuration)config){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestApplicationLimitsByPartition.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        rm1.registerNode("h2:1234", 10240);
        MockNM nm3 = rm1.registerNode("h3:1234", 10240);
        MockRMAppSubmissionData data3 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data3);
        MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("x").build();
        MockRMAppSubmitter.submit(rm1, data2);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)1L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("c1").withUnmanagedAM(false).build();
        RMApp app3 = MockRMAppSubmitter.submit(rm1, data1);
        MockRM.launchAndRegisterAM(app3, rm1, nm3);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("c1").withUnmanagedAM(false).build();
        MockRMAppSubmitter.submit(rm1, data);
        leafQueue = (LeafQueue)cs.getQueue("c1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)1L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testDefaultAMLimitFromQueueForPartition() throws Exception {
        this.simpleNodeLabelMappingToManager();
        CapacitySchedulerConfiguration config = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf);
        String A1 = "root.a.a1";
        config.setMaximumApplicationMasterResourcePerQueuePercent("root.a.a1", 0.2f);
        MockRM rm1 = new MockRM((Configuration)config){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestApplicationLimitsByPartition.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        rm1.registerNode("h2:1234", 10240);
        rm1.registerNode("h3:1234", 10240);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp pendingApp = MockRMAppSubmitter.submit(rm1, data);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)1L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)app1.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.ACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.INACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains("Queue's AM resource limit exceeded. "));
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testUserAMResourceLimitWithLabels() throws Exception {
        String user_0 = "user_0";
        String user_1 = "user_1";
        this.simpleNodeLabelMappingToManager();
        CapacitySchedulerConfiguration config = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf);
        String A1 = "root.a.a1";
        config.setMaximumAMResourcePercentPerPartition("root.a.a1", "x", 0.4f);
        config.setUserLimit("root.a.a1", 50.0f);
        MockRM rm1 = new MockRM((Configuration)config){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestApplicationLimitsByPartition.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        rm1.registerNode("h2:1234", 10240);
        rm1.registerNode("h3:1234", 10240);
        MockRMAppSubmissionData data3 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user_0").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data3);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 15, new ArrayList<ContainerId>(), "");
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user_1").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data2);
        MockRM.launchAndRegisterAM(app2, rm1, nm1);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)2L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)leafQueue.getNumPendingApplications());
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user_1").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp app3 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am2 = MockRM.launchAndRegisterAM(app3, rm1, nm1);
        am2.allocate("*", 1024, 10, new ArrayList<ContainerId>(), "");
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user_1").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp pendingApp = MockRMAppSubmitter.submit(rm1, data);
        Assert.assertEquals((long)3L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)2L, (long)leafQueue.getNumActiveApplications("user_1"));
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications("user_1"));
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.INACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains("User's AM resource limit exceeded. "));
        rm1.close();
    }

    @Test
    public void testAMResourceLimitForMultipleApplications() throws Exception {
        this.complexNodeLabelMappingToManager();
        CapacitySchedulerConfiguration config = (CapacitySchedulerConfiguration)TestUtils.getComplexConfigurationWithQueueLabels((Configuration)this.conf);
        String A1 = "root.a.a1";
        String B1 = "root.b.b1";
        config.setMaximumAMResourcePercentPerPartition("root.a.a1", "y", 0.25f);
        config.setMaximumApplicationMasterResourcePerQueuePercent("root.b.b1", 0.15f);
        MockRM rm1 = new MockRM((Configuration)config){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestApplicationLimitsByPartition.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        rm1.registerNode("h1:1234", 10240);
        MockNM nm2 = rm1.registerNode("h2:1234", 10240);
        MockNM nm3 = rm1.registerNode("h3:1234", 10240);
        rm1.registerNode("h4:1234", 10240);
        MockNM nm5 = rm1.registerNode("h5:1234", 10240);
        MockRMAppSubmissionData data4 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("y").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data4);
        MockRM.launchAndRegisterAM(app1, rm1, nm2);
        MockRMAppSubmissionData data3 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("y").build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data3);
        MockRM.launchAndRegisterAM(app2, rm1, nm3);
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("y").build();
        MockRMAppSubmitter.submit(rm1, data2);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)2L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app3 = MockRMAppSubmitter.submit(rm1, data1);
        MockRM.launchAndRegisterAM(app3, rm1, nm5);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        MockRMAppSubmitter.submit(rm1, data);
        leafQueue = (LeafQueue)cs.getQueue("b1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)1L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        rm1.close();
    }

    @Test
    public void testHeadroom() throws Exception {
        this.simpleNodeLabelMappingToManager();
        CapacitySchedulerConfiguration csConf = (CapacitySchedulerConfiguration)TestUtils.getComplexConfigurationWithQueueLabels((Configuration)this.conf);
        String A1 = "root.a.a1";
        String B2 = "root.b.b2";
        csConf.setUserLimit("root.a.a1", 25.0f);
        csConf.setUserLimit("root.b.b2", 25.0f);
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerContext csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024));
        Mockito.when((Object)csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384));
        Mockito.when((Object)csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        RMContext rmContext = TestUtils.getMockRMContext();
        RMContext spyRMContext = (RMContext)Mockito.spy((Object)rmContext);
        Mockito.when((Object)spyRMContext.getNodeLabelManager()).thenReturn((Object)this.mgr);
        Mockito.when((Object)csContext.getRMContext()).thenReturn((Object)spyRMContext);
        Mockito.when((Object)csContext.getPreemptionManager()).thenReturn((Object)new PreemptionManager());
        CapacitySchedulerQueueManager queueManager = new CapacitySchedulerQueueManager((Configuration)csConf, this.mgr, null);
        Mockito.when((Object)csContext.getCapacitySchedulerQueueManager()).thenReturn((Object)queueManager);
        queueManager.reinitConfiguredNodeLabels(csConf);
        this.mgr.activateNode(NodeId.newInstance((String)"h0", (int)0), Resource.newInstance((int)163840, (int)16));
        this.mgr.activateNode(NodeId.newInstance((String)"h1", (int)0), Resource.newInstance((int)163840, (int)16));
        this.mgr.activateNode(NodeId.newInstance((String)"h2", (int)0), Resource.newInstance((int)163840, (int)16));
        Resource clusterResource = Resources.createResource((int)163840);
        Mockito.when((Object)csContext.getClusterResource()).thenReturn((Object)clusterResource);
        CapacitySchedulerQueueContext queueContext = new CapacitySchedulerQueueContext(csContext);
        CSQueueStore queues = new CSQueueStore();
        CSQueue rootQueue = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)queueContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        queueManager.setRootQueue(rootQueue);
        rootQueue.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        LeafQueue queue = TestLeafQueue.stubLeafQueue((LeafQueue)queues.get("b2"));
        queue.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        String rack_0 = "rack_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode("h0", rack_0, 0, 163840);
        FiCaSchedulerNode node_1 = TestUtils.getMockNode("h1", rack_0, 0, 163840);
        String user_0 = "user_0";
        String user_1 = "user_1";
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        ConcurrentMap spyApps = (ConcurrentMap)Mockito.spy(new ConcurrentHashMap());
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        ResourceRequest amResourceRequest = (ResourceRequest)Mockito.mock(ResourceRequest.class);
        Resource amResource = Resources.createResource((int)0, (int)0);
        Mockito.when((Object)amResourceRequest.getCapability()).thenReturn((Object)amResource);
        Mockito.when((Object)rmApp.getAMResourceRequests()).thenReturn(Collections.singletonList(amResourceRequest));
        ((ConcurrentMap)Mockito.doReturn((Object)rmApp).when((Object)spyApps)).get(ArgumentMatchers.any());
        Mockito.when((Object)spyRMContext.getRMApps()).thenReturn((Object)spyApps);
        RMAppAttempt rmAppAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)rmApp.getRMAppAttempt((ApplicationAttemptId)ArgumentMatchers.any())).thenReturn((Object)rmAppAttempt);
        Mockito.when((Object)rmApp.getCurrentAppAttempt()).thenReturn((Object)rmAppAttempt);
        ((ConcurrentMap)Mockito.doReturn((Object)rmApp).when((Object)spyApps)).get(ArgumentMatchers.any());
        ((ConcurrentMap)Mockito.doReturn((Object)true).when((Object)spyApps)).containsKey(ArgumentMatchers.any());
        Priority priority_1 = TestUtils.createMockPriority(1);
        ApplicationAttemptId appAttemptId_0_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0_0 = new FiCaSchedulerApp(appAttemptId_0_0, "user_0", (Queue)queue, queue.getAbstractUsersManager(), spyRMContext);
        queue.submitApplicationAttempt(app_0_0, "user_0");
        ArrayList<ResourceRequest> app_0_0_requests = new ArrayList<ResourceRequest>();
        app_0_0_requests.add(TestUtils.createResourceRequest("*", 1024, 2, true, priority_1, recordFactory));
        app_0_0.updateResourceRequests(app_0_0_requests);
        queue.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        Resource expectedHeadroom = Resources.createResource((int)18432, (int)1);
        Assert.assertEquals((Object)expectedHeadroom, (Object)app_0_0.getHeadroom());
        ApplicationAttemptId appAttemptId_0_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_0_1 = new FiCaSchedulerApp(appAttemptId_0_1, "user_0", (Queue)queue, queue.getAbstractUsersManager(), spyRMContext);
        queue.submitApplicationAttempt(app_0_1, "user_0");
        ArrayList<ResourceRequest> app_0_1_requests = new ArrayList<ResourceRequest>();
        app_0_1_requests.add(TestUtils.createResourceRequest("*", 1024, 2, true, priority_1, recordFactory));
        app_0_1.updateResourceRequests(app_0_1_requests);
        app_0_1_requests.clear();
        app_0_1_requests.add(TestUtils.createResourceRequest("*", 1024, 2, true, priority_1, recordFactory, "y"));
        app_0_1.updateResourceRequests(app_0_1_requests);
        queue.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        queue.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        Assert.assertEquals((Object)expectedHeadroom, (Object)app_0_0.getHeadroom());
        Resource expectedHeadroomWithReqInY = Resources.add((Resource)Resources.createResource((int)20480, (int)1), (Resource)expectedHeadroom);
        Assert.assertEquals((Object)expectedHeadroomWithReqInY, (Object)app_0_1.getHeadroom());
        ApplicationAttemptId appAttemptId_1_0 = TestUtils.getMockApplicationAttemptId(2, 0);
        FiCaSchedulerApp app_1_0 = new FiCaSchedulerApp(appAttemptId_1_0, "user_1", (Queue)queue, queue.getAbstractUsersManager(), spyRMContext);
        queue.submitApplicationAttempt(app_1_0, "user_1");
        ArrayList<ResourceRequest> app_1_0_requests = new ArrayList<ResourceRequest>();
        app_1_0_requests.add(TestUtils.createResourceRequest("*", 1024, 2, true, priority_1, recordFactory));
        app_1_0.updateResourceRequests(app_1_0_requests);
        app_1_0_requests.clear();
        app_1_0_requests.add(TestUtils.createResourceRequest("*", 1024, 2, true, priority_1, recordFactory, "y"));
        app_1_0.updateResourceRequests(app_1_0_requests);
        queue.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        expectedHeadroom = Resources.createResource((int)18432, (int)1);
        expectedHeadroomWithReqInY = Resources.add((Resource)Resources.createResource((int)20480, (int)1), (Resource)expectedHeadroom);
        Assert.assertEquals((Object)expectedHeadroom, (Object)app_0_0.getHeadroom());
        Assert.assertEquals((Object)expectedHeadroomWithReqInY, (Object)app_0_1.getHeadroom());
        Assert.assertEquals((Object)expectedHeadroomWithReqInY, (Object)app_1_0.getHeadroom());
    }

    @Test
    public void testAMLimitByAllResources() throws Exception {
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        csconf.setResourceComparator(DominantResourceCalculator.class);
        String queueName = "a1";
        csconf.setQueues("root", new String[]{queueName});
        csconf.setCapacity("root." + queueName, 100.0f);
        ResourceInformation res0 = ResourceInformation.newInstance((String)"memory-mb", (String)ResourceInformation.MEMORY_MB.getUnits(), (long)1024L, (long)Long.MAX_VALUE);
        ResourceInformation res1 = ResourceInformation.newInstance((String)"vcores", (String)ResourceInformation.VCORES.getUnits(), (long)1L, (long)Integer.MAX_VALUE);
        ResourceInformation res2 = ResourceInformation.newInstance((String)"gpu", (String)ResourceInformation.GPUS.getUnits(), (long)0L, (long)Integer.MAX_VALUE);
        HashMap<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();
        riMap.put("memory-mb", res0);
        riMap.put("vcores", res1);
        riMap.put("yarn.io/gpu", res2);
        ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
        YarnConfiguration config = new YarnConfiguration((Configuration)csconf);
        config.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        config.setBoolean("yarn.test.reset-resource-types", false);
        MockRM rm = new MockRM((Configuration)config);
        rm.start();
        HashMap<String, Long> res = new HashMap<String, Long>();
        res.put("gpu", 0L);
        Resource clusterResource = Resource.newInstance((long)16384L, (int)64, res);
        rm.registerNode("127.0.0.1:1234", clusterResource);
        String userName = "user_0";
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        LeafQueue queueA = (LeafQueue)((CapacityScheduler)scheduler).getQueue(queueName);
        Resource amResource = Resource.newInstance((int)1024, (int)1);
        MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithResource(amResource, rm).withAppName("app-1").withUser(userName).withAcls(null).withQueue(queueName).build());
        MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithResource(amResource, rm).withAppName("app-2").withUser(userName).withAcls(null).withQueue(queueName).build());
        MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithResource(amResource, rm).withAppName("app-3").withUser(userName).withAcls(null).withQueue(queueName).build());
        Assert.assertEquals((String)"PendingApplications should be 1", (long)1L, (long)queueA.getNumPendingApplications());
        Assert.assertEquals((String)"Active applications should be 2", (long)2L, (long)queueA.getNumActiveApplications());
        Assert.assertEquals((long)2048L, (long)queueA.getQueueResourceUsage().getAMLimit().getMemorySize());
        Assert.assertEquals((long)7L, (long)queueA.getQueueResourceUsage().getAMLimit().getVirtualCores());
        Assert.assertEquals((long)2048L, (long)queueA.getQueueResourceUsage().getAMUsed().getMemorySize());
        Assert.assertEquals((long)2L, (long)queueA.getQueueResourceUsage().getAMUsed().getVirtualCores());
        rm.close();
    }
}

