/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.ReservationDeleteRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.ReservationListRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.ReservationSubmissionRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.ReservationUpdateRequestPBImpl;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationDefinitionPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationRequestsPBImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInputValidator;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReservationInputValidator {
    private static final Logger LOG = LoggerFactory.getLogger(TestReservationInputValidator.class);
    private static final String PLAN_NAME = "test-reservation";
    private Clock clock;
    private Map<String, Plan> plans = new HashMap<String, Plan>(1);
    private ReservationSystem rSystem;
    private Plan plan;
    private ReservationInputValidator rrValidator;

    @Before
    public void setUp() {
        this.clock = (Clock)Mockito.mock(Clock.class);
        this.plan = (Plan)Mockito.mock(Plan.class);
        this.rSystem = (ReservationSystem)Mockito.mock(ReservationSystem.class);
        this.plans.put(PLAN_NAME, this.plan);
        this.rrValidator = new ReservationInputValidator(this.clock);
        Mockito.when((Object)this.clock.getTime()).thenReturn((Object)1L);
        DefaultResourceCalculator rCalc = new DefaultResourceCalculator();
        Resource resource = Resource.newInstance((int)10240, (int)10);
        Mockito.when((Object)this.plan.getResourceCalculator()).thenReturn((Object)rCalc);
        Mockito.when((Object)this.plan.getTotalCapacity()).thenReturn((Object)resource);
        Mockito.when((Object)this.plan.getMaximumPeriodicity()).thenReturn((Object)86400000L);
        Mockito.when((Object)this.rSystem.getQueueForReservation((ReservationId)ArgumentMatchers.any(ReservationId.class))).thenReturn((Object)PLAN_NAME);
        Mockito.when((Object)this.rSystem.getPlan(PLAN_NAME)).thenReturn((Object)this.plan);
    }

    @After
    public void tearDown() {
        this.rrValidator = null;
        this.clock = null;
        this.plan = null;
    }

    @Test
    public void testSubmitReservationNormal() {
        ReservationSubmissionRequest request = this.createSimpleReservationSubmissionRequest(1, 1, 1L, 5L, 3L);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, request, ReservationSystemTestUtil.getNewReservationId());
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull(plan);
    }

    @Test
    public void testSubmitReservationDoesNotExist() {
        ReservationSubmissionRequestPBImpl request = new ReservationSubmissionRequestPBImpl();
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, (ReservationSubmissionRequest)request, ReservationSystemTestUtil.getNewReservationId());
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertEquals((Object)"The queue is not specified. Please try again with a valid reservable queue.", (Object)message);
            LOG.info(message);
        }
    }

    @Test
    public void testSubmitReservationInvalidPlan() {
        ReservationSubmissionRequest request = this.createSimpleReservationSubmissionRequest(1, 1, 1L, 5L, 3L);
        Mockito.when((Object)this.rSystem.getPlan(PLAN_NAME)).thenReturn(null);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, request, ReservationSystemTestUtil.getNewReservationId());
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.endsWith(" is not managed by reservation system. Please try again with a valid reservable queue."));
            LOG.info(message);
        }
    }

    @Test
    public void testSubmitReservationNoDefinition() {
        ReservationSubmissionRequestPBImpl request = new ReservationSubmissionRequestPBImpl();
        request.setQueue(PLAN_NAME);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, (ReservationSubmissionRequest)request, ReservationSystemTestUtil.getNewReservationId());
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertEquals((Object)"Missing reservation definition. Please try again by specifying a reservation definition.", (Object)message);
            LOG.info(message);
        }
    }

    @Test
    public void testSubmitReservationInvalidDeadline() {
        ReservationSubmissionRequest request = this.createSimpleReservationSubmissionRequest(1, 1, 1L, 0L, 3L);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, request, ReservationSystemTestUtil.getNewReservationId());
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("The specified deadline: 0 is the past"));
            LOG.info(message);
        }
    }

    @Test
    public void testSubmitReservationInvalidRR() {
        ReservationSubmissionRequest request = this.createSimpleReservationSubmissionRequest(0, 0, 1L, 5L, 3L);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, request, ReservationSystemTestUtil.getNewReservationId());
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("No resources have been specified to reserve"));
            LOG.info(message);
        }
    }

    @Test
    public void testSubmitReservationEmptyRR() {
        ReservationSubmissionRequest request = this.createSimpleReservationSubmissionRequest(1, 0, 1L, 5L, 3L);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, request, ReservationSystemTestUtil.getNewReservationId());
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("No resources have been specified to reserve"));
            LOG.info(message);
        }
    }

    @Test
    public void testSubmitReservationInvalidDuration() {
        ReservationSubmissionRequest request = this.createSimpleReservationSubmissionRequest(1, 1, 1L, 3L, 4L);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, request, ReservationSystemTestUtil.getNewReservationId());
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("The time difference"));
            Assert.assertTrue((boolean)message.contains("must  be greater or equal to the minimum resource duration"));
            LOG.info(message);
        }
    }

    @Test
    public void testSubmitReservationExceedsGangSize() {
        ReservationSubmissionRequest request = this.createSimpleReservationSubmissionRequest(1, 1, 1L, 5L, 4L);
        Resource resource = Resource.newInstance((int)512, (int)1);
        Mockito.when((Object)this.plan.getTotalCapacity()).thenReturn((Object)resource);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, request, ReservationSystemTestUtil.getNewReservationId());
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("The size of the largest gang in the reservation definition"));
            Assert.assertTrue((boolean)message.contains("exceed the capacity available "));
            LOG.info(message);
        }
    }

    @Test
    public void testSubmitReservationValidRecurrenceExpression() {
        ReservationSubmissionRequest request = this.createSimpleReservationSubmissionRequest(1, 1, 1L, 5L, 3L, "600000");
        this.plan = null;
        try {
            this.plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, request, ReservationSystemTestUtil.getNewReservationId());
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)this.plan);
    }

    @Test
    public void testSubmitReservationNegativeRecurrenceExpression() {
        ReservationSubmissionRequest request = this.createSimpleReservationSubmissionRequest(1, 1, 1L, 5L, 3L, "-1234");
        this.plan = null;
        try {
            this.plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, request, ReservationSystemTestUtil.getNewReservationId());
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull((Object)this.plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("Negative Period : "));
            LOG.info(message);
        }
    }

    @Test
    public void testSubmitReservationMaxPeriodIndivisibleByRecurrenceExp() {
        long indivisibleRecurrence = 43200001L;
        String recurrenceExp = Long.toString(indivisibleRecurrence);
        ReservationSubmissionRequest request = this.createSimpleReservationSubmissionRequest(1, 1, 1L, 5L, 3L, recurrenceExp);
        this.plan = null;
        try {
            this.plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, request, ReservationSystemTestUtil.getNewReservationId());
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull((Object)this.plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("The maximum periodicity:"));
            LOG.info(message);
        }
    }

    @Test
    public void testSubmitReservationInvalidRecurrenceExpression() {
        String message;
        ReservationSubmissionRequest request = this.createSimpleReservationSubmissionRequest(1, 1, 1L, 5L, 3L, "123abc");
        this.plan = null;
        try {
            this.plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, request, ReservationSystemTestUtil.getNewReservationId());
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull((Object)this.plan);
            message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("Invalid period "));
            LOG.info(message);
        }
        request = this.createSimpleReservationSubmissionRequest(1, 1, 1L, 50L, 3L, "10");
        this.plan = null;
        try {
            this.plan = this.rrValidator.validateReservationSubmissionRequest(this.rSystem, request, ReservationSystemTestUtil.getNewReservationId());
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull((Object)this.plan);
            message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("Duration of the requested reservation:"));
            LOG.info(message);
        }
    }

    @Test
    public void testUpdateReservationNormal() {
        ReservationUpdateRequest request = this.createSimpleReservationUpdateRequest(1, 1, 1L, 5L, 3L);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, request);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)plan);
    }

    @Test
    public void testUpdateReservationNoID() {
        ReservationUpdateRequestPBImpl request = new ReservationUpdateRequestPBImpl();
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, (ReservationUpdateRequest)request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("Missing reservation id. Please try again by specifying a reservation id."));
            LOG.info(message);
        }
    }

    @Test
    public void testUpdateReservationDoesnotExist() {
        ReservationUpdateRequest request = this.createSimpleReservationUpdateRequest(1, 1, 1L, 5L, 4L);
        ReservationId rId = request.getReservationId();
        Mockito.when((Object)this.rSystem.getQueueForReservation(rId)).thenReturn(null);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.equals(MessageFormat.format("The specified reservation with ID: {0} is unknown. Please try again with a valid reservation.", rId)));
            LOG.info(message);
        }
    }

    @Test
    public void testUpdateReservationInvalidPlan() {
        ReservationUpdateRequest request = this.createSimpleReservationUpdateRequest(1, 1, 1L, 5L, 4L);
        Mockito.when((Object)this.rSystem.getPlan(PLAN_NAME)).thenReturn(null);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.endsWith(" is not associated with any valid plan. Please try again with a valid reservation."));
            LOG.info(message);
        }
    }

    @Test
    public void testUpdateReservationNoDefinition() {
        ReservationUpdateRequestPBImpl request = new ReservationUpdateRequestPBImpl();
        request.setReservationId(ReservationSystemTestUtil.getNewReservationId());
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, (ReservationUpdateRequest)request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("Missing reservation definition. Please try again by specifying a reservation definition."));
            LOG.info(message);
        }
    }

    @Test
    public void testUpdateReservationInvalidDeadline() {
        ReservationUpdateRequest request = this.createSimpleReservationUpdateRequest(1, 1, 1L, 0L, 3L);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("The specified deadline: 0 is the past"));
            LOG.info(message);
        }
    }

    @Test
    public void testUpdateReservationInvalidRR() {
        ReservationUpdateRequest request = this.createSimpleReservationUpdateRequest(0, 0, 1L, 5L, 3L);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("No resources have been specified to reserve"));
            LOG.info(message);
        }
    }

    @Test
    public void testUpdateReservationEmptyRR() {
        ReservationUpdateRequest request = this.createSimpleReservationUpdateRequest(1, 0, 1L, 5L, 3L);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("No resources have been specified to reserve"));
            LOG.info(message);
        }
    }

    @Test
    public void testUpdateReservationInvalidDuration() {
        ReservationUpdateRequest request = this.createSimpleReservationUpdateRequest(1, 1, 1L, 3L, 4L);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.contains("must  be greater or equal to the minimum resource duration"));
            LOG.info(message);
        }
    }

    @Test
    public void testUpdateReservationExceedsGangSize() {
        ReservationUpdateRequest request = this.createSimpleReservationUpdateRequest(1, 1, 1L, 5L, 4L);
        Resource resource = Resource.newInstance((int)512, (int)1);
        Mockito.when((Object)this.plan.getTotalCapacity()).thenReturn((Object)resource);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("The size of the largest gang in the reservation definition"));
            Assert.assertTrue((boolean)message.contains("exceed the capacity available "));
            LOG.info(message);
        }
    }

    @Test
    public void testUpdateReservationValidRecurrenceExpression() {
        ReservationUpdateRequest request = this.createSimpleReservationUpdateRequest(1, 1, 1L, 5L, 3L, "600000");
        this.plan = null;
        try {
            this.plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, request);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)this.plan);
    }

    @Test
    public void testUpdateReservationNegativeRecurrenceExpression() {
        ReservationUpdateRequest request = this.createSimpleReservationUpdateRequest(1, 1, 1L, 5L, 3L, "-1234");
        this.plan = null;
        try {
            this.plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull((Object)this.plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("Negative Period : "));
            LOG.info(message);
        }
    }

    @Test
    public void testUpdateReservationInvalidRecurrenceExpression() {
        String message;
        ReservationUpdateRequest request = this.createSimpleReservationUpdateRequest(1, 1, 1L, 5L, 3L, "123abc");
        this.plan = null;
        try {
            this.plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull((Object)this.plan);
            message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("Invalid period "));
            LOG.info(message);
        }
        request = this.createSimpleReservationUpdateRequest(1, 1, 1L, 50L, 3L, "10");
        this.plan = null;
        try {
            this.plan = this.rrValidator.validateReservationUpdateRequest(this.rSystem, request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull((Object)this.plan);
            message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("Duration of the requested reservation:"));
            LOG.info(message);
        }
    }

    @Test
    public void testDeleteReservationNormal() {
        ReservationDeleteRequestPBImpl request = new ReservationDeleteRequestPBImpl();
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        request.setReservationId(reservationID);
        ReservationAllocation reservation = (ReservationAllocation)Mockito.mock(ReservationAllocation.class);
        Mockito.when((Object)this.plan.getReservationById(reservationID)).thenReturn((Object)reservation);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationDeleteRequest(this.rSystem, (ReservationDeleteRequest)request);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)plan);
    }

    @Test
    public void testDeleteReservationNoID() {
        ReservationDeleteRequestPBImpl request = new ReservationDeleteRequestPBImpl();
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationDeleteRequest(this.rSystem, (ReservationDeleteRequest)request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.startsWith("Missing reservation id. Please try again by specifying a reservation id."));
            LOG.info(message);
        }
    }

    @Test
    public void testDeleteReservationDoesnotExist() {
        ReservationDeleteRequestPBImpl request = new ReservationDeleteRequestPBImpl();
        ReservationId rId = ReservationSystemTestUtil.getNewReservationId();
        request.setReservationId(rId);
        Mockito.when((Object)this.rSystem.getQueueForReservation(rId)).thenReturn(null);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationDeleteRequest(this.rSystem, (ReservationDeleteRequest)request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.equals(MessageFormat.format("The specified reservation with ID: {0} is unknown. Please try again with a valid reservation.", rId)));
            LOG.info(message);
        }
    }

    @Test
    public void testDeleteReservationInvalidPlan() {
        ReservationDeleteRequestPBImpl request = new ReservationDeleteRequestPBImpl();
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        request.setReservationId(reservationID);
        Mockito.when((Object)this.rSystem.getPlan(PLAN_NAME)).thenReturn(null);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationDeleteRequest(this.rSystem, (ReservationDeleteRequest)request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.endsWith(" is not associated with any valid plan. Please try again with a valid reservation."));
            LOG.info(message);
        }
    }

    @Test
    public void testListReservationsNormal() {
        ReservationListRequestPBImpl request = new ReservationListRequestPBImpl();
        request.setQueue("root.dedicated");
        request.setEndTime(1000L);
        request.setStartTime(0L);
        Mockito.when((Object)this.rSystem.getPlan("root.dedicated")).thenReturn((Object)this.plan);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationListRequest(this.rSystem, (ReservationListRequest)request);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)plan);
    }

    @Test
    public void testListReservationsInvalidTimeIntervalDefaults() {
        ReservationListRequestPBImpl request = new ReservationListRequestPBImpl();
        request.setQueue("root.dedicated");
        request.setEndTime(-2L);
        request.setStartTime(-1L);
        Mockito.when((Object)this.rSystem.getPlan("root.dedicated")).thenReturn((Object)this.plan);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationListRequest(this.rSystem, (ReservationListRequest)request);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)plan);
    }

    @Test
    public void testListReservationsInvalidTimeInterval() {
        ReservationListRequestPBImpl request = new ReservationListRequestPBImpl();
        request.setQueue("root.dedicated");
        request.setEndTime(1000L);
        request.setStartTime(2000L);
        Mockito.when((Object)this.rSystem.getPlan("root.dedicated")).thenReturn((Object)this.plan);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationListRequest(this.rSystem, (ReservationListRequest)request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.equals("The specified end time must be greater than the specified start time."));
            LOG.info(message);
        }
    }

    @Test
    public void testListReservationsEmptyQueue() {
        ReservationListRequestPBImpl request = new ReservationListRequestPBImpl();
        request.setQueue("");
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationListRequest(this.rSystem, (ReservationListRequest)request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.equals("The queue is not specified. Please try again with a valid reservable queue."));
            LOG.info(message);
        }
    }

    @Test
    public void testListReservationsNullPlan() {
        ReservationListRequestPBImpl request = new ReservationListRequestPBImpl();
        request.setQueue("root.dedicated");
        Mockito.when((Object)this.rSystem.getPlan("root.dedicated")).thenReturn(null);
        Plan plan = null;
        try {
            plan = this.rrValidator.validateReservationListRequest(this.rSystem, (ReservationListRequest)request);
            Assert.fail();
        }
        catch (YarnException e) {
            Assert.assertNull(plan);
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.equals("The specified queue: root.dedicated is not managed by reservation system. Please try again with a valid reservable queue."));
            LOG.info(message);
        }
    }

    private ReservationSubmissionRequest createSimpleReservationSubmissionRequest(int numRequests, int numContainers, long arrival, long deadline, long duration) {
        return this.createSimpleReservationSubmissionRequest(numRequests, numContainers, arrival, deadline, duration, "0");
    }

    private ReservationSubmissionRequest createSimpleReservationSubmissionRequest(int numRequests, int numContainers, long arrival, long deadline, long duration, String recurrence) {
        ReservationSubmissionRequestPBImpl request = new ReservationSubmissionRequestPBImpl();
        ReservationDefinitionPBImpl rDef = new ReservationDefinitionPBImpl();
        rDef.setArrival(arrival);
        rDef.setDeadline(deadline);
        rDef.setRecurrenceExpression(recurrence);
        if (numRequests > 0) {
            ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
            rDef.setReservationRequests((ReservationRequests)reqs);
            if (numContainers > 0) {
                ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)numContainers, (int)1, (long)duration);
                reqs.setReservationResources(Collections.singletonList(r));
                reqs.setInterpreter(ReservationRequestInterpreter.R_ALL);
            }
        }
        request.setQueue(PLAN_NAME);
        request.setReservationDefinition((ReservationDefinition)rDef);
        return request;
    }

    private ReservationUpdateRequest createSimpleReservationUpdateRequest(int numRequests, int numContainers, long arrival, long deadline, long duration) {
        return this.createSimpleReservationUpdateRequest(numRequests, numContainers, arrival, deadline, duration, "0");
    }

    private ReservationUpdateRequest createSimpleReservationUpdateRequest(int numRequests, int numContainers, long arrival, long deadline, long duration, String recurrence) {
        ReservationUpdateRequestPBImpl request = new ReservationUpdateRequestPBImpl();
        ReservationDefinitionPBImpl rDef = new ReservationDefinitionPBImpl();
        rDef.setArrival(arrival);
        rDef.setDeadline(deadline);
        rDef.setRecurrenceExpression(recurrence);
        if (numRequests > 0) {
            ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
            rDef.setReservationRequests((ReservationRequests)reqs);
            if (numContainers > 0) {
                ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)numContainers, (int)1, (long)duration);
                reqs.setReservationResources(Collections.singletonList(r));
                reqs.setInterpreter(ReservationRequestInterpreter.R_ALL);
            }
        }
        request.setReservationDefinition((ReservationDefinition)rDef);
        request.setReservationId(ReservationSystemTestUtil.getNewReservationId());
        return request;
    }
}

