/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.MockApplication;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.MockContainers;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MockApplications {
    private static final Logger LOG = LoggerFactory.getLogger(MockApplications.class);
    private String config;
    private ResourceCalculator resourceCalculator;
    private Map<String, CSQueue> nameToCSQueues;
    private Map<String, Resource> partitionToResource;
    private Map<NodeId, FiCaSchedulerNode> nodeIdToSchedulerNodes;
    private Map<String, Set<String>> userMap = new HashMap<String, Set<String>>();
    private Map<String, Map<String, HashMap<String, ResourceUsage>>> userResourceUsagePerLabel = new HashMap<String, Map<String, HashMap<String, ResourceUsage>>>();
    private int id = 1;

    MockApplications(String appsConfig, ResourceCalculator resourceCalculator, Map<String, CSQueue> nameToCSQueues, Map<String, Resource> partitionToResource, Map<NodeId, FiCaSchedulerNode> nodeIdToSchedulerNodes) {
        this.config = appsConfig;
        this.resourceCalculator = resourceCalculator;
        this.nameToCSQueues = nameToCSQueues;
        this.partitionToResource = partitionToResource;
        this.nodeIdToSchedulerNodes = nodeIdToSchedulerNodes;
        this.init();
    }

    private void init() {
        int mulp = -1;
        for (String appConfig : this.config.split(";")) {
            String[] appConfigComponents = appConfig.split("\t");
            String queueName = appConfigComponents[0];
            if (mulp <= 0 && appConfigComponents.length > 2 && appConfigComponents[2] != null) {
                LOG.info("Mulp value: " + appConfigComponents[2]);
                mulp = 100 / Integer.parseInt(appConfigComponents[2]);
            }
            String containersConfig = appConfigComponents[1];
            MockApplication mockApp = new MockApplication(this.id, containersConfig, queueName);
            new MockContainers(mockApp, this.nameToCSQueues, this.nodeIdToSchedulerNodes);
            this.add(mockApp);
            ++this.id;
        }
        this.setupUserResourceUsagePerLabel(this.resourceCalculator, mulp);
    }

    private void add(MockApplication mockApp) {
        LeafQueue queue = (LeafQueue)this.nameToCSQueues.get(mockApp.queueName);
        queue.getApplications().add(mockApp.app);
        queue.getAllApplications().add(mockApp.app);
        Mockito.when((Object)queue.getMinimumAllocation()).thenReturn((Object)Resource.newInstance((int)1, (int)1));
        Mockito.when((Object)mockApp.app.getCSLeafQueue()).thenReturn((Object)queue);
        LOG.debug("Application mock: queue: " + mockApp.queueName + ", appId:" + mockApp.app);
        Set users = this.userMap.computeIfAbsent(mockApp.queueName, k -> new HashSet());
        users.add(mockApp.app.getUser());
        String label = mockApp.app.getAppAMNodePartitionName();
        Map userResourceUsagePerQueue = this.userResourceUsagePerLabel.computeIfAbsent(label, k -> new HashMap());
        Map userResourceUsage = userResourceUsagePerQueue.computeIfAbsent(mockApp.queueName, k -> new HashMap());
        ResourceUsage usage = (ResourceUsage)userResourceUsage.get(mockApp.app.getUser());
        if (null == usage) {
            usage = new ResourceUsage();
            userResourceUsage.put(mockApp.app.getUser(), usage);
        }
        usage.incAMUsed(mockApp.app.getAMResource(label));
        usage.incUsed(mockApp.app.getAppAttemptResourceUsage().getUsed(label));
    }

    private void setupUserResourceUsagePerLabel(ResourceCalculator resourceCalculator, int mulp) {
        for (String label : this.userResourceUsagePerLabel.keySet()) {
            for (String queueName : this.userMap.keySet()) {
                LeafQueue queue = (LeafQueue)this.nameToCSQueues.get(queueName);
                Resource toResourcePartition = this.partitionToResource.get("");
                Resource capacity = Resources.multiply((Resource)toResourcePartition, (double)queue.getQueueCapacities().getAbsoluteCapacity());
                Set<String> users = this.userMap.get(queue.getQueueName());
                if (users == null) {
                    users = this.userMap.get(queue.getQueuePath());
                }
                Mockito.when((Object)queue.getAllUsers()).thenReturn(users);
                Resource userLimit = this.calculateUserLimit(resourceCalculator, mulp, capacity, users);
                LOG.debug("Updating user-limit from mock: toResourcePartition=" + toResourcePartition + ", capacity=" + capacity + ", users.size()=" + users.size() + ", userLimit= " + userLimit + ",label= " + label + ",queueName= " + queueName);
                this.setupUserToQueueSettings(label, queueName, queue, users, userLimit);
            }
        }
    }

    private void setupUserToQueueSettings(String label, String queueName, LeafQueue queue, Set<String> users, Resource userLimit) {
        Map userResourceUsage = this.userResourceUsagePerLabel.get(label).get(queueName);
        for (String userName : users) {
            UsersManager.User user = new UsersManager.User(userName);
            if (userResourceUsage != null) {
                user.setResourceUsage((ResourceUsage)userResourceUsage.get(userName));
            }
            Mockito.when((Object)queue.getUser((String)ArgumentMatchers.eq((Object)userName))).thenReturn((Object)user);
            Mockito.when((Object)queue.getOrCreateUser((String)ArgumentMatchers.eq((Object)userName))).thenReturn((Object)user);
            Mockito.when((Object)queue.getResourceLimitForAllUsers((String)ArgumentMatchers.eq((Object)userName), (Resource)ArgumentMatchers.any(Resource.class), ArgumentMatchers.anyString(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class))).thenReturn((Object)userLimit);
        }
    }

    private Resource calculateUserLimit(ResourceCalculator resourceCalculator, int mulp, Resource capacity, Set<String> users) {
        if (mulp > 0) {
            return Resources.divideAndCeil((ResourceCalculator)resourceCalculator, (Resource)capacity, (int)mulp);
        }
        return Resources.divideAndCeil((ResourceCalculator)resourceCalculator, (Resource)capacity, (int)users.size());
    }
}

