/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.FSSchedulerConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.InMemoryConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.LeveldbConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.ZKConfigurationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YarnConfigurationStoreFactory {
    private static final Logger LOG = LoggerFactory.getLogger(YarnConfigurationStoreFactory.class);

    private YarnConfigurationStoreFactory() {
    }

    public static YarnConfigurationStore getStore(Configuration conf) {
        String store;
        switch (store = conf.get("yarn.scheduler.configuration.store.class", "memory")) {
            case "memory": {
                return new InMemoryConfigurationStore();
            }
            case "leveldb": {
                return new LeveldbConfigurationStore();
            }
            case "zk": {
                return new ZKConfigurationStore();
            }
            case "fs": {
                return new FSSchedulerConfigurationStore();
            }
        }
        Class storeClass = conf.getClass("yarn.scheduler.configuration.store.class", InMemoryConfigurationStore.class, YarnConfigurationStore.class);
        LOG.info("Using YarnConfigurationStore implementation - " + storeClass);
        return (YarnConfigurationStore)ReflectionUtils.newInstance((Class)storeClass, (Configuration)conf);
    }
}

