/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.volume.csi;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.CsiAdaptorProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.VolumeBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.event.ControllerPublishVolumeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.event.ValidateVolumeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.event.VolumeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle.Volume;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle.VolumeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle.VolumeState;
import org.apache.hadoop.yarn.server.volume.csi.exception.VolumeException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestVolumeLifecycle {
    @Test
    public void testValidation() throws YarnException, IOException {
        CsiAdaptorProtocol mockedClient = (CsiAdaptorProtocol)Mockito.mock(CsiAdaptorProtocol.class);
        ((CsiAdaptorProtocol)Mockito.doReturn((Object)ValidateVolumeCapabilitiesResponse.newInstance((boolean)true, (String)"")).when((Object)mockedClient)).validateVolumeCapacity((ValidateVolumeCapabilitiesRequest)Mockito.any(ValidateVolumeCapabilitiesRequest.class));
        VolumeImpl volume = (VolumeImpl)VolumeBuilder.newBuilder().volumeId("test_vol_00000001").maxCapability(5L).unit("Gi").mountPoint("/path/to/mount").driverName("test-driver-name").build();
        volume.setClient(mockedClient);
        Assert.assertEquals((Object)VolumeState.NEW, (Object)volume.getVolumeState());
        volume.handle((VolumeEvent)new ValidateVolumeEvent((Volume)volume));
        Assert.assertEquals((Object)VolumeState.VALIDATED, (Object)volume.getVolumeState());
    }

    @Test
    public void testVolumeCapacityNotSupported() throws Exception {
        CsiAdaptorProtocol mockedClient = (CsiAdaptorProtocol)Mockito.mock(CsiAdaptorProtocol.class);
        VolumeImpl volume = (VolumeImpl)VolumeBuilder.newBuilder().volumeId("test_vol_00000001").build();
        volume.setClient(mockedClient);
        ((CsiAdaptorProtocol)Mockito.doReturn((Object)ValidateVolumeCapabilitiesResponse.newInstance((boolean)false, (String)"")).when((Object)mockedClient)).validateVolumeCapacity((ValidateVolumeCapabilitiesRequest)Mockito.any(ValidateVolumeCapabilitiesRequest.class));
        volume.handle((VolumeEvent)new ValidateVolumeEvent((Volume)volume));
        try {
            GenericTestUtils.waitFor(() -> volume.getVolumeState() == VolumeState.VALIDATED, (long)10L, (long)50L);
            Assert.fail((String)"Validate state not reached, it should keep waiting until timeout");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof TimeoutException));
            Assert.assertEquals((Object)VolumeState.UNAVAILABLE, (Object)volume.getVolumeState());
        }
    }

    @Test
    public void testValidationFailure() throws YarnException, IOException {
        CsiAdaptorProtocol mockedClient = (CsiAdaptorProtocol)Mockito.mock(CsiAdaptorProtocol.class);
        ((CsiAdaptorProtocol)Mockito.doThrow((Throwable[])new Throwable[]{new VolumeException("fail")}).when((Object)mockedClient)).validateVolumeCapacity((ValidateVolumeCapabilitiesRequest)Mockito.any(ValidateVolumeCapabilitiesRequest.class));
        VolumeImpl volume = (VolumeImpl)VolumeBuilder.newBuilder().volumeId("test_vol_00000001").build();
        volume.setClient(mockedClient);
        ((CsiAdaptorProtocol)Mockito.doThrow((Throwable[])new Throwable[]{new VolumeException("failed")}).when((Object)mockedClient)).validateVolumeCapacity((ValidateVolumeCapabilitiesRequest)Mockito.any(ValidateVolumeCapabilitiesRequest.class));
        volume.handle((VolumeEvent)new ValidateVolumeEvent((Volume)volume));
    }

    @Test
    public void testValidated() throws YarnException, IOException {
        VolumeImpl volume = (VolumeImpl)VolumeBuilder.newBuilder().volumeId("test_vol_00000001").build();
        CsiAdaptorProtocol mockedClient = (CsiAdaptorProtocol)Mockito.mock(CsiAdaptorProtocol.class);
        volume.setClient(mockedClient);
        ((CsiAdaptorProtocol)Mockito.doReturn((Object)ValidateVolumeCapabilitiesResponse.newInstance((boolean)true, (String)"")).when((Object)mockedClient)).validateVolumeCapacity((ValidateVolumeCapabilitiesRequest)Mockito.any(ValidateVolumeCapabilitiesRequest.class));
        Assert.assertEquals((Object)VolumeState.NEW, (Object)volume.getVolumeState());
        volume.handle((VolumeEvent)new ValidateVolumeEvent((Volume)volume));
        Assert.assertEquals((Object)VolumeState.VALIDATED, (Object)volume.getVolumeState());
        ((CsiAdaptorProtocol)Mockito.verify((Object)mockedClient, (VerificationMode)Mockito.times((int)1))).validateVolumeCapacity((ValidateVolumeCapabilitiesRequest)Mockito.any(ValidateVolumeCapabilitiesRequest.class));
        volume.handle((VolumeEvent)new ValidateVolumeEvent((Volume)volume));
        Assert.assertEquals((Object)VolumeState.VALIDATED, (Object)volume.getVolumeState());
        ((CsiAdaptorProtocol)Mockito.verify((Object)mockedClient, (VerificationMode)Mockito.times((int)1))).validateVolumeCapacity((ValidateVolumeCapabilitiesRequest)Mockito.any(ValidateVolumeCapabilitiesRequest.class));
    }

    @Test
    public void testUnavailableState() throws YarnException, IOException {
        VolumeImpl volume = (VolumeImpl)VolumeBuilder.newBuilder().volumeId("test_vol_00000001").build();
        CsiAdaptorProtocol mockedClient = (CsiAdaptorProtocol)Mockito.mock(CsiAdaptorProtocol.class);
        volume.setClient(mockedClient);
        ((CsiAdaptorProtocol)Mockito.doThrow((Throwable[])new Throwable[]{new VolumeException("failed")}).when((Object)mockedClient)).validateVolumeCapacity((ValidateVolumeCapabilitiesRequest)Mockito.any(ValidateVolumeCapabilitiesRequest.class));
        Assert.assertEquals((Object)VolumeState.NEW, (Object)volume.getVolumeState());
        volume.handle((VolumeEvent)new ValidateVolumeEvent((Volume)volume));
        Assert.assertEquals((Object)VolumeState.UNAVAILABLE, (Object)volume.getVolumeState());
        volume.handle((VolumeEvent)new ValidateVolumeEvent((Volume)volume));
        Assert.assertEquals((Object)VolumeState.UNAVAILABLE, (Object)volume.getVolumeState());
        ((CsiAdaptorProtocol)Mockito.doReturn((Object)ValidateVolumeCapabilitiesResponse.newInstance((boolean)true, (String)"")).when((Object)mockedClient)).validateVolumeCapacity((ValidateVolumeCapabilitiesRequest)Mockito.any(ValidateVolumeCapabilitiesRequest.class));
        volume.setClient(mockedClient);
        volume.handle((VolumeEvent)new ValidateVolumeEvent((Volume)volume));
        Assert.assertEquals((Object)VolumeState.VALIDATED, (Object)volume.getVolumeState());
    }

    @Test
    public void testPublishUnavailableVolume() throws YarnException, IOException {
        VolumeImpl volume = (VolumeImpl)VolumeBuilder.newBuilder().volumeId("test_vol_00000001").build();
        CsiAdaptorProtocol mockedClient = (CsiAdaptorProtocol)Mockito.mock(CsiAdaptorProtocol.class);
        volume.setClient(mockedClient);
        ((CsiAdaptorProtocol)Mockito.doThrow((Throwable[])new Throwable[]{new VolumeException("failed")}).when((Object)mockedClient)).validateVolumeCapacity((ValidateVolumeCapabilitiesRequest)Mockito.any(ValidateVolumeCapabilitiesRequest.class));
        Assert.assertEquals((Object)VolumeState.NEW, (Object)volume.getVolumeState());
        volume.handle((VolumeEvent)new ValidateVolumeEvent((Volume)volume));
        Assert.assertEquals((Object)VolumeState.UNAVAILABLE, (Object)volume.getVolumeState());
        volume.handle((VolumeEvent)new ControllerPublishVolumeEvent((Volume)volume));
        Assert.assertEquals((Object)VolumeState.UNAVAILABLE, (Object)volume.getVolumeState());
    }
}

