/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicyForNodePartitions;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.MockApplications;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.MockNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.MockQueueHierarchy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.MockSchedulerNodes;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerPreemptEvent;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProportionalCapacityPreemptionPolicyMockFramework {
    private static final Logger LOG = LoggerFactory.getLogger(TestProportionalCapacityPreemptionPolicyForNodePartitions.class);
    private static final double ALLOWED_CAPACITY_DELTA = 0.001;
    private Map<String, CSQueue> nameToCSQueues;
    private Map<String, Resource> partitionToResource;
    private Map<NodeId, FiCaSchedulerNode> nodeIdToSchedulerNodes;
    private RMNodeLabelsManager nodeLabelsManager;
    public RMContext rmContext;
    public ResourceCalculator resourceCalculator = new DefaultResourceCalculator();
    public Clock mClock;
    public CapacitySchedulerConfiguration conf;
    public CapacityScheduler cs;
    public EventHandler<Event> eventHandler;
    public ProportionalCapacityPreemptionPolicy policy;
    private Resource clusterResource;
    public Map<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();

    private void resetResourceInformationMap() {
        ResourceInformation memory = ResourceInformation.newInstance((String)ResourceInformation.MEMORY_MB.getName(), (String)ResourceInformation.MEMORY_MB.getUnits(), (long)1024L, (long)8192L);
        ResourceInformation vcores = ResourceInformation.newInstance((String)ResourceInformation.VCORES.getName(), (String)ResourceInformation.VCORES.getUnits(), (long)1L, (long)4L);
        this.riMap.put("memory-mb", memory);
        this.riMap.put("vcores", vcores);
        ResourceUtils.initializeResourcesFromResourceInformationMap(this.riMap);
    }

    @Before
    public void setup() {
        this.resetResourceInformationMap();
        org.apache.log4j.Logger.getRootLogger().setLevel(Level.DEBUG);
        this.conf = new CapacitySchedulerConfiguration(new Configuration(false));
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", 10000L);
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval", 3000L);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.total_preemption_per_round", 1.0f);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor", 1.0f);
        this.mClock = (Clock)Mockito.mock(Clock.class);
        this.cs = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        Mockito.when((Object)this.cs.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        Mockito.when((Object)this.cs.getPreemptionManager()).thenReturn((Object)new PreemptionManager());
        Mockito.when((Object)this.cs.getConfiguration()).thenReturn((Object)this.conf);
        this.nodeLabelsManager = (RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class);
        this.eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        this.rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)this.rmContext.getNodeLabelManager()).thenReturn((Object)this.nodeLabelsManager);
        Dispatcher dispatcher = (Dispatcher)Mockito.mock(Dispatcher.class);
        Mockito.when((Object)this.rmContext.getDispatcher()).thenReturn((Object)dispatcher);
        Mockito.when((Object)dispatcher.getEventHandler()).thenReturn(this.eventHandler);
        Mockito.when((Object)this.cs.getRMContext()).thenReturn((Object)this.rmContext);
        this.partitionToResource = new HashMap<String, Resource>();
        this.nodeIdToSchedulerNodes = new HashMap<NodeId, FiCaSchedulerNode>();
        this.nameToCSQueues = new HashMap<String, CSQueue>();
        this.clusterResource = Resource.newInstance((int)0, (int)0);
    }

    @After
    public void cleanup() {
        this.resetResourceInformationMap();
    }

    public void buildEnv(String labelsConfig, String nodesConfig, String queuesConfig, String appsConfig) throws IOException {
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig, false);
    }

    public void buildEnv(String labelsConfig, String nodesConfig, String queuesConfig, String appsConfig, boolean useDominantResourceCalculator) throws IOException {
        if (useDominantResourceCalculator) {
            Mockito.when((Object)this.cs.getResourceCalculator()).thenReturn((Object)new DominantResourceCalculator());
        }
        MockNodeLabelsManager mockNodeLabelsManager = new MockNodeLabelsManager(labelsConfig, this.nodeLabelsManager, this.partitionToResource);
        this.clusterResource = mockNodeLabelsManager.getClusterResource();
        MockSchedulerNodes mockSchedulerNodes = new MockSchedulerNodes(nodesConfig);
        this.nodeIdToSchedulerNodes = mockSchedulerNodes.getNodeIdToSchedulerNodes();
        this.addNodeIdDataToScheduler();
        ParentQueue root = this.parseQueueConfig(queuesConfig);
        Mockito.when((Object)this.cs.getRootQueue()).thenReturn((Object)root);
        Mockito.when((Object)this.cs.getClusterResource()).thenReturn((Object)this.clusterResource);
        new MockApplications(appsConfig, this.resourceCalculator, this.nameToCSQueues, this.partitionToResource, this.nodeIdToSchedulerNodes);
        this.policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.cs, this.mClock);
    }

    private ParentQueue parseQueueConfig(String queuesConfig) {
        MockQueueHierarchy mockQueueHierarchy = new MockQueueHierarchy(queuesConfig, this.cs, this.conf, this.resourceCalculator, this.partitionToResource);
        this.nameToCSQueues = mockQueueHierarchy.getNameToCSQueues();
        return mockQueueHierarchy.getRootQueue();
    }

    private void addNodeIdDataToScheduler() {
        for (NodeId nodeId : this.nodeIdToSchedulerNodes.keySet()) {
            Mockito.when((Object)((FiCaSchedulerNode)this.cs.getSchedulerNode(nodeId))).thenReturn((Object)this.nodeIdToSchedulerNodes.get(nodeId));
        }
        ArrayList<FiCaSchedulerNode> allNodes = new ArrayList<FiCaSchedulerNode>(this.nodeIdToSchedulerNodes.values());
        Mockito.when((Object)this.cs.getAllNodes()).thenReturn(allNodes);
    }

    protected void updateQueueConfig(String queuesConfig) {
        ParentQueue root = this.parseQueueConfig(queuesConfig);
        Mockito.when((Object)this.cs.getRootQueue()).thenReturn((Object)root);
    }

    static Resource parseResourceFromString(String resString) {
        Resource res;
        String[] resource = resString.split(":");
        if (resource.length == 1) {
            res = Resources.createResource((int)Integer.valueOf(resource[0]));
        } else {
            res = Resources.createResource((int)Integer.valueOf(resource[0]), (int)Integer.valueOf(resource[1]));
            if (resource.length > 2) {
                ResourceInformation[] storedResourceInfo = ResourceUtils.getResourceTypesArray();
                for (int i = 2; i < resource.length; ++i) {
                    res.setResourceInformation(storedResourceInfo[i].getName(), ResourceInformation.newInstance((String)storedResourceInfo[i].getName(), (String)storedResourceInfo[i].getUnits(), (long)Integer.valueOf(resource[i]).intValue()));
                }
            }
        }
        return res;
    }

    public ApplicationAttemptId getAppAttemptId(int id) {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)id);
        return ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
    }

    protected void checkContainerNodesInApp(FiCaSchedulerApp app, int expectedContainersNumber, String host) {
        NodeId nodeId = NodeId.newInstance((String)host, (int)1);
        int num = 0;
        for (RMContainer c : app.getLiveContainers()) {
            if (!c.getAllocatedNode().equals((Object)nodeId)) continue;
            ++num;
        }
        for (RMContainer c : app.getReservedContainers()) {
            if (!c.getAllocatedNode().equals((Object)nodeId)) continue;
            ++num;
        }
        Assert.assertEquals((long)expectedContainersNumber, (long)num);
    }

    public FiCaSchedulerApp getApp(String queueName, int appId) {
        for (FiCaSchedulerApp app : ((LeafQueue)this.cs.getQueue(queueName)).getApplications()) {
            if (app.getApplicationId().getId() != appId) continue;
            return app;
        }
        return null;
    }

    protected void checkAbsCapacities(CSQueue queue, String partition, float guaranteed, float max, float used) {
        QueueCapacities qc = queue.getQueueCapacities();
        Assert.assertEquals((double)guaranteed, (double)qc.getAbsoluteCapacity(partition), (double)0.001);
        Assert.assertEquals((double)max, (double)qc.getAbsoluteMaximumCapacity(partition), (double)0.001);
        Assert.assertEquals((double)used, (double)qc.getAbsoluteUsedCapacity(partition), (double)0.001);
    }

    protected void checkPendingResource(CSQueue queue, String partition, int pending) {
        ResourceUsage ru = queue.getQueueResourceUsage();
        Assert.assertEquals((long)pending, (long)ru.getPending(partition).getMemorySize());
    }

    protected void checkPriority(CSQueue queue, int expectedPriority) {
        Assert.assertEquals((long)expectedPriority, (long)queue.getPriority().getPriority());
    }

    protected void checkReservedResource(CSQueue queue, String partition, int reserved) {
        ResourceUsage ru = queue.getQueueResourceUsage();
        Assert.assertEquals((long)reserved, (long)ru.getReserved(partition).getMemorySize());
    }

    public static class IsPreemptionRequestForQueueAndNode
    implements ArgumentMatcher<ContainerPreemptEvent> {
        private final ApplicationAttemptId appAttId;
        private final String queueName;
        private final NodeId nodeId;

        public IsPreemptionRequestForQueueAndNode(ApplicationAttemptId appAttId, String queueName, NodeId nodeId) {
            this.appAttId = appAttId;
            this.queueName = queueName;
            this.nodeId = nodeId;
        }

        public boolean matches(ContainerPreemptEvent cpe) {
            return this.appAttId.equals((Object)cpe.getAppId()) && this.queueName.equals(cpe.getContainer().getQueueName()) && this.nodeId.equals((Object)cpe.getContainer().getAllocatedNode());
        }

        public String toString() {
            return this.appAttId.toString();
        }
    }
}

