/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigGeneratorForTest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesCapacitySchedDynamicConfig
extends JerseyTestBase {
    private final boolean legacyQueueMode;
    private static final String EXPECTED_FILE_TMPL = "webapp/dynamic-%s-%s.json";

    @Parameterized.Parameters(name="{index}: legacy-queue-mode={0}")
    public static Collection<Boolean> getParameters() {
        return Arrays.asList(true, false);
    }

    public TestRMWebServicesCapacitySchedDynamicConfig(boolean legacyQueueMode) {
        super(TestWebServiceUtil.createWebAppDescriptor());
        this.legacyQueueMode = legacyQueueMode;
    }

    @Test
    public void testPercentageMode() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", String.valueOf(this.legacyQueueMode));
        conf.put("yarn.scheduler.capacity.root.queues", "default, test1, test2");
        conf.put("yarn.scheduler.capacity.root.test1.queues", "test1_1, test1_2, test1_3");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "12.5");
        conf.put("yarn.scheduler.capacity.root.test1.capacity", "50");
        conf.put("yarn.scheduler.capacity.root.test2.capacity", "37.5");
        conf.put("yarn.scheduler.capacity.root.test1.test1_1.capacity", "12.5");
        conf.put("yarn.scheduler.capacity.root.test1.test1_2.capacity", "12.5");
        conf.put("yarn.scheduler.capacity.root.test1.test1_3.capacity", "75");
        try (MockRM rm = TestWebServiceUtil.createMutableRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testPercentageMode", rm, this.resource());
        }
    }

    @Test
    public void testAbsoluteMode() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", String.valueOf(this.legacyQueueMode));
        conf.put("yarn.scheduler.capacity.root.queues", "default, test1, test2");
        conf.put("yarn.scheduler.capacity.root.test1.queues", "test1_1, test1_2, test1_3");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "[memory=4096,vcores=4]");
        conf.put("yarn.scheduler.capacity.root.test1.capacity", "[memory=16384,vcores=16]");
        conf.put("yarn.scheduler.capacity.root.test2.capacity", "[memory=12288,vcores=12]");
        conf.put("yarn.scheduler.capacity.root.test1.test1_1.capacity", "[memory=2048,vcores=2]");
        conf.put("yarn.scheduler.capacity.root.test1.test1_2.capacity", "[memory=2048,vcores=2]");
        conf.put("yarn.scheduler.capacity.root.test1.test1_3.capacity", "[memory=12288,vcores=12]");
        try (MockRM rm = TestWebServiceUtil.createMutableRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testAbsoluteMode", rm, this.resource());
        }
    }

    @Test
    public void testWeightMode() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", String.valueOf(this.legacyQueueMode));
        conf.put("yarn.scheduler.capacity.root.queues", "default, test1, test2");
        conf.put("yarn.scheduler.capacity.root.test1.queues", "test1_1, test1_2, test1_3");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "4w");
        conf.put("yarn.scheduler.capacity.root.test1.capacity", "16w");
        conf.put("yarn.scheduler.capacity.root.test2.capacity", "12w");
        conf.put("yarn.scheduler.capacity.root.test1.test1_1.capacity", "2w");
        conf.put("yarn.scheduler.capacity.root.test1.test1_2.capacity", "2w");
        conf.put("yarn.scheduler.capacity.root.test1.test1_3.capacity", "12w");
        try (MockRM rm = TestWebServiceUtil.createMutableRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testWeightMode", rm, this.resource());
        }
    }

    @Test
    public void testWeightModeFlexibleAQC() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", String.valueOf(this.legacyQueueMode));
        conf.put("yarn.scheduler.capacity.root.queues", "default, test1, test2");
        conf.put("yarn.scheduler.capacity.root.test1.queues", "test1_1, test1_2, test1_3");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "4w");
        conf.put("yarn.scheduler.capacity.root.test1.capacity", "16w");
        conf.put("yarn.scheduler.capacity.root.test2.capacity", "12w");
        conf.put("yarn.scheduler.capacity.root.test1.test1_1.capacity", "2w");
        conf.put("yarn.scheduler.capacity.root.test1.test1_2.capacity", "2w");
        conf.put("yarn.scheduler.capacity.root.test1.test1_3.capacity", "12w");
        Configuration config = CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf);
        this.setupAQC(config, "yarn.scheduler.capacity.root.test2.");
        try (MockRM rm = TestWebServiceUtil.createMutableRM(config);){
            rm.registerNode("h1:1234", 32768, 32);
            TestWebServiceUtil.assertJsonResponse(TestWebServiceUtil.sendRequest(this.resource()), TestWebServiceUtil.getExpectedResourceFile(EXPECTED_FILE_TMPL, "testWeightMode", "before-aqc", this.legacyQueueMode));
            this.createDynamicQueues(rm, "test2");
            TestWebServiceUtil.reinitialize(rm, config);
            TestWebServiceUtil.assertJsonResponse(TestWebServiceUtil.sendRequest(this.resource()), TestWebServiceUtil.getExpectedResourceFile(EXPECTED_FILE_TMPL, "testWeightMode", "after-aqc", this.legacyQueueMode));
        }
    }

    private void setupAQC(Configuration config, String queueWithConfigPrefix) {
        config.set(queueWithConfigPrefix + "auto-queue-creation-v2.enabled", "true");
        config.set(queueWithConfigPrefix + "auto-queue-creation-v2.maximum-queue-depth", "10");
        config.set(queueWithConfigPrefix + "auto-queue-creation-v2.leaf-template.capacity", "10w");
        config.set(queueWithConfigPrefix + "auto-queue-creation-v2.parent-template.acl_submit_applications", "parentUser");
        config.set(queueWithConfigPrefix + "auto-queue-creation-v2.parent-template.acl_administer_queue", "parentAdmin");
        config.set(queueWithConfigPrefix + "autoParent1.auto-queue-creation-v2.leaf-template.acl_submit_applications", "ap1User");
        config.set(queueWithConfigPrefix + "autoParent1.auto-queue-creation-v2.leaf-template.acl_administer_queue", "ap1Admin");
        config.set(queueWithConfigPrefix + "*.auto-queue-creation-v2.leaf-template.acl_submit_applications", "leafUser");
        config.set(queueWithConfigPrefix + "*.auto-queue-creation-v2.leaf-template.acl_administer_queue", "leafAdmin");
        config.set(queueWithConfigPrefix + "parent.*.auto-queue-creation-v2.leaf-template.acl_submit_applications", "pLeafUser");
        config.set(queueWithConfigPrefix + "parent.*.auto-queue-creation-v2.leaf-template.acl_administer_queue", "pLeafAdmin");
        config.set(queueWithConfigPrefix + "autoParent1.auto-queue-creation-v2.template.maximum-applications", "300");
    }

    private void createDynamicQueues(MockRM rm, String queueName) {
        try {
            CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
            CapacitySchedulerQueueManager autoQueueHandler = cs.getCapacitySchedulerQueueManager();
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".auto1"));
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".auto2"));
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".autoParent1.auto3"));
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".autoParent1.auto4"));
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".autoParent2.auto5"));
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".parent.autoParent2.auto6"));
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".parent2.auto7"));
        }
        catch (IOException | YarnException e) {
            Assertions.fail((String)("Can not auto create queues under " + queueName), (Throwable)e);
        }
    }
}

