/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.IteratorSelector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.MockSchedulableEntity;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;
import org.junit.Assert;
import org.junit.Test;

public class TestFifoOrderingPolicy {
    @Test
    public void testFifoOrderingPolicy() {
        FifoOrderingPolicy policy = new FifoOrderingPolicy();
        MockSchedulableEntity r1 = new MockSchedulableEntity();
        MockSchedulableEntity r2 = new MockSchedulableEntity();
        Assert.assertEquals((String)"The comparator should return 0 because the entities are created with the same values.", (long)0L, (long)policy.getComparator().compare(r1, r2));
        r1.setSerial(1L);
        Assert.assertEquals((String)"The lhs entity has a larger serial, the comparator return value should be 1.", (long)1L, (long)policy.getComparator().compare(r1, r2));
        r2.setSerial(2L);
        Assert.assertEquals((String)"The rhs entity has a larger serial, the comparator return value should be -1.", (long)-1L, (long)policy.getComparator().compare(r1, r2));
    }

    @Test
    public void testIterators() {
        FifoOrderingPolicy schedOrder = new FifoOrderingPolicy();
        MockSchedulableEntity msp1 = new MockSchedulableEntity();
        MockSchedulableEntity msp2 = new MockSchedulableEntity();
        MockSchedulableEntity msp3 = new MockSchedulableEntity();
        msp1.setSerial(3L);
        msp2.setSerial(2L);
        msp3.setSerial(1L);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp1);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp2);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp3);
        this.checkSerials(Arrays.asList(1L, 2L, 3L), schedOrder.getAssignmentIterator(IteratorSelector.EMPTY_ITERATOR_SELECTOR));
        this.checkSerials(Arrays.asList(3L, 2L, 1L), schedOrder.getPreemptionIterator());
    }

    public void checkSerials(List<Long> expectedSerials, Iterator<MockSchedulableEntity> actualSerialIterator) {
        for (long expectedSerial : expectedSerials) {
            Assert.assertEquals((long)expectedSerial, (long)actualSerialIterator.next().getSerial());
        }
    }

    @Test
    public void testFifoOrderingPolicyAlongWithPriority() {
        FifoOrderingPolicy policy = new FifoOrderingPolicy();
        MockSchedulableEntity r1 = new MockSchedulableEntity();
        MockSchedulableEntity r2 = new MockSchedulableEntity();
        Assert.assertEquals((String)"Both r1 and r2 priority is null, the comparator should return 0.", (long)0L, (long)policy.getComparator().compare(r1, r2));
        Priority p2 = Priority.newInstance((int)0);
        r2.setApplicationPriority(p2);
        Assert.assertTrue((String)"The priority of r1 is null, the priority of r2 is not null, the comparator should return a negative value.", (policy.getComparator().compare(r1, r2) < 0 ? 1 : 0) != 0);
        Priority p1 = Priority.newInstance((int)1);
        r1.setApplicationPriority(p1);
        r2.setApplicationPriority(null);
        Assert.assertTrue((String)"The priority of r1 is not null, the priority of r2 is null,the comparator should return a positive value.", (policy.getComparator().compare(r1, r2) > 0 ? 1 : 0) != 0);
        r1.setApplicationPriority(p1);
        r2.setApplicationPriority(p2);
        Assert.assertTrue((String)"Both priorities are not null, the r1 has higher priority, the result should be a negative value.", (policy.getComparator().compare(r1, r2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOrderingUsingAppSubmitTime() {
        FifoOrderingPolicy policy = new FifoOrderingPolicy();
        MockSchedulableEntity r1 = new MockSchedulableEntity();
        MockSchedulableEntity r2 = new MockSchedulableEntity();
        Assert.assertEquals((long)r1.getStartTime(), (long)r2.getStartTime());
        Assert.assertEquals((String)"The submit times are the same, the comparator should return 0.", (long)0L, (long)policy.getComparator().compare(r1, r2));
        r1.setStartTime(5L);
        r2.setStartTime(10L);
        Assert.assertTrue((String)"r2 was started after r1, the comparator should return a negative value.", (policy.getComparator().compare(r1, r2) < 0 ? 1 : 0) != 0);
        r1.setStartTime(10L);
        r2.setStartTime(5L);
        Assert.assertTrue((String)"r2 was started before r1, the comparator should return a positive value.", (policy.getComparator().compare(r1, r2) > 0 ? 1 : 0) != 0);
    }
}

