/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.mockito.Mockito;

public abstract class WeightConverterTestBase {
    protected FSQueue createFSQueues(int ... weights) {
        char current = 'a';
        ArrayList<FSQueue> queues = new ArrayList<FSQueue>();
        for (int w : weights) {
            FSQueue queue = (FSQueue)Mockito.mock(FSQueue.class);
            Mockito.when((Object)Float.valueOf(queue.getWeight())).thenReturn((Object)Float.valueOf(w));
            Mockito.when((Object)queue.getName()).thenReturn((Object)("root." + new String(new char[]{current})));
            Mockito.when((Object)queue.getMinShare()).thenReturn((Object)Resources.none());
            current = (char)(current + 1);
            queues.add(queue);
        }
        return this.createParent(queues);
    }

    protected FSParentQueue createParent(List<FSQueue> children) {
        FSParentQueue root = (FSParentQueue)Mockito.mock(FSParentQueue.class);
        Mockito.when((Object)Float.valueOf(root.getWeight())).thenReturn((Object)Float.valueOf(1.0f));
        Mockito.when((Object)root.getName()).thenReturn((Object)"root");
        Mockito.when((Object)root.getMinShare()).thenReturn((Object)Resources.none());
        Mockito.when((Object)root.getChildQueues()).thenReturn(children);
        return root;
    }
}

