/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionOptions;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConvertedConfigValidator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.DryRunResultHolder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigConverterTestCommons;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigArgumentHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigConverter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigConverterParams;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.PreconditionException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.UnsupportedPropertyException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.VerificationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class TestFSConfigToCSConfigArgumentHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TestFSConfigToCSConfigArgumentHandler.class);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private FSConfigToCSConfigConverter mockConverter;
    @Mock
    private ConvertedConfigValidator mockValidator;
    private DryRunResultHolder dryRunResultHolder;
    private ConversionOptions conversionOptions;
    private FSConfigConverterTestCommons fsTestCommons;

    @Before
    public void setUp() throws IOException {
        this.fsTestCommons = new FSConfigConverterTestCommons();
        this.fsTestCommons.setUp();
        this.dryRunResultHolder = new DryRunResultHolder();
        this.conversionOptions = new ConversionOptions(this.dryRunResultHolder, false);
    }

    @After
    public void tearDown() {
        QueueMetrics.clearQueueMetrics();
        this.fsTestCommons.tearDown();
    }

    private void setupFSConfigConversionFiles(boolean defineAllocationFile) throws IOException {
        FSConfigConverterTestCommons.configureFairSchedulerXml();
        if (defineAllocationFile) {
            FSConfigConverterTestCommons.configureYarnSiteXmlWithFsAllocFileDefined();
        } else {
            FSConfigConverterTestCommons.configureEmptyYarnSiteXml();
        }
        FSConfigConverterTestCommons.configureDummyConversionRulesFile();
    }

    private FSConfigToCSConfigArgumentHandler createArgumentHandler() {
        FSConfigToCSConfigArgumentHandler argumentHandler = new FSConfigToCSConfigArgumentHandler();
        argumentHandler.setConverterSupplier(this::getMockConverter);
        return argumentHandler;
    }

    private FSConfigToCSConfigConverter getMockConverter() {
        return this.mockConverter;
    }

    private static String[] getDefaultArgumentsAsArray() {
        List<String> args = TestFSConfigToCSConfigArgumentHandler.getDefaultArguments();
        return args.toArray(new String[0]);
    }

    private static List<String> getDefaultArguments() {
        return Lists.newArrayList((Object[])new String[]{"-y", FSConfigConverterTestCommons.YARN_SITE_XML, "-o", FSConfigConverterTestCommons.OUTPUT_DIR});
    }

    private static List<String> getDefaultArgumentsWithNoOutput() {
        return Lists.newArrayList((Object[])new String[]{"-y", FSConfigConverterTestCommons.YARN_SITE_XML});
    }

    private String[] getArgumentsAsArrayWithDefaults(String ... args) {
        List<String> result = TestFSConfigToCSConfigArgumentHandler.getDefaultArguments();
        result.addAll(Arrays.asList(args));
        return result.toArray(new String[0]);
    }

    private String[] getArgumentsAsArrayWithDefaultsNoOutput(String ... args) {
        List<String> result = TestFSConfigToCSConfigArgumentHandler.getDefaultArgumentsWithNoOutput();
        result.addAll(Arrays.asList(args));
        return result.toArray(new String[0]);
    }

    private String[] getArgumentsAsArray(String ... args) {
        ArrayList result = Lists.newArrayList();
        result.addAll(Arrays.asList(args));
        return result.toArray(new String[0]);
    }

    @Test
    public void testMissingYarnSiteXmlArgument() throws Exception {
        this.setupFSConfigConversionFiles(true);
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        String[] args = new String[]{"-o", FSConfigConverterTestCommons.OUTPUT_DIR};
        int retVal = argumentHandler.parseAndConvert(args);
        Assert.assertEquals((String)"Return value", (long)-1L, (long)retVal);
        Assert.assertTrue((String)"Error content missing", (boolean)this.fsTestCommons.getErrContent().toString().contains("Missing yarn-site.xml parameter"));
    }

    @Test
    public void testMissingFairSchedulerXmlArgument() throws Exception {
        this.setupFSConfigConversionFiles(true);
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        argumentHandler.parseAndConvert(TestFSConfigToCSConfigArgumentHandler.getDefaultArgumentsAsArray());
    }

    @Test
    public void testMissingOutputDirArgument() throws Exception {
        this.setupFSConfigConversionFiles(true);
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        String[] args = new String[]{"-y", FSConfigConverterTestCommons.YARN_SITE_XML};
        int retVal = argumentHandler.parseAndConvert(args);
        Assert.assertEquals((String)"Return value", (long)-1L, (long)retVal);
        Assert.assertTrue((String)"Error content missing", (boolean)this.fsTestCommons.getErrContent().toString().contains("Output directory or console mode was not defined"));
    }

    @Test
    public void testMissingRulesConfiguration() throws Exception {
        this.setupFSConfigConversionFiles(true);
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        argumentHandler.parseAndConvert(TestFSConfigToCSConfigArgumentHandler.getDefaultArgumentsAsArray());
    }

    @Test
    public void testInvalidRulesConfigFile() throws Exception {
        FSConfigConverterTestCommons.configureYarnSiteXmlWithFsAllocFileDefined();
        FSConfigConverterTestCommons.configureFairSchedulerXml();
        FSConfigConverterTestCommons.configureInvalidConversionRulesFile();
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        String[] args = this.getArgumentsAsArrayWithDefaults(new String[0]);
        argumentHandler.parseAndConvert(args);
    }

    @Test
    public void testInvalidOutputDir() throws Exception {
        FSConfigConverterTestCommons.configureYarnSiteXmlWithFsAllocFileDefined();
        FSConfigConverterTestCommons.configureFairSchedulerXml();
        FSConfigConverterTestCommons.configureDummyConversionRulesFile();
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        String[] args = this.getArgumentsAsArray("-y", FSConfigConverterTestCommons.YARN_SITE_XML, "-o", FSConfigConverterTestCommons.YARN_SITE_XML);
        int retVal = argumentHandler.parseAndConvert(args);
        Assert.assertEquals((String)"Return value", (long)-1L, (long)retVal);
        Assert.assertTrue((String)"Error content missing", (boolean)this.fsTestCommons.getErrContent().toString().contains("Cannot start FS config conversion due to the following precondition error"));
    }

    @Test
    public void testVerificationException() throws Exception {
        this.setupFSConfigConversionFiles(true);
        ConversionOptions mockOptions = (ConversionOptions)Mockito.mock(ConversionOptions.class);
        FSConfigToCSConfigArgumentHandler argumentHandler = new FSConfigToCSConfigArgumentHandler(mockOptions, this.mockValidator);
        argumentHandler.setConverterSupplier(this::getMockConverter);
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE);
        ((FSConfigToCSConfigConverter)Mockito.doThrow((Throwable[])new Throwable[]{new VerificationException("test", (Throwable)new Exception("test"))}).when((Object)this.mockConverter)).convert((FSConfigToCSConfigConverterParams)ArgumentMatchers.any(FSConfigToCSConfigConverterParams.class));
        argumentHandler.parseAndConvert(args);
        ((ConversionOptions)Mockito.verify((Object)mockOptions)).handleVerificationFailure((Throwable)ArgumentMatchers.any(Exception.class), (String)ArgumentMatchers.any(String.class));
    }

    @Test
    public void testFairSchedulerXmlIsNotDefinedIfItsDefinedInYarnSiteXml() throws Exception {
        this.setupFSConfigConversionFiles(true);
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        argumentHandler.parseAndConvert(TestFSConfigToCSConfigArgumentHandler.getDefaultArgumentsAsArray());
    }

    @Test
    public void testEmptyYarnSiteXmlSpecified() throws Exception {
        FSConfigConverterTestCommons.configureFairSchedulerXml();
        FSConfigConverterTestCommons.configureEmptyYarnSiteXml();
        FSConfigConverterTestCommons.configureDummyConversionRulesFile();
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE);
        argumentHandler.parseAndConvert(args);
    }

    @Test
    public void testEmptyFairSchedulerXmlSpecified() throws Exception {
        FSConfigConverterTestCommons.configureEmptyFairSchedulerXml();
        FSConfigConverterTestCommons.configureEmptyYarnSiteXml();
        FSConfigConverterTestCommons.configureDummyConversionRulesFile();
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE);
        argumentHandler.parseAndConvert(args);
    }

    @Test
    public void testEmptyRulesConfigurationSpecified() throws Exception {
        FSConfigConverterTestCommons.configureEmptyFairSchedulerXml();
        FSConfigConverterTestCommons.configureEmptyYarnSiteXml();
        FSConfigConverterTestCommons.configureEmptyConversionRulesFile();
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE);
        argumentHandler.parseAndConvert(args);
    }

    @Test
    public void testConvertFSConfigurationDefaults() throws Exception {
        this.setupFSConfigConversionFiles(true);
        ArgumentCaptor conversionParams = ArgumentCaptor.forClass(FSConfigToCSConfigConverterParams.class);
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE);
        argumentHandler.parseAndConvert(args);
        ((FSConfigToCSConfigConverter)Mockito.verify((Object)this.mockConverter)).convert((FSConfigToCSConfigConverterParams)conversionParams.capture());
        FSConfigToCSConfigConverterParams params = (FSConfigToCSConfigConverterParams)conversionParams.getValue();
        LOG.info("FS config converter parameters: " + params);
        Assert.assertEquals((String)"Yarn site config", (Object)FSConfigConverterTestCommons.YARN_SITE_XML, (Object)params.getYarnSiteXmlConfig());
        Assert.assertEquals((String)"FS xml", (Object)FSConfigConverterTestCommons.FS_ALLOC_FILE, (Object)params.getFairSchedulerXmlConfig());
        Assert.assertEquals((String)"Conversion rules config", (Object)FSConfigConverterTestCommons.CONVERSION_RULES_FILE, (Object)params.getConversionRulesConfig());
        Assert.assertFalse((String)"Console mode", (boolean)params.isConsole());
    }

    @Test
    public void testConvertFSConfigurationWithConsoleParam() throws Exception {
        this.setupFSConfigConversionFiles(true);
        ArgumentCaptor conversionParams = ArgumentCaptor.forClass(FSConfigToCSConfigConverterParams.class);
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE, "-p");
        argumentHandler.parseAndConvert(args);
        ((FSConfigToCSConfigConverter)Mockito.verify((Object)this.mockConverter)).convert((FSConfigToCSConfigConverterParams)conversionParams.capture());
        FSConfigToCSConfigConverterParams params = (FSConfigToCSConfigConverterParams)conversionParams.getValue();
        LOG.info("FS config converter parameters: " + params);
        Assert.assertEquals((String)"Yarn site config", (Object)FSConfigConverterTestCommons.YARN_SITE_XML, (Object)params.getYarnSiteXmlConfig());
        Assert.assertEquals((String)"FS xml", (Object)FSConfigConverterTestCommons.FS_ALLOC_FILE, (Object)params.getFairSchedulerXmlConfig());
        Assert.assertEquals((String)"Conversion rules config", (Object)FSConfigConverterTestCommons.CONVERSION_RULES_FILE, (Object)params.getConversionRulesConfig());
        Assert.assertTrue((String)"Console mode", (boolean)params.isConsole());
    }

    @Test
    public void testConvertFSConfigurationClusterResource() throws Exception {
        this.setupFSConfigConversionFiles(true);
        ArgumentCaptor conversionParams = ArgumentCaptor.forClass(FSConfigToCSConfigConverterParams.class);
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE, "-p", "-c", "vcores=20, memory-mb=240");
        argumentHandler.parseAndConvert(args);
        ((FSConfigToCSConfigConverter)Mockito.verify((Object)this.mockConverter)).convert((FSConfigToCSConfigConverterParams)conversionParams.capture());
        FSConfigToCSConfigConverterParams params = (FSConfigToCSConfigConverterParams)conversionParams.getValue();
        LOG.info("FS config converter parameters: " + params);
        Assert.assertEquals((String)"Yarn site config", (Object)FSConfigConverterTestCommons.YARN_SITE_XML, (Object)params.getYarnSiteXmlConfig());
        Assert.assertEquals((String)"FS xml", (Object)FSConfigConverterTestCommons.FS_ALLOC_FILE, (Object)params.getFairSchedulerXmlConfig());
        Assert.assertEquals((String)"Conversion rules config", (Object)FSConfigConverterTestCommons.CONVERSION_RULES_FILE, (Object)params.getConversionRulesConfig());
        Assert.assertEquals((String)"Cluster resource", (Object)"vcores=20, memory-mb=240", (Object)params.getClusterResource());
        Assert.assertTrue((String)"Console mode", (boolean)params.isConsole());
    }

    @Test
    public void testConvertFSConfigurationErrorHandling() throws Exception {
        this.setupFSConfigConversionFiles(true);
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE, "-p");
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        ((FSConfigToCSConfigConverter)Mockito.doThrow(UnsupportedPropertyException.class).when((Object)this.mockConverter)).convert((FSConfigToCSConfigConverterParams)ArgumentMatchers.any(FSConfigToCSConfigConverterParams.class));
        int retVal = argumentHandler.parseAndConvert(args);
        Assert.assertEquals((String)"Return value", (long)-1L, (long)retVal);
        Assert.assertTrue((String)"Error content missing", (boolean)this.fsTestCommons.getErrContent().toString().contains("Unsupported property/setting encountered"));
    }

    @Test
    public void testConvertFSConfigurationErrorHandling2() throws Exception {
        this.setupFSConfigConversionFiles(true);
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE, "-p");
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        ((FSConfigToCSConfigConverter)Mockito.doThrow(ConversionException.class).when((Object)this.mockConverter)).convert((FSConfigToCSConfigConverterParams)ArgumentMatchers.any(FSConfigToCSConfigConverterParams.class));
        int retVal = argumentHandler.parseAndConvert(args);
        Assert.assertEquals((String)"Return value", (long)-1L, (long)retVal);
        Assert.assertTrue((String)"Error content missing", (boolean)this.fsTestCommons.getErrContent().toString().contains("Fatal error during FS config conversion"));
    }

    @Test
    public void testDryRunWhenPreconditionExceptionOccurs() throws Exception {
        this.testDryRunWithException((Exception)new PreconditionException("test"), "Cannot start FS config conversion");
    }

    @Test
    public void testDryRunWhenUnsupportedPropertyExceptionExceptionOccurs() throws Exception {
        this.testDryRunWithException((Exception)((Object)new UnsupportedPropertyException("test")), "Unsupported property/setting encountered");
    }

    @Test
    public void testDryRunWhenConversionExceptionExceptionOccurs() throws Exception {
        this.testDryRunWithException((Exception)new ConversionException("test"), "Fatal error during FS config conversion");
    }

    @Test
    public void testDryRunWhenIllegalArgumentExceptionExceptionOccurs() throws Exception {
        this.testDryRunWithException(new IllegalArgumentException("test"), "Fatal error during FS config conversion");
    }

    private void testDryRunWithException(Exception exception, String expectedErrorMessage) throws Exception {
        this.setupFSConfigConversionFiles(true);
        String[] args = this.getArgumentsAsArrayWithDefaultsNoOutput("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE, "-d");
        FSConfigToCSConfigArgumentHandler argumentHandler = new FSConfigToCSConfigArgumentHandler(this.conversionOptions, this.mockValidator);
        argumentHandler.setConverterSupplier(this::getMockConverter);
        ((FSConfigToCSConfigConverter)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.mockConverter)).convert((FSConfigToCSConfigConverterParams)ArgumentMatchers.any(FSConfigToCSConfigConverterParams.class));
        int retVal = argumentHandler.parseAndConvert(args);
        Assert.assertEquals((String)"Return value", (long)-1L, (long)retVal);
        Assert.assertEquals((String)"Number of errors", (long)1L, (long)this.dryRunResultHolder.getErrors().size());
        String error = (String)this.dryRunResultHolder.getErrors().iterator().next();
        Assert.assertTrue((String)"Unexpected error message", (boolean)error.contains(expectedErrorMessage));
    }

    @Test
    public void testDisabledTerminalRuleCheck() throws Exception {
        this.setupFSConfigConversionFiles(true);
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE, "-p", "-t");
        FSConfigToCSConfigArgumentHandler argumentHandler = new FSConfigToCSConfigArgumentHandler(this.conversionOptions, this.mockValidator);
        argumentHandler.setConverterSupplier(this::getMockConverter);
        argumentHandler.parseAndConvert(args);
        Assert.assertTrue((String)"-t switch had no effect", (boolean)this.conversionOptions.isNoRuleTerminalCheck());
    }

    @Test
    public void testEnabledTerminalRuleCheck() throws Exception {
        this.setupFSConfigConversionFiles(true);
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE, "-p");
        FSConfigToCSConfigArgumentHandler argumentHandler = new FSConfigToCSConfigArgumentHandler(this.conversionOptions, this.mockValidator);
        argumentHandler.setConverterSupplier(this::getMockConverter);
        argumentHandler.parseAndConvert(args);
        Assert.assertFalse((String)"No terminal rule check was enabled", (boolean)this.conversionOptions.isNoRuleTerminalCheck());
    }

    @Test
    public void testYarnSiteOptionInOutputFolder() throws Exception {
        this.setupFSConfigConversionFiles(true);
        FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
        String[] args = new String[]{"-y", FSConfigConverterTestCommons.YARN_SITE_XML, "-o", FSConfigConverterTestCommons.TEST_DIR};
        int retVal = argumentHandler.parseAndConvert(args);
        Assert.assertEquals((String)"Return value", (long)-1L, (long)retVal);
        Assert.assertTrue((boolean)this.fsTestCommons.getErrContent().toString().contains("contains the yarn-site.xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFileExistsInOutputFolder(String file) throws Exception {
        File testFile = new File(FSConfigConverterTestCommons.OUTPUT_DIR, file);
        try {
            FileUtils.touch((File)testFile);
            this.setupFSConfigConversionFiles(true);
            FSConfigToCSConfigArgumentHandler argumentHandler = this.createArgumentHandler();
            String[] args = new String[]{"-y", FSConfigConverterTestCommons.YARN_SITE_XML, "-o", FSConfigConverterTestCommons.OUTPUT_DIR, "-e"};
            int retVal = argumentHandler.parseAndConvert(args);
            Assert.assertEquals((String)"Return value", (long)-1L, (long)retVal);
            String expectedMessage = String.format("already contains a file or directory named %s", file);
            Assert.assertTrue((boolean)this.fsTestCommons.getErrContent().toString().contains(expectedMessage));
        }
        finally {
            if (testFile.exists()) {
                testFile.delete();
            }
        }
    }

    @Test
    public void testYarnSiteExistsInOutputFolder() throws Exception {
        this.testFileExistsInOutputFolder("yarn-site.xml");
    }

    @Test
    public void testCapacitySchedulerXmlExistsInOutputFolder() throws Exception {
        this.testFileExistsInOutputFolder("capacity-scheduler.xml");
    }

    @Test
    public void testMappingRulesJsonExistsInOutputFolder() throws Exception {
        this.testFileExistsInOutputFolder("mapping-rules.json");
    }

    @Test
    public void testPlacementRulesConversionEnabled() throws Exception {
        this.testPlacementRuleConversion(true);
    }

    @Test
    public void testPlacementRulesConversionDisabled() throws Exception {
        this.testPlacementRuleConversion(false);
    }

    private void testPlacementRuleConversion(boolean enabled) throws Exception {
        this.setupFSConfigConversionFiles(true);
        String[] args = null;
        args = enabled ? this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-p") : this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-p", "-sp");
        FSConfigToCSConfigArgumentHandler argumentHandler = new FSConfigToCSConfigArgumentHandler(this.conversionOptions, this.mockValidator);
        argumentHandler.setConverterSupplier(this::getMockConverter);
        argumentHandler.parseAndConvert(args);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FSConfigToCSConfigConverterParams.class);
        ((FSConfigToCSConfigConverter)Mockito.verify((Object)this.mockConverter)).convert((FSConfigToCSConfigConverterParams)captor.capture());
        FSConfigToCSConfigConverterParams params = (FSConfigToCSConfigConverterParams)captor.getValue();
        if (enabled) {
            Assert.assertTrue((String)"Conversion should be enabled by default", (boolean)params.isConvertPlacementRules());
        } else {
            Assert.assertFalse((String)"-sp switch had no effect", (boolean)params.isConvertPlacementRules());
        }
    }

    public void testValidatorInvocation() throws Exception {
        this.setupFSConfigConversionFiles(true);
        FSConfigToCSConfigArgumentHandler argumentHandler = new FSConfigToCSConfigArgumentHandler(this.conversionOptions, this.mockValidator);
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE);
        argumentHandler.parseAndConvert(args);
        ((ConvertedConfigValidator)Mockito.verify((Object)this.mockValidator)).validateConvertedConfig(ArgumentMatchers.anyString());
    }

    @Test
    public void testValidationSkippedWhenCmdLineSwitchIsDefined() throws Exception {
        this.setupFSConfigConversionFiles(true);
        FSConfigToCSConfigArgumentHandler argumentHandler = new FSConfigToCSConfigArgumentHandler(this.conversionOptions, this.mockValidator);
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-s");
        argumentHandler.parseAndConvert(args);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockValidator});
    }

    @Test
    public void testValidationSkippedWhenOutputIsConsole() throws Exception {
        this.setupFSConfigConversionFiles(true);
        FSConfigToCSConfigArgumentHandler argumentHandler = new FSConfigToCSConfigArgumentHandler(this.conversionOptions, this.mockValidator);
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-s", "-p");
        argumentHandler.parseAndConvert(args);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockValidator});
    }

    @Test
    public void testEnabledAsyncScheduling() throws Exception {
        this.setupFSConfigConversionFiles(true);
        FSConfigToCSConfigArgumentHandler argumentHandler = new FSConfigToCSConfigArgumentHandler(this.conversionOptions, this.mockValidator);
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-p", "-a");
        argumentHandler.parseAndConvert(args);
        Assert.assertTrue((String)"-a switch had no effect", (boolean)this.conversionOptions.isEnableAsyncScheduler());
    }

    @Test
    public void testDisabledAsyncScheduling() throws Exception {
        this.setupFSConfigConversionFiles(true);
        FSConfigToCSConfigArgumentHandler argumentHandler = new FSConfigToCSConfigArgumentHandler(this.conversionOptions, this.mockValidator);
        String[] args = this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-p");
        argumentHandler.parseAndConvert(args);
        Assert.assertFalse((String)"-a switch wasn't provided but async scheduling option is true", (boolean)this.conversionOptions.isEnableAsyncScheduler());
    }

    @Test
    public void testUsePercentages() throws Exception {
        this.testUsePercentages(true);
    }

    @Test
    public void testUseWeights() throws Exception {
        this.testUsePercentages(false);
    }

    private void testUsePercentages(boolean enabled) throws Exception {
        this.setupFSConfigConversionFiles(true);
        FSConfigToCSConfigArgumentHandler argumentHandler = new FSConfigToCSConfigArgumentHandler(this.conversionOptions, this.mockValidator);
        argumentHandler.setConverterSupplier(this::getMockConverter);
        String[] args = enabled ? this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-p", "-pc") : this.getArgumentsAsArrayWithDefaults("-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-p");
        argumentHandler.parseAndConvert(args);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FSConfigToCSConfigConverterParams.class);
        ((FSConfigToCSConfigConverter)Mockito.verify((Object)this.mockConverter)).convert((FSConfigToCSConfigConverterParams)captor.capture());
        FSConfigToCSConfigConverterParams params = (FSConfigToCSConfigConverterParams)captor.getValue();
        Assert.assertEquals((String)"Use percentages", (Object)enabled, (Object)params.isUsePercentages());
    }
}

