/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.impl.LightWeightResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.CustomResourceTypesConfigurationProvider;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestFairSchedulerConfiguration {
    private static final String A_CUSTOM_RESOURCE = "a-custom-resource";
    @Rule
    public ExpectedException exception = ExpectedException.none();

    private void expectMissingResource(String resource) {
        this.exception.expect(AllocationConfigurationException.class);
        this.exception.expectMessage("Missing resource: " + resource);
    }

    private void expectUnparsableResource(String resource) {
        this.exception.expect(AllocationConfigurationException.class);
        this.exception.expectMessage("Cannot parse resource values from input: " + resource);
    }

    private void expectInvalidResource(String resource) {
        this.exception.expect(AllocationConfigurationException.class);
        this.exception.expectMessage("Invalid value of " + resource + ": ");
    }

    private void expectInvalidResourcePercentage(String resource) {
        this.exception.expect(AllocationConfigurationException.class);
        this.exception.expectMessage("Invalid percentage of " + resource + ": ");
    }

    private void expectInvalidResourcePercentageNewStyle(String value) {
        this.exception.expect(AllocationConfigurationException.class);
        this.exception.expectMessage("\"" + value + "\" is either not a non-negative number");
    }

    private void expectNegativePercentageOldStyle() {
        this.exception.expect(AllocationConfigurationException.class);
        this.exception.expectMessage("percentage should not be negative");
    }

    private void expectNegativePercentageNewStyle() {
        this.exception.expect(AllocationConfigurationException.class);
        this.exception.expectMessage("is either not a non-negative number");
    }

    private void expectNegativeValueOfResource(String resource) {
        this.exception.expect(AllocationConfigurationException.class);
        this.exception.expectMessage("Invalid value of " + resource);
    }

    @Test
    public void testParseResourceConfigValue() throws Exception {
        Resource expected = Resources.createResource((int)5120, (int)2);
        Resource clusterResource = Resources.createResource((int)10240, (int)4);
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"5120 mb 2 vcores").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"2 vcores, 5120 mb").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"5120 mb, 2 vcores").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"2vcores,5120mb").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"5120mb,2vcores").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"5120mb   mb, 2    vcores").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"5120 Mb, 2 vCores").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  5120 mb, 2 vcores  ").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  5120.3 mb, 2.35 vcores  ").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  5120. mb, 2. vcores  ").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, 50% cpu").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50% Memory, 50% CpU").getResource(clusterResource));
        Assert.assertEquals((Object)Resources.createResource((int)5120, (int)4), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, 100% cpu").getResource(clusterResource));
        Assert.assertEquals((Object)Resources.createResource((int)5120, (int)4), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)" 100% cpu, 50% memory").getResource(clusterResource));
        Assert.assertEquals((Object)Resources.createResource((int)5120, (int)0), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, 0% cpu").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50 % memory, 50 % cpu").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50%memory,50%cpu").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  50  %  memory,  50  %  cpu  ").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50.% memory, 50.% cpu").getResource(clusterResource));
        Assert.assertEquals((Object)Resources.createResource((int)1116, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"10.9% memory, 50.6% cpu").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50%").getResource(clusterResource));
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types", "test1");
        ResourceUtils.resetResourceTypes((Configuration)conf);
        clusterResource = Resources.createResource((int)10240, (int)4);
        expected = Resources.createResource((int)5120, (int)2);
        expected.setResourceValue("test1", Long.MAX_VALUE);
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=2, memory-mb=5120").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"memory-mb=5120, vcores=2").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=2,memory-mb=5120").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)" vcores = 2 , memory-mb = 5120 ").getResource());
        expected.setResourceValue("test1", 0L);
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=2, memory-mb=5120", (long)0L).getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"memory-mb=5120, vcores=2", (long)0L).getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=2,memory-mb=5120", (long)0L).getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)" vcores = 2 , memory-mb = 5120 ", (long)0L).getResource());
        clusterResource.setResourceValue("test1", 8L);
        expected.setResourceValue("test1", 4L);
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50%").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=2, memory-mb=5120, test1=4").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"test1=4, vcores=2, memory-mb=5120").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"memory-mb=5120, test1=4, vcores=2").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=2,memory-mb=5120,test1=4").getResource());
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)" vcores = 2 , memory-mb = 5120 , test1 = 4 ").getResource());
        expected = Resources.createResource((int)4096, (int)3);
        expected.setResourceValue("test1", 8L);
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=75%, memory-mb=40%").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"memory-mb=40%, vcores=75%").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=75%,memory-mb=40%").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)" vcores = 75 % , memory-mb = 40 % ").getResource(clusterResource));
        expected.setResourceValue("test1", 4L);
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=75%, memory-mb=40%, test1=50%").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"test1=50%, vcores=75%, memory-mb=40%").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"memory-mb=40%, test1=50%, vcores=75%").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=75%,memory-mb=40%,test1=50%").getResource(clusterResource));
        Assert.assertEquals((Object)expected, (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)" vcores = 75 % , memory-mb = 40 % , test1 = 50 % ").getResource(clusterResource));
    }

    @Test
    public void testNoUnits() throws Exception {
        String value = "1024";
        this.expectUnparsableResource(value);
        FairSchedulerConfiguration.parseResourceConfigValue((String)value);
    }

    @Test
    public void testOnlyMemory() throws Exception {
        String value = "1024mb";
        this.expectUnparsableResource(value);
        FairSchedulerConfiguration.parseResourceConfigValue((String)value);
    }

    @Test
    public void testOnlyCPU() throws Exception {
        String value = "1024vcores";
        this.expectUnparsableResource(value);
        FairSchedulerConfiguration.parseResourceConfigValue((String)value);
    }

    @Test
    public void testGibberish() throws Exception {
        String value = "1o24vc0res";
        this.expectUnparsableResource(value);
        FairSchedulerConfiguration.parseResourceConfigValue((String)value);
    }

    @Test
    public void testNoUnitsPercentage() throws Exception {
        this.expectMissingResource("cpu");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"95%, 50% memory");
    }

    @Test
    public void testInvalidNumPercentage() throws Exception {
        this.expectInvalidResourcePercentage("cpu");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"95A% cpu, 50% memory");
    }

    @Test
    public void testCpuPercentageMemoryAbsolute() throws Exception {
        this.expectMissingResource("memory");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"50% cpu, 1024 mb");
    }

    @Test
    public void testMemoryPercentageCpuAbsolute() throws Exception {
        this.expectMissingResource("cpu");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, 2 vcores");
    }

    @Test
    public void testDuplicateVcoresDefinitionAbsolute() throws Exception {
        this.expectInvalidResource("vcores");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1024 mb, 2 4 vcores");
    }

    @Test
    public void testDuplicateMemoryDefinitionAbsolute() throws Exception {
        this.expectInvalidResource("memory");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"2048 1024 mb, 2 vcores");
    }

    @Test
    public void testDuplicateVcoresDefinitionPercentage() throws Exception {
        this.expectInvalidResourcePercentage("cpu");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, 50% 100%cpu");
    }

    @Test
    public void testDuplicateMemoryDefinitionPercentage() throws Exception {
        this.expectInvalidResourcePercentage("memory");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"50% 80% memory, 100%cpu");
    }

    @Test
    public void testParseNewStyleDuplicateMemoryDefinitionPercentage() throws Exception {
        this.expectInvalidResourcePercentageNewStyle("40% 80%");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores = 75%, memory-mb = 40% 80%");
    }

    @Test
    public void testParseNewStyleDuplicateVcoresDefinitionPercentage() throws Exception {
        this.expectInvalidResourcePercentageNewStyle("75% 65%");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores = 75% 65%, memory-mb = 40%");
    }

    @Test
    public void testMemoryPercentageNegativeValue() throws Exception {
        this.expectNegativePercentageOldStyle();
        FairSchedulerConfiguration.parseResourceConfigValue((String)"-10% memory, 50% cpu");
    }

    @Test
    public void testCpuPercentageNegativeValue() throws Exception {
        this.expectNegativePercentageOldStyle();
        FairSchedulerConfiguration.parseResourceConfigValue((String)"10% memory, -10% cpu");
    }

    @Test
    public void testMemoryAndCpuPercentageNegativeValue() throws Exception {
        this.expectNegativePercentageOldStyle();
        FairSchedulerConfiguration.parseResourceConfigValue((String)"-20% memory, -10% cpu");
    }

    @Test
    public void testCpuPercentageMemoryAbsoluteCpuNegative() throws Exception {
        this.expectMissingResource("memory");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"-50% cpu, 1024 mb");
    }

    @Test
    public void testCpuPercentageMemoryAbsoluteMemoryNegative() throws Exception {
        this.expectMissingResource("memory");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"50% cpu, -1024 mb");
    }

    @Test
    public void testMemoryPercentageCpuAbsoluteCpuNegative() throws Exception {
        this.expectMissingResource("cpu");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, -2 vcores");
    }

    @Test
    public void testMemoryPercentageCpuAbsoluteMemoryNegative() throws Exception {
        this.expectNegativePercentageOldStyle();
        FairSchedulerConfiguration.parseResourceConfigValue((String)"-50% memory, 2 vcores");
    }

    @Test
    public void testAbsoluteVcoresNegative() throws Exception {
        this.expectNegativeValueOfResource("vcores");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"-2 vcores,5120 mb");
    }

    @Test
    public void testAbsoluteMemoryNegative() throws Exception {
        this.expectNegativeValueOfResource("memory");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"2 vcores,-5120 mb");
    }

    @Test
    public void testAbsoluteVcoresNegativeWithSpaces() throws Exception {
        this.expectNegativeValueOfResource("vcores");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"-2 vcores, 5120 mb");
    }

    @Test
    public void testAbsoluteMemoryNegativeWithSpaces() throws Exception {
        this.expectNegativeValueOfResource("memory");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"2 vcores, -5120 mb");
    }

    @Test
    public void testAbsoluteVcoresNegativeWithMoreSpaces() throws Exception {
        this.expectNegativeValueOfResource("vcores");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"5120mb   mb, -2    vcores");
    }

    @Test
    public void testAbsoluteMemoryNegativeWithMoreSpaces() throws Exception {
        this.expectNegativeValueOfResource("memory");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"-5120mb   mb, 2    vcores");
    }

    @Test
    public void testAbsoluteVcoresNegativeFractional() throws Exception {
        this.expectNegativeValueOfResource("vcores");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"  5120.3 mb, -2.35 vcores  ");
    }

    @Test
    public void testAbsoluteMemoryNegativeFractional() throws Exception {
        this.expectNegativeValueOfResource("memory");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"  -5120.3 mb, 2.35 vcores  ");
    }

    @Test
    public void testOldStyleResourcesSeparatedBySpaces() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"2 vcores, 5120 mb");
    }

    @Test
    public void testOldStyleResourcesSeparatedBySpacesInvalid() throws Exception {
        String value = "2 vcores 5120 mb 555 mb";
        this.expectUnparsableResource(value);
        FairSchedulerConfiguration.parseResourceConfigValue((String)value);
    }

    @Test
    public void testOldStyleResourcesSeparatedBySpacesInvalidUppercaseUnits() throws Exception {
        String value = "2 vcores 5120 MB 555 GB";
        this.expectUnparsableResource(value);
        FairSchedulerConfiguration.parseResourceConfigValue((String)value);
    }

    @Test
    public void testParseNewStyleResourceMemoryNegative() throws Exception {
        this.expectNegativeValueOfResource("memory");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"memory-mb=-5120,vcores=2");
    }

    @Test
    public void testParseNewStyleResourceVcoresNegative() throws Exception {
        this.expectNegativeValueOfResource("vcores");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"memory-mb=5120,vcores=-2");
    }

    @Test
    public void testParseNewStyleResourceMemoryNegativeWithSpaces() throws Exception {
        this.expectNegativeValueOfResource("memory");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"memory-mb=-5120, vcores=2");
    }

    @Test
    public void testParseNewStyleResourceVcoresNegativeWithSpaces() throws Exception {
        this.expectNegativeValueOfResource("vcores");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"memory-mb=5120, vcores=-2");
    }

    @Test
    public void testParseNewStyleResourceMemoryNegativeWithMoreSpaces() throws Exception {
        this.expectNegativeValueOfResource("memory");
        FairSchedulerConfiguration.parseResourceConfigValue((String)" vcores = 2 ,  memory-mb = -5120 ");
    }

    @Test
    public void testParseNewStyleResourceVcoresNegativeWithMoreSpaces() throws Exception {
        this.expectNegativeValueOfResource("vcores");
        FairSchedulerConfiguration.parseResourceConfigValue((String)" vcores = -2 ,  memory-mb = 5120 ");
    }

    @Test
    public void testParseNewStyleResourceWithCustomResourceMemoryNegative() throws Exception {
        this.expectNegativeValueOfResource("memory");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=2,memory-mb=-5120,test1=4");
    }

    @Test
    public void testParseNewStyleResourceWithCustomResourceVcoresNegative() throws Exception {
        this.expectNegativeValueOfResource("vcores");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=-2,memory-mb=-5120,test1=4");
    }

    @Test
    public void testParseNewStyleResourceWithCustomResourceNegative() throws Exception {
        this.expectNegativeValueOfResource("test1");
        FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=2,memory-mb=5120,test1=-4");
    }

    @Test
    public void testParseNewStyleResourceWithCustomResourceNegativeWithSpaces() throws Exception {
        this.expectNegativeValueOfResource("test1");
        FairSchedulerConfiguration.parseResourceConfigValue((String)" vcores = 2 , memory-mb = 5120 , test1 = -4 ");
    }

    @Test
    public void testParseNewStyleResourceWithPercentagesVcoresNegative() throws Exception {
        this.expectNegativePercentageNewStyle();
        FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=-75%,memory-mb=40%");
    }

    @Test
    public void testParseNewStyleResourceWithPercentagesMemoryNegative() throws Exception {
        this.expectNegativePercentageNewStyle();
        FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=75%,memory-mb=-40%");
    }

    @Test
    public void testParseNewStyleResourceWithPercentagesVcoresNegativeWithSpaces() throws Exception {
        this.expectNegativePercentageNewStyle();
        FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=-75%, memory-mb=40%");
    }

    @Test
    public void testParseNewStyleResourceWithPercentagesMemoryNegativeWithSpaces() throws Exception {
        this.expectNegativePercentageNewStyle();
        FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores=75%, memory-mb=-40%");
    }

    @Test
    public void testParseNewStyleResourceWithPercentagesVcoresNegativeWithMoreSpaces() throws Exception {
        this.expectNegativePercentageNewStyle();
        FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores = -75%, memory-mb = 40%");
    }

    @Test
    public void testParseNewStyleResourceWithPercentagesMemoryNegativeWithMoreSpaces() throws Exception {
        this.expectNegativePercentageNewStyle();
        FairSchedulerConfiguration.parseResourceConfigValue((String)"vcores = 75%, memory-mb = -40%");
    }

    @Test
    public void testParseNewStyleResourceWithPercentagesCustomResourceNegativeWithSpaces() throws Exception {
        this.expectNegativeValueOfResource("test1");
        FairSchedulerConfiguration.parseResourceConfigValue((String)" vcores = 2 , memory-mb = 5120 , test1 = -4 ");
    }

    @Test
    public void testAllocationIncrementMemoryDefaultUnit() {
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types." + ResourceInformation.MEMORY_MB.getName() + ".increment-allocation", "256");
        FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
        Resource minimum = Resources.createResource((long)0L, (int)0);
        Resource maximum = Resources.createResource((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE);
        Resource increment = fsc.getIncrementAllocation();
        DominantResourceCalculator resourceCalculator = new DominantResourceCalculator();
        Assert.assertEquals((long)1024L, (long)resourceCalculator.normalize(Resources.createResource((long)769L), minimum, maximum, increment).getMemorySize());
        Assert.assertEquals((long)1024L, (long)resourceCalculator.normalize(Resources.createResource((long)1023L), minimum, maximum, increment).getMemorySize());
        Assert.assertEquals((long)1024L, (long)resourceCalculator.normalize(Resources.createResource((long)1024L), minimum, maximum, increment).getMemorySize());
        Assert.assertEquals((long)1280L, (long)resourceCalculator.normalize(Resources.createResource((long)1025L), minimum, maximum, increment).getMemorySize());
    }

    @Test
    public void testAllocationIncrementMemoryNonDefaultUnit() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types." + ResourceInformation.MEMORY_MB.getName() + ".increment-allocation", "1 Gi");
        FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
        Resource minimum = Resources.createResource((long)0L, (int)0);
        Resource maximum = Resources.createResource((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE);
        Resource increment = fsc.getIncrementAllocation();
        DominantResourceCalculator resourceCalculator = new DominantResourceCalculator();
        Assert.assertEquals((long)1024L, (long)resourceCalculator.normalize(Resources.createResource((long)1023L), minimum, maximum, increment).getMemorySize());
        Assert.assertEquals((long)1024L, (long)resourceCalculator.normalize(Resources.createResource((long)1024L), minimum, maximum, increment).getMemorySize());
        Assert.assertEquals((long)2048L, (long)resourceCalculator.normalize(Resources.createResource((long)1025L), minimum, maximum, increment).getMemorySize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAllocationIncrementInvalidUnit() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types." + ResourceInformation.MEMORY_MB.getName() + ".increment-allocation", "1 Xi");
        new FairSchedulerConfiguration(conf).getIncrementAllocation();
    }

    @Test
    public void testAllocationIncrementVCoreNoUnit() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types." + ResourceInformation.VCORES.getName() + ".increment-allocation", "10");
        FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
        Resource min = Resources.createResource((long)0L, (int)0);
        Resource max = Resources.createResource((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE);
        Resource increment = fsc.getIncrementAllocation();
        DominantResourceCalculator resourceCalculator = new DominantResourceCalculator();
        Assert.assertEquals((long)10L, (long)resourceCalculator.normalize(Resources.createResource((long)0L, (int)9), min, max, increment).getVirtualCores());
        Assert.assertEquals((long)10L, (long)resourceCalculator.normalize(Resources.createResource((long)0L, (int)10), min, max, increment).getVirtualCores());
        Assert.assertEquals((long)20L, (long)resourceCalculator.normalize(Resources.createResource((long)0L, (int)11), min, max, increment).getVirtualCores());
    }

    @Test
    public void testAllocationIncrementVCoreWithUnit() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types." + ResourceInformation.VCORES.getName() + ".increment-allocation", "1k");
        FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
        Resource min = Resources.createResource((long)0L, (int)0);
        Resource max = Resources.createResource((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE);
        Resource increment = fsc.getIncrementAllocation();
        DominantResourceCalculator resourceCalculator = new DominantResourceCalculator();
        Assert.assertEquals((long)1000L, (long)resourceCalculator.normalize(Resources.createResource((long)0L, (int)999), min, max, increment).getVirtualCores());
        Assert.assertEquals((long)1000L, (long)resourceCalculator.normalize(Resources.createResource((long)0L, (int)1000), min, max, increment).getVirtualCores());
        Assert.assertEquals((long)2000L, (long)resourceCalculator.normalize(Resources.createResource((long)0L, (int)1001), min, max, increment).getVirtualCores());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllocationIncrementCustomResource() {
        try {
            this.initResourceTypes();
            Configuration conf = new Configuration();
            conf.set("yarn.resource-types.a-custom-resource.increment-allocation", "10");
            FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
            Resource increment = fsc.getIncrementAllocation();
            DominantResourceCalculator calculator = new DominantResourceCalculator();
            Resource min = Resources.createResource((long)0L, (int)0);
            Resource max = Resource.newInstance((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE, Collections.singletonMap(A_CUSTOM_RESOURCE, Long.MAX_VALUE / UnitsConversionUtil.convert((String)"k", (String)"", (long)1L)));
            Assert.assertEquals((Object)this.customResourceInformation(10000L, ""), (Object)calculator.normalize(this.customResource(9999L, ""), min, max, increment).getResourceInformation(A_CUSTOM_RESOURCE));
            Assert.assertEquals((Object)this.customResourceInformation(10000L, ""), (Object)calculator.normalize(this.customResource(10000L, ""), min, max, increment).getResourceInformation(A_CUSTOM_RESOURCE));
            Assert.assertEquals((Object)this.customResourceInformation(20000L, ""), (Object)calculator.normalize(this.customResource(19999L, ""), min, max, increment).getResourceInformation(A_CUSTOM_RESOURCE));
            Assert.assertEquals((Object)this.customResourceInformation(10L, "k"), (Object)calculator.normalize(this.customResource(9L, "k"), min, max, increment).getResourceInformation(A_CUSTOM_RESOURCE));
            Assert.assertEquals((Object)this.customResourceInformation(10L, "k"), (Object)calculator.normalize(this.customResource(10L, "k"), min, max, increment).getResourceInformation(A_CUSTOM_RESOURCE));
            Assert.assertEquals((Object)this.customResourceInformation(20L, "k"), (Object)calculator.normalize(this.customResource(11L, "k"), min, max, increment).getResourceInformation(A_CUSTOM_RESOURCE));
        }
        finally {
            ResourceUtils.resetResourceTypes((Configuration)new Configuration());
        }
    }

    private Resource customResource(long value, String units) {
        return new LightWeightResource(0L, 0, new ResourceInformation[]{null, null, this.customResourceInformation(value, units)});
    }

    private ResourceInformation customResourceInformation(long value, String units) {
        return ResourceInformation.newInstance((String)A_CUSTOM_RESOURCE, (String)units, (long)value, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)Long.MAX_VALUE);
    }

    private void initResourceTypes() {
        CustomResourceTypesConfigurationProvider.initResourceTypes((Map)ImmutableMap.builder().put((Object)A_CUSTOM_RESOURCE, (Object)"k").build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemoryIncrementConfiguredViaMultipleProperties() {
        TestAppender testAppender = new TestAppender();
        Logger logger = LogManager.getRootLogger();
        logger.addAppender((Appender)testAppender);
        try {
            Configuration conf = new Configuration();
            conf.set("yarn.scheduler.increment-allocation-mb", "7");
            conf.set("yarn.resource-types." + ResourceInformation.MEMORY_MB.getName() + ".increment-allocation", "13");
            FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
            Resource increment = fsc.getIncrementAllocation();
            Assert.assertEquals((long)13L, (long)increment.getMemorySize());
            Assert.assertTrue((String)"Warning message is not logged when specifying memory increment via multiple properties", (boolean)testAppender.getLogEvents().stream().anyMatch(e -> e.getLevel() == Level.WARN && "Configuration yarn.resource-types.memory-mb.increment-allocation=13 is overriding the yarn.scheduler.increment-allocation-mb=7 property".equals(e.getMessage())));
        }
        finally {
            logger.removeAppender((Appender)testAppender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCpuIncrementConfiguredViaMultipleProperties() {
        TestAppender testAppender = new TestAppender();
        Logger logger = LogManager.getRootLogger();
        logger.addAppender((Appender)testAppender);
        try {
            Configuration conf = new Configuration();
            conf.set("yarn.scheduler.increment-allocation-vcores", "7");
            conf.set("yarn.resource-types." + ResourceInformation.VCORES.getName() + ".increment-allocation", "13");
            FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
            Resource increment = fsc.getIncrementAllocation();
            Assert.assertEquals((long)13L, (long)increment.getVirtualCores());
            Assert.assertTrue((String)"Warning message is not logged when specifying CPU vCores increment via multiple properties", (boolean)testAppender.getLogEvents().stream().anyMatch(e -> e.getLevel() == Level.WARN && "Configuration yarn.resource-types.vcores.increment-allocation=13 is overriding the yarn.scheduler.increment-allocation-vcores=7 property".equals(e.getMessage())));
        }
        finally {
            logger.removeAppender((Appender)testAppender);
        }
    }

    private static class TestAppender
    extends AppenderSkeleton {
        private final List<LoggingEvent> logEvents = new CopyOnWriteArrayList<LoggingEvent>();

        private TestAppender() {
        }

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }

        protected void append(LoggingEvent arg0) {
            this.logEvents.add(arg0);
        }

        private List<LoggingEvent> getLogEvents() {
            return this.logEvents;
        }
    }
}

