/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFSParentQueue {
    private QueueManager queueManager;

    @Before
    public void setUp() {
        FairSchedulerConfiguration conf = new FairSchedulerConfiguration();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        SystemClock clock = SystemClock.getInstance();
        PlacementManager placementManager = new PlacementManager();
        FairScheduler scheduler = (FairScheduler)Mockito.mock(FairScheduler.class);
        Mockito.when((Object)scheduler.getRMContext()).thenReturn((Object)rmContext);
        Mockito.when((Object)scheduler.getConfig()).thenReturn((Object)conf);
        Mockito.when((Object)scheduler.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)scheduler.getResourceCalculator()).thenReturn((Object)new DefaultResourceCalculator());
        Mockito.when((Object)scheduler.getClock()).thenReturn((Object)clock);
        Mockito.when((Object)rmContext.getQueuePlacementManager()).thenReturn((Object)placementManager);
        AllocationConfiguration allocConf = new AllocationConfiguration(scheduler);
        Mockito.when((Object)scheduler.getAllocationConfiguration()).thenReturn((Object)allocConf);
        this.queueManager = new QueueManager(scheduler);
        FSQueueMetrics.forQueue((String)"root", null, (boolean)true, (Configuration)conf);
        this.queueManager.initialize();
    }

    @Test
    public void testConcurrentChangeToGetChildQueue() {
        this.queueManager.getLeafQueue("parent.child", true);
        this.queueManager.getLeafQueue("parent.child2", true);
        FSParentQueue test = this.queueManager.getParentQueue("parent", false);
        Assert.assertEquals((long)2L, (long)test.getChildQueues().size());
        boolean first = true;
        int childQueuesFound = 0;
        for (FSQueue childQueue : test.getChildQueues()) {
            if (first) {
                first = false;
                this.queueManager.getLeafQueue("parent.child3", true);
            }
            ++childQueuesFound;
        }
        Assert.assertEquals((long)2L, (long)childQueuesFound);
        Assert.assertEquals((long)3L, (long)test.getChildQueues().size());
    }
}

