/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQueueCapacityVector {
    private static final String CUSTOM_RESOURCE = "custom";
    public static final String MIXED_CAPACITY_VECTOR_STRING = "[custom=3.0,memory-mb=10.0w,vcores=6.0%]";
    private final YarnConfiguration conf = new YarnConfiguration();

    @Before
    public void setUp() {
        this.conf.set("yarn.resource-types", CUSTOM_RESOURCE);
        ResourceUtils.resetResourceTypes((Configuration)this.conf);
    }

    @Test
    public void getResourceNamesByCapacityType() {
        QueueCapacityVector capacityVector = QueueCapacityVector.newInstance();
        capacityVector.setResource("memory-mb", 10.0, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE);
        capacityVector.setResource("vcores", 6.0, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE);
        Assert.assertEquals((long)1L, (long)capacityVector.getResourceNamesByCapacityType(QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE).size());
        Assert.assertTrue((boolean)capacityVector.getResourceNamesByCapacityType(QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE).contains(CUSTOM_RESOURCE));
        Assert.assertEquals((long)2L, (long)capacityVector.getResourceNamesByCapacityType(QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE).size());
        Assert.assertTrue((boolean)capacityVector.getResourceNamesByCapacityType(QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE).contains("vcores"));
        Assert.assertTrue((boolean)capacityVector.getResourceNamesByCapacityType(QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE).contains("memory-mb"));
        Assert.assertEquals((double)10.0, (double)capacityVector.getResource("memory-mb").getResourceValue(), (double)0.001f);
        Assert.assertEquals((double)6.0, (double)capacityVector.getResource("vcores").getResourceValue(), (double)0.001f);
    }

    @Test
    public void isResourceOfType() {
        QueueCapacityVector capacityVector = QueueCapacityVector.newInstance();
        capacityVector.setResource("memory-mb", 10.0, QueueCapacityVector.ResourceUnitCapacityType.WEIGHT);
        capacityVector.setResource("vcores", 6.0, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE);
        capacityVector.setResource(CUSTOM_RESOURCE, 3.0, QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE);
        Assert.assertTrue((boolean)capacityVector.isResourceOfType("memory-mb", QueueCapacityVector.ResourceUnitCapacityType.WEIGHT));
        Assert.assertTrue((boolean)capacityVector.isResourceOfType("vcores", QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE));
        Assert.assertTrue((boolean)capacityVector.isResourceOfType(CUSTOM_RESOURCE, QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE));
    }

    @Test
    public void testIterator() {
        QueueCapacityVector capacityVector = QueueCapacityVector.newInstance();
        ArrayList entries = Lists.newArrayList((Iterable)capacityVector);
        Assert.assertEquals((long)3L, (long)entries.size());
        QueueCapacityVector emptyCapacityVector = new QueueCapacityVector();
        ArrayList emptyEntries = Lists.newArrayList((Iterable)emptyCapacityVector);
        Assert.assertEquals((long)0L, (long)emptyEntries.size());
    }

    @Test
    public void testToString() {
        QueueCapacityVector capacityVector = QueueCapacityVector.newInstance();
        capacityVector.setResource("memory-mb", 10.0, QueueCapacityVector.ResourceUnitCapacityType.WEIGHT);
        capacityVector.setResource("vcores", 6.0, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE);
        capacityVector.setResource(CUSTOM_RESOURCE, 3.0, QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE);
        Assert.assertEquals((Object)MIXED_CAPACITY_VECTOR_STRING, (Object)capacityVector.toString());
        QueueCapacityVector emptyCapacityVector = new QueueCapacityVector();
        Assert.assertEquals((Object)"[]", (Object)emptyCapacityVector.toString());
    }

    @Test
    public void testIsMixedType() {
        QueueCapacityVector capacityVector = QueueCapacityVector.newInstance();
        Assert.assertFalse((boolean)capacityVector.isMixedCapacityVector());
        capacityVector.setResource("vcores", 6.0, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE);
        capacityVector.setResource("memory-mb", 10.0, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE);
        capacityVector.setResource(CUSTOM_RESOURCE, 3.0, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE);
        Assert.assertFalse((boolean)capacityVector.isMixedCapacityVector());
        capacityVector.setResource("vcores", 6.0, QueueCapacityVector.ResourceUnitCapacityType.WEIGHT);
        Assert.assertTrue((boolean)capacityVector.isMixedCapacityVector());
    }
}

