/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueCapacityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueAssertionBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityUpdateContext;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.Before;

public class CapacitySchedulerQueueCalculationTestBase {
    protected static final String A = "root.a";
    protected static final String A1 = "root.a.a1";
    protected static final String A11 = "root.a.a1.a11";
    protected static final String A12 = "root.a.a1.a12";
    protected static final String A2 = "root.a.a2";
    protected static final String B = "root.b";
    protected static final String B1 = "root.b.b1";
    protected static final String C = "root.c";
    private static final String CAPACITY_VECTOR_TEMPLATE = "[memory=%s, vcores=%s]";
    protected ResourceCalculator resourceCalculator;
    protected MockRM mockRM;
    protected CapacityScheduler cs;
    protected CapacitySchedulerConfiguration csConf;
    protected NullRMNodeLabelsManager mgr;

    @Before
    public void setUp() throws Exception {
        this.csConf = new CapacitySchedulerConfiguration();
        this.csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.csConf.setQueues("root", new String[]{"a", "b"});
        this.csConf.setCapacity(A, 50.0f);
        this.csConf.setCapacity(B, 50.0f);
        this.csConf.setQueues(A, new String[]{"a1", "a2"});
        this.csConf.setCapacity(A1, 100.0f);
        this.csConf.setQueues(A1, new String[]{"a11", "a12"});
        this.csConf.setCapacity(A11, 50.0f);
        this.csConf.setCapacity(A12, 50.0f);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.csConf);
        this.mockRM = new MockRM((Configuration)this.csConf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return CapacitySchedulerQueueCalculationTestBase.this.mgr;
            }
        };
        this.cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
        this.cs.updatePlacementRules();
        this.mockRM.start();
        this.cs.start();
        this.mockRM.registerNode("h1:1234", 10240);
        this.resourceCalculator = this.cs.getResourceCalculator();
    }

    protected QueueCapacityUpdateContext update(QueueAssertionBuilder assertions, Resource clusterResource) throws IOException {
        return this.update(assertions, clusterResource, clusterResource);
    }

    protected QueueCapacityUpdateContext update(QueueAssertionBuilder assertions, Resource clusterResource, Resource emptyLabelResource) throws IOException {
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        CapacitySchedulerQueueCapacityHandler queueController = new CapacitySchedulerQueueCapacityHandler((RMNodeLabelsManager)this.mgr, this.csConf);
        this.mgr.setResourceForLabel("", emptyLabelResource);
        queueController.updateRoot(this.cs.getQueue("root"), clusterResource);
        QueueCapacityUpdateContext updateContext = queueController.updateChildren(clusterResource, this.cs.getQueue("root"));
        assertions.finishAssertion();
        return updateContext;
    }

    protected QueueAssertionBuilder createAssertionBuilder() {
        return new QueueAssertionBuilder(this.cs);
    }

    protected static String createCapacityVector(Object memory, Object vcores) {
        return String.format(CAPACITY_VECTOR_TEMPLATE, memory, vcores);
    }

    protected static String absolute(double value) {
        return String.valueOf((long)value);
    }

    protected static String weight(float value) {
        return value + "w";
    }

    protected static String percentage(float value) {
        return value + "%";
    }

    protected static Resource createResource(double memory, double vcores) {
        return Resource.newInstance((int)((int)memory), (int)((int)vcores));
    }
}

