/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.server.resourcemanager.placement.VariableContext;
import org.junit.Assert;
import org.junit.Test;

public class TestVariableContext {
    @Test
    public void testAddAndGet() {
        VariableContext variables = new VariableContext();
        Assert.assertEquals((Object)"", (Object)variables.get("%user"));
        Assert.assertFalse((boolean)variables.containsKey("%user"));
        variables.put("%user", "john");
        variables.put("%group", "primary");
        variables.put("%group", "secondary");
        variables.put("%empty", null);
        Assert.assertTrue((boolean)variables.containsKey("%user"));
        Assert.assertTrue((boolean)variables.containsKey("%empty"));
        Assert.assertEquals((Object)"john", (Object)variables.get("%user"));
        Assert.assertEquals((Object)"secondary", (Object)variables.get("%group"));
        Assert.assertEquals((Object)"", (Object)variables.get("%empty"));
    }

    @Test(expected=IllegalStateException.class)
    public void testImmutablesCanOnlySetOnceFromSet() {
        VariableContext variables = new VariableContext();
        ImmutableSet immutables = ImmutableSet.of((Object)"%user", (Object)"%primary_group", (Object)"%secondary_group");
        variables.setImmutables((Set)immutables);
        variables.setImmutables((Set)immutables);
    }

    @Test(expected=IllegalStateException.class)
    public void testImmutablesCanOnlySetOnceFromArray() {
        VariableContext variables = new VariableContext();
        variables.setImmutables(new String[]{"%user", "%primary_group", "%secondary_group"});
        variables.setImmutables(new String[]{"%user", "%primary_group", "%secondary_group"});
    }

    @Test(expected=IllegalStateException.class)
    public void testImmutablesCanOnlySetOnceFromSetAndArray() {
        VariableContext variables = new VariableContext();
        ImmutableSet immutables = ImmutableSet.of((Object)"%user", (Object)"%primary_group", (Object)"%secondary_group");
        variables.setImmutables((Set)immutables);
        variables.setImmutables(new String[]{"%user", "%primary_group", "%secondary_group"});
    }

    @Test
    public void testImmutableVariableCanBeSetOnce() {
        VariableContext variables = new VariableContext();
        ImmutableSet immutables = ImmutableSet.of((Object)"%user", (Object)"%primary_group", (Object)"%secondary_group");
        variables.setImmutables((Set)immutables);
        variables.put("%user", "bob");
    }

    @Test(expected=IllegalStateException.class)
    public void testImmutableVariableProtection() {
        VariableContext variables = new VariableContext();
        ImmutableSet immutables = ImmutableSet.of((Object)"%user", (Object)"%primary_group", (Object)"%secondary_group");
        variables.setImmutables((Set)immutables);
        variables.put("%user", "bob");
        variables.put("%user", "bob");
    }

    @Test
    public void testAddAndGetWithImmutables() {
        VariableContext variables = new VariableContext();
        ImmutableSet immutables = ImmutableSet.of((Object)"%user", (Object)"%primary_group", (Object)"%secondary_group");
        Assert.assertFalse((boolean)variables.isImmutable("%user"));
        Assert.assertFalse((boolean)variables.isImmutable("%primary_group"));
        Assert.assertFalse((boolean)variables.isImmutable("%secondary_group"));
        Assert.assertFalse((boolean)variables.isImmutable("%default"));
        variables.setImmutables((Set)immutables);
        Assert.assertTrue((boolean)variables.isImmutable("%user"));
        Assert.assertTrue((boolean)variables.isImmutable("%primary_group"));
        Assert.assertTrue((boolean)variables.isImmutable("%secondary_group"));
        Assert.assertFalse((boolean)variables.isImmutable("%default"));
        variables.put("%user", "bob");
        variables.put("%primary_group", "primary");
        variables.put("%default", "root.default");
        Assert.assertEquals((Object)"bob", (Object)variables.get("%user"));
        Assert.assertEquals((Object)"primary", (Object)variables.get("%primary_group"));
        Assert.assertEquals((Object)"root.default", (Object)variables.get("%default"));
        variables.put("%default", "root.new.default");
        Assert.assertEquals((Object)"root.new.default", (Object)variables.get("%default"));
    }

    @Test
    public void testPathPartReplace() {
        VariableContext variables = new VariableContext();
        ImmutableSet immutables = ImmutableSet.of((Object)"%user", (Object)"%primary_group", (Object)"%secondary_group");
        variables.setImmutables((Set)immutables).put("%user", "bob").put("%primary_group", "developers").put("%secondary_group", "yarn-dev").put("%default", "default.path").put("%null", null).put("%empty", "");
        HashMap<String, String> testCases = new HashMap<String, String>();
        testCases.put("nothing_to_replace", "nothing_to_replace");
        testCases.put(null, null);
        testCases.put("", "");
        testCases.put("%empty", "");
        testCases.put("%null", "");
        testCases.put("%user", "bob");
        testCases.put("root.regular.path", "root.regular.path");
        testCases.put("root.%empty.path", "root..path");
        testCases.put("root.%empty%empty.path", "root.%empty%empty.path");
        testCases.put("root.%null.path", "root..path");
        testCases.put("root.%user.%primary_group.%secondary_group.%default.%null.%empty.end", "root.bob.developers.yarn-dev.default.path...end");
        testCases.put("%user%default.%user.%default", "%user%default.bob.default.path");
        testCases.forEach((k, v) -> Assert.assertEquals((Object)v, (Object)variables.replacePathVariables(k)));
    }

    @Test
    public void testVariableReplace() {
        VariableContext variables = new VariableContext();
        ImmutableSet immutables = ImmutableSet.of((Object)"%user", (Object)"%primary_group", (Object)"%secondary_group");
        variables.setImmutables((Set)immutables).put("%user", "bob").put("%userPhone", "555-3221").put("%primary_group", "developers").put("%secondary_group", "yarn-dev").put("%default", "default.path").put("%null", null).put("%empty", "");
        HashMap<String, String> testCases = new HashMap<String, String>();
        testCases.put("nothing_to_replace", "nothing_to_replace");
        testCases.put(null, null);
        testCases.put("", "");
        testCases.put("%empty", "");
        testCases.put("%null", "");
        testCases.put("%user", "bob");
        testCases.put("%userPhone", "555-3221");
        testCases.put("root.regular.path", "root.regular.path");
        testCases.put("root.%empty.path", "root..path");
        testCases.put("root.%empty%empty.path", "root..path");
        testCases.put("root.%null.path", "root..path");
        testCases.put("root.%user.%primary_group.%secondary_group.%default.%null.%empty.end", "root.bob.developers.yarn-dev.default.path...end");
        testCases.put("%user%default.%user.%default", "bobdefault.path.bob.default.path");
        testCases.put("userPhoneof%useris%userPhone", "userPhoneofbobis555-3221");
        testCases.forEach((pattern, expected) -> Assert.assertEquals((Object)expected, (Object)variables.replaceVariables(pattern)));
    }

    @Test
    public void testCollectionStore() {
        VariableContext variables = new VariableContext();
        HashSet<String> coll1 = new HashSet<String>();
        HashSet<String> coll2 = new HashSet<String>();
        coll1.add("Bob");
        coll1.add("Roger");
        coll2.add("Bob");
        variables.putExtraDataset("set", coll1);
        variables.putExtraDataset("sameset", coll1);
        variables.putExtraDataset("list", coll2);
        try {
            variables.putExtraDataset("set", coll1);
            Assert.fail((String)"Same name cannot be used multiple times to add collections");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertSame(coll1, (Object)variables.getExtraDataset("set"));
        Assert.assertSame(coll1, (Object)variables.getExtraDataset("sameset"));
        Assert.assertSame(coll2, (Object)variables.getExtraDataset("list"));
        Assert.assertNull((Object)variables.getExtraDataset("Nothing"));
    }
}

