/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor;

import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingMonitorManager;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueDeletionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSchedulingMonitor {
    @Test(timeout=10000L)
    public void testRMStarts() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
        conf.set("yarn.resourcemanager.scheduler.monitor.policies", ProportionalCapacityPreemptionPolicy.class.getCanonicalName());
        MockRM rm = new MockRM();
        rm.init((Configuration)conf);
        SchedulingEditPolicy mPolicy = (SchedulingEditPolicy)Mockito.mock(SchedulingEditPolicy.class);
        Mockito.when((Object)mPolicy.getMonitoringInterval()).thenReturn((Object)1000L);
        SchedulingMonitor monitor = new SchedulingMonitor(rm.getRMContext(), mPolicy);
        monitor.serviceInit((Configuration)conf);
        monitor.serviceStart();
        ((SchedulingEditPolicy)Mockito.verify((Object)mPolicy, (VerificationMode)Mockito.timeout((long)10000L))).editSchedule();
        monitor.close();
        rm.close();
    }

    @Test(timeout=10000L)
    public void testRMUpdateSchedulingEditPolicy() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        SchedulingMonitorManager smm = cs.getSchedulingMonitorManager();
        cs.reinitialize((Configuration)conf, rm.getRMContext());
        Assert.assertFalse((boolean)smm.isRSMEmpty());
        String[] configuredPolicies = conf.getStrings("yarn.resourcemanager.scheduler.monitor.policies");
        HashSet<String> configurePoliciesSet = new HashSet<String>();
        for (String s : configuredPolicies) {
            configurePoliciesSet.add(s);
        }
        Assert.assertTrue((boolean)smm.isSameConfiguredPolicies(configurePoliciesSet));
        conf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", false);
        cs.reinitialize((Configuration)conf, rm.getRMContext());
        Assert.assertTrue((boolean)smm.isRSMEmpty());
        rm.close();
    }

    @Test(timeout=10000L)
    public void testRMUpdateAutoCreatedQueueDeletionPolicy() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
        conf.set("yarn.resourcemanager.scheduler.monitor.policies", AutoCreatedQueueDeletionPolicy.class.getCanonicalName());
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        SchedulingMonitorManager smm = cs.getSchedulingMonitorManager();
        cs.reinitialize((Configuration)conf, rm.getRMContext());
        Assert.assertFalse((boolean)smm.isRSMEmpty());
        String[] configuredPolicies = conf.getStrings("yarn.resourcemanager.scheduler.monitor.policies");
        HashSet<String> configurePoliciesSet = new HashSet<String>();
        for (String s : configuredPolicies) {
            configurePoliciesSet.add(s);
        }
        Assert.assertTrue((boolean)smm.isSameConfiguredPolicies(configurePoliciesSet));
        Assert.assertTrue((boolean)configurePoliciesSet.contains(AutoCreatedQueueDeletionPolicy.class.getCanonicalName()));
        conf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", false);
        cs.reinitialize((Configuration)conf, rm.getRMContext());
        Assert.assertTrue((boolean)smm.isRSMEmpty());
        rm.close();
    }
}

