/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.AllocateRequestPBImpl;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterServiceTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;

public class TestApplicationMasterServiceCapacity
extends ApplicationMasterServiceTestBase {
    private static final String DEFAULT_QUEUE = "default";

    @Override
    protected YarnConfiguration createYarnConfig() {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setResourceComparator(DominantResourceCalculator.class);
        YarnConfiguration yarnConf = new YarnConfiguration((Configuration)csConf);
        yarnConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        return yarnConf;
    }

    @Override
    protected Resource getResourceUsageForQueue(ResourceManager rm, String queue) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue leafQueue = (LeafQueue)cs.getQueue(DEFAULT_QUEUE);
        return leafQueue.getUsedResources();
    }

    @Override
    protected String getDefaultQueueName() {
        return DEFAULT_QUEUE;
    }

    private void sentRMContainerLaunched(MockRM rm, ContainerId containerId) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        RMContainer rmContainer = cs.getRMContainer(containerId);
        if (rmContainer != null) {
            rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
        } else {
            Assert.fail((String)"Cannot find RMContainer");
        }
    }

    @Test(timeout=60000L)
    public void testInvalidIncreaseDecreaseRequest() throws Exception {
        conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        try (MockRM rm = new MockRM((Configuration)conf);){
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
            RMApp app1 = MockRMAppSubmitter.submitWithMemory(1024L, rm);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
            MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
            RegisterApplicationMasterResponse registerResponse = am1.registerAppAttempt();
            this.sentRMContainerLaunched(rm, ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L));
            am1.sendContainerResizingRequest(Arrays.asList(UpdateContainerRequest.newInstance((int)0, (ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attempt1.getAppAttemptId(), (long)1L), (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.createResource((int)2048), null)));
            AllocateResponse response = am1.sendContainerResizingRequest(Arrays.asList(UpdateContainerRequest.newInstance((int)0, (ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attempt1.getAppAttemptId(), (long)1L), (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.createResource((int)-1), null)));
            Assert.assertEquals((long)1L, (long)response.getUpdateErrors().size());
            Assert.assertEquals((Object)"RESOURCE_OUTSIDE_ALLOWED_RANGE", (Object)((UpdateContainerError)response.getUpdateErrors().get(0)).getReason());
            response = am1.sendContainerResizingRequest(Arrays.asList(UpdateContainerRequest.newInstance((int)0, (ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attempt1.getAppAttemptId(), (long)1L), (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.add((Resource)registerResponse.getMaximumResourceCapability(), (Resource)Resources.createResource((int)1)), null)));
            Assert.assertEquals((long)1L, (long)response.getUpdateErrors().size());
            Assert.assertEquals((Object)"RESOURCE_OUTSIDE_ALLOWED_RANGE", (Object)((UpdateContainerError)response.getUpdateErrors().get(0)).getReason());
            response = am1.sendContainerResizingRequest(Arrays.asList(UpdateContainerRequest.newInstance((int)0, (ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attempt1.getAppAttemptId(), (long)1L), (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.createResource((int)2048, (int)4), null), UpdateContainerRequest.newInstance((int)0, (ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attempt1.getAppAttemptId(), (long)1L), (ContainerUpdateType)ContainerUpdateType.DECREASE_RESOURCE, (Resource)Resources.createResource((int)1024, (int)1), null)));
            Assert.assertEquals((long)1L, (long)response.getUpdateErrors().size());
            Assert.assertEquals((Object)"UPDATE_OUTSTANDING_ERROR", (Object)((UpdateContainerError)response.getUpdateErrors().get(0)).getReason());
        }
    }

    @Test(timeout=300000L)
    public void testPriorityInAllocatedResponse() throws Exception {
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setInt("yarn.cluster.max-application-priority", 10);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        Priority appPriority1 = Priority.newInstance((int)5);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm).withAppPriority(appPriority1).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        AllocateRequestPBImpl allocateRequest = new AllocateRequestPBImpl();
        ArrayList release = new ArrayList();
        ArrayList ask = new ArrayList();
        allocateRequest.setReleaseList(release);
        allocateRequest.setAskList(ask);
        AllocateResponse response1 = am1.allocate((AllocateRequest)allocateRequest);
        Assert.assertEquals((Object)appPriority1, (Object)response1.getApplicationPriority());
        Priority appPriority2 = Priority.newInstance((int)8);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)app1.getUser());
        rm.getRMAppManager().updateApplicationPriority(ugi, app1.getApplicationId(), appPriority2);
        AllocateResponse response2 = am1.allocate((AllocateRequest)allocateRequest);
        Assert.assertEquals((Object)appPriority2, (Object)response2.getApplicationPriority());
        rm.stop();
    }

    @Test(timeout=300000L)
    public void testGetNMNumInAllocatedResponseWithOutNodeLabel() throws Exception {
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("host1:1234", 6144);
        MockNM nm2 = rm.registerNode("host2:1234", 6144);
        MockNM nm3 = rm.registerNode("host3:1234", 6144);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        nm3.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        AllocateRequestPBImpl allocateRequest = new AllocateRequestPBImpl();
        ArrayList release = new ArrayList();
        ArrayList ask = new ArrayList();
        allocateRequest.setReleaseList(release);
        allocateRequest.setAskList(ask);
        AllocateResponse response1 = am1.allocate((AllocateRequest)allocateRequest);
        Assert.assertEquals((long)3L, (long)response1.getNumClusterNodes());
        rm.stop();
    }

    private Configuration getConfigurationWithQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues("root", new String[]{"a", "b"});
        conf.setCapacityByLabel("root", "x", 100.0f);
        conf.setCapacityByLabel("root", "y", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 50.0f);
        conf.setMaximumCapacity("root.a", 100.0f);
        conf.setAccessibleNodeLabels("root.a", TestUtils.toSet("x"));
        conf.setDefaultNodeLabelExpression("root.a", "x");
        conf.setCapacityByLabel("root.a", "x", 100.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 50.0f);
        conf.setMaximumCapacity("root.b", 100.0f);
        conf.setAccessibleNodeLabels("root.b", TestUtils.toSet("y"));
        conf.setDefaultNodeLabelExpression("root.b", "y");
        conf.setCapacityByLabel("root.b", "y", 100.0f);
        return conf;
    }

    @Test(timeout=300000L)
    public void testGetNMNumInAllocatedResponseWithNodeLabel() throws Exception {
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.node-labels.enabled", true);
        MockRM rm = new MockRM(this.getConfigurationWithQueueLabels((Configuration)conf)){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                RMNodeLabelsManager mgr = new RMNodeLabelsManager();
                mgr.init(this.getConfig());
                return mgr;
            }
        };
        HashSet<String> clusterNodeLabels = new HashSet<String>();
        clusterNodeLabels.add("x");
        clusterNodeLabels.add("y");
        RMNodeLabelsManager nodeLabelManager = rm.getRMContext().getNodeLabelManager();
        nodeLabelManager.addToCluserNodeLabelsWithDefaultExclusivity(clusterNodeLabels);
        nodeLabelManager.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host1", (int)1234), TestUtils.toSet("x")));
        nodeLabelManager.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host2", (int)1234), TestUtils.toSet("x")));
        nodeLabelManager.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host3", (int)1234), TestUtils.toSet("x")));
        nodeLabelManager.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host4", (int)1234), TestUtils.toSet("y")));
        rm.start();
        MockNM nm1 = rm.registerNode("host1:1234", 6144);
        MockNM nm2 = rm.registerNode("host2:1234", 6144);
        MockNM nm3 = rm.registerNode("host3:1234", 6144);
        MockNM nm4 = rm.registerNode("host4:1234", 6144);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm).withAppName("someApp1").withUser("someUser").withQueue("root.a").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm).withAppName("someApp2").withUser("someUser").withQueue("root.b").build();
        RMApp app2 = MockRMAppSubmitter.submit(rm, data2);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm4);
        AllocateRequestPBImpl allocateRequest = new AllocateRequestPBImpl();
        ArrayList release = new ArrayList();
        ArrayList ask = new ArrayList();
        allocateRequest.setReleaseList(release);
        allocateRequest.setAskList(ask);
        AllocateResponse response1 = am1.allocate((AllocateRequest)allocateRequest);
        AllocateResponse response2 = am2.allocate((AllocateRequest)allocateRequest);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNode rmNode2 = (RMNode)rm.getRMContext().getRMNodes().get(nm2.getNodeId());
        RMNode rmNode3 = (RMNode)rm.getRMContext().getRMNodes().get(nm3.getNodeId());
        RMNode rmNode4 = (RMNode)rm.getRMContext().getRMNodes().get(nm4.getNodeId());
        for (int i = 0; i < 3; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode3));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode4));
        }
        Assert.assertEquals((long)3L, (long)response1.getNumClusterNodes());
        Assert.assertEquals((long)1L, (long)response2.getNumClusterNodes());
        rm.stop();
    }
}

