/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ContainerLaunchContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LogAggregationContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;

@XmlRootElement(name="application-submission-context")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ApplicationSubmissionContextInfo {
    @XmlElement(name="application-id")
    String applicationId = "";
    @XmlElement(name="application-name")
    String applicationName = "";
    String queue;
    int priority;
    @XmlElement(name="am-container-spec")
    ContainerLaunchContextInfo containerInfo = new ContainerLaunchContextInfo();
    @XmlElement(name="unmanaged-AM")
    boolean isUnmanagedAM = false;
    @XmlElement(name="cancel-tokens-when-complete")
    boolean cancelTokensWhenComplete = true;
    @XmlElement(name="max-app-attempts")
    int maxAppAttempts;
    @XmlElement(name="resource")
    ResourceInfo resource = new ResourceInfo();
    @XmlElement(name="application-type")
    String applicationType = "";
    @XmlElement(name="keep-containers-across-application-attempts")
    boolean keepContainers = false;
    @XmlElementWrapper(name="application-tags")
    @XmlElement(name="tag")
    Set<String> tags;
    @XmlElement(name="app-node-label-expression")
    String appNodeLabelExpression = "";
    @XmlElement(name="am-container-node-label-expression")
    String amContainerNodeLabelExpression = "";
    @XmlElement(name="log-aggregation-context")
    LogAggregationContextInfo logAggregationContextInfo = null;
    @XmlElement(name="attempt-failures-validity-interval")
    long attemptFailuresValidityInterval = -1L;
    @XmlElement(name="reservation-id")
    String reservationId = "";

    public ApplicationSubmissionContextInfo() {
        this.priority = Priority.UNDEFINED.getPriority();
        this.tags = new HashSet<String>();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getQueue() {
        return this.queue;
    }

    public int getPriority() {
        return this.priority;
    }

    public ContainerLaunchContextInfo getContainerLaunchContextInfo() {
        return this.containerInfo;
    }

    public boolean getUnmanagedAM() {
        return this.isUnmanagedAM;
    }

    public boolean getCancelTokensWhenComplete() {
        return this.cancelTokensWhenComplete;
    }

    public int getMaxAppAttempts() {
        return this.maxAppAttempts;
    }

    public ResourceInfo getResource() {
        return this.resource;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public boolean getKeepContainersAcrossApplicationAttempts() {
        return this.keepContainers;
    }

    public Set<String> getApplicationTags() {
        return this.tags;
    }

    public String getAppNodeLabelExpression() {
        return this.appNodeLabelExpression;
    }

    public String getAMContainerNodeLabelExpression() {
        return this.amContainerNodeLabelExpression;
    }

    public LogAggregationContextInfo getLogAggregationContextInfo() {
        return this.logAggregationContextInfo;
    }

    public long getAttemptFailuresValidityInterval() {
        return this.attemptFailuresValidityInterval;
    }

    public String getReservationId() {
        return this.reservationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setContainerLaunchContextInfo(ContainerLaunchContextInfo containerLaunchContext) {
        this.containerInfo = containerLaunchContext;
    }

    public void setUnmanagedAM(boolean isUnmanagedAM) {
        this.isUnmanagedAM = isUnmanagedAM;
    }

    public void setCancelTokensWhenComplete(boolean cancelTokensWhenComplete) {
        this.cancelTokensWhenComplete = cancelTokensWhenComplete;
    }

    public void setMaxAppAttempts(int maxAppAttempts) {
        this.maxAppAttempts = maxAppAttempts;
    }

    public void setResource(ResourceInfo resource) {
        this.resource = resource;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public void setKeepContainersAcrossApplicationAttempts(boolean keepContainers) {
        this.keepContainers = keepContainers;
    }

    public void setApplicationTags(Set<String> tags) {
        this.tags = tags;
    }

    public void setAppNodeLabelExpression(String appNodeLabelExpression) {
        this.appNodeLabelExpression = appNodeLabelExpression;
    }

    public void setAMContainerNodeLabelExpression(String nodeLabelExpression) {
        this.amContainerNodeLabelExpression = nodeLabelExpression;
    }

    public void setLogAggregationContextInfo(LogAggregationContextInfo logAggregationContextInfo) {
        this.logAggregationContextInfo = logAggregationContextInfo;
    }

    public void setAttemptFailuresValidityInterval(long attemptFailuresValidityInterval) {
        this.attemptFailuresValidityInterval = attemptFailuresValidityInterval;
    }

    public void setReservationId(String reservationId) {
        this.reservationId = reservationId;
    }
}

