/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ReservationACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;

public class QueueProperties {
    private final Map<String, Resource> minQueueResources;
    private final Map<String, ConfigurableResource> maxQueueResources;
    private final Map<String, ConfigurableResource> maxChildQueueResources;
    private final Map<String, Integer> queueMaxApps;
    private final Map<String, Float> queueMaxAMShares;
    private final Map<String, Float> queueWeights;
    private final Map<String, SchedulingPolicy> queuePolicies;
    private final Map<String, Long> minSharePreemptionTimeouts;
    private final Map<String, Long> fairSharePreemptionTimeouts;
    private final Map<String, Float> fairSharePreemptionThresholds;
    private final Map<String, Map<AccessType, AccessControlList>> queueAcls;
    private final Map<String, Map<ReservationACL, AccessControlList>> reservationAcls;
    private final Set<String> reservableQueues;
    private final Set<String> nonPreemptableQueues;
    private final Map<FSQueueType, Set<String>> configuredQueues;
    private final Map<String, Resource> queueMaxContainerAllocation;
    private final Map<String, String> queueLabels;

    QueueProperties(Builder builder) {
        this.reservableQueues = builder.reservableQueues;
        this.minQueueResources = builder.minQueueResources;
        this.fairSharePreemptionTimeouts = builder.fairSharePreemptionTimeouts;
        this.queueWeights = builder.queueWeights;
        this.nonPreemptableQueues = builder.nonPreemptableQueues;
        this.configuredQueues = builder.configuredQueues;
        this.queueMaxAMShares = builder.queueMaxAMShares;
        this.queuePolicies = builder.queuePolicies;
        this.fairSharePreemptionThresholds = builder.fairSharePreemptionThresholds;
        this.queueMaxApps = builder.queueMaxApps;
        this.minSharePreemptionTimeouts = builder.minSharePreemptionTimeouts;
        this.maxQueueResources = builder.maxQueueResources;
        this.maxChildQueueResources = builder.maxChildQueueResources;
        this.reservationAcls = builder.reservationAcls;
        this.queueAcls = builder.queueAcls;
        this.queueMaxContainerAllocation = builder.queueMaxContainerAllocation;
        this.queueLabels = builder.queueLabels;
    }

    public Map<FSQueueType, Set<String>> getConfiguredQueues() {
        return this.configuredQueues;
    }

    public Map<String, Long> getMinSharePreemptionTimeouts() {
        return this.minSharePreemptionTimeouts;
    }

    public Map<String, Long> getFairSharePreemptionTimeouts() {
        return this.fairSharePreemptionTimeouts;
    }

    public Map<String, Float> getFairSharePreemptionThresholds() {
        return this.fairSharePreemptionThresholds;
    }

    public Map<String, Resource> getMinQueueResources() {
        return this.minQueueResources;
    }

    public Map<String, ConfigurableResource> getMaxQueueResources() {
        return this.maxQueueResources;
    }

    public Map<String, ConfigurableResource> getMaxChildQueueResources() {
        return this.maxChildQueueResources;
    }

    public Map<String, Integer> getQueueMaxApps() {
        return this.queueMaxApps;
    }

    public Map<String, Float> getQueueWeights() {
        return this.queueWeights;
    }

    public Map<String, Float> getQueueMaxAMShares() {
        return this.queueMaxAMShares;
    }

    public Map<String, SchedulingPolicy> getQueuePolicies() {
        return this.queuePolicies;
    }

    public Map<String, Map<AccessType, AccessControlList>> getQueueAcls() {
        return this.queueAcls;
    }

    public Map<String, Map<ReservationACL, AccessControlList>> getReservationAcls() {
        return this.reservationAcls;
    }

    public Set<String> getReservableQueues() {
        return this.reservableQueues;
    }

    public Set<String> getNonPreemptableQueues() {
        return this.nonPreemptableQueues;
    }

    public Map<String, Resource> getMaxContainerAllocation() {
        return this.queueMaxContainerAllocation;
    }

    public Map<String, String> getQueueLabels() {
        return this.queueLabels;
    }

    public static final class Builder {
        private Map<String, Resource> minQueueResources = new HashMap<String, Resource>();
        private Map<String, ConfigurableResource> maxQueueResources = new HashMap<String, ConfigurableResource>();
        private Map<String, ConfigurableResource> maxChildQueueResources = new HashMap<String, ConfigurableResource>();
        private Map<String, Integer> queueMaxApps = new HashMap<String, Integer>();
        private Map<String, Float> queueMaxAMShares = new HashMap<String, Float>();
        private Map<String, Resource> queueMaxContainerAllocation = new HashMap<String, Resource>();
        private Map<String, Float> queueWeights = new HashMap<String, Float>();
        private Map<String, SchedulingPolicy> queuePolicies = new HashMap<String, SchedulingPolicy>();
        private Map<String, Long> minSharePreemptionTimeouts = new HashMap<String, Long>();
        private Map<String, Long> fairSharePreemptionTimeouts = new HashMap<String, Long>();
        private Map<String, Float> fairSharePreemptionThresholds = new HashMap<String, Float>();
        private Map<String, Map<AccessType, AccessControlList>> queueAcls = new HashMap<String, Map<AccessType, AccessControlList>>();
        private Map<String, Map<ReservationACL, AccessControlList>> reservationAcls = new HashMap<String, Map<ReservationACL, AccessControlList>>();
        private Set<String> reservableQueues = new HashSet<String>();
        private Set<String> nonPreemptableQueues = new HashSet<String>();
        private Map<FSQueueType, Set<String>> configuredQueues = new HashMap<FSQueueType, Set<String>>();
        private Map<String, String> queueLabels = new HashMap<String, String>();

        Builder() {
            for (FSQueueType queueType : FSQueueType.values()) {
                this.configuredQueues.put(queueType, new HashSet());
            }
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder minQueueResources(String queueName, Resource resource) {
            this.minQueueResources.put(queueName, resource);
            return this;
        }

        public Builder maxQueueResources(String queueName, ConfigurableResource resource) {
            this.maxQueueResources.put(queueName, resource);
            return this;
        }

        public Builder maxChildQueueResources(String queueName, ConfigurableResource resource) {
            this.maxChildQueueResources.put(queueName, resource);
            return this;
        }

        public Builder queueMaxApps(String queueName, int value) {
            this.queueMaxApps.put(queueName, value);
            return this;
        }

        public Builder queueMaxAMShares(String queueName, float value) {
            this.queueMaxAMShares.put(queueName, Float.valueOf(value));
            return this;
        }

        public Builder queueWeights(String queueName, float value) {
            this.queueWeights.put(queueName, Float.valueOf(value));
            return this;
        }

        public Builder queuePolicies(String queueName, SchedulingPolicy policy) {
            this.queuePolicies.put(queueName, policy);
            return this;
        }

        public Builder minSharePreemptionTimeouts(String queueName, long value) {
            this.minSharePreemptionTimeouts.put(queueName, value);
            return this;
        }

        public Builder fairSharePreemptionTimeouts(String queueName, long value) {
            this.fairSharePreemptionTimeouts.put(queueName, value);
            return this;
        }

        public Builder fairSharePreemptionThresholds(String queueName, float value) {
            this.fairSharePreemptionThresholds.put(queueName, Float.valueOf(value));
            return this;
        }

        public Builder queueAcls(String queueName, AccessType accessType, AccessControlList acls) {
            this.queueAcls.putIfAbsent(queueName, new HashMap());
            this.queueAcls.get(queueName).put(accessType, acls);
            return this;
        }

        public Builder reservationAcls(String queueName, ReservationACL reservationACL, AccessControlList acls) {
            this.reservationAcls.putIfAbsent(queueName, new HashMap());
            this.reservationAcls.get(queueName).put(reservationACL, acls);
            return this;
        }

        public Builder reservableQueues(String queue) {
            this.reservableQueues.add(queue);
            return this;
        }

        public Builder nonPreemptableQueues(String queue) {
            this.nonPreemptableQueues.add(queue);
            return this;
        }

        public Builder queueMaxContainerAllocation(String queueName, Resource value) {
            this.queueMaxContainerAllocation.put(queueName, value);
            return this;
        }

        public Builder queueLabels(String queueName, String label) {
            this.queueLabels.put(queueName, label);
            return this;
        }

        public void configuredQueues(FSQueueType queueType, String queueName) {
            this.configuredQueues.get((Object)queueType).add(queueName);
        }

        public boolean isAclDefinedForAccessType(String queueName, AccessType accessType) {
            Map<AccessType, AccessControlList> aclsForQueue = this.queueAcls.get(queueName);
            return aclsForQueue != null && aclsForQueue.get(accessType) != null;
        }

        public Map<String, Resource> getMinQueueResources() {
            return this.minQueueResources;
        }

        public Map<String, ConfigurableResource> getMaxQueueResources() {
            return this.maxQueueResources;
        }

        public QueueProperties build() {
            return new QueueProperties(this);
        }
    }
}

