/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.ActivitiesTestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWSConsts;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesCapacitySched;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRMWebServicesSchedulerActivities
extends TestRMWebServicesCapacitySched {
    private static final Logger LOG = LoggerFactory.getLogger(TestRMWebServicesSchedulerActivities.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssignMultipleContainersPerNodeHeartbeat() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(10L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm, data);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.1:1234");
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocation = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            ActivitiesTestUtils.verifyStateOfAllocations(allocation, "finalAllocationState", "ALLOCATED");
            ActivitiesTestUtils.verifyQueueOrder(allocation, "root-root.a-root.c-root.b-root.b.b2-root.b.b3-root.b.b1");
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssignWithoutAvailableResource() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 1024, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm, data);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.1");
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject rootObj = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations").getJSONObject("root");
            Assert.assertTrue((boolean)rootObj.optString("diagnostic").startsWith("Initial check: node resource is insufficient for minimum allocation"));
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoNM() throws Exception {
        rm.start();
        try {
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.1:1234");
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 0);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrongNodeId() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm, data);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.0");
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 0);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReserveNewContainer() throws Exception {
        rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 4096, rm.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.2:1234", 4096, rm.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        try {
            MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(10L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm, data1);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(10L, rm).withAppName("app2").withUser("user1").withAcls(null).withQueue("b2").withUnmanagedAM(false).build();
            RMApp app2 = MockRMAppSubmitter.submit(rm, data);
            MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)4096), (int)10)), null);
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.2");
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocations = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            ActivitiesTestUtils.verifyQueueOrder(allocations, "root-root.c-root.a-root.b-root.b.b3-root.b.b1");
            ActivitiesTestUtils.verifyStateOfAllocations(allocations, "finalAllocationState", "RESERVED");
            r = this.resource();
            params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.2");
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocation = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            ActivitiesTestUtils.verifyQueueOrder(allocation, "root.b.b1");
            ActivitiesTestUtils.verifyStateOfAllocations(allocation, "finalAllocationState", "RESERVED");
            CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)1L);
            cs.completedContainer(cs.getRMContainer(containerId), ContainerStatus.newInstance((ContainerId)containerId, (ContainerState)ContainerState.COMPLETE, (String)"", (int)0), RMContainerEventType.FINISHED);
            r = this.resource();
            params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.2");
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            allocations = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            ActivitiesTestUtils.verifyQueueOrder(allocations, "root.b.b1");
            ActivitiesTestUtils.verifyStateOfAllocations(allocations, "finalAllocationState", "ALLOCATED_FROM_RESERVED");
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testActivityJSON() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(10L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm, data);
            WebResource r = this.resource();
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("nodeId", "127.0.0.1");
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocation = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            ActivitiesTestUtils.verifyStateOfAllocations(allocation, "finalAllocationState", "ALLOCATED");
            ActivitiesTestUtils.verifyNumberOfNodes(allocation, 6);
            ActivitiesTestUtils.verifyQueueOrder(allocation, "root-root.b-root.b.b1");
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppActivityJSON() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(10L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm, data);
            WebResource r = this.resource().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            nm.nodeHeartbeat(true);
            Thread.sleep(5000L);
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocation = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "appActivities", "allocations");
            ActivitiesTestUtils.verifyStateOfAllocations(allocation, "allocationState", "ALLOCATED");
            JSONObject requestAllocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(allocation, "children");
            ActivitiesTestUtils.verifyStateOfAllocations(requestAllocationObj, "allocationState", "ALLOCATED");
            Assert.assertEquals((long)0L, (long)requestAllocationObj.optInt("requestPriority"));
            Assert.assertEquals((long)-1L, (long)requestAllocationObj.optLong("allocationRequestId"));
            ActivitiesTestUtils.verifyNumberOfAllocationAttempts(requestAllocationObj, 1);
            List<JSONObject> allocationAttempts = ActivitiesTestUtils.getSubNodesFromJson(requestAllocationObj, "children");
            Assert.assertEquals((long)1L, (long)allocationAttempts.size());
            ActivitiesTestUtils.verifyStateOfAllocations(allocationAttempts.get(0), "allocationState", "ALLOCATED");
            Assert.assertNotNull((Object)allocationAttempts.get(0).get("nodeId"));
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppAssignMultipleContainersPerNodeHeartbeat() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm, data);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebResource r = this.resource().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            nm.nodeHeartbeat(true);
            Thread.sleep(5000L);
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 10);
            List<JSONObject> allocations = ActivitiesTestUtils.getSubNodesFromJson(json, "appActivities", "allocations");
            for (int i = 0; i < allocations.size(); ++i) {
                ActivitiesTestUtils.verifyStateOfAllocations(allocations.get(i), "allocationState", "ALLOCATED");
            }
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppAssignWithoutAvailableResource() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 1024, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm, data);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebResource r = this.resource().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            nm.nodeHeartbeat(true);
            Thread.sleep(5000L);
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 0);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppNoNM() throws Exception {
        rm.start();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm, data);
            WebResource r = this.resource().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 0);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppReserveNewContainer() throws Exception {
        rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 4096, rm.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.2:1234", 4096, rm.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        try {
            MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(10L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm, data1);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(10L, rm).withAppName("app2").withUser("user1").withAcls(null).withQueue("b2").withUnmanagedAM(false).build();
            RMApp app2 = MockRMAppSubmitter.submit(rm, data);
            MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)4096), (int)10)), null);
            WebResource r = this.resource().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)1L);
            cs.completedContainer(cs.getRMContainer(containerId), ContainerStatus.newInstance((ContainerId)containerId, (ContainerState)ContainerState.COMPLETE, (String)"", (int)0), RMContainerEventType.FINISHED);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 3);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testInsufficientResourceDiagnostic() throws Exception {
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
        MockNM nm2 = rm.registerNode("127.0.0.2:1234", 8192);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((Object)"waiting for next allocation", (Object)ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities").optString("diagnostic"));
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)5120), (int)1)), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            Predicate<JSONObject> findReqPred = obj -> obj.optString("name").equals("request_-1_-1");
            List<JSONObject> app2ReqObjs = ActivitiesTestUtils.findInAllocations(allocationObj, findReqPred);
            Assert.assertEquals((long)1L, (long)app2ReqObjs.size());
            List<JSONObject> reqAllocations = ActivitiesTestUtils.getSubNodesFromJson(app2ReqObjs.get(0), "children");
            Assert.assertEquals((long)1L, (long)reqAllocations.size());
            Assert.assertTrue((boolean)reqAllocations.get(0).getString("diagnostic").contains("Node's total resource is insufficient for request, insufficient resources="));
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testPlacementConstraintDiagnostic() throws Exception {
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            PlacementConstraint pcExpression = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}));
            ArrayList<SchedulingRequest> schedulingRequests = new ArrayList<SchedulingRequest>();
            schedulingRequests.add(ActivitiesTestUtils.schedulingRequest(5, 1, 1L, 1, 512, pcExpression, "foo"));
            AllocateRequest allocateReq = AllocateRequest.newBuilder().schedulingRequests(schedulingRequests).build();
            am1.allocate(allocateReq);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((Object)"waiting for next allocation", (Object)ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities").optString("diagnostic"));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/activities").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            Predicate<JSONObject> findReqPred = obj -> obj.optString("name").equals("request_1_1");
            List<JSONObject> reqObjs = ActivitiesTestUtils.findInAllocations(allocationObj, findReqPred);
            Assert.assertEquals((long)1L, (long)reqObjs.size());
            JSONObject reqChild = ActivitiesTestUtils.getFirstSubNodeFromJson(reqObjs.get(0), "children");
            Assert.assertTrue((boolean)reqChild.getString("diagnostic").contains("Node does not match partition or placement constraints, unsatisfied PC expression="));
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppInsufficientResourceDiagnostic() throws Exception {
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
        MockNM nm2 = rm.registerNode("127.0.0.2:1234", 8192);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            WebResource r = this.resource().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)5120), (int)1)), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "appActivities", "allocations");
            JSONObject requestAllocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(allocationObj, "children");
            ActivitiesTestUtils.verifyNumberOfAllocationAttempts(requestAllocationObj, 1);
            JSONObject allocationAttemptObj = ActivitiesTestUtils.getFirstSubNodeFromJson(requestAllocationObj, "children");
            ActivitiesTestUtils.verifyStateOfAllocations(allocationAttemptObj, "allocationState", "SKIPPED");
            Assert.assertTrue((boolean)allocationAttemptObj.optString("diagnostic").contains("Node's total resource is insufficient for request, insufficient resources="));
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppPlacementConstraintDiagnostic() throws Exception {
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
        MockNM nm2 = rm.registerNode("127.0.0.2:1234", 8192);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            WebResource r = this.resource().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            PlacementConstraint pcExpression = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}));
            ArrayList<SchedulingRequest> schedulingRequests = new ArrayList<SchedulingRequest>();
            schedulingRequests.add(ActivitiesTestUtils.schedulingRequest(5, 1, 1L, 1, 512, pcExpression, "foo"));
            AllocateRequest allocateReq = AllocateRequest.newBuilder().schedulingRequests(schedulingRequests).build();
            am1.allocate(allocateReq);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "appActivities", "allocations");
            JSONObject requestAllocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(allocationObj, "children");
            ActivitiesTestUtils.verifyNumberOfAllocationAttempts(requestAllocationObj, 1);
            JSONObject allocationAttemptObj = ActivitiesTestUtils.getFirstSubNodeFromJson(requestAllocationObj, "children");
            ActivitiesTestUtils.verifyStateOfAllocations(allocationAttemptObj, "allocationState", "SKIPPED");
            Assert.assertTrue((boolean)allocationAttemptObj.optString("diagnostic").contains("Node does not match partition or placement constraints, unsatisfied PC expression="));
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppFilterByRequestPrioritiesAndAllocationRequestIds() throws Exception {
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 8192);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            WebResource r = this.resource().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            am1.allocate(Arrays.asList(ResourceRequest.newBuilder().priority(Priority.UNDEFINED).allocationRequestId(1L).resourceName("*").capability(Resources.createResource((int)1024)).numContainers(1).build()), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            am1.allocate(Arrays.asList(ResourceRequest.newBuilder().priority(Priority.UNDEFINED).allocationRequestId(2L).resourceName("*").capability(Resources.createResource((int)1024)).numContainers(1).build()), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            am1.allocate(Arrays.asList(ResourceRequest.newBuilder().priority(Priority.newInstance((int)0)).allocationRequestId(1L).resourceName("*").capability(Resources.createResource((int)1024)).numContainers(1).build()), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            am1.allocate(Arrays.asList(ResourceRequest.newBuilder().priority(Priority.newInstance((int)0)).allocationRequestId(3L).resourceName("*").capability(Resources.createResource((int)1024)).numContainers(1).build()), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            MultivaluedMapImpl filterParams1 = new MultivaluedMapImpl((MultivaluedMap)params);
            filterParams1.add("requestPriorities", "0,-1");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)filterParams1);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 4);
            MultivaluedMapImpl filterParams2 = new MultivaluedMapImpl((MultivaluedMap)params);
            filterParams2.add("requestPriorities", "-1");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)filterParams2);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            JSONArray allocations = json.getJSONObject("appActivities").getJSONArray("allocations");
            for (int i = 0; i < allocations.length(); ++i) {
                Assert.assertEquals((Object)"-1", (Object)ActivitiesTestUtils.getFirstSubNodeFromJson(allocations.getJSONObject(i), "children").optString("requestPriority"));
            }
            MultivaluedMapImpl filterParams3 = new MultivaluedMapImpl((MultivaluedMap)params);
            filterParams3.add("allocationRequestIds", "1");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)filterParams3);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            allocations = json.getJSONObject("appActivities").getJSONArray("allocations");
            for (int i = 0; i < allocations.length(); ++i) {
                Assert.assertEquals((Object)"1", (Object)ActivitiesTestUtils.getFirstSubNodeFromJson(allocations.getJSONObject(i), "children").optString("allocationRequestId"));
            }
            MultivaluedMapImpl filterParams4 = new MultivaluedMapImpl((MultivaluedMap)params);
            filterParams4.add("requestPriorities", "0");
            filterParams4.add("allocationRequestIds", "1");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)filterParams4);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocation = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "appActivities", "allocations");
            JSONObject request = ActivitiesTestUtils.getFirstSubNodeFromJson(allocation, "children");
            Assert.assertEquals((Object)"0", (Object)request.optString("requestPriority"));
            Assert.assertEquals((Object)"1", (Object)request.optString("allocationRequestId"));
            MultivaluedMapImpl filterParams5 = new MultivaluedMapImpl((MultivaluedMap)params);
            filterParams5.add("requestPriorities", "-1");
            filterParams5.add("allocationRequestIds", "1,2");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)filterParams5);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            allocations = json.getJSONObject("appActivities").getJSONArray("allocations");
            for (int i = 0; i < allocations.length(); ++i) {
                Assert.assertEquals((Object)"-1", (Object)ActivitiesTestUtils.getFirstSubNodeFromJson(allocations.getJSONObject(i), "children").optString("requestPriority"));
            }
            MultivaluedMapImpl filterParams6 = new MultivaluedMapImpl((MultivaluedMap)params);
            filterParams6.add("requestPriorities", "-1");
            filterParams6.add("allocationRequestIds", "-1,1");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)filterParams6);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppLimit() throws Exception {
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
        MockNM nm2 = rm.registerNode("127.0.0.2:1234", 8192);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            WebResource r = this.resource().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            am1.allocate("*", 5120, 1, new ArrayList<ContainerId>());
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 3);
            params.putSingle("limit", "10");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 3);
            params.putSingle("limit", "2");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            params.putSingle("limit", "1");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            params.putSingle("limit", "STRING");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"limit must be integer!", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            params.putSingle("limit", "0");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"limit must be greater than 0!", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            params.putSingle("limit", "-3");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"limit must be greater than 0!", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppActions() throws Exception {
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 8192);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            am1.allocate("*", 512, 10, new ArrayList<ContainerId>());
            WebResource r = this.resource().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.add("maxTime", (Object)1);
            params.add("actions", "get,invalid-action");
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertTrue((boolean)json.getJSONObject("appActivities").getString("diagnostic").startsWith("Got invalid action"));
            params.putSingle("actions", "get");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            params.putSingle("actions", "get");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            params.putSingle("actions", "refresh");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"Successfully received action: refresh", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            Thread.sleep(1000L);
            params.putSingle("actions", "get");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            Thread.sleep(1000L);
            params.remove((Object)"actions");
            params.add("actions", "refresh,get");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            Thread.sleep(1000L);
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            Thread.sleep(1000L);
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 3);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppSummary() throws Exception {
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 8192);
        MockNM nm2 = rm.registerNode("127.0.0.2:1234", 4096);
        MockNM nm3 = rm.registerNode("127.0.0.3:1234", 4096);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(5120L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            WebResource r = this.resource().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)Resources.createResource((int)5120), (int)1)), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm2.getNodeId())));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm3.getNodeId())));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            params.add("summarize", "true");
            params.add("groupBy", (Object)RMWSConsts.ActivitiesGroupBy.DIAGNOSTIC);
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocation = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "appActivities", "allocations");
            JSONObject reqestAllocation = ActivitiesTestUtils.getFirstSubNodeFromJson(allocation, "children");
            JSONArray attempts = reqestAllocation.getJSONArray("children");
            Assert.assertEquals((long)2L, (long)attempts.length());
            for (int i = 0; i < attempts.length(); ++i) {
                JSONObject attempt = attempts.getJSONObject(i);
                if (attempt.getString("allocationState").equals(ActivityState.SKIPPED.name())) {
                    Assert.assertEquals((long)2L, (long)attempt.getJSONArray("nodeIds").length());
                    continue;
                }
                if (!attempt.getString("allocationState").equals(ActivityState.RESERVED.name())) continue;
                Assert.assertEquals((long)1L, (long)attempt.getJSONArray("nodeIds").length());
                Assert.assertEquals((Object)nm1.getNodeId().toString(), (Object)attempt.getJSONArray("nodeIds").getString(0));
            }
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeSkippedBecauseOfRelaxLocality() throws Exception {
        rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 4096, rm.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.2:1234", 4096, rm.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(10L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            am1.allocate(Arrays.asList(ResourceRequest.newBuilder().priority(Priority.UNDEFINED).resourceName("127.0.0.2").capability(Resources.createResource((int)1024)).numContainers(1).build(), ResourceRequest.newBuilder().priority(Priority.UNDEFINED).resourceName("/default-rack").capability(Resources.createResource((int)1024)).numContainers(1).relaxLocality(false).build(), ResourceRequest.newBuilder().priority(Priority.UNDEFINED).resourceName("*").capability(Resources.createResource((int)1024)).numContainers(1).relaxLocality(false).build()), null);
            WebResource r = this.resource().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            ActivitiesTestUtils.requestWebResource(r, null);
            WebResource sr = this.resource().path("/ws/v1/cluster").path("/scheduler/activities");
            ActivitiesTestUtils.requestWebResource(sr, null);
            nm1.nodeHeartbeat(true);
            Thread.sleep(1000L);
            JSONObject appActivitiesJson = ActivitiesTestUtils.requestWebResource(r, null);
            JSONObject schedulerActivitiesJson = ActivitiesTestUtils.requestWebResource(sr, null);
            ActivitiesTestUtils.verifyNumberOfAllocations(appActivitiesJson, 1);
            List<JSONObject> allocationAttempts = ActivitiesTestUtils.getSubNodesFromJson(appActivitiesJson, "appActivities", "allocations", "children", "children");
            Assert.assertEquals((long)1L, (long)allocationAttempts.size());
            Assert.assertEquals((Object)"Node skipped because relax locality is not allowed", (Object)allocationAttempts.get(0).optString("diagnostic"));
            ActivitiesTestUtils.verifyNumberOfAllocations(schedulerActivitiesJson, 1);
            Predicate<JSONObject> findA1AQueuePred = obj -> obj.optString("name").equals("request_-1_-1");
            List<JSONObject> reqObjs = ActivitiesTestUtils.findInAllocations(ActivitiesTestUtils.getFirstSubNodeFromJson(schedulerActivitiesJson, "activities", "allocations"), findA1AQueuePred);
            Assert.assertEquals((long)1L, (long)reqObjs.size());
            Assert.assertEquals((Object)ActivityState.SKIPPED.name(), (Object)reqObjs.get(0).optString("allocationState"));
            JSONObject nodeObj = ActivitiesTestUtils.getFirstSubNodeFromJson(reqObjs.get(0), "children");
            Assert.assertEquals((Object)nm1.getNodeId().toString(), (Object)nodeObj.optString("nodeId"));
            Assert.assertEquals((Object)"Node skipped because relax locality is not allowed", (Object)nodeObj.optString("diagnostic"));
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueueSkippedBecauseOfHeadroom() throws Exception {
        rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 4096, rm.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.2:1234", 4096, rm.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(10L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("a1a").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            am1.allocate(Arrays.asList(ResourceRequest.newBuilder().priority(Priority.UNDEFINED).resourceName("*").capability(Resources.createResource((int)3072)).numContainers(1).relaxLocality(false).build()), null);
            WebResource r = this.resource().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            ActivitiesTestUtils.requestWebResource(r, null);
            WebResource sr = this.resource().path("/ws/v1/cluster").path("/scheduler/activities");
            ActivitiesTestUtils.requestWebResource(sr, null);
            nm1.nodeHeartbeat(true);
            Thread.sleep(1000L);
            JSONObject appActivitiesJson = ActivitiesTestUtils.requestWebResource(r, null);
            JSONObject schedulerActivitiesJson = ActivitiesTestUtils.requestWebResource(sr, null);
            ActivitiesTestUtils.verifyNumberOfAllocations(appActivitiesJson, 1);
            List<JSONObject> requestAllocations = ActivitiesTestUtils.getSubNodesFromJson(appActivitiesJson, "appActivities", "allocations", "children");
            Assert.assertEquals((long)1L, (long)requestAllocations.size());
            Assert.assertEquals((Object)"Queue does not have enough headroom for inner highest-priority request", (Object)requestAllocations.get(0).optString("diagnostic"));
            Assert.assertFalse((boolean)requestAllocations.get(0).has("children"));
            ActivitiesTestUtils.verifyNumberOfAllocations(schedulerActivitiesJson, 1);
            Predicate<JSONObject> findA1AQueuePred = obj -> obj.optString("name").equals("root.a.a1.a1a");
            List<JSONObject> a1aQueueObj = ActivitiesTestUtils.findInAllocations(ActivitiesTestUtils.getFirstSubNodeFromJson(schedulerActivitiesJson, "activities", "allocations"), findA1AQueuePred);
            Assert.assertEquals((long)1L, (long)a1aQueueObj.size());
            Assert.assertEquals((Object)ActivityState.REJECTED.name(), (Object)a1aQueueObj.get(0).optString("allocationState"));
            Assert.assertTrue((boolean)a1aQueueObj.get(0).optString("diagnostic").startsWith("Queue does not have enough headroom for inner highest-priority request"));
            Predicate<JSONObject> findReqPred = obj -> obj.optString("name").equals("request_-1_-1");
            List<JSONObject> reqObj = ActivitiesTestUtils.findInAllocations(ActivitiesTestUtils.getFirstSubNodeFromJson(schedulerActivitiesJson, "activities", "allocations"), findReqPred);
            Assert.assertEquals((long)1L, (long)reqObj.size());
            Assert.assertEquals((Object)ActivityState.REJECTED.name(), (Object)reqObj.get(0).optString("allocationState"));
            Assert.assertTrue((boolean)reqObj.get(0).optString("diagnostic").startsWith("Queue does not have enough headroom for inner highest-priority request"));
        }
        finally {
            rm.stop();
        }
    }
}

