/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQueueManagerRealScheduler
extends FairSchedulerTestBase {
    private static final File ALLOC_FILE = new File(TEST_DIR, "test-queue-mgr");

    @Before
    public void setup() throws IOException {
        this.createConfiguration();
        this.writeAllocFile(30);
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE.getAbsolutePath());
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
    }

    @After
    public void teardown() {
        ALLOC_FILE.deleteOnExit();
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
    }

    private void writeAllocFile(int defaultFairShareTimeout) {
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("default").build()).addQueue(new AllocationFileQueue.Builder("queueA").build()).addQueue(new AllocationFileQueue.Builder("queueB").subQueue(new AllocationFileQueue.Builder("queueB1").minSharePreemptionTimeout(5).build()).subQueue(new AllocationFileQueue.Builder("queueB2").build()).build()).addQueue(new AllocationFileQueue.Builder("queueC").build()).defaultMinSharePreemptionTimeout(15).defaultFairSharePreemptionTimeout(defaultFairShareTimeout).writeToFile(ALLOC_FILE.getAbsolutePath());
    }

    @Test
    public void testBackwardsCompatiblePreemptionConfiguration() throws IOException {
        QueueManager queueMgr = this.scheduler.getQueueManager();
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("root").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("default").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueA").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueB").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueB.queueB1").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueB.queueB2").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueC").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("root").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("default").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueA").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueB").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)5000L, (long)queueMgr.getQueue("queueB.queueB1").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueB.queueB2").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueC").getMinSharePreemptionTimeout());
        this.writeAllocFile(25);
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)25000L, (long)queueMgr.getQueue("root").getFairSharePreemptionTimeout());
    }
}

