/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.Map;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AppMetricsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(AppMetricsChecker.class);
    private static final AppMetricsChecker INITIAL_CHECKER = new AppMetricsChecker().counter(AppMetricsKey.APPS_SUBMITTED, 0).gaugeInt(AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsKey.APPS_RUNNING, 0).counter(AppMetricsKey.APPS_COMPLETED, 0).counter(AppMetricsKey.APPS_FAILED, 0).counter(AppMetricsKey.APPS_KILLED, 0);
    private final Map<AppMetricsKey, Integer> gaugesInt;
    private final Map<AppMetricsKey, Integer> counters;

    private AppMetricsChecker() {
        this.gaugesInt = Maps.newHashMap();
        this.counters = Maps.newHashMap();
    }

    private AppMetricsChecker(AppMetricsChecker checker) {
        this.gaugesInt = Maps.newHashMap(checker.gaugesInt);
        this.counters = Maps.newHashMap(checker.counters);
    }

    public static AppMetricsChecker createFromChecker(AppMetricsChecker checker) {
        return new AppMetricsChecker(checker);
    }

    public static AppMetricsChecker create() {
        return new AppMetricsChecker(INITIAL_CHECKER);
    }

    AppMetricsChecker gaugeInt(AppMetricsKey key, int value) {
        this.gaugesInt.put(key, value);
        return this;
    }

    AppMetricsChecker counter(AppMetricsKey key, int value) {
        this.counters.put(key, value);
        return this;
    }

    AppMetricsChecker checkAgainst(MetricsSource source, boolean all) {
        if (source == null) {
            throw new IllegalStateException("MetricsSource should not be null!");
        }
        MetricsRecordBuilder recordBuilder = MetricsAsserts.getMetrics((MetricsSource)source, (boolean)all);
        this.logAssertingMessage(source);
        for (Map.Entry<AppMetricsKey, Integer> gauge : this.gaugesInt.entrySet()) {
            MetricsAsserts.assertGauge((String)gauge.getKey().value, (int)gauge.getValue(), (MetricsRecordBuilder)recordBuilder);
        }
        for (Map.Entry<AppMetricsKey, Integer> counter : this.counters.entrySet()) {
            MetricsAsserts.assertCounter((String)counter.getKey().value, (int)counter.getValue(), (MetricsRecordBuilder)recordBuilder);
        }
        return this;
    }

    private void logAssertingMessage(MetricsSource source) {
        String queueName = ((QueueMetrics)source).queueName;
        Map users = ((QueueMetrics)source).users;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Asserting App metrics.. QueueName: " + queueName + ", users: " + (users != null && !users.isEmpty() ? users : ""));
        }
    }

    static enum AppMetricsKey {
        APPS_SUBMITTED("AppsSubmitted"),
        APPS_PENDING("AppsPending"),
        APPS_RUNNING("AppsRunning"),
        APPS_COMPLETED("AppsCompleted"),
        APPS_FAILED("AppsFailed"),
        APPS_KILLED("AppsKilled");

        private String value;

        private AppMetricsKey(String value) {
            this.value = value;
        }
    }
}

