/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.crypto.SecretKey;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecords;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerLaunchContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateUpdateAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ZKRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ZKRMStateStoreOpDurations;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.security.MasterKeyData;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZKRMStateStore
extends RMStateStoreTestBase {
    public static final Logger LOG = LoggerFactory.getLogger(TestZKRMStateStore.class);
    private static final int ZK_TIMEOUT_MS = 1000;
    private TestingServer curatorTestingServer;
    private CuratorFramework curatorFramework;

    public static TestingServer setupCuratorServer() throws Exception {
        TestingServer curatorTestingServer = new TestingServer();
        curatorTestingServer.start();
        return curatorTestingServer;
    }

    public static CuratorFramework setupCuratorFramework(TestingServer curatorTestingServer) throws Exception {
        CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(curatorTestingServer.getConnectString()).retryPolicy((RetryPolicy)new RetryNTimes(100, 100)).build();
        curatorFramework.start();
        return curatorFramework;
    }

    @Before
    public void setupCurator() throws Exception {
        this.curatorTestingServer = TestZKRMStateStore.setupCuratorServer();
        this.curatorFramework = TestZKRMStateStore.setupCuratorFramework(this.curatorTestingServer);
    }

    @After
    public void cleanupCuratorServer() throws IOException {
        this.curatorFramework.close();
        this.curatorTestingServer.stop();
    }

    @Test(timeout=60000L)
    public void testZKRMStateStoreRealZK() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        this.testRMAppStateStore(zkTester);
        this.testRMDTSecretManagerStateStore(zkTester);
        this.testCheckVersion(zkTester);
        this.testEpoch(zkTester);
        this.testAppDeletion(zkTester);
        this.testDeleteStore(zkTester);
        this.testRemoveApplication(zkTester);
        this.testRemoveAttempt(zkTester);
        this.testAMRMTokenSecretManagerStateStore(zkTester);
        this.testReservationStateStore(zkTester);
        ((TestZKRMStateStoreTester.TestZKRMStateStoreInternal)zkTester.getRMStateStore()).testRetryingCreateRootDir();
        this.testProxyCA(zkTester);
    }

    @Test
    public void testZKNodeLimit() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        long submitTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis() + 1234L;
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.zk-max-znode-size.bytes", 1);
        RMStateStore store = zkTester.getRMStateStore((Configuration)conf);
        final TestAppRejDispatcher dispatcher = new TestAppRejDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        ApplicationId appId1 = ApplicationId.fromString((String)"application_1352994193343_0001");
        this.storeApp(store, appId1, submitTime, startTime);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return dispatcher.appsavefailedEvnt;
            }
        }, (long)100L, (long)5000L);
    }

    @Test(timeout=60000L)
    public void testCheckMajorVersionChange() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester(){
            Version VERSION_INFO = Version.newInstance((int)Integer.MAX_VALUE, (int)0);

            @Override
            public Version getCurrentVersion() throws Exception {
                return this.VERSION_INFO;
            }

            @Override
            public RMStateStore getRMStateStore() throws Exception {
                YarnConfiguration conf = new YarnConfiguration();
                this.workingZnode = "/jira/issue/3077/rmstore";
                conf.set("hadoop.zk.address", TestZKRMStateStore.this.curatorTestingServer.getConnectString());
                conf.set("yarn.resourcemanager.zk-state-store.parent-path", this.workingZnode);
                this.store = new TestZKRMStateStoreTester.TestZKRMStateStoreInternal((Configuration)conf, this.workingZnode){
                    Version storedVersion;
                    {
                        this.storedVersion = null;
                    }

                    @Override
                    public Version getCurrentVersion() {
                        return VERSION_INFO;
                    }

                    protected synchronized Version loadVersion() throws Exception {
                        return this.storedVersion;
                    }

                    protected synchronized void storeVersion() throws Exception {
                        this.storedVersion = VERSION_INFO;
                    }
                };
                return this.store;
            }
        };
        RMStateStore store = zkTester.getRMStateStore();
        Version defaultVersion = zkTester.getCurrentVersion();
        store.checkVersion();
        Assert.assertEquals((String)"Store had wrong version", (Object)defaultVersion, (Object)store.loadVersion());
    }

    public static Configuration createHARMConf(String rmIds, String rmId, int adminPort, boolean autoFailoverEnabled, TestingServer curatorTestServer) {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", rmIds);
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.set("yarn.resourcemanager.store.class", ZKRMStateStore.class.getName());
        conf.set("hadoop.zk.address", curatorTestServer.getConnectString());
        conf.setInt("hadoop.zk.timeout-ms", 1000);
        conf.set("yarn.resourcemanager.ha.id", rmId);
        conf.set("yarn.resourcemanager.webapp.address", "localhost:0");
        conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", autoFailoverEnabled);
        for (String rpcAddress : YarnConfiguration.getServiceAddressConfKeys((Configuration)conf)) {
            for (String id : HAUtil.getRMHAIds((Configuration)conf)) {
                conf.set(HAUtil.addSuffix((String)rpcAddress, (String)id), "localhost:0");
            }
        }
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.admin.address", (String)rmId), "localhost:" + adminPort);
        conf.setBoolean("yarn.resourcemanager.status.server.enabled", false);
        return conf;
    }

    private static boolean verifyZKACL(String id, String scheme, int perm, List<ACL> acls) {
        for (ACL acl : acls) {
            if (!acl.getId().getScheme().equals(scheme) || !acl.getId().getId().startsWith(id) || acl.getPerms() != perm) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testZKRootPathAcls() throws Exception {
        HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        String parentPath = "/rmstore";
        String rootPath = parentPath + "/" + "ZKRMStateRoot";
        Configuration conf = TestZKRMStateStore.createHARMConf("rm1,rm2", "rm1", 1234, false, this.curatorTestingServer);
        conf.set("yarn.resourcemanager.zk-acl", "world:anyone:rwca");
        int perm = 23;
        MockRM rm = new MockRM(conf);
        rm.start();
        rm.getRMContext().getRMAdminService().transitionToActive(req);
        ZKRMStateStore stateStore = (ZKRMStateStore)rm.getRMContext().getStateStore();
        List acls = stateStore.getACL(rootPath);
        Assertions.assertThat((List)acls).hasSize(2);
        TestZKRMStateStore.verifyZKACL("digest", "localhost", 12, acls);
        TestZKRMStateStore.verifyZKACL("world", "anyone", 19, acls);
        acls = stateStore.getACL(parentPath);
        Assertions.assertThat((List)acls).hasSize(1);
        Assert.assertEquals((long)perm, (long)((ACL)acls.get(0)).getPerms());
        rm.close();
        conf.setBoolean("yarn.resourcemanager.ha.enabled", false);
        conf.set("yarn.resourcemanager.zk-acl", "world:anyone:rwcda");
        rm = new MockRM(conf);
        rm.start();
        rm.getRMContext().getRMAdminService().transitionToActive(req);
        stateStore = (ZKRMStateStore)rm.getRMContext().getStateStore();
        acls = stateStore.getACL(rootPath);
        Assert.assertEquals((long)acls.size(), (long)1L);
        TestZKRMStateStore.verifyZKACL("world", "anyone", 31, acls);
        rm.close();
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        rm = new MockRM(conf);
        rm.start();
        rm.getRMContext().getRMAdminService().transitionToActive(req);
        stateStore = (ZKRMStateStore)rm.getRMContext().getStateStore();
        acls = stateStore.getACL(rootPath);
        Assertions.assertThat((List)acls).hasSize(2);
        TestZKRMStateStore.verifyZKACL("digest", "localhost", 12, acls);
        TestZKRMStateStore.verifyZKACL("world", "anyone", 19, acls);
        rm.close();
    }

    @Test
    public void testFencing() throws Exception {
        HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Configuration conf1 = TestZKRMStateStore.createHARMConf("rm1,rm2", "rm1", 1234, false, this.curatorTestingServer);
        MockRM rm1 = new MockRM(conf1);
        rm1.start();
        rm1.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm1.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Configuration conf2 = TestZKRMStateStore.createHARMConf("rm1,rm2", "rm2", 5678, false, this.curatorTestingServer);
        MockRM rm2 = new MockRM(conf2);
        rm2.start();
        rm2.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm2.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        for (int i = 0; i < 20; ++i) {
            if (HAServiceProtocol.HAServiceState.ACTIVE != rm1.getRMContext().getRMAdminService().getServiceStatus().getState()) continue;
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"RM should have been fenced", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        rm1.close();
        rm2.close();
    }

    @Test
    public void testFencedState() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        RMStateStore store = zkTester.getRMStateStore();
        store.updateFencedState();
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        long submitTime = System.currentTimeMillis();
        long startTime = submitTime + 1000L;
        RMApp mockApp = (RMApp)Mockito.mock(RMApp.class);
        ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
        context.setApplicationId((ApplicationId)Mockito.mock(ApplicationId.class));
        Mockito.when((Object)mockApp.getSubmitTime()).thenReturn((Object)submitTime);
        Mockito.when((Object)mockApp.getStartTime()).thenReturn((Object)startTime);
        Mockito.when((Object)mockApp.getApplicationSubmissionContext()).thenReturn((Object)context);
        Mockito.when((Object)mockApp.getUser()).thenReturn((Object)"test");
        store.storeNewApplication(mockApp);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        ClientToAMTokenSecretManagerInRM clientToAMTokenMgr = new ClientToAMTokenSecretManagerInRM();
        ApplicationAttemptId attemptId = ApplicationAttemptId.fromString((String)"appattempt_1234567894321_0001_000001");
        SecretKey clientTokenMasterKey = clientToAMTokenMgr.createMasterKey(attemptId);
        RMAppAttemptMetrics mockRmAppAttemptMetrics = (RMAppAttemptMetrics)Mockito.mock(RMAppAttemptMetrics.class);
        ContainerPBImpl container = new ContainerPBImpl();
        container.setId(ContainerId.fromString((String)"container_1234567891234_0001_01_000001"));
        RMAppAttempt mockAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)mockAttempt.getAppAttemptId()).thenReturn((Object)attemptId);
        Mockito.when((Object)mockAttempt.getMasterContainer()).thenReturn((Object)container);
        Mockito.when((Object)mockAttempt.getClientTokenMasterKey()).thenReturn((Object)clientTokenMasterKey);
        Mockito.when((Object)mockAttempt.getRMAppAttemptMetrics()).thenReturn((Object)mockRmAppAttemptMetrics);
        Mockito.when((Object)mockRmAppAttemptMetrics.getAggregateAppResourceUsage()).thenReturn((Object)new AggregateAppResourceUsage(new HashMap()));
        store.storeNewApplicationAttempt(mockAttempt);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        long finishTime = submitTime + 1000L;
        ApplicationAttemptStateData newAttemptState = ApplicationAttemptStateData.newInstance((ApplicationAttemptId)attemptId, (Container)container, (Credentials)store.getCredentialsFromAppAttempt(mockAttempt), (long)startTime, (RMAppAttemptState)RMAppAttemptState.FINISHED, (String)"testUrl", (String)"test", (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (int)100, (long)finishTime, new HashMap(), new HashMap(), (int)0);
        store.updateApplicationAttemptState(newAttemptState);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        ApplicationStateData appState = ApplicationStateData.newInstance((long)submitTime, (long)startTime, (ApplicationSubmissionContext)context, (String)"test");
        store.updateApplicationState(appState);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        store.removeApplication(mockApp);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        RMDelegationTokenIdentifier dtId1 = new RMDelegationTokenIdentifier(new Text("owner1"), new Text("renewer1"), new Text("realuser1"));
        Long renewDate1 = new Long(System.currentTimeMillis());
        dtId1.setSequenceNumber(1111);
        Assert.assertFalse((String)("Token " + dtId1 + " should not exist but was found in ZooKeeper"), (boolean)zkTester.delegationTokenExists(dtId1, 0));
        store.storeRMDelegationToken(dtId1, renewDate1);
        Assert.assertFalse((String)("Token " + dtId1 + " should not exist but was found in ZooKeeper"), (boolean)zkTester.delegationTokenExists(dtId1, 0));
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        store.updateRMDelegationToken(dtId1, renewDate1);
        Assert.assertFalse((String)("Token " + dtId1 + " should not exist but was found in ZooKeeper"), (boolean)zkTester.delegationTokenExists(dtId1, 0));
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        store.removeRMDelegationToken(dtId1);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        DelegationKey key = new DelegationKey(1234, 4321L, "keyBytes".getBytes());
        store.storeRMDTMasterKey(key);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        store.removeRMDTMasterKey(key);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        store.storeOrUpdateAMRMTokenSecretManager(null, false);
        Assert.assertEquals((String)"RMStateStore should have been in fenced state", (Object)true, (Object)store.isFencedState());
        store.close();
    }

    @Test
    public void testDuplicateRMAppDeletion() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        long submitTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis() + 1234L;
        RMStateStore store = zkTester.getRMStateStore();
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        ApplicationAttemptId attemptIdRemoved = ApplicationAttemptId.fromString((String)"appattempt_1352994193343_0002_000001");
        ApplicationId appIdRemoved = attemptIdRemoved.getApplicationId();
        this.storeApp(store, appIdRemoved, submitTime, startTime);
        this.storeAttempt(store, attemptIdRemoved, "container_1352994193343_0002_01_000001", null, null, dispatcher);
        ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
        context.setApplicationId(appIdRemoved);
        ApplicationStateData appStateRemoved = ApplicationStateData.newInstance((long)submitTime, (long)startTime, (ApplicationSubmissionContext)context, (String)"user1");
        appStateRemoved.attempts.put(attemptIdRemoved, null);
        store.removeApplicationStateInternal(appStateRemoved);
        try {
            store.removeApplicationStateInternal(appStateRemoved);
        }
        catch (KeeperException.NoNodeException nne) {
            Assert.fail((String)"NoNodeException should not happen.");
        }
        store.close();
    }

    private static String createPath(String ... parts) {
        return Joiner.on((String)"/").join((Object[])parts);
    }

    private static Configuration createConfForAppNodeSplit(int splitIndex) {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.zk-appid-node.split-index", splitIndex);
        return conf;
    }

    private static RMApp createMockAppForRemove(ApplicationId appId, ApplicationAttemptId ... attemptIds) {
        RMApp app = (RMApp)Mockito.mock(RMApp.class);
        ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
        context.setApplicationId(appId);
        Mockito.when((Object)app.getApplicationSubmissionContext()).thenReturn((Object)context);
        Mockito.when((Object)app.getUser()).thenReturn((Object)"test");
        if (attemptIds.length > 0) {
            HashMap<ApplicationAttemptId, RMAppAttempt> attempts = new HashMap<ApplicationAttemptId, RMAppAttempt>();
            for (ApplicationAttemptId attemptId : attemptIds) {
                RMAppAttempt appAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
                Mockito.when((Object)appAttempt.getAppAttemptId()).thenReturn((Object)attemptId);
                attempts.put(attemptId, appAttempt);
            }
            Mockito.when((Object)app.getAppAttempts()).thenReturn(attempts);
        }
        return app;
    }

    private static void verifyLoadedApp(ApplicationStateData appState, ApplicationId appId, String user, long submitTime, long startTime, RMAppState state, long finishTime, String diagnostics) {
        Assert.assertNotNull((String)("App " + appId + " should have been loaded."), (Object)appState);
        Assert.assertEquals((String)"App submit time in app state", (long)submitTime, (long)appState.getSubmitTime());
        Assert.assertEquals((String)"App start time in app state", (long)startTime, (long)appState.getStartTime());
        Assert.assertEquals((String)"App ID in app state", (Object)appId, (Object)appState.getApplicationSubmissionContext().getApplicationId());
        Assert.assertEquals((String)"App state", (Object)state, (Object)appState.getState());
        Assert.assertEquals((String)"Finish time in app state", (long)finishTime, (long)appState.getFinishTime());
        Assert.assertEquals((String)"User in app state", (Object)user, (Object)appState.getUser());
        Assert.assertEquals((String)"Diagnostics in app state", (Object)diagnostics, (Object)appState.getDiagnostics());
    }

    private static void verifyLoadedApp(RMStateStore.RMState rmState, ApplicationId appId, long submitTime, long startTime, long finishTime, boolean isFinished, List<ApplicationAttemptId> attempts) {
        TestZKRMStateStore.verifyLoadedApp(rmState, appId, submitTime, startTime, finishTime, isFinished, attempts, null, null);
    }

    private static void verifyLoadedApp(RMStateStore.RMState rmState, ApplicationId appId, long submitTime, long startTime, long finishTime, boolean isFinished, List<ApplicationAttemptId> attempts, List<Integer> amExitStatuses, List<FinalApplicationStatus> finalStatuses) {
        Map rmAppState = rmState.getApplicationState();
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(appId);
        Assert.assertNotNull((String)(appId + " is not there in loaded apps"), (Object)appState);
        TestZKRMStateStore.verifyLoadedApp(appState, appId, "test", submitTime, startTime, (RMAppState)(isFinished ? RMAppState.FINISHED : null), finishTime, isFinished ? "appDiagnostics" : "");
        if (attempts != null) {
            Assert.assertEquals((String)("Attempts loaded for app " + appId), (long)attempts.size(), (long)appState.attempts.size());
            if (finalStatuses != null && amExitStatuses != null) {
                for (int i = 0; i < attempts.size(); ++i) {
                    if (finalStatuses.get(i) != null) {
                        TestZKRMStateStore.verifyLoadedAttempt(appState, attempts.get(i), amExitStatuses.get(i), true);
                        continue;
                    }
                    TestZKRMStateStore.verifyLoadedAttempt(appState, attempts.get(i), amExitStatuses.get(i), false);
                }
            }
        } else {
            Assert.assertEquals((String)("Attempts loaded for app " + appId), (long)0L, (long)appState.attempts.size());
        }
    }

    private static void verifyLoadedAttempt(ApplicationStateData appState, ApplicationAttemptId attemptId, int amExitStatus, boolean isFinished) {
        TestZKRMStateStore.verifyLoadedAttempt(appState, attemptId, isFinished ? "myTrackingUrl" : "N/A", ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L), null, (RMAppAttemptState)(isFinished ? RMAppAttemptState.FINISHED : null), isFinished ? "attemptDiagnostics" : "", 0L, amExitStatus, (FinalApplicationStatus)(isFinished ? FinalApplicationStatus.SUCCEEDED : null));
    }

    private static void verifyLoadedAttempt(ApplicationStateData appState, ApplicationAttemptId attemptId, String trackingURL, ContainerId masterContainerId, SecretKey clientTokenKey, RMAppAttemptState state, String diagnostics, long finishTime, int amExitStatus, FinalApplicationStatus finalStatus) {
        ApplicationAttemptStateData attemptState = appState.getAttempt(attemptId);
        Assert.assertNotNull((String)("Attempt " + attemptId + " should have been loaded."), (Object)attemptState);
        Assert.assertEquals((String)"Attempt Id in attempt state", (Object)attemptId, (Object)attemptState.getAttemptId());
        Assert.assertEquals((String)"Master Container Id in attempt state", (Object)masterContainerId, (Object)attemptState.getMasterContainer().getId());
        if (null != clientTokenKey) {
            Assert.assertArrayEquals((String)"Client token key in attempt state", (byte[])clientTokenKey.getEncoded(), (byte[])attemptState.getAppAttemptTokens().getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME));
        }
        Assert.assertEquals((String)"Attempt state", (Object)state, (Object)attemptState.getState());
        Assert.assertEquals((String)"Finish time in attempt state", (long)finishTime, (long)attemptState.getFinishTime());
        Assert.assertEquals((String)"Diagnostics in attempt state", (Object)diagnostics, (Object)attemptState.getDiagnostics());
        Assert.assertEquals((String)"AM Container exit status in attempt state", (long)amExitStatus, (long)attemptState.getAMContainerExitStatus());
        Assert.assertEquals((String)"Final app status in attempt state", (Object)finalStatus, (Object)attemptState.getFinalApplicationStatus());
        Assert.assertEquals((String)"Tracking URL in attempt state", (Object)trackingURL, (Object)attemptState.getFinalTrackingUrl());
    }

    private static ApplicationStateData createAppState(ApplicationSubmissionContext ctxt, long submitTime, long startTime, long finishTime, boolean isFinished) {
        return ApplicationStateData.newInstance((long)submitTime, (long)startTime, (String)"test", (ApplicationSubmissionContext)ctxt, (RMAppState)(isFinished ? RMAppState.FINISHED : null), (String)(isFinished ? "appDiagnostics" : ""), (long)0L, (long)(isFinished ? finishTime : 0L), null);
    }

    private static ApplicationAttemptStateData createFinishedAttempt(ApplicationAttemptId attemptId, Container container, long startTime, int amExitStatus) {
        HashMap<String, Long> resourceSecondsMap = new HashMap<String, Long>();
        HashMap<String, Long> preemptedResoureSecondsMap = new HashMap<String, Long>();
        resourceSecondsMap.put(ResourceInformation.MEMORY_MB.getName(), 0L);
        resourceSecondsMap.put(ResourceInformation.VCORES.getName(), 0L);
        preemptedResoureSecondsMap.put(ResourceInformation.MEMORY_MB.getName(), 0L);
        preemptedResoureSecondsMap.put(ResourceInformation.VCORES.getName(), 0L);
        return ApplicationAttemptStateData.newInstance((ApplicationAttemptId)attemptId, (Container)container, null, (long)startTime, (RMAppAttemptState)RMAppAttemptState.FINISHED, (String)"myTrackingUrl", (String)"attemptDiagnostics", (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (int)amExitStatus, (long)0L, resourceSecondsMap, preemptedResoureSecondsMap, (int)0);
    }

    private ApplicationAttemptId storeAttempt(RMStateStore store, RMStateStoreTestBase.TestDispatcher dispatcher, String appAttemptIdStr, AMRMTokenSecretManager appTokenMgr, ClientToAMTokenSecretManagerInRM clientToAMTokenMgr, boolean createContainer) throws Exception {
        ApplicationAttemptId attemptId = ApplicationAttemptId.fromString((String)appAttemptIdStr);
        Token<AMRMTokenIdentifier> appAttemptToken = null;
        if (appTokenMgr != null) {
            appAttemptToken = this.generateAMRMToken(attemptId, appTokenMgr);
        }
        SecretKey clientTokenKey = null;
        if (clientToAMTokenMgr != null) {
            clientTokenKey = clientToAMTokenMgr.createMasterKey(attemptId);
            Credentials attemptCred = new Credentials();
            attemptCred.addSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME, clientTokenKey.getEncoded());
        }
        ContainerId containerId = null;
        if (createContainer) {
            containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        }
        this.storeAttempt(store, attemptId, containerId.toString(), appAttemptToken, clientTokenKey, dispatcher);
        return attemptId;
    }

    private void finishAppWithAttempts(RMStateStore.RMState state, RMStateStore store, RMStateStoreTestBase.TestDispatcher dispatcher, ApplicationAttemptId attemptId, long submitTime, long startTime, int amExitStatus, long finishTime, boolean createNewApp) throws Exception {
        ApplicationId appId = attemptId.getApplicationId();
        ApplicationStateData appStateNew = null;
        if (createNewApp) {
            ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
            context.setApplicationId(appId);
            context.setAMContainerSpec((ContainerLaunchContext)new ContainerLaunchContextPBImpl());
            appStateNew = TestZKRMStateStore.createAppState((ApplicationSubmissionContext)context, submitTime, startTime, finishTime, true);
        } else {
            ApplicationStateData appState = (ApplicationStateData)state.getApplicationState().get(appId);
            appStateNew = TestZKRMStateStore.createAppState(appState.getApplicationSubmissionContext(), submitTime, startTime, finishTime, true);
            appStateNew.attempts.putAll(appState.attempts);
        }
        store.updateApplicationState(appStateNew);
        dispatcher.waitNotify(appId);
        ContainerPBImpl container = new ContainerPBImpl();
        container.setId(ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L));
        ApplicationAttemptStateData newAttemptState = TestZKRMStateStore.createFinishedAttempt(attemptId, (Container)container, startTime, amExitStatus);
        this.updateAttempt(store, dispatcher, newAttemptState);
    }

    private void storeAppWithAttempts(RMStateStore store, RMStateStoreTestBase.TestDispatcher dispatcher, ApplicationAttemptId attemptId, long submitTime, long startTime) throws Exception {
        this.storeAppWithAttempts(store, dispatcher, submitTime, startTime, null, null, attemptId, new ApplicationAttemptId[0]);
    }

    private void storeApp(RMStateStore store, RMStateStoreTestBase.TestDispatcher dispatcher, ApplicationId appId, long submitTime, long startTime) throws Exception {
        this.storeApp(store, appId, submitTime, startTime);
        dispatcher.waitNotify(appId);
    }

    private void storeAppWithAttempts(RMStateStore store, RMStateStoreTestBase.TestDispatcher dispatcher, long submitTime, long startTime, AMRMTokenSecretManager appTokenMgr, ClientToAMTokenSecretManagerInRM clientToAMTokenMgr, ApplicationAttemptId attemptId, ApplicationAttemptId ... attemptIds) throws Exception {
        ApplicationId appId = attemptId.getApplicationId();
        this.storeApp(store, dispatcher, appId, submitTime, startTime);
        this.storeAttempt(store, dispatcher, attemptId.toString(), appTokenMgr, clientToAMTokenMgr, true);
        for (ApplicationAttemptId attempt : attemptIds) {
            this.storeAttempt(store, dispatcher, attempt.toString(), appTokenMgr, clientToAMTokenMgr, true);
        }
    }

    private static void removeApps(RMStateStore store, Map<ApplicationId, ApplicationAttemptId[]> appWithAttempts) {
        for (Map.Entry<ApplicationId, ApplicationAttemptId[]> entry : appWithAttempts.entrySet()) {
            RMApp mockApp = TestZKRMStateStore.createMockAppForRemove(entry.getKey(), entry.getValue());
            store.removeApplication(mockApp);
        }
    }

    private static void verifyAppPathPath(RMStateStore store, ApplicationId appId, int splitIndex) throws Exception {
        String appIdStr = appId.toString();
        String appParent = appIdStr.substring(0, appIdStr.length() - splitIndex);
        String appPath = appIdStr.substring(appIdStr.length() - splitIndex);
        String path = TestZKRMStateStore.createPath(((ZKRMStateStore)store).znodeWorkingPath, "ZKRMStateRoot", "RMAppRoot", "HIERARCHIES", String.valueOf(splitIndex), appParent, appPath);
        Assert.assertTrue((String)("Application with id " + appIdStr + " does not exist as per split in state store."), (boolean)((ZKRMStateStore)store).exists(path));
    }

    private static void verifyAppInHierarchicalPath(RMStateStore store, String appId, int splitIdx) throws Exception {
        String path = TestZKRMStateStore.createPath(((ZKRMStateStore)store).znodeWorkingPath, "ZKRMStateRoot", "RMAppRoot");
        path = splitIdx != 0 ? TestZKRMStateStore.createPath(path, "HIERARCHIES", String.valueOf(splitIdx), appId.substring(0, appId.length() - splitIdx), appId.substring(appId.length() - splitIdx)) : TestZKRMStateStore.createPath(path, appId);
        Assert.assertTrue((String)(appId + " should exist in path " + path), (boolean)((ZKRMStateStore)store).exists(TestZKRMStateStore.createPath(path)));
    }

    private static void assertHierarchicalPaths(RMStateStore store, Map<Integer, Integer> pathToApps) throws Exception {
        for (Map.Entry<Integer, Integer> entry : pathToApps.entrySet()) {
            String path = TestZKRMStateStore.createPath(((ZKRMStateStore)store).znodeWorkingPath, "ZKRMStateRoot", "RMAppRoot");
            if (entry.getKey() != 0) {
                path = TestZKRMStateStore.createPath(path, "HIERARCHIES", String.valueOf(entry.getKey()));
            }
            Assert.assertEquals((String)("Number of childrens for path " + path), (long)entry.getValue().intValue(), (long)((ZKRMStateStore)store).getChildren(path).size());
        }
    }

    @Test
    public void testAppNodeSplit() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        long submitTime = System.currentTimeMillis();
        long startTime = submitTime + 1234L;
        YarnConfiguration conf = new YarnConfiguration();
        RMStateStore store = zkTester.getRMStateStore(TestZKRMStateStore.createConfForAppNodeSplit(1));
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)store);
        AMRMTokenSecretManager appTokenMgr = (AMRMTokenSecretManager)Mockito.spy((Object)new AMRMTokenSecretManager((Configuration)conf, rmContext));
        MasterKeyData masterKeyData = appTokenMgr.createNewMasterKey();
        Mockito.when((Object)appTokenMgr.getMasterKey()).thenReturn((Object)masterKeyData);
        ClientToAMTokenSecretManagerInRM clientToAMTokenMgr = new ClientToAMTokenSecretManagerInRM();
        ApplicationId appId1 = ApplicationId.newInstance((long)1352994193343L, (int)1);
        ApplicationAttemptId attemptId1 = ApplicationAttemptId.newInstance((ApplicationId)appId1, (int)1);
        ApplicationAttemptId attemptId2 = ApplicationAttemptId.newInstance((ApplicationId)appId1, (int)2);
        this.storeAppWithAttempts(store, dispatcher, submitTime, startTime, appTokenMgr, clientToAMTokenMgr, attemptId1, attemptId2);
        ApplicationId appId21 = ApplicationId.newInstance((long)1352994193343L, (int)120213);
        this.storeApp(store, appId21, submitTime, startTime);
        dispatcher.waitNotify(appId21);
        ApplicationId appIdRemoved = ApplicationId.newInstance((long)1352994193343L, (int)2);
        ApplicationAttemptId attemptIdRemoved = ApplicationAttemptId.newInstance((ApplicationId)appIdRemoved, (int)1);
        this.storeAppWithAttempts(store, dispatcher, submitTime, startTime, null, null, attemptIdRemoved, new ApplicationAttemptId[0]);
        RMApp mockRemovedApp = TestZKRMStateStore.createMockAppForRemove(appIdRemoved, attemptIdRemoved);
        store.removeApplication(mockRemovedApp);
        store.close();
        store = zkTester.getRMStateStore(TestZKRMStateStore.createConfForAppNodeSplit(1));
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMStateStore.RMState state = store.loadState();
        TestZKRMStateStore.verifyAppPathPath(store, appId21, 1);
        TestZKRMStateStore.verifyLoadedApp(state, appId1, submitTime, startTime, 0L, false, Lists.newArrayList((Object[])new ApplicationAttemptId[]{attemptId1, attemptId2}), Lists.newArrayList((Object[])new Integer[]{-1000, -1000}), Lists.newArrayList((Object[])new FinalApplicationStatus[]{null, null}));
        this.finishAppWithAttempts(state, store, dispatcher, attemptId2, submitTime, startTime, 100, 1234L, false);
        ApplicationId dummyAppId = ApplicationId.newInstance((long)1234L, (int)10);
        ApplicationAttemptId dummyAttemptId = ApplicationAttemptId.newInstance((ApplicationId)dummyAppId, (int)6);
        this.finishAppWithAttempts(state, store, dispatcher, dummyAttemptId, submitTime, startTime, 111, 1234L, true);
        store.close();
        store = zkTester.getRMStateStore(TestZKRMStateStore.createConfForAppNodeSplit(1));
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMStateStore.RMState newRMState = store.loadState();
        TestZKRMStateStore.verifyLoadedApp(newRMState, dummyAppId, submitTime, startTime, 1234L, true, Lists.newArrayList((Object[])new ApplicationAttemptId[]{dummyAttemptId}), Lists.newArrayList((Object[])new Integer[]{111}), Lists.newArrayList((Object[])new FinalApplicationStatus[]{FinalApplicationStatus.SUCCEEDED}));
        TestZKRMStateStore.verifyLoadedApp(newRMState, appId1, submitTime, startTime, 1234L, true, Lists.newArrayList((Object[])new ApplicationAttemptId[]{attemptId1, attemptId2}), Lists.newArrayList((Object[])new Integer[]{-1000, 100}), Lists.newArrayList((Object[])new FinalApplicationStatus[]{null, FinalApplicationStatus.SUCCEEDED}));
        Assert.assertTrue((String)"Store is not in expected state", (boolean)zkTester.isFinalStateValid());
        store.close();
    }

    @Test
    public void testAppNodeSplitChangeAcrossRestarts() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        long submitTime = System.currentTimeMillis();
        long startTime = submitTime + 1234L;
        YarnConfiguration conf = new YarnConfiguration();
        RMStateStore store = zkTester.getRMStateStore(TestZKRMStateStore.createConfForAppNodeSplit(1));
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)store);
        AMRMTokenSecretManager appTokenMgr = (AMRMTokenSecretManager)Mockito.spy((Object)new AMRMTokenSecretManager((Configuration)conf, rmContext));
        MasterKeyData masterKeyData = appTokenMgr.createNewMasterKey();
        Mockito.when((Object)appTokenMgr.getMasterKey()).thenReturn((Object)masterKeyData);
        ClientToAMTokenSecretManagerInRM clientToAMTokenMgr = new ClientToAMTokenSecretManagerInRM();
        ApplicationId appId1 = ApplicationId.newInstance((long)1442994194053L, (int)1);
        ApplicationAttemptId attemptId1 = ApplicationAttemptId.newInstance((ApplicationId)appId1, (int)1);
        ApplicationAttemptId attemptId2 = ApplicationAttemptId.newInstance((ApplicationId)appId1, (int)2);
        this.storeAppWithAttempts(store, dispatcher, submitTime, startTime, appTokenMgr, clientToAMTokenMgr, attemptId1, attemptId2);
        ApplicationId appId11 = ApplicationId.newInstance((long)1442994194053L, (int)2);
        ApplicationAttemptId attemptId11 = ApplicationAttemptId.newInstance((ApplicationId)appId11, (int)1);
        this.storeAppWithAttempts(store, dispatcher, attemptId11, submitTime, startTime);
        store.close();
        store = zkTester.getRMStateStore(TestZKRMStateStore.createConfForAppNodeSplit(2));
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMStateStore.RMState state = store.loadState();
        ApplicationId appId21 = ApplicationId.newInstance((long)1442994194053L, (int)120213);
        this.storeApp(store, dispatcher, appId21, submitTime, startTime);
        TestZKRMStateStore.verifyLoadedApp(state, appId1, submitTime, startTime, 0L, false, Lists.newArrayList((Object[])new ApplicationAttemptId[]{attemptId1, attemptId2}), Lists.newArrayList((Object[])new Integer[]{-1000, -1000}), Lists.newArrayList((Object[])new FinalApplicationStatus[]{null, null}));
        this.finishAppWithAttempts(state, store, dispatcher, attemptId2, submitTime, startTime, 100, 1234L, false);
        ApplicationId dummyAppId = ApplicationId.newInstance((long)1234L, (int)10);
        ApplicationAttemptId dummyAttemptId = ApplicationAttemptId.newInstance((ApplicationId)dummyAppId, (int)6);
        this.finishAppWithAttempts(state, store, dispatcher, dummyAttemptId, submitTime, startTime, 111, 1234L, true);
        store.close();
        store = zkTester.getRMStateStore(TestZKRMStateStore.createConfForAppNodeSplit(0));
        store.setRMDispatcher((Dispatcher)dispatcher);
        state = store.loadState();
        Assert.assertEquals((String)"Number of Apps loaded should be 4.", (long)4L, (long)state.getApplicationState().size());
        TestZKRMStateStore.verifyLoadedApp(state, appId1, submitTime, startTime, 1234L, true, Lists.newArrayList((Object[])new ApplicationAttemptId[]{attemptId1, attemptId2}), Lists.newArrayList((Object[])new Integer[]{-1000, 100}), Lists.newArrayList((Object[])new FinalApplicationStatus[]{null, FinalApplicationStatus.SUCCEEDED}));
        store.removeApplicationAttempt(attemptId1);
        ApplicationId appId31 = ApplicationId.newInstance((long)1442994195071L, (int)45);
        this.storeApp(store, dispatcher, appId31, submitTime, startTime);
        store.close();
        store = zkTester.getRMStateStore(TestZKRMStateStore.createConfForAppNodeSplit(3));
        store.setRMDispatcher((Dispatcher)dispatcher);
        state = store.loadState();
        Assert.assertEquals((String)"Number of apps loaded should be 5.", (long)5L, (long)state.getApplicationState().size());
        TestZKRMStateStore.verifyLoadedApp(state, dummyAppId, submitTime, startTime, 1234L, true, Lists.newArrayList((Object[])new ApplicationAttemptId[]{dummyAttemptId}), Lists.newArrayList((Object[])new Integer[]{111}), Lists.newArrayList((Object[])new FinalApplicationStatus[]{FinalApplicationStatus.SUCCEEDED}));
        TestZKRMStateStore.verifyLoadedApp(state, appId31, submitTime, startTime, 0L, false, null);
        TestZKRMStateStore.verifyLoadedApp(state, appId21, submitTime, startTime, 0L, false, null);
        TestZKRMStateStore.verifyLoadedApp(state, appId11, submitTime, startTime, 0L, false, Lists.newArrayList((Object[])new ApplicationAttemptId[]{attemptId11}), Lists.newArrayList((Object[])new Integer[]{-1000}), Lists.newArrayList((Object[])new FinalApplicationStatus[]{null}));
        TestZKRMStateStore.verifyLoadedApp(state, appId1, submitTime, startTime, 1234L, true, Lists.newArrayList((Object[])new ApplicationAttemptId[]{attemptId2}), Lists.newArrayList((Object[])new Integer[]{100}), Lists.newArrayList((Object[])new FinalApplicationStatus[]{FinalApplicationStatus.SUCCEEDED}));
        ApplicationId appId41 = ApplicationId.newInstance((long)1442994195087L, (int)1);
        this.storeApp(store, dispatcher, appId41, submitTime, startTime);
        TestZKRMStateStore.assertHierarchicalPaths(store, (Map<Integer, Integer>)ImmutableMap.of((Object)0, (Object)2, (Object)1, (Object)1, (Object)2, (Object)2, (Object)3, (Object)1, (Object)4, (Object)0));
        TestZKRMStateStore.verifyAppInHierarchicalPath(store, "application_1442994195087_0001", 3);
        ApplicationId appId71 = ApplicationId.newInstance((long)1442994195087L, (int)7);
        this.storeApp(store, appId71, submitTime, startTime);
        dispatcher.waitNotify(appId71);
        ApplicationAttemptId attemptId71 = ApplicationAttemptId.newInstance((ApplicationId)appId71, (int)1);
        this.storeAttempt(store, ApplicationAttemptId.newInstance((ApplicationId)appId71, (int)1), ContainerId.newContainerId((ApplicationAttemptId)attemptId71, (long)1L).toString(), null, null, dispatcher);
        TestZKRMStateStore.removeApps(store, (Map<ApplicationId, ApplicationAttemptId[]>)ImmutableMap.of((Object)appId11, (Object)new ApplicationAttemptId[]{attemptId11}, (Object)appId71, (Object)new ApplicationAttemptId[]{attemptId71}, (Object)appId41, (Object)new ApplicationAttemptId[0], (Object)appId31, (Object)new ApplicationAttemptId[0], (Object)appId21, (Object)new ApplicationAttemptId[0]));
        TestZKRMStateStore.removeApps(store, (Map<ApplicationId, ApplicationAttemptId[]>)ImmutableMap.of((Object)dummyAppId, (Object)new ApplicationAttemptId[]{dummyAttemptId}, (Object)appId1, (Object)new ApplicationAttemptId[]{attemptId1, attemptId2}));
        store.close();
        store = zkTester.getRMStateStore(TestZKRMStateStore.createConfForAppNodeSplit(3));
        store.setRMDispatcher((Dispatcher)dispatcher);
        state = store.loadState();
        Assert.assertEquals((String)"Number of apps loaded should be 0.", (long)0L, (long)state.getApplicationState().size());
        store.close();
    }

    private static Configuration createConfForDelegationTokenNodeSplit(int splitIndex) {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.zk-delegation-token-node.split-index", splitIndex);
        return conf;
    }

    private void verifyDelegationTokensStateStore(TestZKRMStateStoreTester zkTester, Map<RMDelegationTokenIdentifier, Long> tokensWithRenewal, Map<RMDelegationTokenIdentifier, Integer> tokensWithIndex, int sequenceNumber) throws Exception {
        RMStateStore.RMDTSecretManagerState secretManagerState = zkTester.store.loadState().getRMDTSecretManagerState();
        Assert.assertEquals((String)"Unexpected token state", tokensWithRenewal, (Object)secretManagerState.getTokenState());
        Assert.assertEquals((String)"Unexpected sequence number", (long)sequenceNumber, (long)secretManagerState.getDTSequenceNumber());
        for (Map.Entry<RMDelegationTokenIdentifier, Integer> tokenEntry : tokensWithIndex.entrySet()) {
            Assert.assertTrue((String)("Expected to find token " + tokenEntry.getKey() + " in zookeeper but did not"), (boolean)zkTester.delegationTokenExists(tokenEntry.getKey(), tokenEntry.getValue()));
        }
    }

    private void verifyDelegationTokenInStateStore(TestZKRMStateStoreTester zkTester, RMDelegationTokenIdentifier token, long renewDate, int index) throws Exception {
        RMStateStore.RMDTSecretManagerState secretManagerState = zkTester.store.loadState().getRMDTSecretManagerState();
        Map tokenState = secretManagerState.getTokenState();
        Assert.assertTrue((String)("token state does not contain " + token), (boolean)tokenState.containsKey(token));
        Assert.assertTrue((String)("token state does not contain a token with renewal " + renewDate), (boolean)tokenState.containsValue(renewDate));
        Assert.assertTrue((String)("Token " + token + "should exist but was not found in ZooKeeper"), (boolean)zkTester.delegationTokenExists(token, index));
    }

    private RMDelegationTokenIdentifier storeUpdateAndVerifyDelegationToken(TestZKRMStateStoreTester zkTester, Map<RMDelegationTokenIdentifier, Long> tokensWithRenewal, Map<RMDelegationTokenIdentifier, Integer> tokensWithIndex, int sequenceNumber, int split) throws Exception {
        RMDelegationTokenIdentifier token = new RMDelegationTokenIdentifier(new Text("owner"), new Text("renewer"), new Text("realuser"));
        Assert.assertFalse((String)"Token should not exist but was found in ZooKeeper", (boolean)zkTester.delegationTokenExists(token, split));
        token.setSequenceNumber(sequenceNumber);
        Long renewDate = System.currentTimeMillis();
        zkTester.store.storeRMDelegationToken(token, renewDate);
        this.modifyRMDelegationTokenState();
        tokensWithRenewal.put(token, renewDate);
        tokensWithIndex.put(token, split);
        this.verifyDelegationTokensStateStore(zkTester, tokensWithRenewal, tokensWithIndex, sequenceNumber);
        renewDate = System.currentTimeMillis();
        zkTester.store.updateRMDelegationToken(token, renewDate);
        tokensWithRenewal.put(token, renewDate);
        tokensWithIndex.put(token, split);
        this.verifyDelegationTokensStateStore(zkTester, tokensWithRenewal, tokensWithIndex, sequenceNumber);
        return token;
    }

    @Test
    public void testDelegationTokenSplitIndexConfig() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        zkTester.getRMStateStore(TestZKRMStateStore.createConfForDelegationTokenNodeSplit(0)).close();
        Assert.assertEquals((String)"Incorrect split index", (long)0L, (long)zkTester.getDelegationTokenNodeSplitIndex());
        zkTester.getRMStateStore(TestZKRMStateStore.createConfForDelegationTokenNodeSplit(1)).close();
        Assert.assertEquals((String)"Incorrect split index", (long)1L, (long)zkTester.getDelegationTokenNodeSplitIndex());
        zkTester.getRMStateStore(TestZKRMStateStore.createConfForDelegationTokenNodeSplit(2)).close();
        Assert.assertEquals((String)"Incorrect split index", (long)2L, (long)zkTester.getDelegationTokenNodeSplitIndex());
        zkTester.getRMStateStore(TestZKRMStateStore.createConfForDelegationTokenNodeSplit(3)).close();
        Assert.assertEquals((String)"Incorrect split index", (long)3L, (long)zkTester.getDelegationTokenNodeSplitIndex());
        zkTester.getRMStateStore(TestZKRMStateStore.createConfForDelegationTokenNodeSplit(4)).close();
        Assert.assertEquals((String)"Incorrect split index", (long)4L, (long)zkTester.getDelegationTokenNodeSplitIndex());
        zkTester.getRMStateStore(TestZKRMStateStore.createConfForDelegationTokenNodeSplit(-1)).close();
        Assert.assertEquals((String)"Incorrect split index", (long)0L, (long)zkTester.getDelegationTokenNodeSplitIndex());
        zkTester.getRMStateStore(TestZKRMStateStore.createConfForDelegationTokenNodeSplit(5)).close();
        Assert.assertEquals((String)"Incorrect split index", (long)0L, (long)zkTester.getDelegationTokenNodeSplitIndex());
    }

    @Test
    public void testDelegationTokenNodeNoSplit() throws Exception {
        this.testDelegationTokenNode(0);
    }

    @Test
    public void testDelegationTokenNodeWithSplitOne() throws Exception {
        this.testDelegationTokenNode(1);
    }

    @Test
    public void testDelegationTokenNodeWithSplitTwo() throws Exception {
        this.testDelegationTokenNode(2);
    }

    @Test
    public void testDelegationTokenNodeWithSplitThree() throws Exception {
        this.testDelegationTokenNode(3);
    }

    @Test
    public void testDelegationTokenNodeWithSplitFour() throws Exception {
        this.testDelegationTokenNode(4);
    }

    public void testDelegationTokenNode(int split) throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        Configuration conf = TestZKRMStateStore.createConfForDelegationTokenNodeSplit(split);
        RMStateStore store = zkTester.getRMStateStore(conf);
        HashMap<RMDelegationTokenIdentifier, Long> tokensWithRenewal = new HashMap<RMDelegationTokenIdentifier, Long>();
        HashMap<RMDelegationTokenIdentifier, Integer> tokensWithIndex = new HashMap<RMDelegationTokenIdentifier, Integer>();
        int sequenceNumber = 0;
        RMDelegationTokenIdentifier token = this.storeUpdateAndVerifyDelegationToken(zkTester, tokensWithRenewal, tokensWithIndex, sequenceNumber, split);
        store.removeRMDelegationToken(token);
        RMStateStore.RMDTSecretManagerState state = store.loadState().getRMDTSecretManagerState();
        tokensWithRenewal.clear();
        tokensWithIndex.clear();
        Assert.assertEquals((String)"Unexpected token state", tokensWithRenewal, (Object)state.getTokenState());
        Assert.assertEquals((String)"Unexpected sequence number", (long)sequenceNumber, (long)state.getDTSequenceNumber());
        Assert.assertFalse((String)"Token should not exist but was found in ZooKeeper", (boolean)zkTester.delegationTokenExists(token, split));
        store.close();
    }

    @Test
    public void testDelegationTokenNodeWithSplitMultiple() throws Exception {
        Long renewDate;
        RMDelegationTokenIdentifier token2;
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        Configuration conf = TestZKRMStateStore.createConfForDelegationTokenNodeSplit(1);
        RMStateStore store = zkTester.getRMStateStore(conf);
        HashMap<RMDelegationTokenIdentifier, Long> tokensWithRenewal = new HashMap<RMDelegationTokenIdentifier, Long>();
        HashMap<RMDelegationTokenIdentifier, Integer> tokensWithIndex = new HashMap<RMDelegationTokenIdentifier, Integer>();
        HashSet<RMDelegationTokenIdentifier> tokensToDelete = new HashSet<RMDelegationTokenIdentifier>();
        int sequenceNumber = 0;
        block3: for (int i = 0; i <= 12; ++i) {
            token2 = new RMDelegationTokenIdentifier(new Text("owner" + i), new Text("renewer" + i), new Text("realuser" + i));
            sequenceNumber = i;
            token2.setSequenceNumber(sequenceNumber);
            Assert.assertFalse((String)"Token should not exist but was found in ZooKeeper", (boolean)zkTester.delegationTokenExists(token2, 1));
            renewDate = System.currentTimeMillis();
            store.storeRMDelegationToken(token2, renewDate);
            this.modifyRMDelegationTokenState();
            tokensWithRenewal.put(token2, renewDate);
            tokensWithIndex.put(token2, 1);
            switch (i) {
                case 0: 
                case 3: 
                case 6: 
                case 11: {
                    tokensToDelete.add(token2);
                    continue block3;
                }
            }
        }
        this.verifyDelegationTokensStateStore(zkTester, tokensWithRenewal, tokensWithIndex, sequenceNumber);
        for (RMDelegationTokenIdentifier tokenToDelete : tokensToDelete) {
            store.removeRMDelegationToken(tokenToDelete);
            tokensWithRenewal.remove(tokenToDelete);
            tokensWithIndex.remove(tokenToDelete);
        }
        int i = 13;
        while (i <= 22) {
            token2 = new RMDelegationTokenIdentifier(new Text("owner" + i), new Text("renewer" + i), new Text("realuser" + i));
            sequenceNumber = i++;
            token2.setSequenceNumber(sequenceNumber);
            renewDate = System.currentTimeMillis();
            store.storeRMDelegationToken(token2, renewDate);
            this.modifyRMDelegationTokenState();
            tokensWithRenewal.put(token2, renewDate);
            tokensWithIndex.put(token2, 1);
        }
        this.verifyDelegationTokensStateStore(zkTester, tokensWithRenewal, tokensWithIndex, sequenceNumber);
        for (RMDelegationTokenIdentifier token2 : tokensToDelete) {
            Assert.assertFalse((String)("Token " + token2 + " should not exist but was found in ZooKeeper"), (boolean)zkTester.delegationTokenExists(token2, 1));
        }
        store.close();
    }

    @Test
    public void testDelegationTokenNodeWithSplitChangeAcrossRestarts() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        HashMap<RMDelegationTokenIdentifier, Long> tokensWithRenewal = new HashMap<RMDelegationTokenIdentifier, Long>();
        HashMap<RMDelegationTokenIdentifier, Integer> tokensWithIndex = new HashMap<RMDelegationTokenIdentifier, Integer>();
        int sequenceNumber = 0;
        Configuration conf = TestZKRMStateStore.createConfForDelegationTokenNodeSplit(1);
        RMStateStore store = zkTester.getRMStateStore(conf);
        RMDelegationTokenIdentifier token1 = this.storeUpdateAndVerifyDelegationToken(zkTester, tokensWithRenewal, tokensWithIndex, sequenceNumber, 1);
        store.close();
        conf = TestZKRMStateStore.createConfForDelegationTokenNodeSplit(2);
        store = zkTester.getRMStateStore(conf);
        this.verifyDelegationTokenInStateStore(zkTester, token1, (Long)tokensWithRenewal.get(token1), 1);
        RMDelegationTokenIdentifier token2 = this.storeUpdateAndVerifyDelegationToken(zkTester, tokensWithRenewal, tokensWithIndex, ++sequenceNumber, 2);
        long renewDate1 = System.currentTimeMillis();
        zkTester.store.updateRMDelegationToken(token1, renewDate1);
        tokensWithRenewal.put(token1, renewDate1);
        this.verifyDelegationTokenInStateStore(zkTester, token1, (Long)tokensWithRenewal.get(token1), 1);
        store.close();
        conf = TestZKRMStateStore.createConfForDelegationTokenNodeSplit(0);
        store = zkTester.getRMStateStore(conf);
        this.verifyDelegationTokenInStateStore(zkTester, token1, (Long)tokensWithRenewal.get(token1), 1);
        this.verifyDelegationTokenInStateStore(zkTester, token2, (Long)tokensWithRenewal.get(token2), 2);
        RMDelegationTokenIdentifier token0 = this.storeUpdateAndVerifyDelegationToken(zkTester, tokensWithRenewal, tokensWithIndex, ++sequenceNumber, 0);
        store.close();
        conf = TestZKRMStateStore.createConfForDelegationTokenNodeSplit(3);
        store = zkTester.getRMStateStore(conf);
        this.verifyDelegationTokenInStateStore(zkTester, token1, (Long)tokensWithRenewal.get(token1), 1);
        this.verifyDelegationTokenInStateStore(zkTester, token2, (Long)tokensWithRenewal.get(token2), 2);
        this.verifyDelegationTokenInStateStore(zkTester, token0, (Long)tokensWithRenewal.get(token0), 0);
        for (RMDelegationTokenIdentifier token : tokensWithRenewal.keySet()) {
            store.removeRMDelegationToken(token);
        }
        tokensWithRenewal.clear();
        tokensWithIndex.clear();
        this.verifyDelegationTokensStateStore(zkTester, tokensWithRenewal, tokensWithIndex, sequenceNumber);
        Assert.assertFalse((String)("Token " + token1 + " should not exist but was found in ZooKeeper"), (boolean)zkTester.delegationTokenExists(token1, 1));
        Assert.assertFalse((String)("Token " + token1 + " should not exist but was found in ZooKeeper"), (boolean)zkTester.delegationTokenExists(token2, 2));
        Assert.assertFalse((String)("Token " + token1 + " should not exist but was found in ZooKeeper"), (boolean)zkTester.delegationTokenExists(token0, 0));
        this.storeUpdateAndVerifyDelegationToken(zkTester, tokensWithRenewal, tokensWithIndex, ++sequenceNumber, 3);
        store.close();
    }

    @Test
    public void testAppSubmissionContextIsPrunedInFinalApplicationState() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        ApplicationId appId = ApplicationId.fromString((String)"application_1234_0010");
        Configuration conf = TestZKRMStateStore.createConfForDelegationTokenNodeSplit(1);
        RMStateStore store = zkTester.getRMStateStore(conf);
        ApplicationSubmissionContextPBImpl ctx = new ApplicationSubmissionContextPBImpl();
        ctx.setApplicationId(appId);
        ctx.setQueue("a_queue");
        ContainerLaunchContextPBImpl containerLaunchCtx = new ContainerLaunchContextPBImpl();
        containerLaunchCtx.setCommands(Collections.singletonList("a_command"));
        ctx.setAMContainerSpec((ContainerLaunchContext)containerLaunchCtx);
        ResourcePBImpl resource = new ResourcePBImpl();
        resource.setMemorySize(17L);
        ctx.setResource((Resource)resource);
        Map<String, String> schedulingPropertiesMap = Collections.singletonMap("a_key", "a_value");
        ctx.setApplicationSchedulingPropertiesMap(schedulingPropertiesMap);
        ApplicationStateDataPBImpl appState = new ApplicationStateDataPBImpl();
        appState.setState(RMAppState.RUNNING);
        appState.setApplicationSubmissionContext((ApplicationSubmissionContext)ctx);
        store.storeApplicationStateInternal(appId, (ApplicationStateData)appState);
        RMStateStore.RMState rmState = store.loadState();
        Assert.assertEquals((long)1L, (long)rmState.getApplicationState().size());
        ctx = ((ApplicationStateData)rmState.getApplicationState().get(appId)).getApplicationSubmissionContext();
        appState.setState(RMAppState.RUNNING);
        store.handleStoreEvent((RMStateStoreEvent)new RMStateUpdateAppEvent((ApplicationStateData)appState, false, null));
        rmState = store.loadState();
        ctx = ((ApplicationStateData)rmState.getApplicationState().get(appId)).getApplicationSubmissionContext();
        Assert.assertEquals((String)"ApplicationSchedulingPropertiesMap should not have been pruned from the application submission context before the FINISHED state", schedulingPropertiesMap, (Object)ctx.getApplicationSchedulingPropertiesMap());
        appState.setState(RMAppState.FINISHED);
        store.handleStoreEvent((RMStateStoreEvent)new RMStateUpdateAppEvent((ApplicationStateData)appState, false, null));
        rmState = store.loadState();
        ctx = ((ApplicationStateData)rmState.getApplicationState().get(appId)).getApplicationSubmissionContext();
        Assert.assertEquals((Object)appId, (Object)ctx.getApplicationId());
        Assert.assertEquals((Object)"a_queue", (Object)ctx.getQueue());
        Assert.assertNotNull((Object)ctx.getAMContainerSpec());
        Assert.assertEquals((long)17L, (long)ctx.getResource().getMemorySize());
        Assert.assertEquals((String)"ApplicationSchedulingPropertiesMap should have been pruned from the application submission context when in FINISHED STATE", Collections.emptyMap(), (Object)ctx.getApplicationSchedulingPropertiesMap());
        store.close();
    }

    @Test
    public void testMetricsInited() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        Configuration conf = TestZKRMStateStore.createConfForDelegationTokenNodeSplit(1);
        MetricsCollectorImpl collector = new MetricsCollectorImpl();
        ZKRMStateStoreOpDurations opDurations = ((ZKRMStateStore)zkTester.getRMStateStore((Configuration)conf)).opDurations;
        long anyDuration = 10L;
        opDurations.addLoadStateCallDuration(anyDuration);
        opDurations.addStoreApplicationStateCallDuration(anyDuration);
        opDurations.addUpdateApplicationStateCallDuration(anyDuration);
        opDurations.addRemoveApplicationStateCallDuration(anyDuration);
        Thread.sleep(110L);
        opDurations.getMetrics((MetricsCollector)collector, true);
        Assert.assertEquals((String)"Incorrect number of perf metrics", (long)1L, (long)collector.getRecords().size());
        MetricsRecord record = (MetricsRecord)collector.getRecords().get(0);
        MetricsRecords.assertTag((MetricsRecord)record, (String)ZKRMStateStoreOpDurations.RECORD_INFO.name(), (String)"ZKRMStateStoreOpDurations");
        double expectAvgTime = anyDuration;
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"LoadStateCallAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"StoreApplicationStateCallAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"UpdateApplicationStateCallAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"RemoveApplicationStateCallAvgTime", (Number)expectAvgTime);
    }

    static class TestAppRejDispatcher
    extends RMStateStoreTestBase.TestDispatcher {
        private boolean appsavefailedEvnt;

        TestAppRejDispatcher() {
        }

        @Override
        public void handle(Event event) {
            if (event instanceof RMAppEvent && event.getType().equals(RMAppEventType.APP_SAVE_FAILED)) {
                this.appsavefailedEvnt = true;
            }
        }
    }

    class TestZKRMStateStoreTester
    implements RMStateStoreTestBase.RMStateStoreHelper {
        TestZKRMStateStoreInternal store;
        String workingZnode;

        TestZKRMStateStoreTester() {
        }

        private RMStateStore createStore(Configuration conf) throws Exception {
            this.workingZnode = "/jira/issue/3077/rmstore";
            conf.set("hadoop.zk.address", TestZKRMStateStore.this.curatorTestingServer.getConnectString());
            conf.set("yarn.resourcemanager.zk-state-store.parent-path", this.workingZnode);
            conf.setLong("yarn.resourcemanager.epoch", 10L);
            conf.setLong("yarn.resourcemanager.epoch.range", TestZKRMStateStore.this.getEpochRange());
            this.store = new TestZKRMStateStoreInternal(conf, this.workingZnode);
            return this.store;
        }

        public RMStateStore getRMStateStore(Configuration conf) throws Exception {
            return this.createStore(conf);
        }

        @Override
        public RMStateStore getRMStateStore() throws Exception {
            YarnConfiguration conf = new YarnConfiguration();
            return this.createStore((Configuration)conf);
        }

        @Override
        public boolean isFinalStateValid() throws Exception {
            return 1 == ((List)TestZKRMStateStore.this.curatorFramework.getChildren().forPath(this.store.znodeWorkingPath)).size();
        }

        @Override
        public void writeVersion(Version version) throws Exception {
            ((BackgroundPathAndBytesable)TestZKRMStateStore.this.curatorFramework.setData().withVersion(-1)).forPath(this.store.getVersionNode(), ((VersionPBImpl)version).getProto().toByteArray());
        }

        @Override
        public Version getCurrentVersion() throws Exception {
            return this.store.getCurrentVersion();
        }

        @Override
        public boolean appExists(RMApp app) throws Exception {
            String appIdPath = app.getApplicationId().toString();
            int split = this.store.getConfig().getInt("yarn.resourcemanager.zk-appid-node.split-index", 0);
            return null != TestZKRMStateStore.this.curatorFramework.checkExists().forPath(this.store.getAppNode(appIdPath, split));
        }

        @Override
        public boolean attemptExists(RMAppAttempt attempt) throws Exception {
            ApplicationAttemptId attemptId = attempt.getAppAttemptId();
            return null != TestZKRMStateStore.this.curatorFramework.checkExists().forPath(this.store.getAttemptNode(attemptId.getApplicationId().toString(), attemptId.toString()));
        }

        public boolean delegationTokenExists(RMDelegationTokenIdentifier token, int index) throws Exception {
            int rmDTSequenceNumber = token.getSequenceNumber();
            return TestZKRMStateStore.this.curatorFramework.checkExists().forPath(this.store.getDelegationTokenNode(rmDTSequenceNumber, index)) != null;
        }

        public int getDelegationTokenNodeSplitIndex() {
            return this.store.delegationTokenNodeSplitIndex;
        }

        class TestZKRMStateStoreInternal
        extends ZKRMStateStore {
            TestZKRMStateStoreInternal(Configuration conf, String workingZnode) throws Exception {
                this.setResourceManager(new ResourceManager());
                this.init(conf);
                this.start();
                Assert.assertTrue((boolean)this.znodeWorkingPath.equals(workingZnode));
            }

            private String getVersionNode() {
                return this.znodeWorkingPath + "/" + "ZKRMStateRoot" + "/" + "RMVersionNode";
            }

            public Version getCurrentVersion() {
                return CURRENT_VERSION_INFO;
            }

            private String getAppNode(String appId, int splitIdx) {
                String rootPath = TestZKRMStateStoreTester.this.workingZnode + "/" + "ZKRMStateRoot" + "/" + "RMAppRoot";
                String appPath = appId;
                if (splitIdx != 0) {
                    int idx = appId.length() - splitIdx;
                    appPath = appId.substring(0, idx) + "/" + appId.substring(idx);
                    return rootPath + "/" + "HIERARCHIES" + "/" + Integer.toString(splitIdx) + "/" + appPath;
                }
                return rootPath + "/" + appPath;
            }

            private String getAppNode(String appId) {
                return this.getAppNode(appId, 0);
            }

            private String getAttemptNode(String appId, String attemptId) {
                return this.getAppNode(appId) + "/" + attemptId;
            }

            private void testRetryingCreateRootDir() throws Exception {
                this.create(this.znodeWorkingPath);
            }

            private String getDelegationTokenNode(int rmDTSequenceNumber, int splitIdx) {
                String rootPath = TestZKRMStateStoreTester.this.workingZnode + "/" + "ZKRMStateRoot" + "/" + "RMDTSecretManagerRoot" + "/" + "RMDelegationTokensRoot";
                String nodeName = "RMDelegationToken_";
                nodeName = splitIdx == 0 ? nodeName + rmDTSequenceNumber : nodeName + String.format("%04d", rmDTSequenceNumber);
                String path = nodeName;
                if (splitIdx != 0) {
                    int idx = nodeName.length() - splitIdx;
                    path = splitIdx + "/" + nodeName.substring(0, idx) + "/" + nodeName.substring(idx);
                }
                return rootPath + "/" + path;
            }
        }
    }
}

