/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.apache.hadoop.yarn.webapp.util.YarnWebServiceUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRMWebServicesConfigurationMutation
extends JerseyTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestRMWebServicesConfigurationMutation.class);
    private static final File CONF_FILE = new File(new File("target", "test-classes"), "capacity-scheduler.xml");
    private static final File OLD_CONF_FILE = new File(new File("target", "test-classes"), "capacity-scheduler.xml.tmp");
    private static MockRM rm;
    private static String userName;
    private static CapacitySchedulerConfiguration csConf;
    private static YarnConfiguration conf;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    private static void setupQueueConfiguration(CapacitySchedulerConfiguration config) {
        config.setQueues("root", new String[]{"a", "b", "c"});
        String a = "root.a";
        config.setCapacity("root.a", 25.0f);
        config.setMaximumCapacity("root.a", 50.0f);
        String a1 = "root.a.a1";
        String a2 = "root.a.a2";
        config.setQueues("root.a", new String[]{"a1", "a2"});
        config.setCapacity("root.a.a1", 100.0f);
        config.setCapacity("root.a.a2", 0.0f);
        String b = "root.b";
        config.setCapacity("root.b", 75.0f);
        String c = "root.c";
        config.setCapacity("root.c", 0.0f);
        String c1 = "root.c.c1";
        config.setQueues("root.c", new String[]{"c1"});
        config.setCapacity("root.c.c1", 0.0f);
    }

    public TestRMWebServicesConfigurationMutation() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    private CapacitySchedulerConfiguration getSchedulerConf() throws JSONException {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").queryParam("user.name", userName).path("scheduler-conf").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        JSONArray items = (JSONArray)json.get("property");
        CapacitySchedulerConfiguration parsedConf = new CapacitySchedulerConfiguration();
        for (int i = 0; i < items.length(); ++i) {
            JSONObject obj = (JSONObject)items.get(i);
            parsedConf.set(obj.get("name").toString(), obj.get("value").toString());
        }
        return parsedConf;
    }

    @Test
    public void testGetSchedulerConf() throws Exception {
        CapacitySchedulerConfiguration orgConf = this.getSchedulerConf();
        Assert.assertNotNull((Object)orgConf);
        Assert.assertEquals((long)3L, (long)orgConf.getQueues("root").length);
    }

    @Test
    public void testFormatSchedulerConf() throws Exception {
        CapacitySchedulerConfiguration newConf = this.getSchedulerConf();
        Assert.assertNotNull((Object)newConf);
        Assert.assertEquals((long)3L, (long)newConf.getQueues("root").length);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> nearEmptyCapacity = new HashMap<String, String>();
        nearEmptyCapacity.put("capacity", "1E-4");
        QueueConfigInfo d = new QueueConfigInfo("root.formattest", nearEmptyCapacity);
        updateInfo.getAddQueueInfo().add(d);
        HashMap<String, String> stoppedParam = new HashMap<String, String>();
        stoppedParam.put("state", QueueState.STOPPED.toString());
        QueueConfigInfo stoppedInfo = new QueueConfigInfo("root.formattest", stoppedParam);
        updateInfo.getUpdateQueueInfo().add(stoppedInfo);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        newConf = this.getSchedulerConf();
        Assert.assertNotNull((Object)newConf);
        Assert.assertEquals((long)4L, (long)newConf.getQueues("root").length);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").queryParam("user.name", userName).path("/scheduler-conf/format").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        newConf = this.getSchedulerConf();
        Assert.assertEquals((long)3L, (long)newConf.getQueues("root").length);
    }

    private long getConfigVersion() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").queryParam("user.name", userName).path("/scheduler-conf/version").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        return Long.parseLong(json.get("versionID").toString());
    }

    @Test
    public void testSchedulerConfigVersion() throws Exception {
        Assert.assertEquals((long)1L, (long)this.getConfigVersion());
        this.testAddNestedQueue();
        Assert.assertEquals((long)2L, (long)this.getConfigVersion());
    }

    @Test
    public void testAddNestedQueue() throws Exception {
        CapacitySchedulerConfiguration orgConf = this.getSchedulerConf();
        Assert.assertNotNull((Object)orgConf);
        Assert.assertEquals((long)3L, (long)orgConf.getQueues("root").length);
        WebResource r = this.resource();
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> d1Capacity = new HashMap<String, String>();
        d1Capacity.put("capacity", "25");
        d1Capacity.put("maximum-capacity", "25");
        HashMap<String, String> nearEmptyCapacity = new HashMap<String, String>();
        nearEmptyCapacity.put("capacity", "1E-4");
        nearEmptyCapacity.put("maximum-capacity", "1E-4");
        HashMap<String, String> d2Capacity = new HashMap<String, String>();
        d2Capacity.put("capacity", "75");
        d2Capacity.put("maximum-capacity", "75");
        QueueConfigInfo d1 = new QueueConfigInfo("root.d.d1", d1Capacity);
        QueueConfigInfo d2 = new QueueConfigInfo("root.d.d2", d2Capacity);
        QueueConfigInfo d = new QueueConfigInfo("root.d", nearEmptyCapacity);
        updateInfo.getAddQueueInfo().add(d1);
        updateInfo.getAddQueueInfo().add(d2);
        updateInfo.getAddQueueInfo().add(d);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)4L, (long)newCSConf.getQueues("root").length);
        Assert.assertEquals((long)2L, (long)newCSConf.getQueues("root.d").length);
        Assert.assertEquals((float)25.0f, (float)newCSConf.getNonLabeledQueueCapacity("root.d.d1"), (float)0.01f);
        Assert.assertEquals((float)75.0f, (float)newCSConf.getNonLabeledQueueCapacity("root.d.d2"), (float)0.01f);
        CapacitySchedulerConfiguration newConf = this.getSchedulerConf();
        Assert.assertNotNull((Object)newConf);
        Assert.assertEquals((long)4L, (long)newConf.getQueues("root").length);
    }

    @Test
    public void testAddWithUpdate() throws Exception {
        WebResource r = this.resource();
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> dCapacity = new HashMap<String, String>();
        dCapacity.put("capacity", "25");
        HashMap<String, String> bCapacity = new HashMap<String, String>();
        bCapacity.put("capacity", "50");
        QueueConfigInfo d = new QueueConfigInfo("root.d", dCapacity);
        QueueConfigInfo b = new QueueConfigInfo("root.b", bCapacity);
        updateInfo.getAddQueueInfo().add(d);
        updateInfo.getUpdateQueueInfo().add(b);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)4L, (long)newCSConf.getQueues("root").length);
        Assert.assertEquals((float)25.0f, (float)newCSConf.getNonLabeledQueueCapacity("root.d"), (float)0.01f);
        Assert.assertEquals((float)50.0f, (float)newCSConf.getNonLabeledQueueCapacity("root.b"), (float)0.01f);
    }

    @Test
    public void testUnsetParentQueueOrderingPolicy() throws Exception {
        WebResource r = this.resource();
        SchedConfUpdateInfo updateInfo1 = new SchedConfUpdateInfo();
        HashMap<String, String> updateParam = new HashMap<String, String>();
        updateParam.put("ordering-policy", "fair");
        QueueConfigInfo aUpdateInfo = new QueueConfigInfo("root.b", updateParam);
        updateInfo1.getUpdateQueueInfo().add(aUpdateInfo);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo1, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        String bOrderingPolicy = "yarn.scheduler.capacity.root.b.ordering-policy";
        Assert.assertEquals((Object)"fair", (Object)newCSConf.get(bOrderingPolicy));
        this.stopQueue("root.b");
        SchedConfUpdateInfo updateInfo2 = new SchedConfUpdateInfo();
        HashMap<String, String> capacity = new HashMap<String, String>();
        capacity.put("capacity", "100");
        QueueConfigInfo b1 = new QueueConfigInfo("root.b.b1", capacity);
        updateInfo2.getAddQueueInfo().add(b1);
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo2, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        bOrderingPolicy = "yarn.scheduler.capacity.root.b.ordering-policy";
        Assert.assertNull((String)"Failed to unset Parent Queue OrderingPolicy", (Object)newCSConf.get(bOrderingPolicy));
    }

    @Test
    public void testUnsetLeafQueueOrderingPolicy() throws Exception {
        WebResource r = this.resource();
        SchedConfUpdateInfo updateInfo1 = new SchedConfUpdateInfo();
        HashMap<String, String> updateParam = new HashMap<String, String>();
        updateParam.put("ordering-policy", "priority-utilization");
        QueueConfigInfo aUpdateInfo = new QueueConfigInfo("root.c", updateParam);
        updateInfo1.getUpdateQueueInfo().add(aUpdateInfo);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo1, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        String cOrderingPolicy = "yarn.scheduler.capacity.root.c.ordering-policy";
        Assert.assertEquals((Object)"priority-utilization", (Object)newCSConf.get(cOrderingPolicy));
        this.stopQueue("root.c.c1");
        SchedConfUpdateInfo updateInfo2 = new SchedConfUpdateInfo();
        updateInfo2.getRemoveQueueInfo().add("root.c.c1");
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo2, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        cOrderingPolicy = "yarn.scheduler.capacity.root.c.ordering-policy";
        Assert.assertNull((String)"Failed to unset Leaf Queue OrderingPolicy", (Object)newCSConf.get(cOrderingPolicy));
    }

    @Test
    public void testRemoveQueue() throws Exception {
        WebResource r = this.resource();
        this.stopQueue("root.a.a2");
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getRemoveQueueInfo().add("root.a.a2");
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((String)"Failed to remove the queue", (long)1L, (long)newCSConf.getQueues("root.a").length);
        Assert.assertEquals((String)"Failed to remove the right queue", (Object)"a1", (Object)newCSConf.getQueues("root.a")[0]);
    }

    @Test
    public void testStopWithRemoveQueue() throws Exception {
        WebResource r = this.resource();
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> stoppedParam = new HashMap<String, String>();
        stoppedParam.put("state", QueueState.STOPPED.toString());
        QueueConfigInfo stoppedInfo = new QueueConfigInfo("root.a.a2", stoppedParam);
        updateInfo.getUpdateQueueInfo().add(stoppedInfo);
        updateInfo.getRemoveQueueInfo().add("root.a.a2");
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)1L, (long)newCSConf.getQueues("root.a").length);
        Assert.assertEquals((Object)"a1", (Object)newCSConf.getQueues("root.a")[0]);
    }

    @Test
    public void testStopWithConvertLeafToParentQueue() throws Exception {
        WebResource r = this.resource();
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> stoppedParam = new HashMap<String, String>();
        stoppedParam.put("state", QueueState.STOPPED.toString());
        QueueConfigInfo stoppedInfo = new QueueConfigInfo("root.b", stoppedParam);
        updateInfo.getUpdateQueueInfo().add(stoppedInfo);
        HashMap<String, String> b1Capacity = new HashMap<String, String>();
        b1Capacity.put("capacity", "100");
        QueueConfigInfo b1 = new QueueConfigInfo("root.b.b1", b1Capacity);
        updateInfo.getAddQueueInfo().add(b1);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)1L, (long)newCSConf.getQueues("root.b").length);
        Assert.assertEquals((Object)"b1", (Object)newCSConf.getQueues("root.b")[0]);
    }

    @Test
    public void testRemoveParentQueue() throws Exception {
        WebResource r = this.resource();
        this.stopQueue("root.c", "root.c.c1");
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getRemoveQueueInfo().add("root.c");
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)2L, (long)newCSConf.getQueues("root").length);
        Assert.assertNull((Object)newCSConf.getQueues("root.c"));
    }

    @Test
    public void testRemoveParentQueueWithCapacity() throws Exception {
        WebResource r = this.resource();
        this.stopQueue("root.a", "root.a.a1", "root.a.a2");
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getRemoveQueueInfo().add("root.a");
        HashMap<String, String> bCapacity = new HashMap<String, String>();
        bCapacity.put("capacity", "100");
        QueueConfigInfo b = new QueueConfigInfo("root.b", bCapacity);
        updateInfo.getUpdateQueueInfo().add(b);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)2L, (long)newCSConf.getQueues("root").length);
        Assert.assertEquals((float)100.0f, (float)newCSConf.getNonLabeledQueueCapacity("root.b"), (float)0.01f);
    }

    @Test
    public void testRemoveMultipleQueues() throws Exception {
        WebResource r = this.resource();
        this.stopQueue("root.b", "root.c", "root.c.c1");
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getRemoveQueueInfo().add("root.b");
        updateInfo.getRemoveQueueInfo().add("root.c");
        HashMap<String, String> aCapacity = new HashMap<String, String>();
        aCapacity.put("capacity", "100");
        aCapacity.put("maximum-capacity", "100");
        QueueConfigInfo configInfo = new QueueConfigInfo("root.a", aCapacity);
        updateInfo.getUpdateQueueInfo().add(configInfo);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)1L, (long)newCSConf.getQueues("root").length);
    }

    private void stopQueue(String ... queuePaths) throws Exception {
        WebResource r = this.resource();
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> stoppedParam = new HashMap<String, String>();
        stoppedParam.put("state", QueueState.STOPPED.toString());
        for (String queue : queuePaths) {
            QueueConfigInfo stoppedInfo = new QueueConfigInfo(queue, stoppedParam);
            updateInfo.getUpdateQueueInfo().add(stoppedInfo);
        }
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        for (String queue : queuePaths) {
            Assert.assertEquals((Object)QueueState.STOPPED, (Object)newCSConf.getState(queue));
        }
    }

    @Test
    public void testUpdateQueue() throws Exception {
        WebResource r = this.resource();
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> updateParam = new HashMap<String, String>();
        updateParam.put("maximum-am-resource-percent", "0.2");
        QueueConfigInfo aUpdateInfo = new QueueConfigInfo("root.a", updateParam);
        updateInfo.getUpdateQueueInfo().add(aUpdateInfo);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        Assert.assertEquals((float)0.1f, (float)cs.getConfiguration().getMaximumApplicationMasterResourcePerQueuePercent("root.a"), (float)0.001f);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        LOG.debug("Response headers: " + response.getHeaders());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = cs.getConfiguration();
        Assert.assertEquals((float)0.2f, (float)newCSConf.getMaximumApplicationMasterResourcePerQueuePercent("root.a"), (float)0.001f);
        updateParam.put("maximum-am-resource-percent", null);
        aUpdateInfo = new QueueConfigInfo("root.a", updateParam);
        updateInfo.getUpdateQueueInfo().clear();
        updateInfo.getUpdateQueueInfo().add(aUpdateInfo);
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        newCSConf = cs.getConfiguration();
        Assert.assertEquals((float)0.1f, (float)newCSConf.getMaximumApplicationMasterResourcePerQueuePercent("root.a"), (float)0.001f);
    }

    @Test
    public void testUpdateQueueCapacity() throws Exception {
        WebResource r = this.resource();
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> updateParam = new HashMap<String, String>();
        updateParam.put("capacity", "50");
        QueueConfigInfo aUpdateInfo = new QueueConfigInfo("root.a", updateParam);
        QueueConfigInfo bUpdateInfo = new QueueConfigInfo("root.b", updateParam);
        updateInfo.getUpdateQueueInfo().add(aUpdateInfo);
        updateInfo.getUpdateQueueInfo().add(bUpdateInfo);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((float)50.0f, (float)newCSConf.getNonLabeledQueueCapacity("root.a"), (float)0.01f);
        Assert.assertEquals((float)50.0f, (float)newCSConf.getNonLabeledQueueCapacity("root.b"), (float)0.01f);
    }

    @Test
    public void testGlobalConfChange() throws Exception {
        WebResource r = this.resource();
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getGlobalParams().put("yarn.scheduler.capacity.maximum-applications", "30000");
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)30000L, (long)newCSConf.getMaximumSystemApplications());
        updateInfo.getGlobalParams().put("yarn.scheduler.capacity.maximum-applications", null);
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).put(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)10000L, (long)newCSConf.getMaximumSystemApplications());
    }

    @Test
    public void testValidateWithClusterMaxAllocation() throws Exception {
        WebResource r = this.resource();
        int clusterMax = 16384;
        conf.setInt("yarn.scheduler.maximum-allocation-mb", clusterMax);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> updateParam = new HashMap<String, String>();
        updateParam.put("maximum-applications", "100");
        QueueConfigInfo aUpdateInfo = new QueueConfigInfo("root.a", updateParam);
        updateInfo.getUpdateQueueInfo().add(aUpdateInfo);
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("/scheduler-conf/validate").queryParam("user.name", userName).accept(new String[]{"application/json"}).entity((Object)YarnWebServiceUtils.toJson((Object)updateInfo, SchedConfUpdateInfo.class), "application/json")).post(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @After
    public void tearDown() throws Exception {
        if (rm != null) {
            rm.stop();
        }
        CONF_FILE.delete();
        if (!OLD_CONF_FILE.renameTo(CONF_FILE)) {
            throw new RuntimeException("Failed to re-copy old configuration file");
        }
        super.tearDown();
    }

    private static class WebServletModule
    extends ServletModule {
        private WebServletModule() {
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            try {
                userName = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to get current user name " + ioe.getMessage(), ioe);
            }
            csConf = new CapacitySchedulerConfiguration(new Configuration(false), false);
            TestRMWebServicesConfigurationMutation.setupQueueConfiguration(csConf);
            conf = new YarnConfiguration();
            conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
            conf.set("yarn.scheduler.configuration.store.class", "memory");
            conf.set("yarn.admin.acl", userName);
            try {
                if (CONF_FILE.exists() && !CONF_FILE.renameTo(OLD_CONF_FILE)) {
                    throw new RuntimeException("Failed to rename conf file");
                }
                FileOutputStream out = new FileOutputStream(CONF_FILE);
                csConf.writeXml((OutputStream)out);
                out.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write XML file", e);
            }
            rm = new MockRM((Configuration)conf);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
            this.filter("/*", new String[0]).through(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
        }
    }
}

