/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.volume.csi;

import org.apache.hadoop.yarn.server.volume.csi.VolumeCapabilityRange;
import org.apache.hadoop.yarn.server.volume.csi.exception.InvalidVolumeException;
import org.junit.Assert;
import org.junit.Test;

public class TestVolumeCapabilityRange {
    @Test(expected=InvalidVolumeException.class)
    public void testInvalidMinCapability() throws InvalidVolumeException {
        VolumeCapabilityRange.newBuilder().minCapacity(-1L).maxCapacity(5L).unit("Gi").build();
    }

    @Test(expected=InvalidVolumeException.class)
    public void testMissingMinCapability() throws InvalidVolumeException {
        VolumeCapabilityRange.newBuilder().maxCapacity(5L).unit("Gi").build();
    }

    @Test(expected=InvalidVolumeException.class)
    public void testMissingUnit() throws InvalidVolumeException {
        VolumeCapabilityRange.newBuilder().minCapacity(0L).maxCapacity(5L).build();
    }

    @Test
    public void testGetVolumeCapability() throws InvalidVolumeException {
        VolumeCapabilityRange vc = VolumeCapabilityRange.newBuilder().minCapacity(0L).maxCapacity(5L).unit("Gi").build();
        Assert.assertEquals((long)0L, (long)vc.getMinCapacity());
        Assert.assertEquals((long)5L, (long)vc.getMaxCapacity());
        Assert.assertEquals((Object)"Gi", (Object)vc.getUnit());
    }
}

