/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.lib.StaticUserWebFilter;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.Task;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStartedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigConverterTestCommons;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilterInitializer;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(TestResourceManager.class);
    private ResourceManager resourceManager = null;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private FSConfigConverterTestCommons converterTestCommons;

    @Before
    public void setUp() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.webapp.api-service.enable", false);
        UserGroupInformation.setConfiguration((Configuration)conf);
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        this.resourceManager = new ResourceManager();
        this.resourceManager.init((Configuration)conf);
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        this.resourceManager.getRMContext().getNMTokenSecretManager().rollMasterKey();
        this.converterTestCommons = new FSConfigConverterTestCommons();
        this.converterTestCommons.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.resourceManager.stop();
        this.converterTestCommons.tearDown();
    }

    private NodeManager registerNode(String hostName, int containerManagerPort, int httpPort, String rackName, Resource capability, NodeStatus nodeStatus) throws IOException, YarnException {
        NodeManager nm = new NodeManager(hostName, containerManagerPort, httpPort, rackName, capability, this.resourceManager, nodeStatus);
        NodeAddedSchedulerEvent nodeAddEvent1 = new NodeAddedSchedulerEvent((RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId()));
        this.resourceManager.getResourceScheduler().handle((Event)nodeAddEvent1);
        return nm;
    }

    @Test
    public void testResourceAllocation() throws IOException, YarnException, InterruptedException, TimeoutException {
        LOG.info("--- START: testResourceAllocation ---");
        int memory = 4096;
        int vcores = 4;
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        String host1 = "host1";
        NodeManager nm1 = this.registerNode(host1, 1234, 2345, "/default-rack", Resources.createResource((int)4096, (int)4), mockNodeStatus);
        String host2 = "host2";
        NodeManager nm2 = this.registerNode(host2, 1234, 2345, "/default-rack", Resources.createResource((int)2048, (int)2), mockNodeStatus);
        RMNodeImpl node1 = (RMNodeImpl)this.resourceManager.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNodeImpl node2 = (RMNodeImpl)this.resourceManager.getRMContext().getRMNodes().get(nm2.getNodeId());
        node1.handle((RMNodeEvent)new RMNodeStartedEvent(nm1.getNodeId(), null, null, mockNodeStatus));
        node2.handle((RMNodeEvent)new RMNodeStartedEvent(nm2.getNodeId(), null, null, mockNodeStatus));
        Application application = new Application("user1", this.resourceManager);
        application.submit();
        application.addNodeManager(host1, 1234, nm1);
        application.addNodeManager(host2, 1234, nm2);
        int memory1 = 1024;
        Resource capability1 = Resources.createResource((int)1024, (int)1);
        Priority priority1 = Priority.newInstance((int)1);
        application.addResourceRequestSpec(priority1, capability1);
        Task t1 = new Task(application, priority1, new String[]{host1, host2});
        application.addTask(t1);
        int memory2 = 2048;
        Resource capability2 = Resources.createResource((int)2048, (int)1);
        Priority priority0 = Priority.newInstance((int)0);
        application.addResourceRequestSpec(priority0, capability2);
        application.schedule();
        this.nodeUpdate(nm1);
        ((AbstractYarnScheduler)this.resourceManager.getResourceScheduler()).update();
        application.schedule();
        this.checkResourceUsage(nm1, nm2);
        LOG.info("Adding new tasks...");
        Task t2 = new Task(application, priority1, new String[]{host1, host2});
        application.addTask(t2);
        Task t3 = new Task(application, priority0, new String[]{"*"});
        application.addTask(t3);
        application.schedule();
        this.checkResourceUsage(nm1, nm2);
        this.nodeUpdate(nm2);
        this.nodeUpdate(nm2);
        this.nodeUpdate(nm1);
        this.nodeUpdate(nm1);
        LOG.info("Trying to allocate...");
        application.schedule();
        this.checkResourceUsage(nm1, nm2);
        LOG.info("Finishing up tasks...");
        application.finishTask(t1);
        application.finishTask(t2);
        application.finishTask(t3);
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(application.getApplicationAttemptId(), RMAppAttemptState.FINISHED, false);
        this.resourceManager.getResourceScheduler().handle((Event)appRemovedEvent1);
        this.checkResourceUsage(nm1, nm2);
        LOG.info("--- END: testResourceAllocation ---");
    }

    private void nodeUpdate(NodeManager nm1) {
        RMNode node = (RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm1.getNodeId());
        NodeUpdateSchedulerEvent nodeUpdate = new NodeUpdateSchedulerEvent(node);
        this.resourceManager.getResourceScheduler().handle((Event)nodeUpdate);
    }

    @Test
    public void testNodeHealthReportIsNotNull() throws Exception {
        String host1 = "host1";
        int memory = 4096;
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        NodeManager nm1 = this.registerNode(host1, 1234, 2345, "/default-rack", Resources.createResource((int)4096, (int)1), mockNodeStatus);
        nm1.heartbeat();
        nm1.heartbeat();
        Collection values = this.resourceManager.getRMContext().getRMNodes().values();
        for (RMNode ni : values) {
            Assert.assertNotNull((Object)ni.getHealthReport());
        }
    }

    private void checkResourceUsage(NodeManager ... nodes) {
        for (NodeManager nodeManager : nodes) {
            nodeManager.checkResourceUsage();
        }
    }

    @Test(timeout=30000L)
    public void testResourceManagerInitConfigValidation() throws Exception {
        block5: {
            block4: {
                YarnConfiguration conf = new YarnConfiguration();
                conf.setInt("yarn.resourcemanager.am.global.max-attempts", -1);
                try {
                    this.resourceManager = new MockRM((Configuration)conf);
                    Assert.fail((String)"Exception is expected because the global max attempts is negative.");
                }
                catch (YarnRuntimeException e) {
                    if (e.getMessage().startsWith("Invalid global max attempts configuration")) break block4;
                    throw e;
                }
            }
            YarnConfiguration yarnConf = new YarnConfiguration();
            yarnConf.setInt("yarn.resourcemanager.am.max-attempts", -1);
            try {
                this.resourceManager = new MockRM((Configuration)yarnConf);
                Assert.fail((String)"Exception is expected because AM max attempts is negative.");
            }
            catch (YarnRuntimeException e) {
                if (e.getMessage().startsWith("Invalid rm am max attempts configuration")) break block5;
                throw e;
            }
        }
    }

    @Test
    public void testNMExpiryAndHeartbeatIntervalsValidation() throws Exception {
        block2: {
            YarnConfiguration conf = new YarnConfiguration();
            conf.setLong("yarn.nm.liveness-monitor.expiry-interval-ms", 1000L);
            conf.setLong("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 1001L);
            try {
                this.resourceManager = new MockRM((Configuration)conf);
            }
            catch (YarnRuntimeException e) {
                if (e.getMessage().startsWith("Nodemanager expiry interval should be no less than heartbeat interval")) break block2;
                throw e;
            }
        }
    }

    @Test(timeout=50000L)
    public void testFilterOverrides() throws Exception {
        String[] simpleFilterInitializers;
        String[] filterInitializers;
        String filterInitializerConfKey = "hadoop.http.filter.initializers";
        for (String filterInitializer : filterInitializers = new String[]{AuthenticationFilterInitializer.class.getName(), RMAuthenticationFilterInitializer.class.getName(), AuthenticationFilterInitializer.class.getName() + "," + RMAuthenticationFilterInitializer.class.getName(), AuthenticationFilterInitializer.class.getName() + ", " + RMAuthenticationFilterInitializer.class.getName(), AuthenticationFilterInitializer.class.getName() + ", " + this.getClass().getName()}) {
            this.resourceManager = new ResourceManager(){

                protected void doSecureLogin() throws IOException {
                }
            };
            YarnConfiguration conf = new YarnConfiguration();
            conf.setBoolean("yarn.webapp.api-service.enable", false);
            conf.set(filterInitializerConfKey, filterInitializer);
            conf.set("hadoop.security.authentication", "kerberos");
            conf.set("hadoop.http.authentication.type", "kerberos");
            conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
            conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
            try {
                try {
                    UserGroupInformation.setConfiguration((Configuration)conf);
                }
                catch (Exception e) {
                    LOG.info("Got expected exception");
                }
                this.resourceManager.init((Configuration)conf);
                this.resourceManager.startWepApp();
            }
            catch (RuntimeException e) {
                String tmp = this.resourceManager.getConfig().get(filterInitializerConfKey);
                if (filterInitializer.contains(this.getClass().getName())) {
                    Assert.assertEquals((Object)(RMAuthenticationFilterInitializer.class.getName() + "," + this.getClass().getName()), (Object)tmp);
                } else {
                    Assert.assertEquals((Object)RMAuthenticationFilterInitializer.class.getName(), (Object)tmp);
                }
                this.resourceManager.stop();
            }
        }
        for (String filterInitializer : simpleFilterInitializers = new String[]{"", StaticUserWebFilter.class.getName()}) {
            this.resourceManager = new ResourceManager();
            YarnConfiguration conf = new YarnConfiguration();
            conf.setBoolean("yarn.webapp.api-service.enable", false);
            conf.set(filterInitializerConfKey, filterInitializer);
            try {
                UserGroupInformation.setConfiguration((Configuration)conf);
                this.resourceManager.init((Configuration)conf);
                this.resourceManager.startWepApp();
            }
            catch (RuntimeException e) {
                String tmp = this.resourceManager.getConfig().get(filterInitializerConfKey);
                if (filterInitializer.equals(StaticUserWebFilter.class.getName())) {
                    Assert.assertEquals((Object)(RMAuthenticationFilterInitializer.class.getName() + "," + StaticUserWebFilter.class.getName()), (Object)tmp);
                } else {
                    Assert.assertEquals((Object)RMAuthenticationFilterInitializer.class.getName(), (Object)tmp);
                }
                this.resourceManager.stop();
            }
        }
    }

    @Test
    public void testUserProvidedUGIConf() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid attribute value for hadoop.security.authentication of DUMMYAUTH");
        YarnConfiguration dummyConf = new YarnConfiguration();
        dummyConf.set("hadoop.security.authentication", "DUMMYAUTH");
        ResourceManager dummyResourceManager = new ResourceManager();
        try {
            dummyResourceManager.init((Configuration)dummyConf);
        }
        finally {
            dummyResourceManager.stop();
        }
    }
}

