/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework;

import java.util.Map;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.ContainerSpecification;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.MockApplication;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.MockContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;

class MockContainers {
    private MockApplication mockApp;
    private Map<String, CSQueue> nameToCSQueues;
    private Map<NodeId, FiCaSchedulerNode> nodeIdToSchedulerNodes;

    MockContainers(MockApplication mockApp, Map<String, CSQueue> nameToCSQueues, Map<NodeId, FiCaSchedulerNode> nodeIdToSchedulerNodes) {
        this.mockApp = mockApp;
        this.nameToCSQueues = nameToCSQueues;
        this.nodeIdToSchedulerNodes = nodeIdToSchedulerNodes;
        this.init();
    }

    private void init() {
        String containersConfig = this.mockApp.containersConfig;
        int start = containersConfig.indexOf("=") + 1;
        int end = -1;
        int containerId = 1;
        while (start < containersConfig.length()) {
            while (start < containersConfig.length() && containersConfig.charAt(start) != '(') {
                ++start;
            }
            if (start >= containersConfig.length()) {
                throw new IllegalArgumentException("Error in containers specification, line=" + containersConfig);
            }
            for (end = start + 1; end < containersConfig.length() && containersConfig.charAt(end) != ')'; ++end) {
            }
            if (end >= containersConfig.length()) {
                throw new IllegalArgumentException("Error in containers specification, line=" + containersConfig);
            }
            String[] values = containersConfig.substring(start + 1, end).split(",");
            if (values.length < 6 || values.length > 8) {
                throw new IllegalArgumentException("Format to define container is:(priority,resource,host,label expression,repeat,reserved, pending)");
            }
            ContainerSpecification.Builder builder = ContainerSpecification.Builder.create().withPriority(values[0]).withResource(values[1]).withHostname(values[2]).withLabel(values[3]).withRepeat(values[4]).withReserved(values[5]);
            if (values.length >= 7) {
                builder.withPendingResource(values[6]);
            }
            if (values.length == 8) {
                builder.withUsername(values[7]);
            }
            ContainerSpecification containerSpec = builder.build();
            Resource usedResources = Resource.newInstance((int)0, (int)0);
            for (int i = 0; i < containerSpec.repeat; ++i) {
                Resources.addTo((Resource)usedResources, (Resource)containerSpec.resource);
                MockContainer mockContainer = new MockContainer(containerSpec, containerId, this.mockApp);
                FiCaSchedulerNode schedulerNode = this.nodeIdToSchedulerNodes.get(containerSpec.nodeId);
                LeafQueue queue = (LeafQueue)this.nameToCSQueues.get(this.mockApp.queueName);
                this.mockApp.addMockContainer(mockContainer, schedulerNode, queue);
                ++containerId;
            }
            this.mockApp.addAggregatedContainerData(containerSpec, usedResources);
            start = end + 1;
        }
    }
}

