/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework;

import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.ContainerSpecification;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.MockApplication;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

class MockContainer {
    ContainerSpecification containerSpec;
    public int containerId;
    private MockApplication mockApp;
    RMContainerImpl rmContainerMock;

    MockContainer(ContainerSpecification containerSpec, int containerId, MockApplication mockApp) {
        this.containerSpec = containerSpec;
        this.containerId = containerId;
        this.mockApp = mockApp;
        this.rmContainerMock = (RMContainerImpl)Mockito.mock(RMContainerImpl.class);
        this.init();
    }

    private void init() {
        Container c = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)c.getResource()).thenReturn((Object)this.containerSpec.resource);
        Mockito.when((Object)c.getPriority()).thenReturn((Object)this.containerSpec.priority);
        SchedulerRequestKey sk = SchedulerRequestKey.extractFrom((Container)c);
        Mockito.when((Object)this.rmContainerMock.getAllocatedSchedulerKey()).thenReturn((Object)sk);
        Mockito.when((Object)this.rmContainerMock.getAllocatedNode()).thenReturn((Object)this.containerSpec.nodeId);
        Mockito.when((Object)this.rmContainerMock.getNodeLabelExpression()).thenReturn((Object)this.containerSpec.label);
        Mockito.when((Object)this.rmContainerMock.getAllocatedResource()).thenReturn((Object)this.containerSpec.resource);
        Mockito.when((Object)this.rmContainerMock.getContainer()).thenReturn((Object)c);
        Mockito.when((Object)this.rmContainerMock.getApplicationAttemptId()).thenReturn((Object)this.mockApp.appAttemptId);
        Mockito.when((Object)this.rmContainerMock.getQueueName()).thenReturn((Object)this.mockApp.queueName);
        final ContainerId cId = ContainerId.newContainerId((ApplicationAttemptId)this.mockApp.appAttemptId, (long)this.containerId);
        Mockito.when((Object)this.rmContainerMock.getContainerId()).thenReturn((Object)cId);
        ((RMContainerImpl)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) {
                return cId.compareTo(((RMContainer)invocation.getArguments()[0]).getContainerId());
            }
        }).when((Object)this.rmContainerMock)).compareTo((RMContainer)ArgumentMatchers.any(RMContainer.class));
        if (this.containerId == 1) {
            Mockito.when((Object)this.rmContainerMock.isAMContainer()).thenReturn((Object)true);
        }
        if (this.containerSpec.reserved) {
            Mockito.when((Object)this.rmContainerMock.getReservedResource()).thenReturn((Object)this.containerSpec.resource);
        }
    }
}

