/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.AllocateRequestPBImpl;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockMemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ParameterizedSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAMRMTokenEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreProxyCAEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRMDTEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRMDTMasterKeyEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestSchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestRMRestart
extends ParameterizedSchedulerTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestRMRestart.class);
    private static final File TEMP_DIR = new File(System.getProperty("test.build.data", "/tmp"), "decommision");
    private File hostFile = new File(TEMP_DIR + File.separator + "hostFile.txt");
    private YarnConfiguration conf;
    private static InetSocketAddress rmAddr;
    private List<MockRM> rms = new ArrayList<MockRM>();
    private int appsSubmittedCarryOn = 0;
    private int appsPendingCarryOn = 0;
    private int appsRunningCarryOn = 0;
    private int appsCompletedCarryOn = 0;

    public TestRMRestart(ParameterizedSchedulerTestBase.SchedulerType type) throws IOException {
        super(type);
    }

    @Before
    public void setup() throws IOException {
        this.conf = this.getConf();
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", false);
        this.conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        this.conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
        rmAddr = new InetSocketAddress("localhost", 8032);
        Assert.assertTrue((boolean)true);
    }

    @Override
    @After
    public void tearDown() {
        for (MockRM rm : this.rms) {
            rm.stop();
        }
        this.rms.clear();
        TEMP_DIR.delete();
    }

    private MockRM createMockRM(YarnConfiguration conf, RMStateStore store) {
        MockRM rm = new MockRM((Configuration)conf, store);
        this.rms.add(rm);
        return rm;
    }

    private MockRM createMockRM(YarnConfiguration config) {
        MockRM rm = new MockRM((Configuration)config);
        this.rms.add(rm);
        return rm;
    }

    private RMApp submitApp(MockRM rm, List<ResourceRequest> amResourceRequests, String appNodeLabel) throws Exception {
        int maxAttempts = rm.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.create().withAmResourceRequests(amResourceRequests).withAppName("app1").withUser("user").withAcls(null).withUnmanagedAM(false).withQueue(null).withMaxAppAttempts(maxAttempts).withCredentials(null).withAppType(null).withWaitForAppAcceptedState(true).withKeepContainers(false).withApplicationId(null).withAttemptFailuresValidityInterval(0L).withLogAggregationContext(null).withCancelTokensWhenComplete(true).withAppPriority(amResourceRequests.get(0).getPriority()).withAmLabel(amResourceRequests.get(0).getNodeLabelExpression()).withApplicationTimeouts(null).withTokensConf(null).withApplicationTags(null).withAppNodeLabel(appNodeLabel).build();
        return MockRMAppSubmitter.submit(rm, data);
    }

    @Test(timeout=180000L)
    public void testRMRestart() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = this.createMockRM(this.conf);
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)rm1.getRMStateStore();
        Map rmAppState = memStore.getState().getApplicationState();
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.2:5678", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        RMAppAttempt attempt0 = app0.getCurrentAppAttempt();
        Assert.assertEquals((long)1L, (long)rmAppState.size());
        nm1.nodeHeartbeat(true);
        MockAM am0 = rm1.sendAMLaunched(attempt0.getAppAttemptId());
        am0.registerAppAttempt();
        this.finishApplicationMaster(app0, rm1, nm1, am0);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(app1.getApplicationId());
        Assert.assertNotNull((Object)appState);
        Assert.assertEquals((long)0L, (long)appState.getAttemptCount());
        Assert.assertEquals((Object)appState.getApplicationSubmissionContext().getApplicationId(), (Object)app1.getApplicationSubmissionContext().getApplicationId());
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        ApplicationAttemptId attemptId1 = attempt1.getAppAttemptId();
        rm1.waitForState(attemptId1, RMAppAttemptState.ALLOCATED);
        Assert.assertEquals((long)1L, (long)appState.getAttemptCount());
        ApplicationAttemptStateData attemptState = appState.getAttempt(attemptId1);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)BuilderUtils.newContainerId((ApplicationAttemptId)attemptId1, (long)1L), (Object)attemptState.getMasterContainer().getId());
        MockAM am1 = rm1.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        am1.allocate("127.0.0.1", 1000, 1, new ArrayList<ContainerId>());
        nm1.nodeHeartbeat(true);
        List conts = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        while (conts.size() == 0) {
            nm1.nodeHeartbeat(true);
            conts.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(500L);
        }
        RMApp app2 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        appState = (ApplicationStateData)rmAppState.get(app2.getApplicationId());
        Assert.assertNotNull((Object)appState);
        Assert.assertEquals((long)0L, (long)appState.getAttemptCount());
        Assert.assertEquals((Object)appState.getApplicationSubmissionContext().getApplicationId(), (Object)app2.getApplicationSubmissionContext().getApplicationId());
        RMApp appUnmanaged = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("someApp").withUser("someUser").withAcls(null).withUnmanagedAM(true).withQueue(null).withMaxAppAttempts(this.conf.getInt("yarn.resourcemanager.am.max-attempts", 2)).withCredentials(null).build());
        ApplicationAttemptId unmanagedAttemptId = appUnmanaged.getCurrentAppAttempt().getAppAttemptId();
        ApplicationId unmanagedAppId = appUnmanaged.getApplicationId();
        appState = (ApplicationStateData)rmAppState.get(unmanagedAppId);
        Assert.assertNotNull((Object)appState);
        rm1.waitForState(unmanagedAttemptId, RMAppAttemptState.LAUNCHED);
        rm1.waitForState(unmanagedAppId, RMAppState.ACCEPTED);
        Assert.assertEquals((long)1L, (long)appState.getAttemptCount());
        Assert.assertEquals((Object)appState.getApplicationSubmissionContext().getApplicationId(), (Object)appUnmanaged.getApplicationSubmissionContext().getApplicationId());
        MockRM rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm2.start();
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        nm2.setResourceTrackerService(rm2.getResourceTrackerService());
        Assert.assertEquals((long)4L, (long)rm2.getRMContext().getRMApps().size());
        rm2.waitForState(app0.getApplicationId(), RMAppState.FINISHED);
        rm2.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.FINISHED);
        RMApp loadedApp1 = (RMApp)rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        Assert.assertNotNull((Object)loadedApp1);
        Assert.assertEquals((long)1L, (long)loadedApp1.getAppAttempts().size());
        Assert.assertEquals((Object)app1.getApplicationSubmissionContext().getApplicationId(), (Object)loadedApp1.getApplicationSubmissionContext().getApplicationId());
        RMApp loadedApp2 = (RMApp)rm2.getRMContext().getRMApps().get(app2.getApplicationId());
        Assert.assertNotNull((Object)loadedApp2);
        Assert.assertEquals((Object)app2.getApplicationSubmissionContext().getApplicationId(), (Object)loadedApp2.getApplicationSubmissionContext().getApplicationId());
        rm2.waitForState(loadedApp1.getApplicationId(), RMAppState.ACCEPTED);
        rm2.waitForState(loadedApp2.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((long)1L, (long)loadedApp1.getAppAttempts().size());
        Assert.assertEquals((long)1L, (long)loadedApp2.getAppAttempts().size());
        am1.setAMRMProtocol((ApplicationMasterProtocol)rm2.getApplicationMasterService(), rm2.getRMContext());
        try {
            am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
            Assert.fail();
        }
        catch (ApplicationAttemptNotFoundException e) {
            Assert.assertTrue((boolean)(e instanceof ApplicationAttemptNotFoundException));
        }
        NodeHeartbeatResponse hbResponse = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.RESYNC, (Object)hbResponse.getNodeAction());
        hbResponse = nm2.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.RESYNC, (Object)hbResponse.getNodeAction());
        nm1 = new MockNM("127.0.0.1:1234", 15120, rm2.getResourceTrackerService());
        nm2 = new MockNM("127.0.0.2:5678", 15120, rm2.getResourceTrackerService());
        NMContainerStatus status = TestRMRestart.createNMContainerStatus(loadedApp1.getCurrentAppAttempt().getAppAttemptId(), 1, ContainerState.COMPLETE);
        nm1.registerNode(Arrays.asList(status), null);
        nm2.registerNode();
        rm2.waitForState(loadedApp1.getApplicationId(), RMAppState.ACCEPTED);
        int timeoutSecs = 0;
        while (loadedApp1.getAppAttempts().size() != 2 && timeoutSecs++ < 40) {
            Thread.sleep(200L);
        }
        hbResponse = nm1.nodeHeartbeat(true);
        Assert.assertTrue((NodeAction.RESYNC != hbResponse.getNodeAction() ? 1 : 0) != 0);
        hbResponse = nm2.nodeHeartbeat(true);
        Assert.assertTrue((NodeAction.RESYNC != hbResponse.getNodeAction() ? 1 : 0) != 0);
        attempt1 = loadedApp1.getCurrentAppAttempt();
        attemptId1 = attempt1.getAppAttemptId();
        ((AbstractYarnScheduler)rm2.getResourceScheduler()).update();
        rm2.waitForState(attemptId1, RMAppAttemptState.ALLOCATED);
        appState = (ApplicationStateData)rmAppState.get(loadedApp1.getApplicationId());
        attemptState = appState.getAttempt(attemptId1);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)BuilderUtils.newContainerId((ApplicationAttemptId)attemptId1, (long)1L), (Object)attemptState.getMasterContainer().getId());
        MockNM am1Node = nm1;
        if (attemptState.getMasterContainer().getNodeId().toString().contains("127.0.0.2")) {
            am1Node = nm2;
        }
        RMAppAttempt attempt2 = loadedApp2.getCurrentAppAttempt();
        ApplicationAttemptId attemptId2 = attempt2.getAppAttemptId();
        rm2.waitForState(attemptId2, RMAppAttemptState.ALLOCATED);
        appState = (ApplicationStateData)rmAppState.get(loadedApp2.getApplicationId());
        attemptState = appState.getAttempt(attemptId2);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)BuilderUtils.newContainerId((ApplicationAttemptId)attemptId2, (long)1L), (Object)attemptState.getMasterContainer().getId());
        MockNM am2Node = nm1;
        if (attemptState.getMasterContainer().getNodeId().toString().contains("127.0.0.2")) {
            am2Node = nm2;
        }
        am1 = rm2.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        MockAM am2 = rm2.sendAMLaunched(attempt2.getAppAttemptId());
        am2.registerAppAttempt();
        am1.allocate("127.0.0.1", 1000, 3, new ArrayList<ContainerId>());
        am2.allocate("127.0.0.2", 1000, 1, new ArrayList<ContainerId>());
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        conts = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        while (conts.size() == 0) {
            nm1.nodeHeartbeat(true);
            nm2.nodeHeartbeat(true);
            conts.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(500L);
        }
        this.finishApplicationMaster(loadedApp1, rm2, am1Node, am1);
        this.finishApplicationMaster(loadedApp2, rm2, am2Node, am2);
        rm2.stop();
        rm1.stop();
        Assert.assertEquals((long)4L, (long)rmAppState.size());
    }

    @Test(timeout=60000L)
    public void testAppReportNodeLabelRMRestart() throws Exception {
        if (this.getSchedulerType() != ParameterizedSchedulerTestBase.SchedulerType.CAPACITY) {
            return;
        }
        YarnConfiguration newConf = new YarnConfiguration((Configuration)this.conf);
        newConf.setBoolean("yarn.node-labels.enabled", true);
        MockRM rm1 = this.createMockRM(newConf);
        NodeLabel amLabel = NodeLabel.newInstance((String)"AMLABEL");
        NodeLabel appLabel = NodeLabel.newInstance((String)"APPLABEL");
        ArrayList<NodeLabel> labels = new ArrayList<NodeLabel>();
        labels.add(amLabel);
        labels.add(appLabel);
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        rm1.start();
        rm1.getAdminService().addToClusterNodeLabels(AddToClusterNodeLabelsRequest.newInstance(labels));
        ResourceRequest amResourceRequest = ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)Resource.newInstance((int)200, (int)1), (int)1, (boolean)true, (String)amLabel.getName());
        ArrayList<ResourceRequest> resReqs = new ArrayList<ResourceRequest>();
        resReqs.add(amResourceRequest);
        RMApp app0 = this.submitApp(rm1, resReqs, appLabel.getName());
        rm1.killApp(app0.getApplicationId());
        rm1.waitForState(app0.getApplicationId(), RMAppState.KILLED);
        MockRM rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm2.start();
        Assert.assertEquals((long)1L, (long)rm2.getRMContext().getRMApps().size());
        ApplicationReport appReport = rm2.getClientRMService().getApplicationReport(GetApplicationReportRequest.newInstance((ApplicationId)app0.getApplicationId())).getApplicationReport();
        Assert.assertEquals((Object)amLabel.getName(), (Object)appReport.getAmNodeLabelExpression());
        Assert.assertEquals((Object)appLabel.getName(), (Object)appReport.getAppNodeLabelExpression());
        rm1.stop();
        rm2.stop();
    }

    @Test(timeout=60000L)
    public void testUnManagedRMRestart() throws Exception {
        MockRM rm1 = this.createMockRM(this.conf);
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        rm1.start();
        RMApp app0 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithResource(null, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(true).withQueue("default").build());
        rm1.killApp(app0.getApplicationId());
        rm1.waitForState(app0.getApplicationId(), RMAppState.KILLED);
        MockRM rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm2.start();
        Assert.assertEquals((long)1L, (long)rm2.getRMContext().getRMApps().size());
        ApplicationReport appReport = rm2.getClientRMService().getApplicationReport(GetApplicationReportRequest.newInstance((ApplicationId)app0.getApplicationId())).getApplicationReport();
        Assert.assertEquals((Object)true, (Object)appReport.isUnmanagedApp());
        rm1.stop();
        rm2.stop();
    }

    @Test(timeout=60000L)
    public void testRMRestartAppRunningAMFailed() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = this.createMockRM(this.conf);
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        Map rmAppState = memStore.getState().getApplicationState();
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(-1).withCredentials(null).withAppType("MAPREDUCE").withWaitForAppAcceptedState(true).withKeepContainers(true).build();
        RMApp app0 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am0 = this.launchAM(app0, rm1, nm1);
        nm1.nodeHeartbeat(am0.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(app0.getApplicationId());
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)appState.getAttempt(am0.getApplicationAttemptId()).getState());
        Assert.assertNull((Object)((ApplicationStateData)rmAppState.get(app0.getApplicationId())).getState());
        rm1.waitForState(app0.getApplicationId(), RMAppState.ACCEPTED);
        MockRM rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm2.start();
        rm2.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.FAILED);
    }

    @Test(timeout=60000L)
    public void testRMRestartWaitForPreviousAMToFinish() throws Exception {
        YarnConfiguration conf = new YarnConfiguration((Configuration)this.conf);
        conf.setInt("yarn.resourcemanager.am.max-attempts", 40);
        MockRM rm1 = this.createMockRM(conf);
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        Map rmAppState = memStore.getState().getApplicationState();
        rm1.start();
        AbstractYarnScheduler ys = (AbstractYarnScheduler)rm1.getResourceScheduler();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 16382, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am1 = this.launchAM(app1, rm1, nm1);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        TestSchedulerUtils.waitSchedulerApplicationAttemptStopped(ys, am1.getApplicationAttemptId());
        MockAM am2 = this.launchAM(app1, rm1, nm1);
        Assert.assertEquals((long)1L, (long)rmAppState.size());
        Assertions.assertThat((Comparable)app1.getState()).isEqualTo((Object)RMAppState.RUNNING);
        Assert.assertEquals((Object)((RMAppAttempt)app1.getAppAttempts().get(app1.getCurrentAppAttempt().getAppAttemptId())).getAppAttemptState(), (Object)RMAppAttemptState.RUNNING);
        MockRM rm2 = this.createMockRM(conf, (RMStateStore)memStore);
        rm2.start();
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        NodeHeartbeatResponse res = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.RESYNC, (Object)res.getNodeAction());
        RMApp rmApp = (RMApp)rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        rm2.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((Object)RMAppState.ACCEPTED, (Object)rmApp.getState());
        Assert.assertEquals((long)2L, (long)rmApp.getAppAttempts().size());
        rm2.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm2.waitForState(am2.getApplicationAttemptId(), RMAppAttemptState.LAUNCHED);
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)((RMAppAttempt)rmApp.getAppAttempts().get(am1.getApplicationAttemptId())).getAppAttemptState());
        Assert.assertEquals((Object)RMAppAttemptState.LAUNCHED, (Object)((RMAppAttempt)rmApp.getAppAttempts().get(am2.getApplicationAttemptId())).getAppAttemptState());
        NMContainerStatus status = TestRMRestart.createNMContainerStatus(am2.getApplicationAttemptId(), 1, ContainerState.COMPLETE);
        nm1.registerNode(Arrays.asList(status), null);
        rm2.waitForState(am2.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        ys = (AbstractYarnScheduler)rm2.getResourceScheduler();
        TestSchedulerUtils.waitSchedulerApplicationAttemptStopped(ys, am2.getApplicationAttemptId());
        this.launchAM(rmApp, rm2, nm1);
        Assert.assertEquals((long)3L, (long)rmApp.getAppAttempts().size());
        rm2.waitForState(rmApp.getCurrentAppAttempt().getAppAttemptId(), RMAppAttemptState.RUNNING);
        conf.setInt("yarn.am.liveness-monitor.expiry-interval-ms", 10000);
        MockRM rm3 = this.createMockRM(conf, (RMStateStore)memStore);
        rm3.start();
        nm1.setResourceTrackerService(rm3.getResourceTrackerService());
        rmApp = (RMApp)rm3.getRMContext().getRMApps().get(app1.getApplicationId());
        rm3.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        Assertions.assertThat((Comparable)rmApp.getState()).isEqualTo((Object)RMAppState.ACCEPTED);
        Assert.assertEquals((long)3L, (long)rmApp.getAppAttempts().size());
        rm3.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm3.waitForState(am2.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        ApplicationAttemptId latestAppAttemptId = rmApp.getCurrentAppAttempt().getAppAttemptId();
        rm3.waitForState(latestAppAttemptId, RMAppAttemptState.LAUNCHED);
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)((RMAppAttempt)rmApp.getAppAttempts().get(am1.getApplicationAttemptId())).getAppAttemptState());
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)((RMAppAttempt)rmApp.getAppAttempts().get(am2.getApplicationAttemptId())).getAppAttemptState());
        Assert.assertEquals((Object)RMAppAttemptState.LAUNCHED, (Object)((RMAppAttempt)rmApp.getAppAttempts().get(latestAppAttemptId)).getAppAttemptState());
        rm3.waitForState(latestAppAttemptId, RMAppAttemptState.FAILED);
        rm3.waitForState(rmApp.getApplicationId(), RMAppState.ACCEPTED);
        int maxRetry = 10;
        final RMApp rmAppForCheck = rmApp;
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return new Boolean(rmAppForCheck.getAppAttempts().size() == 4);
            }
        }, (long)100L, (long)1000L);
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)((RMAppAttempt)rmApp.getAppAttempts().get(latestAppAttemptId)).getAppAttemptState());
        latestAppAttemptId = rmApp.getCurrentAppAttempt().getAppAttemptId();
        RMApp app2 = MockRMAppSubmitter.submitWithMemory(200L, rm3);
        rm3.waitForState(app2.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((long)1L, (long)app2.getAppAttempts().size());
        Assert.assertEquals((long)0L, (long)((ApplicationStateData)memStore.getState().getApplicationState().get(app2.getApplicationId())).getAttemptCount());
        MockRM rm4 = this.createMockRM(conf, (RMStateStore)memStore);
        rm4.start();
        rmApp = (RMApp)rm4.getRMContext().getRMApps().get(app1.getApplicationId());
        rm4.waitForState(rmApp.getApplicationId(), RMAppState.ACCEPTED);
        int timeoutSecs = 0;
        while (rmApp.getAppAttempts().size() != 2 && timeoutSecs++ < 40) {
            Thread.sleep(200L);
        }
        Assert.assertEquals((long)4L, (long)rmApp.getAppAttempts().size());
        Assert.assertEquals((Object)RMAppState.ACCEPTED, (Object)rmApp.getState());
        rm4.waitForState(latestAppAttemptId, RMAppAttemptState.SCHEDULED);
        Assert.assertEquals((Object)RMAppAttemptState.SCHEDULED, (Object)((RMAppAttempt)rmApp.getAppAttempts().get(latestAppAttemptId)).getAppAttemptState());
        app2 = (RMApp)rm4.getRMContext().getRMApps().get(app2.getApplicationId());
        rm4.waitForState(app2.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((Object)RMAppState.ACCEPTED, (Object)app2.getState());
        Assert.assertEquals((long)1L, (long)app2.getAppAttempts().size());
        rm4.waitForState(app2.getCurrentAppAttempt().getAppAttemptId(), RMAppAttemptState.SCHEDULED);
        Assert.assertEquals((Object)RMAppAttemptState.SCHEDULED, (Object)app2.getCurrentAppAttempt().getAppAttemptState());
    }

    @Test(timeout=60000L)
    public void testRMRestartWaitForPreviousSucceededAttempt() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockMemoryRMStateStore memStore = new MockMemoryRMStateStore(){
            int count = 0;

            @Override
            public void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateData) throws Exception {
                if (this.count == 1) {
                    LOG.info(appId + " final state is not saved.");
                } else {
                    super.updateApplicationStateInternal(appId, appStateData);
                }
                ++this.count;
            }
        };
        memStore.init((Configuration)this.conf);
        RMStateStore.RMState rmState = memStore.getState();
        Map rmAppState = rmState.getApplicationState();
        MockRM rm1 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm1.start();
        MockNM nm1 = rm1.registerNode("127.0.0.1:1234", 15120);
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        MockAM am0 = MockRM.launchAndRegisterAM(app0, rm1, nm1);
        FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (String)"", (String)"");
        am0.unregisterAppAttempt(req, true);
        rm1.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.FINISHING);
        Assert.assertNull((Object)((ApplicationStateData)rmAppState.get(app0.getApplicationId())).getState());
        MockRM rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        rm2.start();
        rm2.waitForState(app0.getCurrentAppAttempt().getAppAttemptId(), RMAppAttemptState.FINISHED);
        rm2.waitForState(app0.getApplicationId(), RMAppState.FINISHED);
        Assert.assertEquals((Object)RMAppState.FINISHED, (Object)((ApplicationStateData)rmAppState.get(app0.getApplicationId())).getState());
    }

    @Test(timeout=60000L)
    public void testRMRestartFailedApp() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        MockRM rm1 = this.createMockRM(this.conf);
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)rm1.getRMStateStore();
        Map rmAppState = memStore.getState().getApplicationState();
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        MockAM am0 = this.launchAM(app0, rm1, nm1);
        nm1.nodeHeartbeat(am0.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm1.waitForState(app0.getApplicationId(), RMAppState.FAILED);
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(app0.getApplicationId());
        Assert.assertEquals((Object)RMAppState.FAILED, (Object)appState.getState());
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)appState.getAttempt(am0.getApplicationAttemptId()).getState());
        MockRM rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm2.start();
        RMApp loadedApp0 = (RMApp)rm2.getRMContext().getRMApps().get(app0.getApplicationId());
        rm2.waitForState(app0.getApplicationId(), RMAppState.FAILED);
        rm2.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        Assert.assertEquals((Object)app0.getUser(), (Object)loadedApp0.getUser());
        Assert.assertEquals((long)1L, (long)loadedApp0.getAppAttempts().size());
        this.verifyAppReportAfterRMRestart(app0, rm2);
        Assert.assertTrue((boolean)app0.getDiagnostics().toString().contains("Failing the application."));
    }

    @Test(timeout=60000L)
    public void testRMRestartKilledApp() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = this.createMockRM(this.conf);
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)rm1.getRMStateStore();
        Map rmAppState = memStore.getState().getApplicationState();
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        MockAM am0 = this.launchAM(app0, rm1, nm1);
        rm1.killApp(app0.getApplicationId());
        rm1.waitForState(app0.getApplicationId(), RMAppState.KILLED);
        rm1.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.KILLED);
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(app0.getApplicationId());
        Assert.assertEquals((Object)RMAppState.KILLED, (Object)appState.getState());
        Assert.assertEquals((Object)RMAppAttemptState.KILLED, (Object)appState.getAttempt(am0.getApplicationAttemptId()).getState());
        String trackingUrl = app0.getCurrentAppAttempt().getOriginalTrackingUrl();
        Assert.assertNotNull((Object)trackingUrl);
        MockRM rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm2.start();
        RMApp loadedApp0 = (RMApp)rm2.getRMContext().getRMApps().get(app0.getApplicationId());
        rm2.waitForState(app0.getApplicationId(), RMAppState.KILLED);
        rm2.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.KILLED);
        Assert.assertEquals((long)1L, (long)loadedApp0.getAppAttempts().size());
        ApplicationReport appReport = this.verifyAppReportAfterRMRestart(app0, rm2);
        Assert.assertEquals((Object)app0.getDiagnostics().toString(), (Object)appReport.getDiagnostics());
        Assert.assertEquals((Object)trackingUrl, (Object)loadedApp0.getCurrentAppAttempt().getOriginalTrackingUrl());
    }

    @Test(timeout=60000L)
    public void testRMRestartKilledAppWithNoAttempts() throws Exception {
        MockMemoryRMStateStore memStore = new MockMemoryRMStateStore(){

            public synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptState) throws Exception {
            }

            public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptState) throws Exception {
            }
        };
        memStore.init((Configuration)this.conf);
        MockRM rm1 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm1.start();
        RMApp app0 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(-1).withCredentials(null).withAppType("MAPREDUCE").withWaitForAppAcceptedState(false).build());
        rm1.killApp(app0.getApplicationId());
        rm1.waitForState(app0.getApplicationId(), RMAppState.KILLED);
        MockRM rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm2.start();
        RMApp loadedApp0 = (RMApp)rm2.getRMContext().getRMApps().get(app0.getApplicationId());
        rm2.waitForState(loadedApp0.getApplicationId(), RMAppState.KILLED);
        Assert.assertTrue((loadedApp0.getAppAttempts().size() == 0 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testRMRestartSucceededApp() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = this.createMockRM(this.conf);
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)rm1.getRMStateStore();
        Map rmAppState = memStore.getState().getApplicationState();
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        MockAM am0 = this.launchAM(app0, rm1, nm1);
        FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (String)"diagnostics", (String)"trackingUrl");
        this.finishApplicationMaster(app0, rm1, nm1, am0, req);
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(app0.getApplicationId());
        ApplicationAttemptStateData attemptState0 = appState.getAttempt(am0.getApplicationAttemptId());
        Assert.assertEquals((Object)"diagnostics", (Object)attemptState0.getDiagnostics());
        Assert.assertEquals((Object)FinalApplicationStatus.SUCCEEDED, (Object)attemptState0.getFinalApplicationStatus());
        Assert.assertEquals((Object)"trackingUrl", (Object)attemptState0.getFinalTrackingUrl());
        Assert.assertEquals((long)app0.getFinishTime(), (long)appState.getFinishTime());
        MockRM rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm2.start();
        ApplicationReport appReport = this.verifyAppReportAfterRMRestart(app0, rm2);
        Assert.assertEquals((Object)FinalApplicationStatus.SUCCEEDED, (Object)appReport.getFinalApplicationStatus());
        Assert.assertEquals((Object)"trackingUrl", (Object)appReport.getOriginalTrackingUrl());
    }

    @Test(timeout=60000L)
    public void testRMRestartGetApplicationList() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        MockRM rm1 = new MockRM((Configuration)this.conf){

            protected SystemMetricsPublisher createSystemMetricsPublisher() {
                return (SystemMetricsPublisher)Mockito.spy((Object)super.createSystemMetricsPublisher());
            }
        };
        this.rms.add(rm1);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)rm1.getRMStateStore();
        RMApp app0 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(null).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(1).withCredentials(null).withAppType("myType").build());
        MockAM am0 = this.launchAM(app0, rm1, nm1);
        this.finishApplicationMaster(app0, rm1, nm1, am0);
        RMApp app1 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(null).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(1).withCredentials(null).withAppType("myType").build());
        MockAM am1 = this.launchAM(app1, rm1, nm1);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm1.waitForState(app1.getApplicationId(), RMAppState.FAILED);
        RMApp app2 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(null).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(1).withCredentials(null).withAppType("myType").build());
        MockAM am2 = this.launchAM(app2, rm1, nm1);
        rm1.killApp(app2.getApplicationId());
        rm1.waitForState(app2.getApplicationId(), RMAppState.KILLED);
        rm1.waitForState(am2.getApplicationAttemptId(), RMAppAttemptState.KILLED);
        ((SystemMetricsPublisher)Mockito.verify((Object)rm1.getRMContext().getSystemMetricsPublisher(), (VerificationMode)Mockito.times((int)3))).appCreated((RMApp)ArgumentMatchers.any(RMApp.class), ArgumentMatchers.anyLong());
        MockRM rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore){

            protected RMAppManager createRMAppManager() {
                return (RMAppManager)Mockito.spy((Object)super.createRMAppManager());
            }

            protected SystemMetricsPublisher createSystemMetricsPublisher() {
                return (SystemMetricsPublisher)Mockito.spy((Object)super.createSystemMetricsPublisher());
            }
        };
        this.rms.add(rm2);
        rm2.start();
        ((SystemMetricsPublisher)Mockito.verify((Object)rm2.getRMContext().getSystemMetricsPublisher(), (VerificationMode)Mockito.times((int)3))).appCreated((RMApp)ArgumentMatchers.any(RMApp.class), ArgumentMatchers.anyLong());
        GetApplicationsRequest request1 = GetApplicationsRequest.newInstance(EnumSet.of(YarnApplicationState.FINISHED, YarnApplicationState.KILLED, YarnApplicationState.FAILED));
        GetApplicationsResponse response1 = rm2.getClientRMService().getApplications(request1);
        List appList1 = response1.getApplicationList();
        boolean forApp0 = false;
        boolean forApp1 = false;
        boolean forApp2 = false;
        for (ApplicationReport report : appList1) {
            if (report.getApplicationId().equals((Object)app0.getApplicationId())) {
                Assert.assertEquals((Object)YarnApplicationState.FINISHED, (Object)report.getYarnApplicationState());
                forApp0 = true;
            }
            if (report.getApplicationId().equals((Object)app1.getApplicationId())) {
                Assert.assertEquals((Object)YarnApplicationState.FAILED, (Object)report.getYarnApplicationState());
                forApp1 = true;
            }
            if (!report.getApplicationId().equals((Object)app2.getApplicationId())) continue;
            Assert.assertEquals((Object)YarnApplicationState.KILLED, (Object)report.getYarnApplicationState());
            forApp2 = true;
        }
        Assert.assertTrue((forApp0 && forApp1 && forApp2 ? 1 : 0) != 0);
        HashSet<String> appTypes = new HashSet<String>();
        appTypes.add("myType");
        GetApplicationsRequest request2 = GetApplicationsRequest.newInstance(appTypes);
        GetApplicationsResponse response2 = rm2.getClientRMService().getApplications(request2);
        List appList2 = response2.getApplicationList();
        Assert.assertTrue((3 == appList2.size() ? 1 : 0) != 0);
        ((RMAppManager)Mockito.verify((Object)rm2.getRMAppManager(), (VerificationMode)Mockito.timeout((long)1000L).times(3))).logApplicationSummary((ApplicationId)ArgumentMatchers.isA(ApplicationId.class));
    }

    private MockAM launchAM(RMApp app, MockRM rm, MockNM nm) throws Exception {
        RMAppAttempt attempt = MockRM.waitForAttemptScheduled(app, rm);
        nm.nodeHeartbeat(true);
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        rm.waitForState(app.getApplicationId(), RMAppState.RUNNING);
        return am;
    }

    private ApplicationReport verifyAppReportAfterRMRestart(RMApp app, MockRM rm) throws Exception {
        GetApplicationReportRequest reportRequest = GetApplicationReportRequest.newInstance((ApplicationId)app.getApplicationId());
        GetApplicationReportResponse response = rm.getClientRMService().getApplicationReport(reportRequest);
        ApplicationReport report = response.getApplicationReport();
        Assert.assertEquals((long)app.getStartTime(), (long)report.getStartTime());
        Assert.assertEquals((long)app.getFinishTime(), (long)report.getFinishTime());
        Assert.assertEquals((Object)app.createApplicationState(), (Object)report.getYarnApplicationState());
        Assert.assertTrue((1.0f == report.getProgress() ? 1 : 0) != 0);
        return response.getApplicationReport();
    }

    private void finishApplicationMaster(RMApp rmApp, MockRM rm, MockNM nm, MockAM am) throws Exception {
        FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (String)"", (String)"");
        this.finishApplicationMaster(rmApp, rm, nm, am, req);
    }

    private void finishApplicationMaster(RMApp rmApp, MockRM rm, MockNM nm, MockAM am, FinishApplicationMasterRequest req) throws Exception {
        RMStateStore.RMState rmState = ((MemoryRMStateStore)rm.getRMContext().getStateStore()).getState();
        Map rmAppState = rmState.getApplicationState();
        am.unregisterAppAttempt(req, true);
        rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FINISHING);
        nm.nodeHeartbeat(am.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FINISHED);
        rm.waitForState(rmApp.getApplicationId(), RMAppState.FINISHED);
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(rmApp.getApplicationId());
        Assert.assertEquals((Object)RMAppState.FINISHED, (Object)appState.getState());
        Assert.assertEquals((Object)RMAppAttemptState.FINISHED, (Object)appState.getAttempt(am.getApplicationAttemptId()).getState());
    }

    @Test(timeout=60000L)
    public void testRMRestartOnMaxAppAttempts() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = this.createMockRM(this.conf);
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        Map rmAppState = memStore.getState().getApplicationState();
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(1).withCredentials(null).build());
        RMApp app2 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(-1).withCredentials(null).build());
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(app1.getApplicationId());
        Assert.assertNotNull((Object)appState);
        Assert.assertEquals((long)0L, (long)appState.getAttemptCount());
        Assert.assertEquals((Object)appState.getApplicationSubmissionContext().getApplicationId(), (Object)app1.getApplicationSubmissionContext().getApplicationId());
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app1.getCurrentAppAttempt();
        ApplicationAttemptId attemptId1 = attempt.getAppAttemptId();
        rm1.waitForState(attemptId1, RMAppAttemptState.ALLOCATED);
        Assert.assertEquals((long)1L, (long)appState.getAttemptCount());
        ApplicationAttemptStateData attemptState = appState.getAttempt(attemptId1);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)BuilderUtils.newContainerId((ApplicationAttemptId)attemptId1, (long)1L), (Object)attemptState.getMasterContainer().getId());
        this.conf.setInt("yarn.am.liveness-monitor.expiry-interval-ms", 3000);
        MockRM rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm2.start();
        Assert.assertEquals((long)2L, (long)((RMApp)rm2.getRMContext().getRMApps().get(app2.getApplicationId())).getMaxAppAttempts());
        Assert.assertEquals((long)2L, (long)rm2.getRMContext().getRMApps().size());
        rm2.waitForState(app1.getApplicationId(), RMAppState.FAILED);
        rm2.waitForState(app2.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((Object)RMAppState.FAILED, (Object)((ApplicationStateData)rmAppState.get(app1.getApplicationId())).getState());
        Assert.assertNull((Object)((ApplicationStateData)rmAppState.get(app2.getApplicationId())).getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRMRestartTimelineCollectorContext() throws Exception {
        this.conf.setBoolean("yarn.timeline-service.enabled", true);
        this.conf.setFloat("yarn.timeline-service.version", 2.0f);
        MockRM rm1 = null;
        MockRM rm2 = null;
        try {
            rm1 = this.createMockRM(this.conf);
            rm1.start();
            MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
            Map rmAppState = memStore.getState().getApplicationState();
            MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
            nm1.registerNode();
            RMApp app = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(-1).withCredentials(null).build());
            ApplicationStateData appState = (ApplicationStateData)rmAppState.get(app.getApplicationId());
            Assert.assertNotNull((Object)appState);
            Assert.assertEquals((long)0L, (long)appState.getAttemptCount());
            Assert.assertEquals((Object)appState.getApplicationSubmissionContext().getApplicationId(), (Object)app.getApplicationSubmissionContext().getApplicationId());
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt = app.getCurrentAppAttempt();
            ApplicationAttemptId attemptId1 = attempt.getAppAttemptId();
            rm1.waitForState(attemptId1, RMAppAttemptState.ALLOCATED);
            ApplicationId appId = app.getApplicationId();
            TimelineCollectorContext contextBeforeRestart = rm1.getRMContext().getRMTimelineCollectorManager().get(appId).getTimelineEntityContext();
            rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
            rm2.start();
            Assert.assertEquals((long)1L, (long)rm2.getRMContext().getRMApps().size());
            rm2.waitForState(app.getApplicationId(), RMAppState.ACCEPTED);
            TimelineCollectorContext contextAfterRestart = rm2.getRMContext().getRMTimelineCollectorManager().get(appId).getTimelineEntityContext();
            Assert.assertEquals((String)"Collector contexts for an app should be same across restarts", (Object)contextBeforeRestart, (Object)contextAfterRestart);
        }
        finally {
            this.conf.setBoolean("yarn.timeline-service.enabled", false);
            if (rm1 != null) {
                rm1.close();
            }
            if (rm2 != null) {
                rm2.close();
            }
        }
    }

    @Test(timeout=60000L)
    public void testDelegationTokenRestoredInDelegationTokenRenewer() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        this.conf.set("hadoop.security.authentication", "kerberos");
        this.conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        this.conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        TestSecurityMockRM rm1 = new TestSecurityMockRM((Configuration)this.conf);
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        Map rmAppState = memStore.getState().getApplicationState();
        rm1.start();
        HashSet<Token<RMDelegationTokenIdentifier>> tokenSet = new HashSet<Token<RMDelegationTokenIdentifier>>();
        Credentials ts = new Credentials();
        Text userText1 = new Text("user1");
        RMDelegationTokenIdentifier dtId1 = new RMDelegationTokenIdentifier(userText1, new Text("renewer1"), userText1);
        Token token1 = new Token((TokenIdentifier)dtId1, (SecretManager)rm1.getRMContext().getRMDelegationTokenSecretManager());
        SecurityUtil.setTokenService((Token)token1, (InetSocketAddress)rmAddr);
        ts.addToken(userText1, token1);
        tokenSet.add(token1);
        Text userText2 = new Text("user2");
        RMDelegationTokenIdentifier dtId2 = new RMDelegationTokenIdentifier(userText2, new Text("renewer2"), userText2);
        Token token2 = new Token((TokenIdentifier)dtId2, (SecretManager)rm1.getRMContext().getRMDelegationTokenSecretManager());
        SecurityUtil.setTokenService((Token)token2, (InetSocketAddress)rmAddr);
        ts.addToken(userText2, token2);
        tokenSet.add(token2);
        RMApp app = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(1).withCredentials(ts).build());
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(app.getApplicationId());
        Assert.assertNotNull((Object)appState);
        Assert.assertEquals(tokenSet, (Object)rm1.getRMContext().getDelegationTokenRenewer().getDelegationTokens());
        DataOutputBuffer dob = new DataOutputBuffer();
        ts.writeTokenStorageToStream((DataOutputStream)dob);
        ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        securityTokens.rewind();
        Assert.assertEquals((Object)securityTokens, (Object)appState.getApplicationSubmissionContext().getAMContainerSpec().getTokens());
        TestSecurityMockRM rm2 = new TestSecurityMockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm2.start();
        this.waitForTokensToBeRenewed(rm2, tokenSet);
        Assert.assertEquals(tokenSet, (Object)rm2.getRMContext().getDelegationTokenRenewer().getDelegationTokens());
    }

    private void waitForTokensToBeRenewed(MockRM rm2, HashSet<Token<RMDelegationTokenIdentifier>> tokenSet) throws Exception {
        int waitCnt = 100;
        while (waitCnt-- > 0 && !tokenSet.equals(rm2.getRMContext().getDelegationTokenRenewer().getDelegationTokens())) {
            Thread.sleep(10L);
        }
    }

    @Test(timeout=60000L)
    public void testAppAttemptTokensRestoredOnRMRestart() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        this.conf.set("hadoop.security.authentication", "kerberos");
        this.conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        this.conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        TestSecurityMockRM rm1 = new TestSecurityMockRM((Configuration)this.conf);
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        Map rmAppState = memStore.getState().getApplicationState();
        rm1.start();
        MockNM nm1 = new MockNM("0.0.0.0:4321", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withQueue("default").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(app1.getApplicationId());
        Assert.assertNotNull((Object)appState);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        ApplicationAttemptId attemptId1 = attempt1.getAppAttemptId();
        rm1.waitForState(attemptId1, RMAppAttemptState.ALLOCATED);
        ApplicationAttemptStateData attemptState = appState.getAttempt(attemptId1);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)BuilderUtils.newContainerId((ApplicationAttemptId)attemptId1, (long)1L), (Object)attemptState.getMasterContainer().getId());
        byte[] clientTokenMasterKey = attempt1.getClientTokenMasterKey().getEncoded();
        Credentials savedCredentials = attemptState.getAppAttemptTokens();
        Assert.assertArrayEquals((String)"client token master key not saved", (byte[])clientTokenMasterKey, (byte[])savedCredentials.getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME));
        TestSecurityMockRM rm2 = new TestSecurityMockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm2.start();
        RMApp loadedApp1 = (RMApp)rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        RMAppAttempt loadedAttempt1 = loadedApp1.getRMAppAttempt(attemptId1);
        Assert.assertNotNull((Object)loadedAttempt1);
        Assert.assertEquals((String)"client token master key not restored", (Object)attempt1.getClientTokenMasterKey(), (Object)loadedAttempt1.getClientTokenMasterKey());
        Assert.assertArrayEquals((byte[])clientTokenMasterKey, (byte[])rm2.getClientToAMTokenSecretManager().getMasterKey(attemptId1).getEncoded());
        Token amrmToken = loadedAttempt1.getAMRMToken();
        Assert.assertArrayEquals((byte[])amrmToken.getPassword(), (byte[])rm2.getRMContext().getAMRMTokenSecretManager().retrievePassword((AMRMTokenIdentifier)amrmToken.decodeIdentifier()));
    }

    @Test(timeout=60000L)
    public void testRMDelegationTokenRestoredOnRMRestart() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        this.conf.set("hadoop.security.authentication", "kerberos");
        this.conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        this.conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        this.conf.set("yarn.resourcemanager.address", "localhost:8032");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        TestSecurityMockRM rm1 = new TestSecurityMockRM((Configuration)this.conf);
        rm1.start();
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        RMStateStore.RMState rmState = memStore.getState();
        Map rmAppState = rmState.getApplicationState();
        Map rmDTState = rmState.getRMDTSecretManagerState().getTokenState();
        Set rmDTMasterKeyState = rmState.getRMDTSecretManagerState().getMasterKeyState();
        Credentials ts = new Credentials();
        GetDelegationTokenRequest request1 = GetDelegationTokenRequest.newInstance((String)"renewer1");
        UserGroupInformation.getCurrentUser().setAuthenticationMethod(SaslRpcServer.AuthMethod.KERBEROS);
        GetDelegationTokenResponse response1 = rm1.getClientRMService().getDelegationToken(request1);
        org.apache.hadoop.yarn.api.records.Token delegationToken1 = response1.getRMDelegationToken();
        Token token1 = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)delegationToken1, (InetSocketAddress)rmAddr);
        RMDelegationTokenIdentifier dtId1 = (RMDelegationTokenIdentifier)token1.decodeIdentifier();
        HashSet<RMDelegationTokenIdentifier> tokenIdentSet = new HashSet<RMDelegationTokenIdentifier>();
        ts.addToken(token1.getService(), token1);
        tokenIdentSet.add(dtId1);
        RMApp app = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(1).withCredentials(ts).build());
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(app.getApplicationId());
        Assert.assertNotNull((Object)appState);
        Set allKeysRM1 = rm1.getRMContext().getRMDelegationTokenSecretManager().getAllMasterKeys();
        Assert.assertEquals((Object)allKeysRM1, (Object)rmDTMasterKeyState);
        Map allTokensRM1 = rm1.getRMContext().getRMDelegationTokenSecretManager().getAllTokens();
        Assert.assertEquals(tokenIdentSet, allTokensRM1.keySet());
        Assert.assertEquals((Object)allTokensRM1, (Object)rmDTState);
        Assert.assertEquals((long)rm1.getRMContext().getRMDelegationTokenSecretManager().getLatestDTSequenceNumber(), (long)rmState.getRMDTSecretManagerState().getDTSequenceNumber());
        GetDelegationTokenRequest request2 = GetDelegationTokenRequest.newInstance((String)"renewer2");
        GetDelegationTokenResponse response2 = rm1.getClientRMService().getDelegationToken(request2);
        org.apache.hadoop.yarn.api.records.Token delegationToken2 = response2.getRMDelegationToken();
        Token token2 = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)delegationToken2, (InetSocketAddress)rmAddr);
        RMDelegationTokenIdentifier dtId2 = (RMDelegationTokenIdentifier)token2.decodeIdentifier();
        try {
            rm1.getRMContext().getRMDelegationTokenSecretManager().cancelToken(token2, UserGroupInformation.getCurrentUser().getUserName());
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((long)rm1.getRMContext().getRMDelegationTokenSecretManager().getLatestDTSequenceNumber(), (long)dtId2.getSequenceNumber());
        Assert.assertFalse((boolean)rmDTState.containsKey(dtId2));
        TestSecurityMockRM rm2 = new TestSecurityMockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm2.start();
        Map allTokensRM2 = rm2.getRMContext().getRMDelegationTokenSecretManager().getAllTokens();
        Assert.assertEquals(allTokensRM2.keySet(), allTokensRM1.keySet());
        Assert.assertTrue((boolean)rm2.getRMContext().getRMDelegationTokenSecretManager().getAllMasterKeys().containsAll(allKeysRM1));
        Assert.assertEquals((long)rm1.getRMContext().getRMDelegationTokenSecretManager().getLatestDTSequenceNumber(), (long)rm2.getRMContext().getRMDelegationTokenSecretManager().getLatestDTSequenceNumber());
        Long renewDateBeforeRenew = (Long)allTokensRM2.get(dtId1);
        try {
            Thread.sleep(1L);
            rm2.getRMContext().getRMDelegationTokenSecretManager().renewToken(token1, "renewer1");
        }
        catch (Exception e) {
            Assert.fail();
        }
        allTokensRM2 = rm2.getRMContext().getRMDelegationTokenSecretManager().getAllTokens();
        Long renewDateAfterRenew = (Long)allTokensRM2.get(dtId1);
        Assert.assertTrue((renewDateAfterRenew > renewDateBeforeRenew ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rmDTState.containsValue(renewDateAfterRenew));
        Assert.assertFalse((boolean)rmDTState.containsValue(renewDateBeforeRenew));
        try {
            rm2.getRMContext().getRMDelegationTokenSecretManager().cancelToken(token1, UserGroupInformation.getCurrentUser().getUserName());
        }
        catch (Exception e) {
            Assert.fail();
        }
        allTokensRM2 = rm2.getRMContext().getRMDelegationTokenSecretManager().getAllTokens();
        Assert.assertFalse((boolean)allTokensRM2.containsKey(dtId1));
        Assert.assertFalse((boolean)rmDTState.containsKey(dtId1));
    }

    @Test(timeout=60000L)
    public void testAppSubmissionWithOldDelegationTokenAfterRMRestart() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        this.conf.set("hadoop.security.authentication", "kerberos");
        this.conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        this.conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        this.conf.set("yarn.resourcemanager.address", "localhost:8032");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        TestSecurityMockRM rm1 = new TestSecurityMockRM((Configuration)this.conf);
        rm1.start();
        GetDelegationTokenRequest request1 = GetDelegationTokenRequest.newInstance((String)"renewer1");
        UserGroupInformation.getCurrentUser().setAuthenticationMethod(SaslRpcServer.AuthMethod.KERBEROS);
        GetDelegationTokenResponse response1 = rm1.getClientRMService().getDelegationToken(request1);
        Token token1 = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)response1.getRMDelegationToken(), (InetSocketAddress)rmAddr);
        TestSecurityMockRM rm2 = new TestSecurityMockRM((Configuration)this.conf, rm1.getRMStateStore());
        rm2.start();
        Credentials ts = new Credentials();
        ts.addToken(token1.getService(), token1);
        RMApp app = MockRMAppSubmitter.submit(rm2, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm2).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(1).withCredentials(ts).build());
        rm2.waitForState(app.getApplicationId(), RMAppState.ACCEPTED);
    }

    @Test(timeout=60000L)
    public void testRMStateStoreDispatcherDrainedOnRMStop() throws Exception {
        MemoryRMStateStore memStore = new MemoryRMStateStore(){
            volatile boolean wait = true;

            public void serviceStop() throws Exception {
                this.wait = false;
                super.serviceStop();
            }

            protected void handleStoreEvent(RMStateStoreEvent event) {
                if (!(event instanceof RMStateStoreAMRMTokenEvent || event instanceof RMStateStoreRMDTEvent || event instanceof RMStateStoreRMDTMasterKeyEvent || event instanceof RMStateStoreProxyCAEvent)) {
                    while (this.wait) {
                    }
                }
                super.handleStoreEvent(event);
            }
        };
        memStore.init((Configuration)this.conf);
        MockRM rm1 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm1.disableDrainEventsImplicitly();
        rm1.start();
        ArrayList<RMApp> appList = new ArrayList<RMApp>();
        int NUM_APPS = 5;
        for (int i = 0; i < 5; ++i) {
            RMApp app = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(-1).withCredentials(null).withAppType("MAPREDUCE").withWaitForAppAcceptedState(false).build());
            appList.add(app);
            rm1.waitForState(app.getApplicationId(), RMAppState.NEW_SAVING);
        }
        Map rmAppState = memStore.getState().getApplicationState();
        Assert.assertTrue((rmAppState.size() == 0 ? 1 : 0) != 0);
        rm1.stop();
        for (RMApp app : appList) {
            ApplicationStateData appState = (ApplicationStateData)rmAppState.get(app.getApplicationId());
            Assert.assertNotNull((Object)appState);
            Assert.assertEquals((long)0L, (long)appState.getAttemptCount());
            Assert.assertEquals((Object)appState.getApplicationSubmissionContext().getApplicationId(), (Object)app.getApplicationSubmissionContext().getApplicationId());
        }
        Assert.assertTrue((rmAppState.size() == 5 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testFinishedAppRemovalAfterRMRestart() throws Exception {
        this.conf.setInt("yarn.resourcemanager.max-completed-applications", 1);
        MockRM rm1 = this.createMockRM(this.conf);
        rm1.start();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)rm1.getRMStateStore();
        RMStateStore.RMState rmState = memStore.getState();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        MockAM am0 = this.launchAM(app0, rm1, nm1);
        this.finishApplicationMaster(app0, rm1, nm1, am0);
        MockRM rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm2.start();
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        nm1 = rm2.registerNode("127.0.0.1:1234", 15120);
        Map rmAppState = rmState.getApplicationState();
        Assert.assertEquals((Object)RMAppState.FINISHED, (Object)((ApplicationStateData)rmAppState.get(app0.getApplicationId())).getState());
        rm2.waitForState(app0.getApplicationId(), RMAppState.FINISHED);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(200L, rm2);
        MockAM am1 = this.launchAM(app1, rm2, nm1);
        this.finishApplicationMaster(app1, rm2, nm1, am1);
        rm2.drainEvents();
        Assert.assertNull(rm2.getRMContext().getRMApps().get(app0.getApplicationId()));
        Assert.assertNull(rmAppState.get(app0.getApplicationId()));
    }

    @Test(timeout=10000L)
    public void testRMShutdown() throws Exception {
        MockMemoryRMStateStore memStore = new MockMemoryRMStateStore(){

            public synchronized void checkVersion() throws Exception {
                throw new Exception("Invalid version.");
            }
        };
        memStore.init((Configuration)this.conf);
        MockRM rm1 = null;
        try {
            rm1 = this.createMockRM(this.conf, (RMStateStore)memStore);
            rm1.start();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid version."));
        }
        Assert.assertTrue((rm1.getServiceState() == Service.STATE.STOPPED ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testClientRetryOnKillingApplication() throws Exception {
        KillApplicationResponse response;
        TestMemoryRMStateStore memStore = new TestMemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        MockRM rm1 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(null).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(1).withCredentials(null).withAppType("myType").build());
        MockAM am1 = this.launchAM(app1, rm1, nm1);
        int count = 0;
        while (!(response = rm1.killApp(app1.getApplicationId())).getIsKillCompleted()) {
            Thread.sleep(100L);
            ++count;
        }
        Assert.assertTrue((count >= 1 ? 1 : 0) != 0);
        rm1.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.KILLED);
        rm1.waitForState(app1.getApplicationId(), RMAppState.KILLED);
        Assert.assertEquals((long)2L, (long)memStore.updateAttempt);
        Assert.assertEquals((long)3L, (long)memStore.updateApp);
    }

    @Test(timeout=20000L)
    public void testAppFailedOnSubmissionSavedInStateStore() throws Exception {
        this.conf.set("hadoop.security.authentication", "kerberos");
        this.conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        this.conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        TestSecurityMockRM rm1 = new TestSecurityMockRM((Configuration)this.conf){

            protected DelegationTokenRenewer createDelegationTokenRenewer() {
                return new TestDelegationTokenRenewer();
            }

            class TestDelegationTokenRenewer
            extends DelegationTokenRenewer {
                TestDelegationTokenRenewer() {
                }

                public void addApplicationAsync(ApplicationId applicationId, Credentials ts, boolean shouldCancelAtEnd, String user, Configuration appConf) {
                    throw new RuntimeException("failed to submit app");
                }
            }
        };
        rm1.start();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)rm1.getRMStateStore();
        RMApp app1 = null;
        try {
            app1 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(-1).withCredentials(null).withAppType("MAPREDUCE").withWaitForAppAcceptedState(false).build());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        app1 = (RMApp)rm1.getRMContext().getRMApps().values().iterator().next();
        rm1.waitForState(app1.getApplicationId(), RMAppState.FAILED);
        Assert.assertEquals((Object)RMAppState.FAILED, (Object)((ApplicationStateData)memStore.getState().getApplicationState().get(app1.getApplicationId())).getState());
        TestSecurityMockRM rm2 = new TestSecurityMockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm2.start();
        rm2.waitForState(app1.getApplicationId(), RMAppState.FAILED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testAppRecoveredInOrderOnRMRestart() throws Exception {
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        for (int i = 10; i > 0; --i) {
            ApplicationStateData appState = (ApplicationStateData)Mockito.mock(ApplicationStateData.class);
            ApplicationSubmissionContext context = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
            Mockito.when((Object)appState.getApplicationSubmissionContext()).thenReturn((Object)context);
            Mockito.when((Object)context.getApplicationId()).thenReturn((Object)ApplicationId.newInstance((long)1234L, (int)i));
            memStore.getState().getApplicationState().put(appState.getApplicationSubmissionContext().getApplicationId(), appState);
        }
        MockRM rm1 = new MockRM((Configuration)this.conf, (RMStateStore)memStore){

            protected RMAppManager createRMAppManager() {
                return new TestRMAppManager((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.masterService, this.applicationACLsManager, (Configuration)TestRMRestart.this.conf);
            }

            class TestRMAppManager
            extends RMAppManager {
                ApplicationId prevId;

                public TestRMAppManager(RMContext context, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationACLsManager applicationACLsManager, Configuration conf) {
                    super(context, scheduler, masterService, applicationACLsManager, conf);
                    this.prevId = ApplicationId.newInstance((long)1234L, (int)0);
                }

                protected void recoverApplication(ApplicationStateData appState, RMStateStore.RMState rmState) throws Exception {
                    Assert.assertTrue((rmState.getApplicationState().size() > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((appState.getApplicationSubmissionContext().getApplicationId().compareTo(this.prevId) > 0 ? 1 : 0) != 0);
                    this.prevId = appState.getApplicationSubmissionContext().getApplicationId();
                }
            }
        };
        try {
            rm1.start();
        }
        finally {
            rm1.stop();
        }
    }

    @Test(timeout=60000L)
    public void testQueueMetricsOnRMRestart() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = this.createMockRM(this.conf);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        QueueMetrics qm1 = rm1.getResourceScheduler().getRootQueueMetrics();
        this.resetQueueMetrics(qm1);
        this.assertQueueMetrics(qm1, 0, 0, 0, 0);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        ApplicationAttemptId attemptId1 = attempt1.getAppAttemptId();
        rm1.waitForState(attemptId1, RMAppAttemptState.SCHEDULED);
        this.assertQueueMetrics(qm1, 1, 1, 0, 0);
        nm1.nodeHeartbeat(true);
        rm1.waitForState(attemptId1, RMAppAttemptState.ALLOCATED);
        MockAM am1 = rm1.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        am1.allocate("127.0.0.1", 1000, 1, new ArrayList<ContainerId>());
        nm1.nodeHeartbeat(true);
        List conts = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        while (conts.size() == 0) {
            nm1.nodeHeartbeat(true);
            conts.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(500L);
        }
        this.assertQueueMetrics(qm1, 1, 0, 1, 0);
        MockRM rm2 = this.createMockRM(this.conf, rm1.getRMStateStore());
        QueueMetrics qm2 = rm2.getResourceScheduler().getRootQueueMetrics();
        this.resetQueueMetrics(qm2);
        this.assertQueueMetrics(qm2, 0, 0, 0, 0);
        rm2.start();
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        RMApp loadedApp1 = (RMApp)rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        nm1.nodeHeartbeat(true);
        nm1 = new MockNM("127.0.0.1:1234", 15120, rm2.getResourceTrackerService());
        NMContainerStatus status = TestRMRestart.createNMContainerStatus(loadedApp1.getCurrentAppAttempt().getAppAttemptId(), 1, ContainerState.COMPLETE);
        nm1.registerNode(Arrays.asList(status), null);
        while (loadedApp1.getAppAttempts().size() != 2) {
            Thread.sleep(200L);
        }
        attempt1 = loadedApp1.getCurrentAppAttempt();
        attemptId1 = attempt1.getAppAttemptId();
        rm2.waitForState(attemptId1, RMAppAttemptState.SCHEDULED);
        this.assertQueueMetrics(qm2, 1, 1, 0, 0);
        nm1.nodeHeartbeat(true);
        rm2.waitForState(attemptId1, RMAppAttemptState.ALLOCATED);
        this.assertQueueMetrics(qm2, 1, 0, 1, 0);
        am1 = rm2.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        am1.allocate("127.0.0.1", 1000, 3, new ArrayList<ContainerId>());
        nm1.nodeHeartbeat(true);
        conts = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        while (conts.size() == 0) {
            nm1.nodeHeartbeat(true);
            conts.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(500L);
        }
        this.finishApplicationMaster(loadedApp1, rm2, nm1, am1);
        rm2.waitForAppRemovedFromScheduler(loadedApp1.getApplicationId());
        this.assertQueueMetrics(qm2, 1, 0, 0, 1);
    }

    private void resetQueueMetrics(QueueMetrics qm) {
        this.appsSubmittedCarryOn = qm.getAppsSubmitted();
        this.appsPendingCarryOn = qm.getAppsPending();
        this.appsRunningCarryOn = qm.getAppsRunning();
        this.appsCompletedCarryOn = qm.getAppsCompleted();
    }

    private void assertQueueMetrics(QueueMetrics qm, int appsSubmitted, int appsPending, int appsRunning, int appsCompleted) {
        Assert.assertEquals((long)(appsSubmitted + this.appsSubmittedCarryOn), (long)qm.getAppsSubmitted());
        Assert.assertEquals((long)(appsPending + this.appsPendingCarryOn), (long)qm.getAppsPending());
        Assert.assertEquals((long)(appsRunning + this.appsRunningCarryOn), (long)qm.getAppsRunning());
        Assert.assertEquals((long)(appsCompleted + this.appsCompletedCarryOn), (long)qm.getAppsCompleted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDecommissionedNMsMetricsOnRMRestart() throws Exception {
        this.conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.writeToHostsFile("");
        MockRM rm1 = null;
        MockRM rm2 = null;
        try {
            rm1 = new MockRM((Configuration)this.conf);
            rm1.start();
            MockNM nm1 = rm1.registerNode("localhost:1234", 8000);
            MockNM nm2 = rm1.registerNode("host2:1234", 8000);
            Resource expectedCapability = Resource.newInstance((long)nm1.getMemory(), (int)nm1.getvCores());
            String expectedVersion = nm1.getVersion();
            Assert.assertEquals((long)0L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
            String ip = NetUtils.normalizeHostName((String)"localhost");
            this.writeToHostsFile("host2", ip);
            rm1.getNodesListManager().refreshNodes((Configuration)this.conf);
            NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
            Assert.assertTrue((boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
            nodeHeartbeat = nm2.nodeHeartbeat(true);
            Assert.assertTrue((String)"The decommisioned metrics are not updated", (boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
            rm1.drainEvents();
            Assert.assertEquals((long)2L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
            this.verifyNodesAfterDecom(rm1, 2, expectedCapability, expectedVersion);
            rm1.stop();
            rm1 = null;
            Assert.assertEquals((long)0L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
            rm2 = new MockRM((Configuration)this.conf);
            rm2.start();
            rm2.drainEvents();
            Assert.assertEquals((long)2L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
            this.verifyNodesAfterDecom(rm2, 2, Resource.newInstance((int)0, (int)0), "unknown");
        }
        finally {
            if (rm1 != null) {
                rm1.stop();
            }
            if (rm2 != null) {
                rm2.stop();
            }
        }
    }

    private void verifyNodesAfterDecom(MockRM rm, int numNodes, Resource expectedCapability, String expectedVersion) {
        ConcurrentMap inactiveRMNodes = rm.getRMContext().getInactiveRMNodes();
        Assert.assertEquals((long)numNodes, (long)inactiveRMNodes.size());
        for (RMNode rmNode : inactiveRMNodes.values()) {
            Assert.assertEquals((Object)expectedCapability, (Object)rmNode.getTotalCapability());
            Assert.assertEquals((Object)expectedVersion, (Object)rmNode.getNodeManagerVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testSynchronouslyRenewDTOnRecovery() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        this.conf.set("hadoop.security.authentication", "kerberos");
        this.conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        this.conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        TestSecurityMockRM rm1 = new TestSecurityMockRM((Configuration)this.conf);
        rm1.start();
        final MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        final MockAM am0 = MockRM.launchAndRegisterAM(app0, rm1, nm1);
        TestSecurityMockRM rm2 = new TestSecurityMockRM((Configuration)this.conf, rm1.getRMStateStore()){

            @Override
            protected ResourceTrackerService createResourceTrackerService() {
                return new ResourceTrackerService((RMContext)this.rmContext, this.nodesListManager, this.nmLivelinessMonitor, this.rmContext.getContainerTokenSecretManager(), this.rmContext.getNMTokenSecretManager()){

                    protected void serviceStart() throws Exception {
                        super.serviceStart();
                        nm1.setResourceTrackerService(this.getResourceTrackerService());
                        NMContainerStatus status = TestRMRestart.createNMContainerStatus(am0.getApplicationAttemptId(), 1, ContainerState.COMPLETE);
                        nm1.registerNode(Arrays.asList(status), null);
                    }
                };
            }
        };
        try {
            rm2.start();
            RMApp loadedApp0 = (RMApp)rm2.getRMContext().getRMApps().get(app0.getApplicationId());
            int timeoutSecs = 0;
            while (loadedApp0.getAppAttempts().size() != 2 && timeoutSecs++ < 40) {
                Thread.sleep(200L);
            }
            MockAM am1 = MockRM.launchAndRegisterAM(loadedApp0, rm2, nm1);
            MockRM.finishAMAndVerifyAppState(loadedApp0, rm2, nm1, am1);
        }
        finally {
            rm2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToHostsFile(String ... hosts) throws IOException {
        if (!this.hostFile.exists()) {
            TEMP_DIR.mkdirs();
            this.hostFile.createNewFile();
        }
        FileOutputStream fStream = null;
        try {
            fStream = new FileOutputStream(this.hostFile);
            for (int i = 0; i < hosts.length; ++i) {
                fStream.write(hosts[i].getBytes());
                fStream.write(System.getProperty("line.separator").getBytes());
            }
        }
        finally {
            if (fStream != null) {
                IOUtils.closeStream((Closeable)fStream);
                fStream = null;
            }
        }
    }

    public static NMContainerStatus createNMContainerStatus(ApplicationAttemptId appAttemptId, int id, ContainerState containerState) {
        return TestRMRestart.createNMContainerStatus(appAttemptId, id, containerState, "");
    }

    public static NMContainerStatus createNMContainerStatus(ApplicationAttemptId appAttemptId, int id, ContainerState containerState, String nodeLabelExpression) {
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)id);
        NMContainerStatus containerReport = NMContainerStatus.newInstance((ContainerId)containerId, (int)0, (ContainerState)containerState, (Resource)Resource.newInstance((int)1024, (int)1), (String)"recover container", (int)0, (Priority)Priority.newInstance((int)0), (long)0L, (String)nodeLabelExpression, (ExecutionType)ExecutionType.GUARANTEED, (long)-1L);
        return containerReport;
    }

    @Test(timeout=20000L)
    public void testRMRestartRecoveringNodeLabelManager() throws Exception {
        File nodeLabelFsStoreDir = new File("target", this.getClass().getSimpleName() + "-testRMRestartRecoveringNodeLabelManager");
        if (nodeLabelFsStoreDir.exists()) {
            FileUtils.deleteDirectory((File)nodeLabelFsStoreDir);
        }
        nodeLabelFsStoreDir.deleteOnExit();
        String nodeLabelFsStoreDirURI = nodeLabelFsStoreDir.toURI().toString();
        this.conf.set("yarn.node-labels.fs-store.root-dir", nodeLabelFsStoreDirURI);
        this.conf.setBoolean("yarn.node-labels.enabled", true);
        MockRM rm1 = new MockRM((Configuration)this.conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                RMNodeLabelsManager mgr = new RMNodeLabelsManager();
                mgr.init(this.getConfig());
                return mgr;
            }
        };
        rm1.init((Configuration)this.conf);
        rm1.start();
        RMNodeLabelsManager nodeLabelManager = rm1.getRMContext().getNodeLabelManager();
        HashSet<String> clusterNodeLabels = new HashSet<String>();
        clusterNodeLabels.add("x");
        clusterNodeLabels.add("y");
        clusterNodeLabels.add("z");
        nodeLabelManager.addToCluserNodeLabelsWithDefaultExclusivity(clusterNodeLabels);
        NodeId n1 = NodeId.newInstance((String)"h1", (int)0);
        nodeLabelManager.addLabelsToNode((Map)ImmutableMap.of((Object)n1, this.toSet("x")));
        clusterNodeLabels.remove("z");
        nodeLabelManager.removeFromClusterNodeLabels(this.toSet("z"));
        nodeLabelManager.replaceLabelsOnNode((Map)ImmutableMap.of((Object)n1, this.toSet("y")));
        int count = 10;
        while (count-- > 0 && nodeLabelManager.getNodeLabels().size() <= 0) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)clusterNodeLabels.size(), (long)nodeLabelManager.getClusterNodeLabelNames().size());
        Map nodeLabels = nodeLabelManager.getNodeLabels();
        Assert.assertEquals((long)1L, (long)nodeLabelManager.getNodeLabels().size());
        Assert.assertTrue((boolean)((Set)nodeLabels.get(n1)).equals(this.toSet("y")));
        MockRM rm2 = new MockRM((Configuration)this.conf, rm1.getRMStateStore()){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                RMNodeLabelsManager mgr = new RMNodeLabelsManager();
                mgr.init(this.getConfig());
                return mgr;
            }
        };
        rm2.init((Configuration)this.conf);
        rm2.start();
        nodeLabelManager = rm2.getRMContext().getNodeLabelManager();
        Assert.assertEquals((long)clusterNodeLabels.size(), (long)nodeLabelManager.getClusterNodeLabelNames().size());
        nodeLabels = nodeLabelManager.getNodeLabels();
        Assert.assertEquals((long)1L, (long)nodeLabelManager.getNodeLabels().size());
        Assert.assertTrue((boolean)((Set)nodeLabels.get(n1)).equals(this.toSet("y")));
        rm1.stop();
        rm2.stop();
    }

    @Test(timeout=60000L)
    public void testRMRestartFailAppAttempt() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        int maxAttempt = this.conf.getInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = this.createMockRM(this.conf);
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        Map rmAppState = memStore.getState().getApplicationState();
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        MockAM am0 = this.launchAM(app0, rm1, nm1);
        ApplicationId applicationId = app0.getApplicationId();
        ApplicationAttemptId appAttemptId1 = app0.getCurrentAppAttempt().getAppAttemptId();
        Assert.assertEquals((long)1L, (long)appAttemptId1.getAttemptId());
        rm1.failApplicationAttempt(appAttemptId1);
        rm1.waitForState(appAttemptId1, RMAppAttemptState.FAILED);
        rm1.waitForState(applicationId, RMAppState.ACCEPTED);
        ApplicationAttemptId appAttemptId2 = app0.getCurrentAppAttempt().getAppAttemptId();
        Assert.assertEquals((long)2L, (long)appAttemptId2.getAttemptId());
        rm1.waitForState(appAttemptId2, RMAppAttemptState.SCHEDULED);
        MockRM rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm2.start();
        RMApp loadedApp0 = (RMApp)rm2.getRMContext().getRMApps().get(applicationId);
        rm2.waitForState(applicationId, RMAppState.ACCEPTED);
        rm2.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        Thread.sleep(1000L);
        Assert.assertEquals((long)2L, (long)loadedApp0.getAppAttempts().size());
        rm2.waitForState(appAttemptId2, RMAppAttemptState.SCHEDULED);
        appAttemptId2 = loadedApp0.getCurrentAppAttempt().getAppAttemptId();
        Assert.assertEquals((long)2L, (long)appAttemptId2.getAttemptId());
        rm2.failApplicationAttempt(appAttemptId2);
        rm2.waitForState(appAttemptId2, RMAppAttemptState.FAILED);
        rm2.waitForState(applicationId, RMAppState.FAILED);
        Assert.assertEquals((long)maxAttempt, (long)loadedApp0.getAppAttempts().size());
    }

    private <E> Set<E> toSet(E ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    @Test(timeout=20000L)
    public void testRMRestartNodeMapping() throws Exception {
        File nodeLabelFsStoreDir = new File("target", this.getClass().getSimpleName() + "-testRMRestartNodeMapping");
        if (nodeLabelFsStoreDir.exists()) {
            FileUtils.deleteDirectory((File)nodeLabelFsStoreDir);
        }
        nodeLabelFsStoreDir.deleteOnExit();
        String nodeLabelFsStoreDirURI = nodeLabelFsStoreDir.toURI().toString();
        this.conf.set("yarn.node-labels.fs-store.root-dir", nodeLabelFsStoreDirURI);
        this.conf.setBoolean("yarn.node-labels.enabled", true);
        MockRM rm1 = new MockRM((Configuration)this.conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                RMNodeLabelsManager mgr = new RMNodeLabelsManager();
                mgr.init(this.getConfig());
                return mgr;
            }
        };
        rm1.init((Configuration)this.conf);
        rm1.start();
        RMNodeLabelsManager nodeLabelManager = rm1.getRMContext().getNodeLabelManager();
        HashSet<String> clusterNodeLabels = new HashSet<String>();
        clusterNodeLabels.add("x");
        clusterNodeLabels.add("y");
        nodeLabelManager.addToCluserNodeLabelsWithDefaultExclusivity(clusterNodeLabels);
        NodeId n1 = NodeId.newInstance((String)"h1", (int)1234);
        NodeId n2 = NodeId.newInstance((String)"h1", (int)1235);
        NodeId nihost = NodeId.newInstance((String)"h1", (int)0);
        nodeLabelManager.replaceLabelsOnNode((Map)ImmutableMap.of((Object)n1, this.toSet("x")));
        nodeLabelManager.replaceLabelsOnNode((Map)ImmutableMap.of((Object)n2, this.toSet("x")));
        nodeLabelManager.replaceLabelsOnNode((Map)ImmutableMap.of((Object)nihost, this.toSet("y")));
        nodeLabelManager.replaceLabelsOnNode((Map)ImmutableMap.of((Object)n1, this.toSet("x")));
        MockRM rm2 = null;
        for (int i = 0; i < 2; ++i) {
            rm2 = new MockRM((Configuration)this.conf, rm1.getRMStateStore()){

                @Override
                protected RMNodeLabelsManager createNodeLabelManager() {
                    RMNodeLabelsManager mgr = new RMNodeLabelsManager();
                    mgr.init(this.getConfig());
                    return mgr;
                }
            };
            rm2.init((Configuration)this.conf);
            rm2.start();
            nodeLabelManager = rm2.getRMContext().getNodeLabelManager();
            Map labelsToNodes = nodeLabelManager.getLabelsToNodes(this.toSet("x"));
            Assert.assertEquals((long)1L, (long)(null == labelsToNodes.get("x") ? 0L : (long)((Set)labelsToNodes.get("x")).size()));
        }
        rm1.stop();
        rm2.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testRMRestartAfterPreemption() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        if (!this.getSchedulerType().equals((Object)ParameterizedSchedulerTestBase.SchedulerType.CAPACITY)) {
            return;
        }
        MockRM rm1 = new MockRM((Configuration)this.conf);
        rm1.start();
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)rm1.getRMStateStore();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        int CONTAINER_MEMORY = 1024;
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(CONTAINER_MEMORY, rm1);
        MockAM am0 = MockRM.launchAM(app0, rm1, nm1);
        nm1.nodeHeartbeat(am0.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        TestSchedulerUtils.waitSchedulerApplicationAttemptStopped((AbstractYarnScheduler)cs, am0.getApplicationAttemptId());
        for (int i = 0; i < 4; ++i) {
            am0 = MockRM.launchAM(app0, rm1, nm1);
            am0.registerAppAttempt();
            FiCaSchedulerApp schedulerAppAttempt = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(app0.getApplicationId())).getCurrentAppAttempt();
            cs.markContainerForKillable(schedulerAppAttempt.getRMContainer(app0.getCurrentAppAttempt().getMasterContainer().getId()));
            rm1.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.FAILED);
            TestSchedulerUtils.waitSchedulerApplicationAttemptStopped((AbstractYarnScheduler)cs, am0.getApplicationAttemptId());
        }
        am0 = MockRM.launchAM(app0, rm1, nm1);
        am0.registerAppAttempt();
        rm1.killApp(app0.getApplicationId());
        rm1.waitForState(app0.getCurrentAppAttempt().getAppAttemptId(), RMAppAttemptState.KILLED);
        MockRM rm2 = null;
        try {
            rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
            rm2.start();
            Assert.assertTrue((String)"RM start successfully", (boolean)true);
        }
        catch (Exception e) {
            LOG.debug("Exception on start", (Throwable)e);
            Assert.fail((String)"RM should start with out any issue");
        }
        finally {
            rm1.stop();
        }
    }

    @Test(timeout=60000L)
    public void testRMRestartOnMissingAttempts() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 5);
        MockRM rm1 = this.createMockRM(this.conf);
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        MockAM am0 = this.launchAndFailAM(app0, rm1, nm1);
        MockAM am1 = this.launchAndFailAM(app0, rm1, nm1);
        MockAM am2 = this.launchAndFailAM(app0, rm1, nm1);
        MockAM am3 = this.launchAM(app0, rm1, nm1);
        memStore.removeApplicationAttemptInternal(am1.getApplicationAttemptId());
        ApplicationStateData app0State = (ApplicationStateData)memStore.getState().getApplicationState().get(app0.getApplicationId());
        ApplicationAttemptStateData am2State = app0State.getAttempt(am2.getApplicationAttemptId());
        am2State.setState(null);
        MockRM rm2 = this.createMockRM(this.conf, (RMStateStore)memStore);
        rm2.start();
        Assert.assertEquals((long)1L, (long)rm2.getRMContext().getRMApps().size());
        RMApp recoveredApp0 = (RMApp)rm2.getRMContext().getRMApps().values().iterator().next();
        Map recoveredAppAttempts = recoveredApp0.getAppAttempts();
        Assert.assertEquals((long)3L, (long)recoveredAppAttempts.size());
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)((RMAppAttempt)recoveredAppAttempts.get(am0.getApplicationAttemptId())).getAppAttemptState());
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)((RMAppAttempt)recoveredAppAttempts.get(am2.getApplicationAttemptId())).getAppAttemptState());
        Assert.assertEquals((Object)RMAppAttemptState.LAUNCHED, (Object)((RMAppAttempt)recoveredAppAttempts.get(am3.getApplicationAttemptId())).getAppAttemptState());
        Assert.assertEquals((long)5L, (long)((RMAppImpl)app0).getNextAttemptId());
    }

    private MockAM launchAndFailAM(RMApp app, MockRM rm, MockNM nm) throws Exception {
        MockAM am = this.launchAM(app, rm, nm);
        nm.nodeHeartbeat(am.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        return am;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRMRestartAfterNodeLabelDisabled() throws Exception {
        if (this.getSchedulerType() != ParameterizedSchedulerTestBase.SchedulerType.CAPACITY) {
            return;
        }
        File nodeLabelFsStoreDir = new File("target", this.getClass().getSimpleName() + "-testRMRestartAfterNodeLabelDisabled");
        if (nodeLabelFsStoreDir.exists()) {
            FileUtils.deleteDirectory((File)nodeLabelFsStoreDir);
        }
        nodeLabelFsStoreDir.deleteOnExit();
        String nodeLabelFsStoreDirURI = nodeLabelFsStoreDir.toURI().toString();
        this.conf.set("yarn.node-labels.fs-store.root-dir", nodeLabelFsStoreDirURI);
        this.conf.setBoolean("yarn.node-labels.enabled", true);
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithDefaultQueueLabels((Configuration)this.conf)){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                RMNodeLabelsManager mgr = new RMNodeLabelsManager();
                mgr.init(this.getConfig());
                return mgr;
            }
        };
        rm1.start();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)rm1.getRMStateStore();
        HashSet<String> clusterNodeLabels = new HashSet<String>();
        clusterNodeLabels.add("x");
        RMNodeLabelsManager nodeLabelManager = rm1.getRMContext().getNodeLabelManager();
        nodeLabelManager.addToCluserNodeLabelsWithDefaultExclusivity(clusterNodeLabels);
        nodeLabelManager.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockNM nm1 = rm1.registerNode("h1:1234", 8000);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("someApp").withUser("someUser").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        ContainerId amContainerId1 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        Assert.assertEquals((Object)"x", (Object)rm1.getRMContext().getScheduler().getRMContainer(amContainerId1).getNodeLabelExpression());
        this.finishApplicationMaster(app1, rm1, nm1, am1);
        this.conf.setBoolean("yarn.node-labels.enabled", false);
        MockRM rm2 = new MockRM(TestUtils.getConfigurationWithDefaultQueueLabels((Configuration)this.conf), (RMStateStore)memStore){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                RMNodeLabelsManager mgr = new RMNodeLabelsManager();
                mgr.init(this.getConfig());
                return mgr;
            }
        };
        try {
            rm2.start();
            Assert.assertTrue((String)"RM start successfully", (boolean)true);
            Assert.assertEquals((long)1L, (long)rm2.getRMContext().getRMApps().size());
        }
        catch (Exception e) {
            LOG.debug("Exception on start", (Throwable)e);
            Assert.fail((String)"RM should start without any issue");
        }
        finally {
            rm1.stop();
            rm2.stop();
        }
    }

    @Test(timeout=20000L)
    public void testRMRestartAfterPriorityChangesInAllocatedResponse() throws Exception {
        this.conf.set("hadoop.security.authentication", "kerberos");
        this.conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        this.conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.conf.setInt("yarn.cluster.max-application-priority", 10);
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", false);
        this.conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        TestSecurityMockRM rm = new TestSecurityMockRM((Configuration)this.conf);
        rm.start();
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm.getRMStateStore();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        Priority appPriority1 = Priority.newInstance((int)5);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm).withAppPriority(appPriority1).withCredentials(this.getCreds()).withTokensConf(this.getTokensConf()).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        AllocateRequestPBImpl allocateRequest = new AllocateRequestPBImpl();
        ArrayList release = new ArrayList();
        ArrayList ask = new ArrayList();
        allocateRequest.setReleaseList(release);
        allocateRequest.setAskList(ask);
        AllocateResponse response1 = am1.allocate((AllocateRequest)allocateRequest);
        Assert.assertEquals((Object)appPriority1, (Object)response1.getApplicationPriority());
        Priority appPriority2 = Priority.newInstance((int)8);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)app1.getUser());
        rm.getRMAppManager().updateApplicationPriority(ugi, app1.getApplicationId(), appPriority2);
        AllocateResponse response2 = am1.allocate((AllocateRequest)allocateRequest);
        Assert.assertEquals((Object)appPriority2, (Object)response2.getApplicationPriority());
        Map rmAppState = memStore.getState().getApplicationState();
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(app1.getApplicationId());
        Assert.assertEquals((Object)this.getTokensConf(), (Object)appState.getApplicationSubmissionContext().getAMContainerSpec().getTokensConf());
        TestSecurityMockRM rm2 = new TestSecurityMockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm2.start();
        AllocateResponse response3 = am1.allocate((AllocateRequest)allocateRequest);
        Assert.assertEquals((Object)appPriority2, (Object)response3.getApplicationPriority());
        Map rmAppStateNew = memStore.getState().getApplicationState();
        ApplicationStateData appStateNew = (ApplicationStateData)rmAppStateNew.get(app1.getApplicationId());
        Assert.assertEquals((Object)this.getTokensConf(), (Object)appStateNew.getApplicationSubmissionContext().getAMContainerSpec().getTokensConf());
        rm.stop();
        rm2.stop();
    }

    @Test(timeout=20000L)
    public void testRMRestartAfterUpdateTrackingUrl() throws Exception {
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.start();
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm.getRMStateStore();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(2048L, rm);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        AllocateRequestPBImpl allocateRequest = new AllocateRequestPBImpl();
        String newTrackingUrl = "hadoop.apache.org";
        allocateRequest.setTrackingUrl(newTrackingUrl);
        am1.allocate((AllocateRequest)allocateRequest);
        Assert.assertEquals((Object)newTrackingUrl, (Object)((RMApp)rm.getRMContext().getRMApps().get(app1.getApplicationId())).getOriginalTrackingUrl());
        Assert.assertEquals((Object)newTrackingUrl, (Object)((RMApp)rm.getRMContext().getRMApps().get(app1.getApplicationId())).getCurrentAppAttempt().getOriginalTrackingUrl());
        Assert.assertEquals((Object)newTrackingUrl, (Object)((ApplicationStateData)memStore.getState().getApplicationState().get(app1.getApplicationId())).getAttempt(attempt1.getAppAttemptId()).getFinalTrackingUrl());
        MockRM rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm2.start();
        Assert.assertEquals((Object)newTrackingUrl, (Object)((RMApp)rm.getRMContext().getRMApps().get(app1.getApplicationId())).getOriginalTrackingUrl());
        Assert.assertEquals((Object)newTrackingUrl, (Object)((RMApp)rm.getRMContext().getRMApps().get(app1.getApplicationId())).getCurrentAppAttempt().getOriginalTrackingUrl());
        rm.stop();
        rm2.stop();
    }

    private Credentials getCreds() throws IOException {
        Credentials ts = new Credentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        ts.writeTokenStorageToStream((DataOutputStream)dob);
        return ts;
    }

    private ByteBuffer getTokensConf() throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        Configuration appConf = new Configuration(false);
        appConf.clear();
        appConf.set("dfs.nameservices", "mycluster1,mycluster2");
        appConf.set("dfs.namenode.rpc-address.mycluster2.nn1", "123.0.0.1");
        appConf.set("dfs.namenode.rpc-address.mycluster3.nn2", "123.0.0.2");
        appConf.write((DataOutput)dob);
        ByteBuffer tokenConf = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        return tokenConf;
    }

    public static class TestSecurityMockRM
    extends MockRM {
        public TestSecurityMockRM(Configuration conf, RMStateStore store) {
            super(conf, store);
        }

        public TestSecurityMockRM(Configuration conf) {
            super(conf);
        }

        public void init(Configuration conf) {
            RMDelegationTokenIdentifier.Renewer.setSecretManager(null, null);
            super.init(conf);
        }

        @Override
        protected ClientRMService createClientRMService() {
            return new ClientRMService(this.getRMContext(), (YarnScheduler)this.getResourceScheduler(), this.rmAppManager, this.applicationACLsManager, null, this.getRMContext().getRMDelegationTokenSecretManager()){

                protected void serviceStart() throws Exception {
                }

                protected void serviceStop() throws Exception {
                }
            };
        }

        protected void doSecureLogin() throws IOException {
        }
    }

    public class TestMemoryRMStateStore
    extends MemoryRMStateStore {
        int count = 0;
        public int updateApp = 0;
        public int updateAttempt = 0;

        public void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateData) throws Exception {
            this.updateApp = ++this.count;
            super.updateApplicationStateInternal(appId, appStateData);
        }

        public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId attemptId, ApplicationAttemptStateData attemptStateData) throws Exception {
            this.updateAttempt = ++this.count;
            super.updateApplicationAttemptStateInternal(attemptId, attemptStateData);
        }
    }
}

