/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.metrics;

import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsEvent;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;

public class ApplicationFinishedEvent
extends SystemMetricsEvent {
    private ApplicationId appId;
    private String diagnosticsInfo;
    private FinalApplicationStatus appStatus;
    private YarnApplicationState state;
    private ApplicationAttemptId latestAppAttemptId;
    private RMAppMetrics appMetrics;

    public ApplicationFinishedEvent(ApplicationId appId, String diagnosticsInfo, FinalApplicationStatus appStatus, YarnApplicationState state, ApplicationAttemptId latestAppAttemptId, long finishedTime, RMAppMetrics appMetrics) {
        super(SystemMetricsEventType.APP_FINISHED, finishedTime);
        this.appId = appId;
        this.diagnosticsInfo = diagnosticsInfo;
        this.appStatus = appStatus;
        this.latestAppAttemptId = latestAppAttemptId;
        this.state = state;
        this.appMetrics = appMetrics;
    }

    public int hashCode() {
        return this.appId.hashCode();
    }

    public ApplicationId getApplicationId() {
        return this.appId;
    }

    public String getDiagnosticsInfo() {
        return this.diagnosticsInfo;
    }

    public FinalApplicationStatus getFinalApplicationStatus() {
        return this.appStatus;
    }

    public YarnApplicationState getYarnApplicationState() {
        return this.state;
    }

    public ApplicationAttemptId getLatestApplicationAttemptId() {
        return this.latestAppAttemptId;
    }

    public RMAppMetrics getAppMetrics() {
        return this.appMetrics;
    }
}

