/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.ErrorBlock;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebApp;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.Test;

public class TestRedirectionErrorPage {
    @Test
    public void testAppBlockRenderWithNullCurrentAppAttempt() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1234L, (int)0);
        final RMContext rmContext = TestRMWebApp.mockRMContext(15, 1, 2, 8);
        Injector injector = WebAppTests.createMockInjector(RMContext.class, (Object)rmContext, (Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                try {
                    ResourceManager rm = TestRMWebApp.mockRm(rmContext);
                    binder.bind(ResourceManager.class).toInstance((Object)rm);
                    binder.bind(ApplicationBaseProtocol.class).toInstance((Object)rm.getClientRMService());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }});
        ErrorBlock instance = (ErrorBlock)injector.getInstance(ErrorBlock.class);
        instance.set("app.id", appId.toString());
        instance.set("error.message", "This is an error");
        instance.render();
    }
}

