/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestParentQueue {
    private static final Logger LOG = LoggerFactory.getLogger(TestParentQueue.class);
    RMContext rmContext;
    YarnConfiguration conf;
    CapacitySchedulerConfiguration csConf;
    CapacitySchedulerContext csContext;
    static final int GB = 1024;
    static final String DEFAULT_RACK = "/default";
    private final ResourceCalculator resourceComparator = new DefaultResourceCalculator();
    private static final String A = "a";
    private static final String B = "b";
    static final float DELTA = 1.0E-4f;
    private static final String C = "c";
    private static final String C1 = "c1";
    private static final String C11 = "c11";
    private static final String C111 = "c111";
    private static final String C1111 = "c1111";
    private static final String D = "d";
    private static final String A1 = "a1";
    private static final String A2 = "a2";
    private static final String B1 = "b1";
    private static final String B2 = "b2";
    private static final String B3 = "b3";

    @Before
    public void setUp() throws Exception {
        this.rmContext = TestUtils.getMockRMContext();
        this.conf = new YarnConfiguration();
        this.csConf = new CapacitySchedulerConfiguration();
        this.csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)this.csContext.getConf()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.csContext.getConfiguration()).thenReturn((Object)this.csConf);
        Mockito.when((Object)this.csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)this.csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)Resources.createResource((int)0x190000, (int)3200));
        Mockito.when((Object)this.csContext.getApplicationComparator()).thenReturn((Object)CapacityScheduler.applicationComparator);
        Mockito.when((Object)this.csContext.getQueueComparator()).thenReturn((Object)CapacityScheduler.queueComparator);
        Mockito.when((Object)this.csContext.getResourceCalculator()).thenReturn((Object)this.resourceComparator);
        Mockito.when((Object)this.csContext.getRMContext()).thenReturn((Object)this.rmContext);
    }

    private void setupSingleLevelQueues(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{A, B});
        String Q_A = "root.a";
        conf.setCapacity("root.a", 30.0f);
        String Q_B = "root.b";
        conf.setCapacity("root.b", 70.0f);
        LOG.info("Setup top-level queues a and b");
    }

    private FiCaSchedulerApp getMockApplication(int appId, String user) {
        FiCaSchedulerApp application = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        ((FiCaSchedulerApp)Mockito.doReturn((Object)user).when((Object)application)).getUser();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)Resources.createResource((int)0, (int)0)).when((Object)application)).getHeadroom();
        return application;
    }

    private void stubQueueAllocation(CSQueue queue, Resource clusterResource, FiCaSchedulerNode node, int allocation) {
        this.stubQueueAllocation(queue, clusterResource, node, allocation, NodeType.NODE_LOCAL);
    }

    private void stubQueueAllocation(final CSQueue queue, final Resource clusterResource, final FiCaSchedulerNode node, final int allocation, final NodeType type) {
        ((CSQueue)Mockito.doAnswer((Answer)new Answer<CSAssignment>(){

            public CSAssignment answer(InvocationOnMock invocation) throws Throwable {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    LOG.info("FOOBAR q.assignContainers q=" + queue.getQueueName() + " alloc=" + allocation + " node=" + node.getNodeName());
                    Resource allocatedResource = Resources.createResource((int)allocation);
                    if (queue instanceof ParentQueue) {
                        ((ParentQueue)queue).allocateResource(clusterResource, allocatedResource, null);
                    } else {
                        FiCaSchedulerApp app1 = TestParentQueue.this.getMockApplication(0, "");
                        ((LeafQueue)queue).allocateResource(clusterResource, (SchedulerApplicationAttempt)app1, allocatedResource, null);
                    }
                    if (allocation > 0) {
                        ((CSQueue)Mockito.doReturn((Object)new CSAssignment(Resources.none(), type)).when((Object)queue)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.eq((Object)node), Matchers.eq((boolean)false), (ResourceLimits)Matchers.any(ResourceLimits.class));
                        Resource available = node.getAvailableResource();
                        ((FiCaSchedulerNode)Mockito.doReturn((Object)Resources.subtractFrom((Resource)available, (Resource)allocatedResource)).when((Object)node)).getAvailableResource();
                    }
                    return new CSAssignment(allocatedResource, type);
                }
            }
        }).when((Object)queue)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.eq((Object)node), Matchers.eq((boolean)false), (ResourceLimits)Matchers.any(ResourceLimits.class));
    }

    private float computeQueueAbsoluteUsedCapacity(CSQueue queue, int expectedMemory, Resource clusterResource) {
        return (float)expectedMemory / (float)clusterResource.getMemory();
    }

    private float computeQueueUsedCapacity(CSQueue queue, int expectedMemory, Resource clusterResource) {
        return (float)expectedMemory / ((float)clusterResource.getMemory() * queue.getAbsoluteCapacity());
    }

    private void verifyQueueMetrics(CSQueue queue, int expectedMemory, Resource clusterResource) {
        Assert.assertEquals((float)this.computeQueueAbsoluteUsedCapacity(queue, expectedMemory, clusterResource), (float)queue.getAbsoluteUsedCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)this.computeQueueUsedCapacity(queue, expectedMemory, clusterResource), (float)queue.getUsedCapacity(), (float)1.0E-4f);
    }

    @Test
    public void testSingleLevelQueues() throws Exception {
        this.setupSingleLevelQueues(this.csConf);
        HashMap queues = new HashMap();
        CSQueue root = CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        int memoryPerNode = 10;
        int coresPerNode = 16;
        int numNodes = 2;
        FiCaSchedulerNode node_0 = TestUtils.getMockNode("host_0", DEFAULT_RACK, 0, 10240);
        FiCaSchedulerNode node_1 = TestUtils.getMockNode("host_1", DEFAULT_RACK, 0, 10240);
        Resource clusterResource = Resources.createResource((int)20480, (int)32);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        LeafQueue a = (LeafQueue)queues.get(A);
        LeafQueue b = (LeafQueue)queues.get(B);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_0, 0);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_0, 1024);
        root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        this.verifyQueueMetrics((CSQueue)a, 0, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 1024, clusterResource);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_1, 2048);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_1, 1024);
        root.assignContainers(clusterResource, node_1, false, new ResourceLimits(clusterResource));
        InOrder allocationOrder = Mockito.inOrder((Object[])new Object[]{a, b});
        ((LeafQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        ((LeafQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        this.verifyQueueMetrics((CSQueue)a, 2048, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 2048, clusterResource);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_0, 1024);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_0, 2048);
        root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        allocationOrder = Mockito.inOrder((Object[])new Object[]{b, a});
        ((LeafQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        ((LeafQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        this.verifyQueueMetrics((CSQueue)a, 3072, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 4096, clusterResource);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_0, 0);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_0, 4096);
        root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        allocationOrder = Mockito.inOrder((Object[])new Object[]{b, a});
        ((LeafQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        ((LeafQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        this.verifyQueueMetrics((CSQueue)a, 3072, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 8192, clusterResource);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_1, 1024);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_1, 1024);
        root.assignContainers(clusterResource, node_1, false, new ResourceLimits(clusterResource));
        allocationOrder = Mockito.inOrder((Object[])new Object[]{a, b});
        ((LeafQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        ((LeafQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        this.verifyQueueMetrics((CSQueue)a, 4096, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 9216, clusterResource);
    }

    @Test
    public void testSingleLevelQueuesPrecision() throws Exception {
        this.setupSingleLevelQueues(this.csConf);
        String Q_A = "root.a";
        this.csConf.setCapacity("root.a", 30.0f);
        String Q_B = "root.b";
        this.csConf.setCapacity("root.b", 70.5f);
        HashMap queues = new HashMap();
        boolean exceptionOccured = false;
        try {
            CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        }
        catch (IllegalArgumentException ie) {
            exceptionOccured = true;
        }
        if (!exceptionOccured) {
            Assert.fail((String)"Capacity is more then 100% so should be failed.");
        }
        this.csConf.setCapacity("root.a", 30.0f);
        this.csConf.setCapacity("root.b", 70.0f);
        exceptionOccured = false;
        queues.clear();
        try {
            CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        }
        catch (IllegalArgumentException ie) {
            exceptionOccured = true;
        }
        if (exceptionOccured) {
            Assert.fail((String)"Capacity is 100% so should not be failed.");
        }
        this.csConf.setCapacity("root.a", 30.0f);
        this.csConf.setCapacity("root.b", 70.005f);
        exceptionOccured = false;
        queues.clear();
        try {
            CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        }
        catch (IllegalArgumentException ie) {
            exceptionOccured = true;
        }
        if (exceptionOccured) {
            Assert.fail((String)"Capacity is under PRECISION which is .05% so should not be failed.");
        }
    }

    private void setupMultiLevelQueues(CapacitySchedulerConfiguration conf) {
        this.csConf.setQueues("root", new String[]{A, B, C, D});
        String Q_A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        String Q_B = "root.b";
        conf.setCapacity("root.b", 50.0f);
        String Q_C = "root.c";
        conf.setCapacity("root.c", 19.5f);
        String Q_D = "root.d";
        conf.setCapacity("root.d", 20.5f);
        conf.setQueues("root.a", new String[]{A1, A2});
        conf.setCapacity("root.a.a1", 50.0f);
        conf.setCapacity("root.a.a2", 50.0f);
        conf.setQueues("root.b", new String[]{B1, B2, B3});
        conf.setCapacity("root.b.b1", 10.0f);
        conf.setCapacity("root.b.b2", 20.0f);
        conf.setCapacity("root.b.b3", 70.0f);
        conf.setQueues("root.c", new String[]{C1});
        String Q_C1 = "root.c.c1";
        conf.setCapacity("root.c.c1", 100.0f);
        conf.setQueues("root.c.c1", new String[]{C11});
        String Q_C11 = "root.c.c1.c11";
        conf.setCapacity("root.c.c1.c11", 100.0f);
        conf.setQueues("root.c.c1.c11", new String[]{C111});
        String Q_C111 = "root.c.c1.c11.c111";
        conf.setCapacity("root.c.c1.c11.c111", 100.0f);
        conf.setQueues("root.c.c1.c11.c111", new String[]{C1111});
        String Q_C1111 = "root.c.c1.c11.c111.c1111";
        conf.setCapacity("root.c.c1.c11.c111.c1111", 100.0f);
    }

    @Test
    public void testMultiLevelQueues() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        HashMap queues = new HashMap();
        CSQueue root = CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        int memoryPerNode = 10;
        int coresPerNode = 16;
        int numNodes = 3;
        FiCaSchedulerNode node_0 = TestUtils.getMockNode("host_0", DEFAULT_RACK, 0, 10240);
        FiCaSchedulerNode node_1 = TestUtils.getMockNode("host_1", DEFAULT_RACK, 0, 10240);
        FiCaSchedulerNode node_2 = TestUtils.getMockNode("host_2", DEFAULT_RACK, 0, 10240);
        Resource clusterResource = Resources.createResource((int)30720, (int)48);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        CSQueue a = (CSQueue)queues.get(A);
        CSQueue b = (CSQueue)queues.get(B);
        CSQueue c = (CSQueue)queues.get(C);
        CSQueue d = (CSQueue)queues.get(D);
        CSQueue a1 = (CSQueue)queues.get(A1);
        CSQueue a2 = (CSQueue)queues.get(A2);
        CSQueue b1 = (CSQueue)queues.get(B1);
        CSQueue b2 = (CSQueue)queues.get(B2);
        CSQueue b3 = (CSQueue)queues.get(B3);
        this.stubQueueAllocation(a, clusterResource, node_0, 0);
        this.stubQueueAllocation(b, clusterResource, node_0, 0);
        this.stubQueueAllocation(c, clusterResource, node_0, 1024);
        this.stubQueueAllocation(d, clusterResource, node_0, 0);
        root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        this.verifyQueueMetrics(a, 0, clusterResource);
        this.verifyQueueMetrics(b, 0, clusterResource);
        this.verifyQueueMetrics(c, 1024, clusterResource);
        this.verifyQueueMetrics(d, 0, clusterResource);
        Mockito.reset((Object[])new CSQueue[]{a});
        Mockito.reset((Object[])new CSQueue[]{b});
        Mockito.reset((Object[])new CSQueue[]{c});
        this.stubQueueAllocation(a, clusterResource, node_1, 0);
        this.stubQueueAllocation(b2, clusterResource, node_1, 4096);
        this.stubQueueAllocation(c, clusterResource, node_1, 0);
        root.assignContainers(clusterResource, node_1, false, new ResourceLimits(clusterResource));
        this.verifyQueueMetrics(a, 0, clusterResource);
        this.verifyQueueMetrics(b, 4096, clusterResource);
        this.verifyQueueMetrics(c, 1024, clusterResource);
        Mockito.reset((Object[])new CSQueue[]{a});
        Mockito.reset((Object[])new CSQueue[]{b});
        Mockito.reset((Object[])new CSQueue[]{c});
        this.stubQueueAllocation(a1, clusterResource, node_0, 1024);
        this.stubQueueAllocation(b3, clusterResource, node_0, 2048);
        this.stubQueueAllocation(c, clusterResource, node_0, 2048);
        root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        InOrder allocationOrder = Mockito.inOrder((Object[])new Object[]{a, c, b});
        ((CSQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        ((CSQueue)allocationOrder.verify((Object)c)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        ((CSQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        this.verifyQueueMetrics(a, 1024, clusterResource);
        this.verifyQueueMetrics(b, 6144, clusterResource);
        this.verifyQueueMetrics(c, 3072, clusterResource);
        Mockito.reset((Object[])new CSQueue[]{a});
        Mockito.reset((Object[])new CSQueue[]{b});
        Mockito.reset((Object[])new CSQueue[]{c});
        LOG.info("here");
        ((ParentQueue)a).setMaxCapacity(0.1f);
        this.stubQueueAllocation(a1, clusterResource, node_2, 1024);
        this.stubQueueAllocation(a2, clusterResource, node_2, 2048);
        this.stubQueueAllocation(b3, clusterResource, node_2, 1024);
        this.stubQueueAllocation(b1, clusterResource, node_2, 1024);
        this.stubQueueAllocation(c, clusterResource, node_2, 1024);
        root.assignContainers(clusterResource, node_2, false, new ResourceLimits(clusterResource));
        allocationOrder = Mockito.inOrder((Object[])new Object[]{a, a2, a1, b, c});
        ((CSQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        ((CSQueue)allocationOrder.verify((Object)a2)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        ((CSQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        ((CSQueue)allocationOrder.verify((Object)c)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        this.verifyQueueMetrics(a, 3072, clusterResource);
        this.verifyQueueMetrics(b, 8192, clusterResource);
        this.verifyQueueMetrics(c, 4096, clusterResource);
        Mockito.reset((Object[])new CSQueue[]{a});
        Mockito.reset((Object[])new CSQueue[]{b});
        Mockito.reset((Object[])new CSQueue[]{c});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueueCapacitySettingChildZero() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        String Q_B = "root.b";
        this.csConf.setCapacity("root.b.b1", 0.0f);
        this.csConf.setCapacity("root.b.b2", 0.0f);
        this.csConf.setCapacity("root.b.b3", 0.0f);
        HashMap queues = new HashMap();
        CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueueCapacitySettingParentZero() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        String Q_B = "root.b";
        this.csConf.setCapacity("root.b", 0.0f);
        String Q_A = "root.a";
        this.csConf.setCapacity("root.a", 60.0f);
        HashMap queues = new HashMap();
        CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
    }

    @Test
    public void testQueueCapacityZero() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        String Q_B = "root.b";
        this.csConf.setCapacity("root.b", 0.0f);
        this.csConf.setCapacity("root.b.b1", 0.0f);
        this.csConf.setCapacity("root.b.b2", 0.0f);
        this.csConf.setCapacity("root.b.b3", 0.0f);
        String Q_A = "root.a";
        this.csConf.setCapacity("root.a", 60.0f);
        HashMap queues = new HashMap();
        try {
            CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Failed to create queues with 0 capacity: " + e));
        }
        Assert.assertTrue((String)"Failed to create queues with 0 capacity", (boolean)true);
    }

    @Test
    public void testOffSwitchScheduling() throws Exception {
        this.setupSingleLevelQueues(this.csConf);
        HashMap queues = new HashMap();
        CSQueue root = CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        int memoryPerNode = 10;
        int coresPerNode = 16;
        int numNodes = 2;
        FiCaSchedulerNode node_0 = TestUtils.getMockNode("host_0", DEFAULT_RACK, 0, 10240);
        FiCaSchedulerNode node_1 = TestUtils.getMockNode("host_1", DEFAULT_RACK, 0, 10240);
        Resource clusterResource = Resources.createResource((int)20480, (int)32);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        LeafQueue a = (LeafQueue)queues.get(A);
        LeafQueue b = (LeafQueue)queues.get(B);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_0, 0, NodeType.OFF_SWITCH);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_0, 1024, NodeType.OFF_SWITCH);
        root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        this.verifyQueueMetrics((CSQueue)a, 0, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 1024, clusterResource);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_1, 2048, NodeType.RACK_LOCAL);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_1, 1024, NodeType.OFF_SWITCH);
        root.assignContainers(clusterResource, node_1, false, new ResourceLimits(clusterResource));
        InOrder allocationOrder = Mockito.inOrder((Object[])new Object[]{a, b});
        ((LeafQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        ((LeafQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        this.verifyQueueMetrics((CSQueue)a, 2048, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 2048, clusterResource);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_0, 1024, NodeType.NODE_LOCAL);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_0, 2048, NodeType.OFF_SWITCH);
        root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        allocationOrder = Mockito.inOrder((Object[])new Object[]{b, a});
        ((LeafQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        ((LeafQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        this.verifyQueueMetrics((CSQueue)a, 2048, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 4096, clusterResource);
    }

    @Test
    public void testOffSwitchSchedulingMultiLevelQueues() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        HashMap queues = new HashMap();
        CSQueue root = CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        int memoryPerNode = 10;
        int coresPerNode = 10;
        int numNodes = 2;
        FiCaSchedulerNode node_0 = TestUtils.getMockNode("host_0", DEFAULT_RACK, 0, 10240);
        FiCaSchedulerNode node_1 = TestUtils.getMockNode("host_1", DEFAULT_RACK, 0, 10240);
        Resource clusterResource = Resources.createResource((int)20480, (int)20);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        LeafQueue b3 = (LeafQueue)queues.get(B3);
        LeafQueue b2 = (LeafQueue)queues.get(B2);
        this.stubQueueAllocation((CSQueue)b2, clusterResource, node_0, 0, NodeType.OFF_SWITCH);
        this.stubQueueAllocation((CSQueue)b3, clusterResource, node_0, 1024, NodeType.OFF_SWITCH);
        root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        this.verifyQueueMetrics((CSQueue)b2, 0, clusterResource);
        this.verifyQueueMetrics((CSQueue)b3, 1024, clusterResource);
        this.stubQueueAllocation((CSQueue)b2, clusterResource, node_1, 1024, NodeType.RACK_LOCAL);
        this.stubQueueAllocation((CSQueue)b3, clusterResource, node_1, 1024, NodeType.OFF_SWITCH);
        root.assignContainers(clusterResource, node_1, false, new ResourceLimits(clusterResource));
        InOrder allocationOrder = Mockito.inOrder((Object[])new Object[]{b2, b3});
        ((LeafQueue)allocationOrder.verify((Object)b2)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        ((LeafQueue)allocationOrder.verify((Object)b3)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        this.verifyQueueMetrics((CSQueue)b2, 1024, clusterResource);
        this.verifyQueueMetrics((CSQueue)b3, 2048, clusterResource);
        this.stubQueueAllocation((CSQueue)b2, clusterResource, node_0, 1024, NodeType.NODE_LOCAL);
        this.stubQueueAllocation((CSQueue)b3, clusterResource, node_0, 1024, NodeType.OFF_SWITCH);
        root.assignContainers(clusterResource, node_0, false, new ResourceLimits(clusterResource));
        allocationOrder = Mockito.inOrder((Object[])new Object[]{b3, b2});
        ((LeafQueue)allocationOrder.verify((Object)b3)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        ((LeafQueue)allocationOrder.verify((Object)b2)).assignContainers((Resource)Matchers.eq((Object)clusterResource), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), Matchers.anyBoolean(), this.anyResourceLimits());
        this.verifyQueueMetrics((CSQueue)b2, 1024, clusterResource);
        this.verifyQueueMetrics((CSQueue)b3, 3072, clusterResource);
    }

    public boolean hasQueueACL(List<QueueUserACLInfo> aclInfos, QueueACL acl, String qName) {
        for (QueueUserACLInfo aclInfo : aclInfos) {
            if (!aclInfo.getQueueName().equals(qName) || !aclInfo.getUserAcls().contains(acl)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testQueueAcl() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        this.csConf.setAcl("root", QueueACL.SUBMIT_APPLICATIONS, " ");
        this.csConf.setAcl("root", QueueACL.ADMINISTER_QUEUE, " ");
        String Q_C = "root.c";
        this.csConf.setAcl("root.c", QueueACL.ADMINISTER_QUEUE, "*");
        String Q_C11 = "root.c.c1.c11";
        this.csConf.setAcl("root.c.c1.c11", QueueACL.SUBMIT_APPLICATIONS, "*");
        HashMap queues = new HashMap();
        CSQueue root = CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        YarnAuthorizationProvider authorizer = YarnAuthorizationProvider.getInstance((Configuration)this.conf);
        CapacityScheduler.setQueueAcls((YarnAuthorizationProvider)authorizer, queues);
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        ParentQueue c = (ParentQueue)queues.get(C);
        ParentQueue c1 = (ParentQueue)queues.get(C1);
        ParentQueue c11 = (ParentQueue)queues.get(C11);
        ParentQueue c111 = (ParentQueue)queues.get(C111);
        Assert.assertFalse((boolean)root.hasAccess(QueueACL.ADMINISTER_QUEUE, user));
        List aclInfos = root.getQueueUserAclInfo(user);
        Assert.assertFalse((boolean)this.hasQueueACL(aclInfos, QueueACL.ADMINISTER_QUEUE, "root"));
        Assert.assertFalse((boolean)root.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertFalse((boolean)this.hasQueueACL(aclInfos, QueueACL.SUBMIT_APPLICATIONS, "root"));
        Assert.assertTrue((boolean)c.hasAccess(QueueACL.ADMINISTER_QUEUE, user));
        Assert.assertTrue((boolean)this.hasQueueACL(aclInfos, QueueACL.ADMINISTER_QUEUE, C));
        Assert.assertFalse((boolean)c.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertFalse((boolean)this.hasQueueACL(aclInfos, QueueACL.SUBMIT_APPLICATIONS, C));
        Assert.assertTrue((boolean)c1.hasAccess(QueueACL.ADMINISTER_QUEUE, user));
        Assert.assertTrue((boolean)this.hasQueueACL(aclInfos, QueueACL.ADMINISTER_QUEUE, C1));
        Assert.assertFalse((boolean)c1.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertFalse((boolean)this.hasQueueACL(aclInfos, QueueACL.SUBMIT_APPLICATIONS, C1));
        Assert.assertTrue((boolean)c11.hasAccess(QueueACL.ADMINISTER_QUEUE, user));
        Assert.assertTrue((boolean)this.hasQueueACL(aclInfos, QueueACL.ADMINISTER_QUEUE, C11));
        Assert.assertTrue((boolean)c11.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertTrue((boolean)this.hasQueueACL(aclInfos, QueueACL.SUBMIT_APPLICATIONS, C11));
        Assert.assertTrue((boolean)c111.hasAccess(QueueACL.ADMINISTER_QUEUE, user));
        Assert.assertTrue((boolean)this.hasQueueACL(aclInfos, QueueACL.ADMINISTER_QUEUE, C111));
        Assert.assertTrue((boolean)c111.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertTrue((boolean)this.hasQueueACL(aclInfos, QueueACL.SUBMIT_APPLICATIONS, C111));
        Mockito.reset((Object[])new ParentQueue[]{c});
    }

    @After
    public void tearDown() throws Exception {
    }

    private ResourceLimits anyResourceLimits() {
        return (ResourceLimits)Matchers.any(ResourceLimits.class);
    }
}

