/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class TestRMAppAttemptImplDiagnostics {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void whenCreatedWithDefaultConfigurationSuccess() {
        Configuration configuration = new Configuration();
        configuration.setInt("yarn.app.attempt.diagnostics.limit.kc", 64);
        this.createRMAppAttemptImpl(configuration);
    }

    @Test
    public void whenCreatedWithWrongConfigurationError() {
        Configuration configuration = new Configuration();
        configuration.setInt("yarn.app.attempt.diagnostics.limit.kc", 0);
        this.expectedException.expect(YarnRuntimeException.class);
        this.createRMAppAttemptImpl(configuration);
    }

    @Test
    public void whenAppendedWithinLimitMessagesArePreserved() {
        Configuration configuration = new Configuration();
        configuration.setInt("yarn.app.attempt.diagnostics.limit.kc", 1);
        RMAppAttemptImpl appAttempt = this.createRMAppAttemptImpl(configuration);
        String withinLimit = RandomStringUtils.random((int)1024);
        appAttempt.appendDiagnostics((CharSequence)withinLimit);
        Assert.assertEquals((String)"messages within limit should be preserved", (Object)withinLimit, (Object)appAttempt.getDiagnostics());
    }

    @Test
    public void whenAppendedBeyondLimitMessagesAreTruncated() {
        Configuration configuration = new Configuration();
        configuration.setInt("yarn.app.attempt.diagnostics.limit.kc", 1);
        RMAppAttemptImpl appAttempt = this.createRMAppAttemptImpl(configuration);
        String beyondLimit = RandomStringUtils.random((int)1025);
        appAttempt.appendDiagnostics((CharSequence)beyondLimit);
        String truncated = String.format("Diagnostic messages truncated, showing last %d chars out of %d:%n...%s", 1024, 1025, beyondLimit.substring(1));
        Assert.assertEquals((String)"messages beyond limit should be truncated", (Object)truncated, (Object)appAttempt.getDiagnostics());
    }

    private RMAppAttemptImpl createRMAppAttemptImpl(Configuration configuration) {
        ApplicationAttemptId mockApplicationAttemptId = (ApplicationAttemptId)Mockito.mock(ApplicationAttemptId.class);
        ApplicationId mockApplicationId = (ApplicationId)Mockito.mock(ApplicationId.class);
        Mockito.when((Object)mockApplicationAttemptId.getApplicationId()).thenReturn((Object)mockApplicationId);
        RMContext mockRMContext = (RMContext)Mockito.mock(RMContext.class);
        Dispatcher mockDispatcher = (Dispatcher)Mockito.mock(Dispatcher.class);
        Mockito.when((Object)mockRMContext.getDispatcher()).thenReturn((Object)mockDispatcher);
        return new RMAppAttemptImpl(mockApplicationAttemptId, mockRMContext, null, null, null, configuration, false, null);
    }
}

