/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.resourcetracker;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.conf.ConfigurationProviderFactory;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNMReconnect {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private List<RMNodeEvent> rmNodeEvents = new ArrayList<RMNodeEvent>();
    private Dispatcher dispatcher;
    private RMContextImpl context;
    ResourceTrackerService resourceTrackerService;

    @Before
    public void setUp() {
        Configuration conf = new Configuration();
        this.dispatcher = new InlineDispatcher();
        this.dispatcher.register(RMNodeEventType.class, (EventHandler)new TestRMNodeEventDispatcher());
        this.context = new RMContextImpl(this.dispatcher, null, null, null, null, null, null, null, null, null);
        this.dispatcher.register(SchedulerEventType.class, (EventHandler)new InlineDispatcher.EmptyEventHandler());
        this.dispatcher.register(RMNodeEventType.class, (EventHandler)new ResourceManager.NodeEventDispatcher((RMContext)this.context));
        NMLivelinessMonitor nmLivelinessMonitor = new NMLivelinessMonitor(this.dispatcher);
        nmLivelinessMonitor.init(conf);
        nmLivelinessMonitor.start();
        NodesListManager nodesListManager = new NodesListManager((RMContext)this.context);
        nodesListManager.init(conf);
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager(conf);
        containerTokenSecretManager.start();
        NMTokenSecretManagerInRM nmTokenSecretManager = new NMTokenSecretManagerInRM(conf);
        nmTokenSecretManager.start();
        this.resourceTrackerService = new ResourceTrackerService((RMContext)this.context, nodesListManager, nmLivelinessMonitor, containerTokenSecretManager, nmTokenSecretManager);
        this.resourceTrackerService.init(conf);
        this.resourceTrackerService.start();
    }

    @After
    public void tearDown() {
        this.resourceTrackerService.stop();
    }

    @Test
    public void testReconnect() throws Exception {
        String hostname1 = "localhost1";
        Resource capability = BuilderUtils.newResource((int)1024, (int)1);
        RegisterNodeManagerRequest request1 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        NodeId nodeId1 = NodeId.newInstance((String)hostname1, (int)0);
        request1.setNodeId(nodeId1);
        request1.setHttpPort(0);
        request1.setResource(capability);
        this.resourceTrackerService.registerNodeManager(request1);
        Assert.assertEquals((Object)RMNodeEventType.STARTED, (Object)this.rmNodeEvents.get(0).getType());
        this.rmNodeEvents.clear();
        this.resourceTrackerService.registerNodeManager(request1);
        Assert.assertEquals((Object)RMNodeEventType.RECONNECTED, (Object)this.rmNodeEvents.get(0).getType());
        this.rmNodeEvents.clear();
        this.resourceTrackerService.registerNodeManager(request1);
        capability = BuilderUtils.newResource((int)1024, (int)2);
        request1.setResource(capability);
        Assert.assertEquals((Object)RMNodeEventType.RECONNECTED, (Object)this.rmNodeEvents.get(0).getType());
    }

    @Test
    public void testCompareRMNodeAfterReconnect() throws Exception {
        YarnConfiguration yarnConf = new YarnConfiguration();
        CapacityScheduler scheduler = new CapacityScheduler();
        scheduler.setConf((Configuration)yarnConf);
        ConfigurationProvider configurationProvider = ConfigurationProviderFactory.getConfigurationProvider((Configuration)yarnConf);
        configurationProvider.init((Configuration)yarnConf);
        this.context.setConfigurationProvider(configurationProvider);
        RMNodeLabelsManager nlm = new RMNodeLabelsManager();
        nlm.init((Configuration)yarnConf);
        nlm.start();
        this.context.setNodeLabelManager(nlm);
        scheduler.setRMContext((RMContext)this.context);
        scheduler.init((Configuration)yarnConf);
        scheduler.start();
        this.dispatcher.register(SchedulerEventType.class, (EventHandler)scheduler);
        String hostname1 = "localhost1";
        Resource capability = BuilderUtils.newResource((int)4096, (int)4);
        RegisterNodeManagerRequest request1 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        NodeId nodeId1 = NodeId.newInstance((String)hostname1, (int)0);
        request1.setNodeId(nodeId1);
        request1.setHttpPort(0);
        request1.setResource(capability);
        this.resourceTrackerService.registerNodeManager(request1);
        Assert.assertNotNull(this.context.getRMNodes().get(nodeId1));
        Assert.assertTrue((scheduler.getSchedulerNode(nodeId1).getRMNode() == this.context.getRMNodes().get(nodeId1) ? 1 : 0) != 0);
        Assert.assertEquals((Object)((RMNode)this.context.getRMNodes().get(nodeId1)).getTotalCapability(), (Object)capability);
        Resource capability1 = BuilderUtils.newResource((int)2048, (int)2);
        request1.setResource(capability1);
        this.resourceTrackerService.registerNodeManager(request1);
        Assert.assertNotNull(this.context.getRMNodes().get(nodeId1));
        Assert.assertTrue((scheduler.getSchedulerNode(nodeId1).getRMNode() == this.context.getRMNodes().get(nodeId1) ? 1 : 0) != 0);
        Assert.assertEquals((Object)((RMNode)this.context.getRMNodes().get(nodeId1)).getTotalCapability(), (Object)capability1);
        nlm.stop();
        scheduler.stop();
    }

    private class TestRMNodeEventDispatcher
    implements EventHandler<RMNodeEvent> {
        private TestRMNodeEventDispatcher() {
        }

        public void handle(RMNodeEvent event) {
            TestNMReconnect.this.rmNodeEvents.add(event);
        }
    }
}

