/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSchedulingMonitor {
    @Test(timeout=10000L)
    public void testRMStarts() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
        conf.set("yarn.resourcemanager.scheduler.monitor.policies", ProportionalCapacityPreemptionPolicy.class.getCanonicalName());
        ResourceManager rm = new ResourceManager();
        rm.init((Configuration)conf);
        SchedulingEditPolicy mPolicy = (SchedulingEditPolicy)Mockito.mock(SchedulingEditPolicy.class);
        Mockito.when((Object)mPolicy.getMonitoringInterval()).thenReturn((Object)1000L);
        SchedulingMonitor monitor = new SchedulingMonitor(rm.getRMContext(), mPolicy);
        monitor.serviceInit((Configuration)conf);
        monitor.serviceStart();
        ((SchedulingEditPolicy)Mockito.verify((Object)mPolicy, (VerificationMode)Mockito.timeout((int)10000))).editSchedule();
        monitor.close();
        rm.close();
    }
}

