/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.labelmanager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Set;
import net.java.dev.eval.Expression;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelExpressionHandlingHelper;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManagementService;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLabelManager {
    private static Configuration conf;
    private static FileSystem fs;
    private static LabelManagementService lbS;
    private static final String TEST_DIR;
    private static final String LABEL_FILE;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = new Configuration();
        conf.set("node.labels.file", LABEL_FILE);
        conf.setLong("node.labels.monitor.interval", 5000L);
        fs = FileSystem.getLocal((Configuration)conf);
        PrintWriter out = new PrintWriter(new FileWriter(LABEL_FILE));
        out.println("perfnode200.* big, \"Production Machines\"");
        out.println("perfnode203.* big, 'Development Machines'");
        out.println("perfnode15* good");
        out.println("perfnode1* right, good, fantastic");
        out.println("perfnode201* slow");
        out.println("perfnode204* good, big");
        out.println("node-.+lab     Fast");
        out.println("node-2*      Slow");
        out.close();
        lbS = new LabelManagementService();
        lbS.init(conf);
        lbS.start();
        Assert.assertTrue((lbS.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        lbS.stop();
        Assert.assertFalse((lbS.getServiceState() != Service.STATE.STOPPED ? 1 : 0) != 0);
        fs.delete(new Path(LABEL_FILE), false);
    }

    @Before
    public void setUp() throws Exception {
        conf = new Configuration();
        conf.set("node.labels.file", LABEL_FILE);
        conf.setLong("node.labels.monitor.interval", 5000L);
        PrintWriter out = new PrintWriter(new FileWriter(LABEL_FILE));
        out.println("perfnode200.* big, \"Production Machines\"");
        out.println("perfnode203.* big, 'Development Machines'");
        out.println("perfnode15* good");
        out.println("perfnode1* right, good, fantastic");
        out.println("perfnode201* slow");
        out.println("perfnode204* good, big");
        out.println("node-.+lab     Fast");
        out.println("node-2*      Slow");
        out.close();
        LabelManager lb = LabelManager.getInstance();
        lb.refreshLabels(conf);
    }

    @After
    public void tearDown() throws Exception {
        fs.delete(new Path(LABEL_FILE), false);
    }

    @Test(timeout=10000L)
    public void testLabelManager() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        Path labelFile = lb.getLabelFile();
        Assert.assertNotNull((Object)labelFile);
        Assert.assertTrue((boolean)LABEL_FILE.equalsIgnoreCase(labelFile.toString()));
        Assert.assertTrue((lbS.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        Thread.sleep(1000L);
        Set labels = lb.getLabelsForNode("perfnode151.perf.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)3L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("good"));
        Assert.assertTrue((boolean)labels.contains("right"));
        Assert.assertTrue((boolean)labels.contains("fantastic"));
        labels = lb.getLabelsForNode("perfnode200.abc.qa.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("big"));
        Assert.assertTrue((boolean)labels.contains("Production Machines"));
        labels = lb.getLabelsForNode("perfnode203.abc.qa.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("big"));
        Assert.assertTrue((boolean)labels.contains("Development Machines"));
        labels = lb.getLabelsForNode("node-33.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)1L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Fast"));
        labels = lb.getLabelsForNode("node-28.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Slow"));
        Assert.assertTrue((boolean)labels.contains("Fast"));
        labels = lb.getLabelsForNode("node-28.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Slow"));
        Assert.assertTrue((boolean)labels.contains("Fast"));
        labels = lb.getLabelsForNode("perfnode01.lab");
        Assert.assertNull((Object)labels);
        labels = lb.getLabelsForNode("perfnode01.lab");
        Assert.assertNull((Object)labels);
        labels = lb.getLabelsForNode("perfnode10.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)3L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("good"));
        Assert.assertTrue((boolean)labels.contains("right"));
        Assert.assertTrue((boolean)labels.contains("fantastic"));
        labels = lb.getLabelsForNode("perfnode10.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)3L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("good"));
        Assert.assertTrue((boolean)labels.contains("right"));
        Assert.assertTrue((boolean)labels.contains("fantastic"));
    }

    @Test
    public void testlabelExpressioncreation() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        Path labelFile = lb.getLabelFile();
        Assert.assertNotNull((Object)labelFile);
        Assert.assertTrue((boolean)LABEL_FILE.equalsIgnoreCase(labelFile.toString()));
        Assert.assertTrue((lbS.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        Thread.sleep(1000L);
        Expression expr = lb.getEffectiveLabelExpr("good && big");
        Assert.assertEquals((Object)"(good&&big)", (Object)expr.toString());
    }

    @Test
    public void testAllLabelQueuePolicyExpression() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        Path labelFile = lb.getLabelFile();
        Assert.assertNotNull((Object)labelFile);
        Assert.assertTrue((boolean)LABEL_FILE.equalsIgnoreCase(labelFile.toString()));
        Assert.assertTrue((lbS.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        Thread.sleep(1000L);
        Queue.QueueLabelPolicy policy = Queue.QueueLabelPolicy.AND;
        Expression queueLabelExpression = lb.getEffectiveLabelExpr("good && big");
        Expression appLabelExpression = lb.getEffectiveLabelExpr("good");
        Expression finalExpr = lb.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
        Assert.assertEquals((Object)"((good&&big)&&good)", (Object)finalExpr.toString());
        policy = Queue.QueueLabelPolicy.OR;
        finalExpr = lb.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
        Assert.assertEquals((Object)"((good&&big)||good)", (Object)finalExpr.toString());
        policy = Queue.QueueLabelPolicy.PREFER_APP;
        finalExpr = lb.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
        Assert.assertEquals((Object)"(good)", (Object)finalExpr.toString());
        policy = Queue.QueueLabelPolicy.PREFER_QUEUE;
        finalExpr = lb.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
        Assert.assertEquals((Object)"(good&&big)", (Object)finalExpr.toString());
    }

    @Test
    public void testLabelExpressionEvauation() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        Path labelFile = lb.getLabelFile();
        Assert.assertNotNull((Object)labelFile);
        Assert.assertTrue((boolean)LABEL_FILE.equalsIgnoreCase(labelFile.toString()));
        Assert.assertTrue((lbS.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        Thread.sleep(1000L);
        Queue.QueueLabelPolicy policy = Queue.QueueLabelPolicy.AND;
        Expression queueLabelExpression = lb.getEffectiveLabelExpr("good && big");
        Expression appLabelExpression = lb.getEffectiveLabelExpr("good");
        Expression finalExpr = lb.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
        Assert.assertEquals((Object)"((good&&big)&&good)", (Object)finalExpr.toString());
        LabelManager.LabelApplicabilityStatus result = lb.isNodeApplicableForApp("perfnode204.qa.lab", finalExpr);
        Assert.assertTrue((result == LabelManager.LabelApplicabilityStatus.NODE_HAS_LABEL ? 1 : 0) != 0);
        result = lb.isNodeApplicableForApp("perfnode203.qa.lab", finalExpr);
        Assert.assertTrue((result == LabelManager.LabelApplicabilityStatus.NODE_DOES_NOT_HAVE_LABEL ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testLabelsUpdateAfterMonitorInterval() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        Path labelFile = lb.getLabelFile();
        Assert.assertNotNull((Object)labelFile);
        Assert.assertTrue((boolean)LABEL_FILE.equalsIgnoreCase(labelFile.toString()));
        Assert.assertTrue((lbS.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        Thread.sleep(1000L);
        Set labels = lb.getLabelsForNode("perfnode151.perf.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)3L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("good"));
        Assert.assertTrue((boolean)labels.contains("right"));
        Assert.assertTrue((boolean)labels.contains("fantastic"));
        labels = lb.getLabelsForNode("perfnode200.abc.qa.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("big"));
        Assert.assertTrue((boolean)labels.contains("Production Machines"));
        labels = lb.getLabelsForNode("perfnode203.abc.qa.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("big"));
        Assert.assertTrue((boolean)labels.contains("Development Machines"));
        labels = lb.getLabelsForNode("node-33.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)1L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Fast"));
        labels = lb.getLabelsForNode("node-28.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Slow"));
        Assert.assertTrue((boolean)labels.contains("Fast"));
        fs.delete(new Path(LABEL_FILE), false);
        FSDataOutputStream fsout = fs.create(new Path(LABEL_FILE));
        fsout.writeBytes("/perfnode200.*/ big, \"Prod Machines\"");
        fsout.writeBytes("\n");
        fsout.writeBytes("/perfnode203.*/ small, 'Dev Machines'");
        fsout.writeBytes("\n");
        fsout.writeBytes("perfnode15* good");
        fsout.writeBytes("\n");
        fsout.writeBytes("perfnode201* slow");
        fsout.writeBytes("\n");
        fsout.writeBytes("perfnode204* good, big");
        fsout.writeBytes("\n");
        fsout.writeBytes("/node-.+lab/     Fast");
        fsout.writeBytes("\n");
        fsout.writeBytes("node-2*      Slow");
        fsout.writeBytes("\n");
        fsout.close();
        Thread.sleep(6000L);
        labels = lb.getLabelsForNode("perfnode200.abc.qa.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("big"));
        Assert.assertTrue((boolean)labels.contains("Prod Machines"));
        labels = lb.getLabelsForNode("perfnode203.abc.qa.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("small"));
        Assert.assertTrue((boolean)labels.contains("Dev Machines"));
        labels = lb.getLabelsForNode("perfnode151.perf.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)1L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("good"));
        labels = lb.getLabelsForNode("node-33.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)1L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Fast"));
        labels = lb.getLabelsForNode("node-28.lab");
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("Slow"));
        Assert.assertTrue((boolean)labels.contains("Fast"));
    }

    @Test
    public void testGetEffectiveLabelExpr() throws IOException {
        LabelManager lb = LabelManager.getInstance();
        Expression labelExpr = lb.getEffectiveLabelExpr("High Memory");
        Assert.assertEquals((Object)"(High Memory)", (Object)labelExpr.toString());
        labelExpr = lb.getEffectiveLabelExpr("'High Memory'");
        Assert.assertEquals((Object)"(High Memory)", (Object)labelExpr.toString());
        labelExpr = lb.getEffectiveLabelExpr("\"High Memory\"");
        Assert.assertEquals((Object)"(High Memory)", (Object)labelExpr.toString());
        labelExpr = lb.getEffectiveLabelExpr("Slow && Fast");
        Assert.assertEquals((Object)"(Slow&&Fast)", (Object)labelExpr.toString());
        labelExpr = lb.getEffectiveLabelExpr("Slow A && Slow B && 'Slow C'");
        Assert.assertEquals((Object)"((Slow A&&Slow B)&&Slow C)", (Object)labelExpr.toString());
        labelExpr = lb.getEffectiveLabelExpr("Slow A && Slow B || 'Slow C'");
        Assert.assertEquals((Object)"((Slow A&&Slow B)||Slow C)", (Object)labelExpr.toString());
        labelExpr = lb.getEffectiveLabelExpr("SlowA && !Slow B && ! 'Slow C'");
        Assert.assertEquals((Object)"((SlowA&&(!Slow B))&&(!Slow C))", (Object)labelExpr.toString());
        labelExpr = lb.getEffectiveLabelExpr("(Slow A && Slow B) ||! 'Slow C'");
        Assert.assertEquals((Object)"((Slow A&&Slow B)||(!Slow C))", (Object)labelExpr.toString());
        labelExpr = lb.getEffectiveLabelExpr("!A&&( B && C)");
        Assert.assertEquals((Object)"((!A)&&(B&&C))", (Object)labelExpr.toString());
        labelExpr = lb.getEffectiveLabelExpr("! A && ! B && Slow C");
        Assert.assertEquals((Object)"(((!A)&&(!B))&&Slow C)", (Object)labelExpr.toString());
        labelExpr = lb.getEffectiveLabelExpr("*");
        Assert.assertNull((Object)labelExpr);
        labelExpr = lb.getEffectiveLabelExpr("all");
        Assert.assertNull((Object)labelExpr);
        labelExpr = lb.getEffectiveLabelExpr(null);
        Assert.assertNull((Object)labelExpr);
    }

    @Test
    public void testLabelsRefresh() throws IOException {
        LabelManager lb = LabelManager.getInstance();
        fs.delete(new Path(LABEL_FILE), false);
        PrintWriter out = new PrintWriter(new FileWriter(LABEL_FILE));
        out.println("node1  Plain");
        out.println("node2  Large");
        out.close();
        lb.refreshLabels(conf);
        Set node1Labels = lb.getLabelsForNode("node1");
        Set node2Labels = lb.getLabelsForNode("node2");
        Assert.assertEquals((long)node1Labels.size(), (long)1L);
        Assert.assertTrue((boolean)node1Labels.contains("Plain"));
        Assert.assertEquals((long)node2Labels.size(), (long)1L);
        Assert.assertTrue((boolean)node2Labels.contains("Large"));
        fs.delete(new Path(LABEL_FILE), false);
        out = new PrintWriter(new FileWriter(LABEL_FILE));
        out.println("node1  Dev");
        out.println("node2  Prod");
        out.close();
        lb.refreshLabels(conf);
        node1Labels = lb.getLabelsForNode("node1");
        node2Labels = lb.getLabelsForNode("node2");
        Assert.assertEquals((long)node1Labels.size(), (long)1L);
        Assert.assertTrue((boolean)node1Labels.contains("Dev"));
        Assert.assertEquals((long)node2Labels.size(), (long)1L);
        Assert.assertTrue((boolean)node2Labels.contains("Prod"));
        lb.refreshLabels(new Configuration());
        Set labels = lb.getLabels();
        Assert.assertTrue((boolean)labels.isEmpty());
        conf.set("node.labels.file", "/notexist");
        lb.refreshLabels(conf);
        labels = lb.getLabels();
        Assert.assertTrue((boolean)labels.isEmpty());
    }

    @Test
    public void testBadLabels() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        Queue.QueueLabelPolicy policy = Queue.QueueLabelPolicy.AND;
        Expression queueLabelExpression = lb.getEffectiveLabelExpr("good && big");
        Expression appLabelExpression = lb.getEffectiveLabelExpr("badlabel");
        Expression finalExpr = lb.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
        Assert.assertEquals((Object)"((good&&big)&&badlabel)", (Object)finalExpr.toString());
        try {
            lb.isNodeApplicableForApp("perfnode204.qa.lab", finalExpr);
            Assert.fail((String)("Evaluation should fail for: " + finalExpr.toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testAddLabels_ok() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        String existedNode = "perfnode1*";
        ImmutableSet existedLabels = ImmutableSet.of((Object)"right", (Object)"good", (Object)"fantastic");
        String nodeName1 = "node04.cluster.com";
        String nodeName2 = "node05.cluster.com";
        String label1 = "_fast A1";
        String label2 = "slow";
        String arg = nodeName1 + "=" + label1 + "; " + nodeName2 + "=" + label2;
        String nodeName3 = "node06.cluster.com";
        String label31 = "label AAA";
        String label32 = "label-777";
        String label33 = "'label BB'";
        arg = arg + "; " + nodeName3 + "=" + label31 + ", " + label32 + ", " + label33;
        lb.addToClusterNodeLabels(arg);
        lb.refreshLabels(conf);
        Set labelsForNode1 = lb.getLabelsForNode(nodeName1);
        Set labelsForNode2 = lb.getLabelsForNode(nodeName2);
        Set labelsForNode3 = lb.getLabelsForNode(nodeName3);
        Set existed = lb.getLabelsForNode(existedNode);
        Assert.assertNotNull((Object)labelsForNode1);
        Assert.assertNotNull((Object)labelsForNode2);
        Assert.assertNotNull((Object)existed);
        Assert.assertTrue((boolean)labelsForNode1.contains(label1));
        Assert.assertTrue((boolean)labelsForNode2.contains(label2));
        Assert.assertTrue((boolean)existed.containsAll((Collection<?>)existedLabels));
        Assert.assertTrue((boolean)labelsForNode3.contains(label31));
        Assert.assertTrue((boolean)labelsForNode3.contains(label32));
        Assert.assertTrue((boolean)labelsForNode3.contains("label BB"));
    }

    @Test
    public void testAddLabels_badLabel() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        String node = "node1";
        String badLabel = "1label";
        ImmutableList labelsForAllNodes = ImmutableList.copyOf((Collection)lb.getLabelsForAllNodes(false));
        try {
            lb.addToClusterNodeLabels(node + "=" + badLabel);
            Assert.fail((String)"IOException is expected!");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((Object)lb.getLabelsForAllNodes(false), (Object)labelsForAllNodes);
    }

    @Test
    public void testRemoveLabels_ok() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        String node = "perfnode1*";
        String node2 = "perfnode15*";
        String node3 = "perfnode201*";
        String node4 = "perfnode204*";
        String node5 = "perfnode200.*";
        String label1 = "right";
        String label2 = "good";
        String label3 = "fantastic";
        String label4 = "slow";
        String label5 = "big";
        String label6 = "Production Machines";
        String nodeName6 = "node06.cluster.com";
        String label61 = "label-777";
        String label62 = "label AAA";
        Assert.assertNotNull((Object)lb.getLabelsForNode(node));
        Assert.assertTrue((boolean)lb.getLabelsForNode(node).containsAll((Collection<?>)ImmutableSet.of((Object)label1, (Object)label2, (Object)label3)));
        lb.removeFromClusterNodeLabels(node + "=" + label1);
        lb.refreshLabels(conf);
        Assert.assertFalse((boolean)lb.getLabelsForNode(node).contains(label1));
        lb.removeFromClusterNodeLabels(node + "=" + label2 + "," + label3);
        lb.refreshLabels(conf);
        Assert.assertNull((Object)lb.getLabelsForNode(node));
        lb.removeFromClusterNodeLabels(node2 + "=*");
        lb.refreshLabels(conf);
        Assert.assertNull((Object)lb.getLabelsForNode(node2));
        Assert.assertTrue((lb.getLabelsForAllNodes(false).size() > 0 ? 1 : 0) != 0);
        lb.removeFromClusterNodeLabels(node3 + "=" + label4 + ";" + node4 + "=" + label2 + "," + label5);
        lb.refreshLabels(conf);
        Assert.assertNull((Object)lb.getLabelsForNode(node3));
        Assert.assertNull((Object)lb.getLabelsForNode(node4));
        Assert.assertTrue((boolean)lb.getLabelsForNode(node5).contains(label6));
        lb.addToClusterNodeLabels(nodeName6 + "=" + label3);
        lb.refreshLabels(conf);
        lb.addToClusterNodeLabels(nodeName6 + "=" + label61 + ", " + label62);
        lb.refreshLabels(conf);
        lb.removeFromClusterNodeLabels(nodeName6 + "=" + label61);
        lb.refreshLabels(conf);
        Assert.assertFalse((boolean)lb.getLabelsForNode(nodeName6).contains(label61));
        lb.removeFromClusterNodeLabels(nodeName6 + "=" + label62);
        lb.refreshLabels(conf);
        Assert.assertFalse((boolean)lb.getLabelsForNode(nodeName6).contains(label62));
        lb.addToClusterNodeLabels(nodeName6 + "=label BB");
        lb.removeFromClusterNodeLabels(nodeName6 + "='label BB'");
        lb.refreshLabels(conf);
        Assert.assertFalse((boolean)lb.getLabelsForNode(nodeName6).contains("label BB"));
        lb.removeFromClusterNodeLabels("*");
        lb.refreshLabels(conf);
        Assert.assertTrue((boolean)fs.exists(new Path(LABEL_FILE)));
        Assert.assertTrue((boolean)lb.getLabelsForAllNodes(false).isEmpty());
    }

    @Test
    public void testRemoveLabels_bad() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        String node = "perfnode1*";
        String label1 = "right";
        String label2 = "good";
        String label3 = "fantastic";
        String nonExistingLabel = "left";
        Assert.assertNotNull((Object)lb.getLabelsForNode(node));
        Assert.assertTrue((boolean)lb.getLabelsForNode(node).containsAll((Collection<?>)ImmutableSet.of((Object)label1, (Object)label2, (Object)label3)));
        lb.removeFromClusterNodeLabels(node + "=" + nonExistingLabel);
        lb.refreshLabels(conf);
        Assert.assertNotNull((Object)lb.getLabelsForNode(node));
        Assert.assertTrue((boolean)lb.getLabelsForNode(node).containsAll((Collection<?>)ImmutableSet.of((Object)label1, (Object)label2, (Object)label3)));
    }

    @Test
    public void testReplaceLabels_ok() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        String node = "perfnode1*";
        String node2 = "perfnode15*";
        String node3 = "perfnode201*";
        String node4 = "perfnode204*";
        String label1 = "right";
        String label2 = "good";
        String label3 = "fantastic";
        String label4 = "slow";
        String testLabel1 = "test Label1";
        String testLabel2 = "testLabel2";
        String testLabel3 = "testLabel3";
        lb.replaceLabelsOnNode(node3 + "=" + label4 + "|" + testLabel1 + ";" + node4 + "=" + label2 + "|" + testLabel2);
        lb.refreshLabels(conf);
        Assert.assertFalse((boolean)lb.getLabelsForNode(node3).contains(label4));
        Assert.assertFalse((boolean)lb.getLabelsForNode(node4).contains(label2));
        Assert.assertTrue((boolean)lb.getLabelsForNode(node3).contains(testLabel1));
        Assert.assertTrue((boolean)lb.getLabelsForNode(node4).contains(testLabel2));
        lb.replaceLabelsOnNode(node + "=" + label1 + "|" + testLabel1);
        lb.refreshLabels(conf);
        Assert.assertFalse((boolean)lb.getLabelsForNode(node).contains(label1));
        Assert.assertTrue((boolean)lb.getLabelsForNode(node).contains(testLabel1));
        lb.replaceLabelsOnNode(node + "=" + label3 + "|" + testLabel3 + "," + testLabel1 + "|" + label1);
        lb.refreshLabels(conf);
        Assert.assertFalse((boolean)lb.getLabelsForNode(node).containsAll((Collection<?>)ImmutableSet.of((Object)label3, (Object)LabelExpressionHandlingHelper.wrapIfNeeded((String)testLabel1))));
        Assert.assertTrue((boolean)lb.getLabelsForNode(node).containsAll((Collection<?>)ImmutableSet.of((Object)testLabel3, (Object)label1)));
        lb.replaceLabelsOnNode("*=" + label2 + "|" + testLabel2);
        lb.refreshLabels(conf);
        Assert.assertTrue((lb.getLabelsForNode(node).contains(testLabel2) && lb.getLabelsForNode(node2).contains(testLabel2) ? 1 : 0) != 0);
        Assert.assertFalse((lb.getLabelsForNode(node).contains(label2) && lb.getLabelsForNode(node2).contains(label2) ? 1 : 0) != 0);
        lb.replaceLabelsOnNode(node3 + "='test Label1'|'label replaced'");
        lb.refreshLabels(conf);
        Assert.assertTrue((boolean)lb.getLabelsForNode(node3).contains("label replaced"));
        Assert.assertEquals((long)3L, (long)lb.getLabelsForNode(node).size());
        Assert.assertTrue((boolean)lb.getLabelsForNode(node).containsAll((Collection<?>)ImmutableList.of((Object)testLabel2, (Object)testLabel3)));
        lb.replaceLabelsOnNode(node + "=" + testLabel2 + "|" + testLabel3);
        Assert.assertEquals((long)2L, (long)lb.getLabelsForNode(node).size());
        Assert.assertTrue((boolean)lb.getLabelsForNode(node).contains(testLabel3));
        Assert.assertFalse((boolean)lb.getLabelsForNode(node).contains(testLabel2));
    }

    @Test
    public void testReplaceLabels_notExistedAndBadLabels() throws Exception {
        LabelManager lb = LabelManager.getInstance();
        String node = "perfnode1*";
        String label = "good";
        String badLabel = "1asdasdasd";
        lb.replaceLabelsOnNode(node + "=" + badLabel + "|" + label);
        lb.refreshLabels(conf);
        Assert.assertNotNull((Object)lb.getLabelsForNode(node));
        Assert.assertTrue((boolean)lb.getLabelsForNode(node).contains(label));
        Assert.assertFalse((boolean)lb.getLabelsForNode(node).contains(badLabel));
        try {
            lb.replaceLabelsOnNode(node + "=" + label + "|" + badLabel);
            Assert.fail((String)"Expected IOException! Cause: label syntax is wrong.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testPerformance() throws Exception {
        Object resourceName;
        int i;
        fs.delete(new Path(LABEL_FILE), false);
        FSDataOutputStream fsout = fs.create(new Path(LABEL_FILE));
        for (int i2 = 0; i2 < 1000; ++i2) {
            String node = "node-2." + i2 + ".lab";
            if (i2 % 3 == 0) {
                fsout.writeBytes(node + "      Slow");
            } else if (i2 % 5 == 0) {
                fsout.writeBytes(node + "      good");
            } else if (i2 % 7 == 0) {
                fsout.writeBytes(node + "      Fast");
            } else {
                fsout.writeBytes(node + "      Slow, good, small");
            }
            fsout.writeBytes("\n");
        }
        fsout.close();
        Thread.sleep(6000L);
        LabelManager lb = LabelManager.getInstance();
        Expression finalExp = lb.constructAppLabel(Queue.QueueLabelPolicy.OR, new Expression("Slow || Fast"), new Expression("Slow"));
        Expression appExp = new Expression("Slow || Fast");
        Expression qExp = new Expression("Slow");
        long startTime = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            String resourceName2 = "node-2." + i % 1000 + ".lab";
            lb.isNodeApplicableForApp(resourceName2, finalExp);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Time taken: " + (endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            resourceName = "node-2." + i % 1000 + ".lab";
            lb.isNodeApplicableForApp((String)resourceName, finalExp);
        }
        endTime = System.currentTimeMillis();
        System.out.println("Time taken2: " + (endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        for (i = 0; i < 3000000; ++i) {
            resourceName = "/defaultrack";
            lb.isNodeApplicableForApp((String)resourceName, finalExp);
        }
        endTime = System.currentTimeMillis();
        System.out.println("Time taken3: " + (endTime - startTime) + " ms");
    }

    static {
        TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        LABEL_FILE = TEST_DIR + "/labelFile";
    }
}

