/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManager;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelStorage;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.UTCClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClientRMService {
    private static final Logger LOG = LoggerFactory.getLogger(TestClientRMService.class);
    private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private String appType = "MockApp";
    private static RMDelegationTokenSecretManager dtsm;
    private static final String QUEUE_1 = "Q-1";
    private static final String QUEUE_2 = "Q-2";
    private static final String kerberosRule = "RULE:[1:$1@$0](.*@EXAMPLE.COM)s/@.*//\nDEFAULT";
    private static final UserGroupInformation owner;
    private static final UserGroupInformation other;
    private static final UserGroupInformation tester;
    private static final String testerPrincipal = "tester@EXAMPLE.COM";
    private static final String ownerPrincipal = "owner@EXAMPLE.COM";
    private static final String otherPrincipal = "other@EXAMPLE.COM";
    private static final UserGroupInformation testerKerb;
    private static final UserGroupInformation ownerKerb;
    private static final UserGroupInformation otherKerb;

    @BeforeClass
    public static void setupSecretManager() throws IOException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)new NullRMStateStore());
        dtsm = new RMDelegationTokenSecretManager(60000L, 60000L, 60000L, 60000L, rmContext);
        dtsm.startThreads();
    }

    @AfterClass
    public static void teardownSecretManager() {
        if (dtsm != null) {
            dtsm.stopThreads();
        }
    }

    @Test
    public void testGetClusterNodes() throws Exception {
        MockRM rm = new MockRM(){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        RMNodeLabelsManager labelsMgr = rm.getRMContext().getNodeLabelManager();
        labelsMgr.addToCluserNodeLabels((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        MockNM node = rm.registerNode("host1:1234", 1024);
        HashMap<NodeId, ImmutableSet> map = new HashMap<NodeId, ImmutableSet>();
        map.put(node.getNodeId(), ImmutableSet.of((Object)"x"));
        labelsMgr.replaceLabelsOnNode(map);
        rm.sendNodeStarted(node);
        node.nodeHeartbeat(true);
        MockNM lostNode = rm.registerNode("host2:1235", 1024);
        rm.sendNodeStarted(lostNode);
        lostNode.nodeHeartbeat(true);
        rm.NMwaitForState(lostNode.getNodeId(), NodeState.RUNNING);
        rm.sendNodeLost(lostNode);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetClusterNodesRequest request = GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.RUNNING));
        List nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((long)1L, (long)nodeReports.size());
        Assert.assertNotSame((String)"Node is expected to be healthy!", (Object)NodeState.UNHEALTHY, (Object)((NodeReport)nodeReports.get(0)).getNodeState());
        RMNodeLabelsManager nlm = rm.getRMContext().getNodeLabelManager();
        Assert.assertTrue((boolean)nlm.getLabelsOnNode(node.getNodeId()).contains("x"));
        node.nodeHeartbeat(false);
        nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((String)"Unhealthy nodes should not show up by default", (long)0L, (long)nodeReports.size());
        map = new HashMap();
        map.put(node.getNodeId(), ImmutableSet.of((Object)"y"));
        labelsMgr.replaceLabelsOnNode(map);
        request = GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.UNHEALTHY));
        nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((long)1L, (long)nodeReports.size());
        Assert.assertEquals((String)"Node is expected to be unhealthy!", (Object)NodeState.UNHEALTHY, (Object)((NodeReport)nodeReports.get(0)).getNodeState());
        Assert.assertTrue((boolean)nlm.getLabelsOnNode(node.getNodeId()).contains("y"));
        map = new HashMap();
        map.put(node.getNodeId(), ImmutableSet.of((Object)"y"));
        labelsMgr.removeLabelsFromNode(map);
        rm.registerNode("host3:1236", 1024);
        request = GetClusterNodesRequest.newInstance(EnumSet.allOf(NodeState.class));
        nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((long)3L, (long)nodeReports.size());
        for (NodeReport report : nodeReports) {
            Assert.assertTrue((report.getNodeLabels() != null && report.getNodeLabels().isEmpty() ? 1 : 0) != 0);
        }
        rpc.stopProxy((Object)client, conf);
        rm.close();
    }

    @Test
    public void testNonExistingApplicationReport() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationReportRequest request = (GetApplicationReportRequest)recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        request.setApplicationId(ApplicationId.newInstance((long)0L, (int)0));
        try {
            rmService.getApplicationReport(request);
            Assert.fail();
        }
        catch (ApplicationNotFoundException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)("Application with id '" + request.getApplicationId() + "' doesn't exist in RM."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetApplicationReport() throws Exception {
        YarnScheduler yarnScheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        ApplicationId appId1 = TestClientRMService.getApplicationId(1);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId1)).thenReturn((Object)true);
        try (ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, null, mockAclsManager, null, null);){
            RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
            GetApplicationReportRequest request = (GetApplicationReportRequest)recordFactory.newRecordInstance(GetApplicationReportRequest.class);
            request.setApplicationId(appId1);
            GetApplicationReportResponse response = rmService.getApplicationReport(request);
            ApplicationReport report = response.getApplicationReport();
            ApplicationResourceUsageReport usageReport = report.getApplicationResourceUsageReport();
            Assert.assertEquals((long)10L, (long)usageReport.getMemorySeconds());
            Assert.assertEquals((long)3L, (long)usageReport.getVcoreSeconds());
            GetApplicationReportRequest invalidRequest = (GetApplicationReportRequest)recordFactory.newRecordInstance(GetApplicationReportRequest.class);
            invalidRequest.setApplicationId(null);
            try {
                rmService.getApplicationReport(invalidRequest);
            }
            catch (YarnException e) {
                Assert.assertTrue((boolean)(e instanceof ApplicationNotFoundException));
            }
        }
    }

    @Test
    public void testGetApplicationAttemptReport() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationAttemptReportRequest request = (GetApplicationAttemptReportRequest)recordFactory.newRecordInstance(GetApplicationAttemptReportRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        request.setApplicationAttemptId(attemptId);
        try {
            GetApplicationAttemptReportResponse response = rmService.getApplicationAttemptReport(request);
            Assert.assertEquals((Object)attemptId, (Object)response.getApplicationAttemptReport().getApplicationAttemptId());
        }
        catch (ApplicationNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetApplicationResourceUsageReportDummy() throws YarnException, IOException {
        ApplicationAttemptId attemptId = TestClientRMService.getApplicationAttemptId(1);
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationSubmissionContext asContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        YarnConfiguration config = new YarnConfiguration();
        RMAppAttemptImpl rmAppAttemptImpl = new RMAppAttemptImpl(attemptId, rmContext, yarnScheduler, null, asContext, (Configuration)config, false, null);
        ApplicationResourceUsageReport report = rmAppAttemptImpl.getApplicationResourceUsageReport();
        Assert.assertEquals((Object)report, (Object)RMServerUtils.DUMMY_APPLICATION_RESOURCE_USAGE_REPORT);
    }

    @Test
    public void testGetApplicationAttempts() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationAttemptsRequest request = (GetApplicationAttemptsRequest)recordFactory.newRecordInstance(GetApplicationAttemptsRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        request.setApplicationId(ApplicationId.newInstance((long)123456L, (int)1));
        try {
            GetApplicationAttemptsResponse response = rmService.getApplicationAttempts(request);
            Assert.assertEquals((long)1L, (long)response.getApplicationAttemptList().size());
            Assert.assertEquals((Object)attemptId, (Object)((ApplicationAttemptReport)response.getApplicationAttemptList().get(0)).getApplicationAttemptId());
        }
        catch (ApplicationNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetContainerReport() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetContainerReportRequest request = (GetContainerReportRequest)recordFactory.newRecordInstance(GetContainerReportRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        request.setContainerId(containerId);
        try {
            GetContainerReportResponse response = rmService.getContainerReport(request);
            Assert.assertEquals((Object)containerId, (Object)response.getContainerReport().getContainerId());
        }
        catch (ApplicationNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetContainers() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetContainersRequest request = (GetContainersRequest)recordFactory.newRecordInstance(GetContainersRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        request.setApplicationAttemptId(attemptId);
        try {
            GetContainersResponse response = rmService.getContainers(request);
            Assert.assertEquals((Object)containerId, (Object)((ContainerReport)response.getContainerList().get(0)).getContainerId());
        }
        catch (ApplicationNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    public ClientRMService createRMService() throws IOException {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        ConcurrentHashMap<ApplicationId, RMApp> apps = this.getRMApps(rmContext, yarnScheduler);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(apps);
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)new Configuration());
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString())).thenReturn((Object)true);
        return new ClientRMService(rmContext, yarnScheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
    }

    @Test
    public void testForceKillNonExistingApplication() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)System.currentTimeMillis(), (int)0);
        KillApplicationRequest request = KillApplicationRequest.newInstance((ApplicationId)applicationId);
        try {
            rmService.forceKillApplication(request);
            Assert.fail();
        }
        catch (ApplicationNotFoundException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)("Trying to kill an absent application " + request.getApplicationId()));
        }
    }

    @Test
    public void testForceKillApplication() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        MockRM rm = new MockRM();
        rm.init((Configuration)conf);
        rm.start();
        ClientRMService rmService = rm.getClientRMService();
        GetApplicationsRequest getRequest = GetApplicationsRequest.newInstance(EnumSet.of(YarnApplicationState.KILLED));
        RMApp app1 = rm.submitApp(1024);
        RMApp app2 = rm.submitApp(1024, true);
        Assert.assertEquals((String)"Incorrect number of apps in the RM", (long)0L, (long)rmService.getApplications(getRequest).getApplicationList().size());
        KillApplicationRequest killRequest1 = KillApplicationRequest.newInstance((ApplicationId)app1.getApplicationId());
        KillApplicationRequest killRequest2 = KillApplicationRequest.newInstance((ApplicationId)app2.getApplicationId());
        int killAttemptCount = 0;
        for (int i = 0; i < 100; ++i) {
            KillApplicationResponse killResponse1 = rmService.forceKillApplication(killRequest1);
            ++killAttemptCount;
            if (killResponse1.getIsKillCompleted()) break;
            Thread.sleep(10L);
        }
        Assert.assertTrue((String)"Kill attempt count should be greater than 1 for managed AMs", (killAttemptCount > 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Incorrect number of apps in the RM", (long)1L, (long)rmService.getApplications(getRequest).getApplicationList().size());
        KillApplicationResponse killResponse2 = rmService.forceKillApplication(killRequest2);
        Assert.assertTrue((String)"Killing UnmanagedAM should falsely acknowledge true", (boolean)killResponse2.getIsKillCompleted());
        for (int i = 0; i < 100 && 2 != rmService.getApplications(getRequest).getApplicationList().size(); ++i) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((String)"Incorrect number of apps in the RM", (long)2L, (long)rmService.getApplications(getRequest).getApplicationList().size());
    }

    @Test(expected=ApplicationNotFoundException.class)
    public void testMoveAbsentApplication() throws YarnException, InterruptedException, ExecutionException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)System.currentTimeMillis(), (int)0);
        MoveApplicationAcrossQueuesRequest request = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)applicationId, (String)"newqueue");
        rmService.moveApplicationAcrossQueues(request);
    }

    @Test
    public void testGetQueueInfo() throws Exception {
        YarnScheduler yarnScheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)mockAclsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (ApplicationAccessType)Matchers.any(ApplicationAccessType.class), Matchers.anyString(), (ApplicationId)Matchers.any(ApplicationId.class))).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, null, mockAclsManager, mockQueueACLsManager, null);
        GetQueueInfoRequest request = (GetQueueInfoRequest)this.recordFactory.newRecordInstance(GetQueueInfoRequest.class);
        request.setQueueName("testqueue");
        request.setIncludeApplications(true);
        GetQueueInfoResponse queueInfo = rmService.getQueueInfo(request);
        List applications = queueInfo.getQueueInfo().getApplications();
        Assert.assertEquals((long)2L, (long)applications.size());
        request.setQueueName("nonexistentqueue");
        request.setIncludeApplications(true);
        queueInfo = rmService.getQueueInfo(request);
        ApplicationACLsManager mockAclsManager1 = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager1 = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager1.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)mockAclsManager1.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (ApplicationAccessType)Matchers.any(ApplicationAccessType.class), Matchers.anyString(), (ApplicationId)Matchers.any(ApplicationId.class))).thenReturn((Object)false);
        ClientRMService rmService1 = new ClientRMService(rmContext, yarnScheduler, null, mockAclsManager1, mockQueueACLsManager1, null);
        request.setQueueName("testqueue");
        request.setIncludeApplications(true);
        GetQueueInfoResponse queueInfo1 = rmService1.getQueueInfo(request);
        List applications1 = queueInfo1.getQueueInfo().getApplications();
        Assert.assertEquals((long)0L, (long)applications1.size());
    }

    @Test
    public void testTokenRenewalByOwner() throws Exception {
        owner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestClientRMService.this.checkTokenRenewal(owner, owner);
                return null;
            }
        });
    }

    @Test
    public void testTokenRenewalWrongUser() throws Exception {
        try {
            owner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        TestClientRMService.this.checkTokenRenewal(owner, other);
                        return null;
                    }
                    catch (YarnException ex) {
                        Assert.assertTrue((boolean)ex.getMessage().contains(owner.getUserName() + " tries to renew a token with renewer " + other.getUserName()));
                        throw ex;
                    }
                }
            });
        }
        catch (Exception e) {
            return;
        }
        Assert.fail((String)"renew should have failed");
    }

    @Test
    public void testTokenRenewalByLoginUser() throws Exception {
        UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestClientRMService.this.checkTokenRenewal(owner, owner);
                TestClientRMService.this.checkTokenRenewal(owner, other);
                return null;
            }
        });
    }

    private void checkTokenRenewal(UserGroupInformation owner, UserGroupInformation renewer) throws IOException, YarnException {
        RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier(new Text(owner.getUserName()), new Text(renewer.getUserName()), null);
        Token token = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)dtsm);
        org.apache.hadoop.yarn.api.records.Token dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
        RenewDelegationTokenRequest request = (RenewDelegationTokenRequest)Records.newRecord(RenewDelegationTokenRequest.class);
        request.setDelegationToken(dToken);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, dtsm);
        rmService.renewDelegationToken(request);
    }

    @Test
    public void testTokenCancellationByOwner() throws Exception {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        final ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, dtsm);
        testerKerb.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestClientRMService.this.checkTokenCancellation(rmService, testerKerb, other);
                return null;
            }
        });
        owner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestClientRMService.this.checkTokenCancellation(owner, other);
                return null;
            }
        });
    }

    @Test
    public void testTokenCancellationByRenewer() throws Exception {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        final ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, dtsm);
        testerKerb.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestClientRMService.this.checkTokenCancellation(rmService, owner, testerKerb);
                return null;
            }
        });
        other.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestClientRMService.this.checkTokenCancellation(owner, other);
                return null;
            }
        });
    }

    @Test
    public void testTokenCancellationByWrongUser() {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        final ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, dtsm);
        UserGroupInformation[] kerbTestOwners = new UserGroupInformation[]{owner, other, tester, ownerKerb, otherKerb};
        UserGroupInformation[] kerbTestRenewers = new UserGroupInformation[]{owner, other, ownerKerb, otherKerb};
        for (final UserGroupInformation tokOwner : kerbTestOwners) {
            for (final UserGroupInformation tokRenewer : kerbTestRenewers) {
                try {
                    testerKerb.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            try {
                                TestClientRMService.this.checkTokenCancellation(rmService, tokOwner, tokRenewer);
                                Assert.fail((String)("We should not reach here; token owner = " + tokOwner.getUserName() + ", renewer = " + tokRenewer.getUserName()));
                                return null;
                            }
                            catch (YarnException e) {
                                Assert.assertTrue((boolean)e.getMessage().contains(testerKerb.getUserName() + " is not authorized to cancel the token"));
                                return null;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception; " + e.getMessage()));
                }
            }
        }
        UserGroupInformation[] simpleTestOwners = new UserGroupInformation[]{owner, other, ownerKerb, otherKerb, testerKerb};
        UserGroupInformation[] simpleTestRenewers = new UserGroupInformation[]{owner, other, ownerKerb, otherKerb};
        for (final UserGroupInformation tokOwner : simpleTestOwners) {
            for (final UserGroupInformation tokRenewer : simpleTestRenewers) {
                try {
                    tester.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            try {
                                TestClientRMService.this.checkTokenCancellation(tokOwner, tokRenewer);
                                Assert.fail((String)("We should not reach here; token owner = " + tokOwner.getUserName() + ", renewer = " + tokRenewer.getUserName()));
                                return null;
                            }
                            catch (YarnException ex) {
                                Assert.assertTrue((boolean)ex.getMessage().contains(tester.getUserName() + " is not authorized to cancel the token"));
                                return null;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception; " + e.getMessage()));
                }
            }
        }
    }

    private void checkTokenCancellation(UserGroupInformation owner, UserGroupInformation renewer) throws IOException, YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, dtsm);
        this.checkTokenCancellation(rmService, owner, renewer);
    }

    private void checkTokenCancellation(ClientRMService rmService, UserGroupInformation owner, UserGroupInformation renewer) throws IOException, YarnException {
        RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier(new Text(owner.getUserName()), new Text(renewer.getUserName()), null);
        Token token = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)dtsm);
        org.apache.hadoop.yarn.api.records.Token dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
        CancelDelegationTokenRequest request = (CancelDelegationTokenRequest)Records.newRecord(CancelDelegationTokenRequest.class);
        request.setDelegationToken(dToken);
        rmService.cancelDelegationToken(request);
    }

    @Test(timeout=30000L)
    public void testAppSubmit() throws Exception {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationId appId1 = TestClientRMService.getApplicationId(100);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId1)).thenReturn((Object)true);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString())).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
        SubmitApplicationRequest submitRequest1 = this.mockSubmitAppRequest(appId1, null, null);
        try {
            rmService.submitApplication(submitRequest1);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        RMApp app1 = (RMApp)rmContext.getRMApps().get(appId1);
        Assert.assertNotNull((String)"app doesn't exist", (Object)app1);
        Assert.assertEquals((String)"app name doesn't match", (Object)"N/A", (Object)app1.getName());
        Assert.assertEquals((String)"app queue doesn't match", (Object)"default", (Object)app1.getQueue());
        String name = MockApps.newAppName();
        String queue = MockApps.newQueue();
        ApplicationId appId2 = TestClientRMService.getApplicationId(101);
        SubmitApplicationRequest submitRequest2 = this.mockSubmitAppRequest(appId2, name, queue);
        submitRequest2.getApplicationSubmissionContext().setApplicationType("matchType");
        try {
            rmService.submitApplication(submitRequest2);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        RMApp app2 = (RMApp)rmContext.getRMApps().get(appId2);
        Assert.assertNotNull((String)"app doesn't exist", (Object)app2);
        Assert.assertEquals((String)"app name doesn't match", (Object)name, (Object)app2.getName());
        Assert.assertEquals((String)"app queue doesn't match", (Object)queue, (Object)app2.getQueue());
        try {
            rmService.submitApplication(submitRequest2);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        GetApplicationsRequest getAllAppsRequest = GetApplicationsRequest.newInstance(new HashSet());
        GetApplicationsResponse getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        Assert.assertEquals((long)5L, (long)getAllApplicationsResponse.getApplicationList().size());
        HashSet<String> appTypes = new HashSet<String>();
        appTypes.add("matchType");
        getAllAppsRequest = GetApplicationsRequest.newInstance(appTypes);
        getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        Assert.assertEquals((long)1L, (long)getAllApplicationsResponse.getApplicationList().size());
        Assert.assertEquals((Object)appId2, (Object)((ApplicationReport)getAllApplicationsResponse.getApplicationList().get(0)).getApplicationId());
        appTypes = new HashSet();
        appTypes.add("MATCHTYPE");
        getAllAppsRequest = GetApplicationsRequest.newInstance(appTypes);
        getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        Assert.assertEquals((long)1L, (long)getAllApplicationsResponse.getApplicationList().size());
        Assert.assertEquals((Object)appId2, (Object)((ApplicationReport)getAllApplicationsResponse.getApplicationList().get(0)).getApplicationId());
    }

    @Test
    public void testAppSubmitInvalidLabel() throws IOException, NoSuchFieldException, IllegalAccessException {
        String label = "label";
        MockRM rm = new MockRM(){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        LabelManager labelManager = LabelManager.getInstance();
        Field privateField = LabelManager.class.getDeclaredField("isServiceEnabled");
        privateField.setAccessible(true);
        privateField.setBoolean(labelManager, true);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        String name = MockApps.newAppName();
        String queue = MockApps.newQueue();
        ApplicationId appId = TestClientRMService.getApplicationId(101);
        Resource resource = Resources.createResource((int)1024);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)this.recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        submissionContext.setApplicationName(name);
        submissionContext.setQueue(queue);
        submissionContext.setApplicationId(appId);
        submissionContext.setResource(resource);
        submissionContext.setApplicationType(this.appType);
        SubmitApplicationRequest submitRequest = (SubmitApplicationRequest)this.recordFactory.newRecordInstance(SubmitApplicationRequest.class);
        submitRequest.setApplicationSubmissionContext(submissionContext);
        submitRequest.getApplicationSubmissionContext().setApplicationType("matchType");
        submitRequest.getApplicationSubmissionContext().setLabel(label);
        try {
            client.submitApplication(submitRequest);
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Label \"" + label + "\" was not attached to any of the nodes. Application rejected!"));
            privateField.setBoolean(labelManager, false);
            return;
        }
        privateField.setBoolean(labelManager, false);
        Assert.fail();
    }

    @Test
    public void testGetApplications() throws Exception {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString())).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
        String[] queues = new String[]{QUEUE_1, QUEUE_2};
        String[] appNames = new String[]{MockApps.newAppName(), MockApps.newAppName(), MockApps.newAppName()};
        ApplicationId[] appIds = new ApplicationId[]{TestClientRMService.getApplicationId(101), TestClientRMService.getApplicationId(102), TestClientRMService.getApplicationId(103)};
        List<String> tags = Arrays.asList("Tag1", "Tag2", "Tag3");
        long[] submitTimeMillis = new long[3];
        for (int i = 0; i < appIds.length; ++i) {
            ApplicationId appId = appIds[i];
            Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId)).thenReturn((Object)true);
            SubmitApplicationRequest submitRequest = this.mockSubmitAppRequest(appId, appNames[i], queues[i % queues.length], new HashSet<String>(tags.subList(0, i + 1)));
            Thread.sleep(1L);
            rmService.submitApplication(submitRequest);
            submitTimeMillis[i] = rmService.getApplicationReport(GetApplicationReportRequest.newInstance((ApplicationId)appId)).getApplicationReport().getStartTime();
        }
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        Assert.assertEquals((String)"Incorrect total number of apps", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        request.setLimit(1L);
        Assert.assertEquals((String)"Failed to limit applications", (long)1L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance();
        request.setStartRange(submitTimeMillis[0] + 1L, System.currentTimeMillis());
        Assert.assertEquals((String)"Incorrect number of matching start range", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        request.setStartRange(submitTimeMillis[1] + 1L, System.currentTimeMillis());
        Assert.assertEquals((String)"Incorrect number of matching start range", (long)1L, (long)rmService.getApplications(request).getApplicationList().size());
        request.setStartRange(submitTimeMillis[2] + 1L, System.currentTimeMillis());
        Assert.assertEquals((String)"Incorrect number of matching start range", (long)0L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance();
        HashSet<String> queueSet = new HashSet<String>();
        request.setQueues(queueSet);
        queueSet.add(queues[0]);
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        queueSet.add(queues[1]);
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance();
        HashSet<String> userSet = new HashSet<String>();
        request.setUsers(userSet);
        userSet.add("random-user-name");
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)0L, (long)rmService.getApplications(request).getApplicationList().size());
        userSet.add(UserGroupInformation.getCurrentUser().getShortUserName());
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
        rmService.setDisplayPerUserApps(true);
        userSet.clear();
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        rmService.setDisplayPerUserApps(false);
        request = GetApplicationsRequest.newInstance((ApplicationsRequestScope)ApplicationsRequestScope.ALL, null, null, null, null, null, null, null, null);
        HashSet tagSet = new HashSet();
        request.setApplicationTags(tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        tagSet = Sets.newHashSet((Object[])new String[]{tags.get(0)});
        request.setApplicationTags((Set)tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
        tagSet = Sets.newHashSet((Object[])new String[]{tags.get(1)});
        request.setApplicationTags((Set)tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        tagSet = Sets.newHashSet((Object[])new String[]{tags.get(2)});
        request.setApplicationTags((Set)tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)1L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance((ApplicationsRequestScope)ApplicationsRequestScope.VIEWABLE);
        Assert.assertEquals((String)"Incorrect number of applications for the scope", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance((ApplicationsRequestScope)ApplicationsRequestScope.OWN);
        Assert.assertEquals((String)"Incorrect number of applications for the scope", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
    }

    @Test(timeout=4000L)
    public void testConcurrentAppSubmit() throws IOException, InterruptedException, BrokenBarrierException, YarnException {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        final ApplicationId appId1 = TestClientRMService.getApplicationId(100);
        ApplicationId appId2 = TestClientRMService.getApplicationId(101);
        final SubmitApplicationRequest submitRequest1 = this.mockSubmitAppRequest(appId1, null, null);
        SubmitApplicationRequest submitRequest2 = this.mockSubmitAppRequest(appId2, null, null);
        final CyclicBarrier startBarrier = new CyclicBarrier(2);
        final CyclicBarrier endBarrier = new CyclicBarrier(2);
        EventHandler eventHandler = new EventHandler(){

            public void handle(Event rawEvent) {
                RMAppEvent event;
                if (rawEvent instanceof RMAppEvent && (event = (RMAppEvent)rawEvent).getApplicationId().equals((Object)appId1)) {
                    try {
                        startBarrier.await();
                        endBarrier.await();
                    }
                    catch (BrokenBarrierException e) {
                        LOG.warn("Broken Barrier", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Interrupted while awaiting barriers", (Throwable)e);
                    }
                }
            }
        };
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)eventHandler);
        final ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, null, null, null);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    rmService.submitApplication(submitRequest1);
                }
                catch (YarnException yarnException) {
                    // empty catch block
                }
            }
        };
        t.start();
        startBarrier.await();
        rmService.submitApplication(submitRequest2);
        endBarrier.await();
        t.join();
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue) {
        return this.mockSubmitAppRequest(appId, name, queue, null);
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue, Set<String> tags) {
        return this.mockSubmitAppRequest(appId, name, queue, tags, false);
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue, Set<String> tags, boolean unmanaged) {
        ContainerLaunchContext amContainerSpec = (ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class);
        Resource resource = Resources.createResource((int)1024);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)this.recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        submissionContext.setAMContainerSpec(amContainerSpec);
        submissionContext.setApplicationName(name);
        submissionContext.setQueue(queue);
        submissionContext.setApplicationId(appId);
        submissionContext.setResource(resource);
        submissionContext.setApplicationType(this.appType);
        submissionContext.setApplicationTags(tags);
        submissionContext.setUnmanagedAM(unmanaged);
        SubmitApplicationRequest submitRequest = (SubmitApplicationRequest)this.recordFactory.newRecordInstance(SubmitApplicationRequest.class);
        submitRequest.setApplicationSubmissionContext(submissionContext);
        return submitRequest;
    }

    private void mockRMContext(YarnScheduler yarnScheduler, RMContext rmContext) throws IOException {
        Dispatcher dispatcher = (Dispatcher)Mockito.mock(Dispatcher.class);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)dispatcher);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)dispatcher.getEventHandler()).thenReturn((Object)eventHandler);
        QueueInfo queInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queInfo.setQueueName("testqueue");
        Mockito.when((Object)yarnScheduler.getQueueInfo((String)Matchers.eq((Object)"testqueue"), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)queInfo);
        Mockito.when((Object)yarnScheduler.getQueueInfo((String)Matchers.eq((Object)"nonexistentqueue"), Matchers.anyBoolean(), Matchers.anyBoolean())).thenThrow(new Throwable[]{new IOException("queue does not exist")});
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        Mockito.when((Object)rmContext.getRMApplicationHistoryWriter()).thenReturn((Object)writer);
        SystemMetricsPublisher publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        Mockito.when((Object)rmContext.getSystemMetricsPublisher()).thenReturn((Object)publisher);
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)new YarnConfiguration());
        ConcurrentHashMap<ApplicationId, RMApp> apps = this.getRMApps(rmContext, yarnScheduler);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(apps);
        Mockito.when((Object)yarnScheduler.getAppsInQueue((String)Matchers.eq((Object)"testqueue"))).thenReturn(this.getSchedulerApps(apps));
        ResourceScheduler rs = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)rs);
    }

    private ConcurrentHashMap<ApplicationId, RMApp> getRMApps(RMContext rmContext, YarnScheduler yarnScheduler) {
        ConcurrentHashMap<ApplicationId, RMApp> apps = new ConcurrentHashMap<ApplicationId, RMApp>();
        ApplicationId applicationId1 = TestClientRMService.getApplicationId(1);
        ApplicationId applicationId2 = TestClientRMService.getApplicationId(2);
        ApplicationId applicationId3 = TestClientRMService.getApplicationId(3);
        YarnConfiguration config = new YarnConfiguration();
        apps.put(applicationId1, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId1, config, "testqueue", 10L, 3L));
        apps.put(applicationId2, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId2, config, "a", 20L, 2L));
        apps.put(applicationId3, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId3, config, "testqueue", 40L, 5L));
        return apps;
    }

    private List<ApplicationAttemptId> getSchedulerApps(Map<ApplicationId, RMApp> apps) {
        ArrayList<ApplicationAttemptId> schedApps = new ArrayList<ApplicationAttemptId>();
        schedApps.add(ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId(1), (int)0));
        schedApps.add(ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId(3), (int)0));
        return schedApps;
    }

    private static ApplicationId getApplicationId(int id) {
        return ApplicationId.newInstance((long)123456L, (int)id);
    }

    private static ApplicationAttemptId getApplicationAttemptId(int id) {
        return ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId(id), (int)1);
    }

    private RMAppImpl getRMApp(RMContext rmContext, YarnScheduler yarnScheduler, ApplicationId applicationId3, YarnConfiguration config, String queueName, final long memorySeconds, final long vcoreSeconds) {
        ApplicationSubmissionContext asContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)asContext.getMaxAppAttempts()).thenReturn((Object)1);
        RMAppImpl app = (RMAppImpl)Mockito.spy((Object)new RMAppImpl(applicationId3, rmContext, (Configuration)config, null, null, queueName, asContext, yarnScheduler, null, System.currentTimeMillis(), "YARN", null, BuilderUtils.newResourceRequest((Priority)RMAppAttemptImpl.AM_CONTAINER_PRIORITY, (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)1)){

            public ApplicationReport createAndGetApplicationReport(String clientUserName, boolean allowAccess) {
                ApplicationReport report = super.createAndGetApplicationReport(clientUserName, allowAccess);
                ApplicationResourceUsageReport usageReport = report.getApplicationResourceUsageReport();
                usageReport.setMemorySeconds(memorySeconds);
                usageReport.setVcoreSeconds(vcoreSeconds);
                report.setApplicationResourceUsageReport(usageReport);
                return report;
            }
        });
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        RMAppAttemptImpl rmAppAttemptImpl = (RMAppAttemptImpl)Mockito.spy((Object)new RMAppAttemptImpl(attemptId, rmContext, yarnScheduler, null, asContext, (Configuration)config, false, null));
        Container container = Container.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L), null, (String)"", null, null, null);
        RMContainerImpl containerimpl = (RMContainerImpl)Mockito.spy((Object)new RMContainerImpl(container, attemptId, null, "", rmContext));
        HashMap<ApplicationAttemptId, RMAppAttemptImpl> attempts = new HashMap<ApplicationAttemptId, RMAppAttemptImpl>();
        attempts.put(attemptId, rmAppAttemptImpl);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)rmAppAttemptImpl);
        Mockito.when((Object)app.getAppAttempts()).thenReturn(attempts);
        Mockito.when((Object)rmAppAttemptImpl.getMasterContainer()).thenReturn((Object)container);
        ResourceScheduler rs = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)rs);
        Mockito.when((Object)rmContext.getScheduler().getRMContainer((ContainerId)Matchers.any(ContainerId.class))).thenReturn((Object)containerimpl);
        SchedulerAppReport sAppReport = (SchedulerAppReport)Mockito.mock(SchedulerAppReport.class);
        Mockito.when((Object)rmContext.getScheduler().getSchedulerAppInfo((ApplicationAttemptId)Matchers.any(ApplicationAttemptId.class))).thenReturn((Object)sAppReport);
        ArrayList<RMContainerImpl> rmContainers = new ArrayList<RMContainerImpl>();
        rmContainers.add(containerimpl);
        Mockito.when((Object)rmContext.getScheduler().getSchedulerAppInfo(attemptId).getLiveContainers()).thenReturn(rmContainers);
        ContainerStatus cs = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)containerimpl.getFinishedStatus()).thenReturn((Object)cs);
        Mockito.when((Object)containerimpl.getDiagnosticsInfo()).thenReturn((Object)"N/A");
        Mockito.when((Object)containerimpl.getContainerExitStatus()).thenReturn((Object)0);
        Mockito.when((Object)containerimpl.getContainerState()).thenReturn((Object)ContainerState.COMPLETE);
        return app;
    }

    private static YarnScheduler mockYarnScheduler() {
        YarnScheduler yarnScheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        Mockito.when((Object)yarnScheduler.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024));
        Mockito.when((Object)yarnScheduler.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)8192));
        Mockito.when((Object)yarnScheduler.getMaximumResourceCapability((String)Matchers.any(String.class))).thenReturn((Object)Resources.createResource((int)8192));
        Mockito.when((Object)yarnScheduler.getAppsInQueue(QUEUE_1)).thenReturn(Arrays.asList(TestClientRMService.getApplicationAttemptId(101), TestClientRMService.getApplicationAttemptId(102)));
        Mockito.when((Object)yarnScheduler.getAppsInQueue(QUEUE_2)).thenReturn(Arrays.asList(TestClientRMService.getApplicationAttemptId(103)));
        ApplicationAttemptId attemptId = TestClientRMService.getApplicationAttemptId(1);
        Mockito.when((Object)yarnScheduler.getAppResourceUsageReport(attemptId)).thenReturn(null);
        ResourceCalculator rs = (ResourceCalculator)Mockito.mock(ResourceCalculator.class);
        Mockito.when((Object)yarnScheduler.getResourceCalculator()).thenReturn((Object)rs);
        return yarnScheduler;
    }

    @Test
    public void testReservationAPIs() {
        MockNM nm;
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        ReservationSystemTestUtil.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.resourcemanager.reservation-system.enable", true);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        try {
            nm = rm.registerNode("127.0.0.1:1", 102400, 100);
            Thread.sleep(1050L);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        ClientRMService clientService = rm.getClientRMService();
        UTCClock clock = new UTCClock();
        long arrival = clock.getTime();
        long duration = 60000L;
        long deadline = (long)((double)arrival + 1.05 * (double)duration);
        ReservationSubmissionRequest sRequest = this.createSimpleReservationRequest(4, arrival, deadline, duration);
        ReservationSubmissionResponse sResponse = null;
        try {
            sResponse = clientService.submitReservation(sRequest);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)sResponse);
        ReservationId reservationID = sResponse.getReservationId();
        Assert.assertNotNull((Object)reservationID);
        LOG.info("Submit reservation response: " + reservationID);
        ReservationDefinition rDef = sRequest.getReservationDefinition();
        ReservationRequest rr = (ReservationRequest)rDef.getReservationRequests().getReservationResources().get(0);
        rr.setNumContainers(5);
        arrival = clock.getTime();
        duration = 30000L;
        deadline = (long)((double)arrival + 1.05 * (double)duration);
        rr.setDuration(duration);
        rDef.setArrival(arrival);
        rDef.setDeadline(deadline);
        ReservationUpdateRequest uRequest = ReservationUpdateRequest.newInstance((ReservationDefinition)rDef, (ReservationId)reservationID);
        ReservationUpdateResponse uResponse = null;
        try {
            uResponse = clientService.updateReservation(uRequest);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)sResponse);
        LOG.info("Update reservation response: " + uResponse);
        ReservationDeleteRequest dRequest = ReservationDeleteRequest.newInstance((ReservationId)reservationID);
        ReservationDeleteResponse dResponse = null;
        try {
            dResponse = clientService.deleteReservation(dRequest);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)sResponse);
        LOG.info("Delete reservation response: " + dResponse);
        rm.stop();
        nm = null;
        rm = null;
    }

    private ReservationSubmissionRequest createSimpleReservationRequest(int numContainers, long arrival, long deadline, long duration) {
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)numContainers, (int)1, (long)duration);
        ReservationRequests reqs = ReservationRequests.newInstance(Collections.singletonList(r), (ReservationRequestInterpreter)ReservationRequestInterpreter.R_ALL);
        ReservationDefinition rDef = ReservationDefinition.newInstance((long)arrival, (long)deadline, (ReservationRequests)reqs, (String)"testClientRMService#reservation");
        ReservationSubmissionRequest request = ReservationSubmissionRequest.newInstance((ReservationDefinition)rDef, (String)"dedicated");
        return request;
    }

    @Test
    public void testGetNodeLabels() throws Exception {
        MockRM rm = new MockRM(){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        HashMap<String, List<String>> nodesAndLabels = new HashMap<String, List<String>>();
        nodesAndLabels.put("host1", Arrays.asList("x"));
        nodesAndLabels.put("host2", Arrays.asList("y"));
        this.setLabelNodeDataInLabelStorage(LabelStorage.getInstance(), nodesAndLabels);
        NodeId node1 = NodeId.newInstance((String)"host1", (int)0);
        NodeId node2 = NodeId.newInstance((String)"host2", (int)0);
        HashMap<NodeId, ImmutableSet> map = new HashMap<NodeId, ImmutableSet>();
        map.put(node1, ImmutableSet.of((Object)"x"));
        map.put(node2, ImmutableSet.of((Object)"y"));
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetNodesToLabelsResponse response1 = client.getNodeToLabels(GetNodesToLabelsRequest.newInstance());
        Map nodeToLabels = response1.getNodeToLabels();
        Assert.assertTrue((boolean)nodeToLabels.keySet().containsAll(Arrays.asList(node1, node2)));
        Assert.assertTrue((boolean)((Set)nodeToLabels.get(node1)).containsAll(Arrays.asList("x")));
        Assert.assertTrue((boolean)((Set)nodeToLabels.get(node2)).containsAll(Arrays.asList("y")));
        rpc.stopProxy((Object)client, conf);
        rm.close();
        this.cleanUpDataInLabelStorage(LabelStorage.getInstance());
    }

    @Test
    public void testGetLabelsToNodes() throws Exception {
        MockRM rm = new MockRM(){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        NodeId node1A = NodeId.newInstance((String)"host1", (int)0);
        NodeId node1B = NodeId.newInstance((String)"host1", (int)0);
        NodeId node2A = NodeId.newInstance((String)"host2", (int)0);
        NodeId node3A = NodeId.newInstance((String)"host3", (int)0);
        NodeId node3B = NodeId.newInstance((String)"host3", (int)0);
        HashMap<NodeId, ImmutableSet> map = new HashMap<NodeId, ImmutableSet>();
        map.put(node1A, ImmutableSet.of((Object)"x"));
        map.put(node1B, ImmutableSet.of((Object)"z"));
        map.put(node2A, ImmutableSet.of((Object)"y"));
        map.put(node3A, ImmutableSet.of((Object)"y"));
        map.put(node3B, ImmutableSet.of((Object)"z"));
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        HashMap<String, List<String>> nodesAndLabels = new HashMap<String, List<String>>();
        nodesAndLabels.put("host1", Arrays.asList("x", "z"));
        nodesAndLabels.put("host2", Arrays.asList("y"));
        nodesAndLabels.put("host3", Arrays.asList("y", "z"));
        this.setLabelNodeDataInLabelStorage(LabelStorage.getInstance(), nodesAndLabels);
        GetLabelsToNodesResponse response1 = client.getLabelsToNodes(GetLabelsToNodesRequest.newInstance());
        Map labelsToNodes = response1.getLabelsToNodes();
        Assert.assertTrue((boolean)((Set)labelsToNodes.get("x")).containsAll(Arrays.asList(node1A)));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get("y")).containsAll(Arrays.asList(node2A, node3A)));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get("z")).containsAll(Arrays.asList(node1B, node3B)));
        HashSet<String> setlabels = new HashSet<String>(Arrays.asList("x", "z"));
        GetLabelsToNodesResponse response2 = client.getLabelsToNodes(GetLabelsToNodesRequest.newInstance(setlabels));
        labelsToNodes = response2.getLabelsToNodes();
        Assert.assertTrue((boolean)labelsToNodes.keySet().containsAll(Arrays.asList("x", "z")));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get("x")).containsAll(Arrays.asList(node1A)));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get("z")).containsAll(Arrays.asList(node1B, node3B)));
        Assert.assertEquals(labelsToNodes.get("y"), null);
        rpc.stopProxy((Object)client, conf);
        rm.close();
        this.cleanUpDataInLabelStorage(LabelStorage.getInstance());
    }

    private void setLabelNodeDataInLabelStorage(LabelStorage storage, Map<String, List<String>> nodesAndLabels) throws Exception {
        Field privateField = LabelStorage.class.getDeclaredField("nodeExpressionLabels");
        privateField.setAccessible(true);
        privateField.set(storage, nodesAndLabels);
    }

    private void cleanUpDataInLabelStorage(LabelStorage storage) throws Exception {
        Field privateField = LabelStorage.class.getDeclaredField("nodeExpressionLabels");
        privateField.setAccessible(true);
        privateField.set(storage, new HashMap());
    }

    @Test
    public void testGetApplicationsWithPerUserApps() throws IOException, YarnException {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        QueueACLsManager queueAclsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)queueAclsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), (String)Matchers.any(String.class))).thenReturn((Object)false);
        ApplicationACLsManager appAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        Mockito.when((Object)appAclsManager.checkAccess((UserGroupInformation)Matchers.eq((Object)UserGroupInformation.getCurrentUser()), (ApplicationAccessType)Matchers.any(ApplicationAccessType.class), (String)Matchers.any(String.class), (ApplicationId)Matchers.any(ApplicationId.class))).thenReturn((Object)false);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, appAclsManager, queueAclsManager, null);
        rmService.init(new Configuration());
        String[] queues = new String[]{QUEUE_1, QUEUE_2};
        String[] appNames = new String[]{MockApps.newAppName(), MockApps.newAppName(), MockApps.newAppName()};
        ApplicationId[] appIds = new ApplicationId[]{TestClientRMService.getApplicationId(101), TestClientRMService.getApplicationId(102), TestClientRMService.getApplicationId(103)};
        List<String> tags = Arrays.asList("Tag1", "Tag2", "Tag3");
        long[] submitTimeMillis = new long[3];
        for (int i = 0; i < appIds.length; ++i) {
            ApplicationId appId = appIds[i];
            SubmitApplicationRequest submitRequest = this.mockSubmitAppRequest(appId, appNames[i], queues[i % queues.length], new HashSet<String>(tags.subList(0, i + 1)));
            rmService.submitApplication(submitRequest);
            submitTimeMillis[i] = System.currentTimeMillis();
        }
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        Assert.assertEquals((String)"Incorrect total number of apps", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        rmService.setDisplayPerUserApps(true);
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)0L, (long)rmService.getApplications(request).getApplicationList().size());
        rmService.setDisplayPerUserApps(false);
    }

    static {
        KerberosName.setRules((String)kerberosRule);
        owner = UserGroupInformation.createRemoteUser((String)"owner");
        other = UserGroupInformation.createRemoteUser((String)"other");
        tester = UserGroupInformation.createRemoteUser((String)"tester");
        testerKerb = UserGroupInformation.createRemoteUser((String)testerPrincipal);
        ownerKerb = UserGroupInformation.createRemoteUser((String)ownerPrincipal);
        otherKerb = UserGroupInformation.createRemoteUser((String)otherPrincipal);
    }
}

