/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class ContainerPage
extends NMView
implements YarnWebParams {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage.__> html) {
        this.commonPreHead(html);
        this.setTitle("Container " + this.$("container.id"));
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:0}");
    }

    protected Class<? extends SubView> content() {
        return ContainerBlock.class;
    }

    public static class ContainerBlock
    extends HtmlBlock
    implements YarnWebParams {
        private final Context nmContext;

        @Inject
        public ContainerBlock(Context nmContext) {
            this.nmContext = nmContext;
        }

        protected void render(HtmlBlock.Block html) {
            ContainerId containerID;
            try {
                containerID = ContainerId.fromString((String)this.$("container.id"));
            }
            catch (IllegalArgumentException e) {
                html.p().__(new Object[]{"Invalid containerId " + this.$("container.id")}).__();
                return;
            }
            Hamlet.DIV div = html.div("#content");
            Container container = (Container)this.nmContext.getContainers().get(containerID);
            if (container == null) {
                div.h1("Unknown Container. Container might have completed, please go back to the previous page and retry.").__();
                return;
            }
            ContainerInfo info = new ContainerInfo(this.nmContext, container);
            this.info("Container information").__("ContainerID", (Object)info.getId()).__("ContainerState", (Object)info.getState()).__("ExitStatus", (Object)info.getExitStatus()).__("Diagnostics", (Object)info.getDiagnostics()).__("User", (Object)info.getUser()).__("TotalMemoryNeeded", (Object)info.getMemoryNeeded()).__("TotalVCoresNeeded", (Object)info.getVCoresNeeded()).__("ExecutionType", (Object)info.getExecutionType()).__("logs", info.getShortLogLink(), (Object)"Link to logs");
            html.__(InfoBlock.class);
        }
    }
}

