/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.CsiAdaptorProtocol;
import org.apache.hadoop.yarn.api.impl.pb.client.CsiAdaptorProtocolPBClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DockerLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.RuncContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;
import org.apache.hadoop.yarn.util.csi.CsiConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class OCIContainerRuntime
implements LinuxContainerRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(OCIContainerRuntime.class);
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9_.-]+$");
    static final Pattern USER_MOUNT_PATTERN = Pattern.compile("(?<=^|,)([^:\\x00]+):([^:\\x00]+)(:(r[ow]|(r[ow][+])?(r?shared|r?slave|r?private)))?(?:,|$)");
    static final Pattern TMPFS_MOUNT_PATTERN = Pattern.compile("^/[^:\\x00]+$");
    static final String PORTS_MAPPING_PATTERN = "^:[0-9]+|^[0-9]+:[0-9]+|^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]):[0-9]+:[0-9]+$";
    private static final int HOST_NAME_LENGTH = 64;
    @InterfaceAudience.Private
    public static final String RUNTIME_PREFIX = "YARN_CONTAINER_RUNTIME_%s_%s";
    @InterfaceAudience.Private
    public static final String CONTAINER_PID_NAMESPACE_SUFFIX = "CONTAINER_PID_NAMESPACE";
    @InterfaceAudience.Private
    public static final String RUN_PRIVILEGED_CONTAINER_SUFFIX = "RUN_PRIVILEGED_CONTAINER";
    private Map<String, CsiAdaptorProtocol> csiClients = new HashMap<String, CsiAdaptorProtocol>();

    abstract Set<String> getAllowedNetworks();

    abstract Set<String> getAllowedRuntimes();

    abstract boolean getHostPidNamespaceEnabled();

    abstract boolean getPrivilegedContainersEnabledOnCluster();

    abstract AccessControlList getPrivilegedContainersAcl();

    abstract String getEnvOciContainerPidNamespace();

    abstract String getEnvOciContainerRunPrivilegedContainer();

    public OCIContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor) {
        this(privilegedOperationExecutor, ResourceHandlerModule.getCGroupsHandler());
    }

    public OCIContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor, CGroupsHandler cGroupsHandler) {
    }

    @Override
    public void initialize(Configuration conf, Context nmContext) throws ContainerExecutionException {
    }

    public static boolean isOCICompliantContainerRequested(Configuration daemonConf, Map<String, String> env) {
        return DockerLinuxContainerRuntime.isDockerContainerRequested(daemonConf, env) || RuncContainerRuntime.isRuncContainerRequested(daemonConf, env);
    }

    @VisibleForTesting
    protected String mountReadOnlyPath(String mount, Map<Path, List<String>> localizedResources) throws ContainerExecutionException {
        for (Map.Entry<Path, List<String>> resource : localizedResources.entrySet()) {
            if (!resource.getValue().contains(mount)) continue;
            java.nio.file.Path path = Paths.get(resource.getKey().toString(), new String[0]);
            if (!path.isAbsolute()) {
                throw new ContainerExecutionException("Mount must be absolute: " + mount);
            }
            if (Files.isSymbolicLink(path)) {
                throw new ContainerExecutionException("Mount cannot be a symlink: " + mount);
            }
            return path.toString();
        }
        throw new ContainerExecutionException("Mount must be a localized resource: " + mount);
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
    }

    protected String getUserIdInfo(String userName) throws ContainerExecutionException {
        String id;
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(new String[]{"id", "-u", userName});
        try {
            shexec.execute();
            id = shexec.getOutput().replaceAll("[^0-9]", "");
        }
        catch (Exception e) {
            throw new ContainerExecutionException(e);
        }
        return id;
    }

    protected String[] getGroupIdInfo(String userName) throws ContainerExecutionException {
        String[] id;
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(new String[]{"id", "-G", userName});
        try {
            shexec.execute();
            id = shexec.getOutput().replace("\n", "").split(" ");
        }
        catch (Exception e) {
            throw new ContainerExecutionException(e);
        }
        return id;
    }

    protected void validateContainerNetworkType(String network) throws ContainerExecutionException {
        Set<String> allowedNetworks = this.getAllowedNetworks();
        if (allowedNetworks.contains(network)) {
            return;
        }
        String msg = "Disallowed network:  '" + network + "' specified. Allowed networks: are " + allowedNetworks.toString();
        throw new ContainerExecutionException(msg);
    }

    protected void validateContainerRuntimeType(String runtime) throws ContainerExecutionException {
        Set<String> allowedRuntimes = this.getAllowedRuntimes();
        if (runtime == null || runtime.isEmpty() || allowedRuntimes.contains(runtime)) {
            return;
        }
        String msg = "Disallowed runtime:  '" + runtime + "' specified. Allowed runtimes: are " + allowedRuntimes.toString();
        throw new ContainerExecutionException(msg);
    }

    protected boolean allowHostPidNamespace(Container container) throws ContainerExecutionException {
        String envOciContainerPidNamespace;
        Map environment = container.getLaunchContext().getEnvironment();
        String pidNamespace = (String)environment.get(envOciContainerPidNamespace = this.getEnvOciContainerPidNamespace());
        if (pidNamespace == null) {
            return false;
        }
        if (!pidNamespace.equalsIgnoreCase("host")) {
            LOG.warn("NOT requesting PID namespace. Value of " + envOciContainerPidNamespace + "is invalid: " + pidNamespace);
            return false;
        }
        boolean hostPidNamespaceEnabled = this.getHostPidNamespaceEnabled();
        if (!hostPidNamespaceEnabled) {
            String message = "Host pid namespace being requested but this is not enabled on this cluster";
            LOG.warn(message);
            throw new ContainerExecutionException(message);
        }
        return true;
    }

    protected static void validateHostname(String hostname) throws ContainerExecutionException {
        if (hostname != null && !hostname.isEmpty()) {
            if (!HOSTNAME_PATTERN.matcher(hostname).matches()) {
                throw new ContainerExecutionException("Hostname '" + hostname + "' doesn't match OCI-compliant hostname pattern");
            }
            if (hostname.length() > 64) {
                throw new ContainerExecutionException("Hostname can not be greater than 64 characters: " + hostname);
            }
        }
    }

    protected boolean allowPrivilegedContainerExecution(Container container) throws ContainerExecutionException {
        if (!this.isContainerRequestedAsPrivileged(container)) {
            return false;
        }
        LOG.info("Privileged container requested for : " + container.getContainerId().toString());
        boolean privilegedContainersEnabledOnCluster = this.getPrivilegedContainersEnabledOnCluster();
        if (!privilegedContainersEnabledOnCluster) {
            String message = "Privileged container being requested but privileged containers are not enabled on this cluster";
            LOG.warn(message);
            throw new ContainerExecutionException(message);
        }
        String submittingUser = container.getUser();
        UserGroupInformation submitterUgi = UserGroupInformation.createRemoteUser((String)submittingUser);
        if (!this.getPrivilegedContainersAcl().isUserAllowed(submitterUgi)) {
            String message = "Cannot launch privileged container. Submitting user (" + submittingUser + ") fails ACL check.";
            LOG.warn(message);
            throw new ContainerExecutionException(message);
        }
        LOG.info("All checks pass. Launching privileged container for : " + container.getContainerId().toString());
        return true;
    }

    protected boolean isContainerRequestedAsPrivileged(Container container) {
        String envOciContainerRunPrivilegedContainer = this.getEnvOciContainerRunPrivilegedContainer();
        String runPrivilegedContainerEnvVar = (String)container.getLaunchContext().getEnvironment().get(envOciContainerRunPrivilegedContainer);
        return Boolean.parseBoolean(runPrivilegedContainerEnvVar);
    }

    public Map<String, CsiAdaptorProtocol> getCsiClients() {
        return this.csiClients;
    }

    protected void initiateCsiClients(Configuration config) throws ContainerExecutionException {
        String[] driverNames = CsiConfigUtils.getCsiDriverNames((Configuration)config);
        if (driverNames != null && driverNames.length > 0) {
            for (String driverName : driverNames) {
                try {
                    InetSocketAddress adaptorServiceAddress = CsiConfigUtils.getCsiAdaptorAddressForDriver((String)driverName, (Configuration)config);
                    LOG.info("Initializing a csi-adaptor-client for csi-adaptor {}, csi-driver {}", (Object)adaptorServiceAddress.toString(), (Object)driverName);
                    CsiAdaptorProtocolPBClientImpl client = new CsiAdaptorProtocolPBClientImpl(1L, adaptorServiceAddress, config);
                    this.csiClients.put(driverName, (CsiAdaptorProtocol)client);
                }
                catch (IOException | YarnException e1) {
                    throw new ContainerExecutionException(e1.getMessage());
                }
            }
        }
    }

    public static String formatOciEnvKey(String runtimeTypeUpper, String envKeySuffix) {
        return String.format(RUNTIME_PREFIX, runtimeTypeUpper, envKeySuffix);
    }
}

