/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class AllContainersPage
extends NMView {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage.__> html) {
        this.commonPreHead(html);
        this.setTitle("All containers running on this node");
        this.set("ui.dataTables.id", "containers");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"containers"), this.containersTableInit());
        this.setTableStyles(html, "containers", new String[0]);
    }

    private String containersTableInit() {
        return JQueryUI.tableInit().append(", aoColumns:[").append(this.getContainersIdColumnDefs()).append(", null, {bSearchable:false}]} ").toString();
    }

    private String getContainersIdColumnDefs() {
        StringBuilder sb = new StringBuilder();
        return sb.append("{'sType':'natural', 'aTargets': [0]").append(", 'mRender': parseHadoopID }").toString();
    }

    protected Class<? extends SubView> content() {
        return AllContainersBlock.class;
    }

    public static class AllContainersBlock
    extends HtmlBlock
    implements YarnWebParams {
        private final Context nmContext;

        @Inject
        public AllContainersBlock(Context nmContext) {
            this.nmContext = nmContext;
        }

        protected void render(HtmlBlock.Block html) {
            Hamlet.TBODY tableBody = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)html.body().table("#containers").thead().tr().td().__(new Object[]{"ContainerId"}).__()).td().__(new Object[]{"ContainerState"}).__()).td().__(new Object[]{"logs"}).__()).__()).__()).tbody();
            for (Map.Entry entry : this.nmContext.getContainers().entrySet()) {
                ContainerInfo info = new ContainerInfo(this.nmContext, (Container)entry.getValue());
                ((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)tableBody.tr().td().a(this.url(new String[]{"container", info.getId()}), info.getId()).__()).td().__(new Object[]{info.getState()}).__()).td().a(this.url(new String[]{info.getShortLogLink()}), "logs").__()).__();
            }
            ((Hamlet.BODY)((Hamlet.TABLE)tableBody.__()).__()).__();
        }
    }
}

