/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.apache.hadoop.yarn.server.api.ContainerInitializationContext;
import org.apache.hadoop.yarn.server.api.ContainerTerminationContext;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AuxServices
extends AbstractService
implements ServiceStateChangeListener,
EventHandler<AuxServicesEvent> {
    static final String STATE_STORE_ROOT_NAME = "nm-aux-services";
    private static final Logger LOG = LoggerFactory.getLogger(AuxServices.class);
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    protected final Map<String, AuxiliaryService> serviceMap;
    protected final Map<String, ByteBuffer> serviceMetaData;
    private final Pattern p = Pattern.compile("^[A-Za-z_]+[A-Za-z0-9_]*$");

    public AuxServices() {
        super(AuxServices.class.getName());
        this.serviceMap = Collections.synchronizedMap(new HashMap());
        this.serviceMetaData = Collections.synchronizedMap(new HashMap());
    }

    protected final synchronized void addService(String name, AuxiliaryService service) {
        LOG.info("Adding auxiliary service " + service.getName() + ", \"" + name + "\"");
        this.serviceMap.put(name, service);
    }

    Collection<AuxiliaryService> getServices() {
        return Collections.unmodifiableCollection(this.serviceMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ByteBuffer> getMetaData() {
        HashMap<String, ByteBuffer> metaClone = new HashMap<String, ByteBuffer>(this.serviceMetaData.size());
        Map<String, ByteBuffer> map = this.serviceMetaData;
        synchronized (map) {
            for (Map.Entry<String, ByteBuffer> entry : this.serviceMetaData.entrySet()) {
                metaClone.put(entry.getKey(), entry.getValue().duplicate());
            }
        }
        return metaClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ByteBuffer> getMetaData(ContainerInitializationContext ctx) {
        HashMap<String, ByteBuffer> metaClone = new HashMap<String, ByteBuffer>(this.serviceMap.size());
        Map<String, AuxiliaryService> map = this.serviceMap;
        synchronized (map) {
            for (Map.Entry<String, AuxiliaryService> entry : this.serviceMap.entrySet()) {
                ByteBuffer data = entry.getValue().getMetaData(ctx);
                if (data == null) continue;
                metaClone.put(entry.getKey(), data);
            }
        }
        return metaClone;
    }

    public void serviceInit(Configuration conf) throws Exception {
        FsPermission storeDirPerms = new FsPermission(448);
        Path stateStoreRoot = null;
        LocalFileSystem stateStoreFs = null;
        boolean recoveryEnabled = conf.getBoolean("yarn.nodemanager.recovery.enabled", true);
        if (recoveryEnabled) {
            stateStoreRoot = new Path(conf.get("yarn.nodemanager.recovery.dir"), STATE_STORE_ROOT_NAME);
            stateStoreFs = FileSystem.getLocal((Configuration)conf);
        }
        Collection auxNames = conf.getStringCollection("yarn.nodemanager.aux-services");
        for (String sName : auxNames) {
            try {
                Preconditions.checkArgument((boolean)this.validateAuxServiceName(sName), (Object)("The ServiceName: " + sName + " set in yarn.nodemanager.aux-services is invalid.The valid service name should only contain a-zA-Z0-9_ and can not start with numbers"));
                Class sClass = conf.getClass(String.format("yarn.nodemanager.aux-services.%s.class", sName), null, AuxiliaryService.class);
                if (null == sClass) {
                    throw new RuntimeException("No class defined for " + sName);
                }
                AuxiliaryService s = (AuxiliaryService)ReflectionUtils.newInstance((Class)sClass, (Configuration)conf);
                if (!sName.equals(s.getName())) {
                    LOG.warn("The Auxilurary Service named '" + sName + "' in the configuration is for " + sClass + " which has a name of '" + s.getName() + "'. Because these are not the same tools trying to send ServiceData and read Service Meta Data may have issues unless the refer to the name in the config.");
                }
                this.addService(sName, s);
                if (recoveryEnabled) {
                    Path storePath = new Path(stateStoreRoot, sName);
                    stateStoreFs.mkdirs(storePath, storeDirPerms);
                    s.setRecoveryPath(storePath);
                }
                s.init(conf);
            }
            catch (RuntimeException e) {
                LOG.error(FATAL, "Failed to initialize " + sName, (Throwable)e);
                throw e;
            }
        }
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        for (Map.Entry<String, AuxiliaryService> entry : this.serviceMap.entrySet()) {
            AuxiliaryService service = entry.getValue();
            String name = entry.getKey();
            service.start();
            service.registerServiceListener((ServiceStateChangeListener)this);
            ByteBuffer meta = service.getMetaData();
            if (meta == null) continue;
            this.serviceMetaData.put(name, meta);
        }
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws Exception {
        try {
            Map<String, AuxiliaryService> map = this.serviceMap;
            synchronized (map) {
                for (Service service : this.serviceMap.values()) {
                    if (service.getServiceState() != Service.STATE.STARTED) continue;
                    service.unregisterServiceListener((ServiceStateChangeListener)this);
                    service.stop();
                }
                this.serviceMap.clear();
                this.serviceMetaData.clear();
            }
        }
        finally {
            super.serviceStop();
        }
    }

    public void stateChanged(Service service) {
        LOG.error(FATAL, "Service " + service.getName() + " changed state: " + service.getServiceState());
        this.stop();
    }

    public void handle(AuxServicesEvent event) {
        LOG.info("Got event " + event.getType() + " for appId " + event.getApplicationID());
        switch ((AuxServicesEventType)event.getType()) {
            case APPLICATION_INIT: {
                LOG.info("Got APPLICATION_INIT for service " + event.getServiceID());
                AuxiliaryService service = null;
                try {
                    service = this.serviceMap.get(event.getServiceID());
                    service.initializeApplication(new ApplicationInitializationContext(event.getUser(), event.getApplicationID(), event.getServiceData()));
                }
                catch (Throwable th) {
                    this.logWarningWhenAuxServiceThrowExceptions(service, AuxServicesEventType.APPLICATION_INIT, th);
                }
                break;
            }
            case APPLICATION_STOP: {
                for (AuxiliaryService serv : this.serviceMap.values()) {
                    try {
                        serv.stopApplication(new ApplicationTerminationContext(event.getApplicationID()));
                    }
                    catch (Throwable th) {
                        this.logWarningWhenAuxServiceThrowExceptions(serv, AuxServicesEventType.APPLICATION_STOP, th);
                    }
                }
                break;
            }
            case CONTAINER_INIT: {
                for (AuxiliaryService serv : this.serviceMap.values()) {
                    try {
                        serv.initializeContainer(new ContainerInitializationContext(event.getUser(), event.getContainer().getContainerId(), event.getContainer().getResource()));
                    }
                    catch (Throwable th) {
                        this.logWarningWhenAuxServiceThrowExceptions(serv, AuxServicesEventType.CONTAINER_INIT, th);
                    }
                }
                break;
            }
            case CONTAINER_STOP: {
                for (AuxiliaryService serv : this.serviceMap.values()) {
                    try {
                        serv.stopContainer(new ContainerTerminationContext(event.getUser(), event.getContainer().getContainerId(), event.getContainer().getResource()));
                    }
                    catch (Throwable th) {
                        this.logWarningWhenAuxServiceThrowExceptions(serv, AuxServicesEventType.CONTAINER_STOP, th);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + event.getType());
            }
        }
    }

    private boolean validateAuxServiceName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        return this.p.matcher(name).matches();
    }

    private void logWarningWhenAuxServiceThrowExceptions(AuxiliaryService service, AuxServicesEventType eventType, Throwable th) {
        LOG.warn((String)(null == service ? "The auxService is null" : "The auxService name is " + service.getName()) + " and it got an error at event: " + eventType, th);
    }
}

