/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.AdminACLsManager;
import org.apache.hadoop.yarn.server.timeline.LeveldbTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineStoreTestUtils;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTimelineDataManager
extends TimelineStoreTestUtils {
    private FileContext fsContext;
    private File fsPath;
    private TimelineDataManager dataManaer;
    private static TimelineACLsManager aclsManager;
    private static AdminACLsManager adminACLsManager;

    @Before
    public void setup() throws Exception {
        this.fsPath = new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsoluteFile();
        this.fsContext = FileContext.getLocalFSFileContext();
        this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.timeline-service.leveldb-timeline-store.path", this.fsPath.getAbsolutePath());
        conf.setBoolean("yarn.timeline-service.ttl-enable", false);
        this.store = new LeveldbTimelineStore();
        this.store.init((Configuration)conf);
        this.store.start();
        this.loadTestEntityData();
        this.loadVerificationEntityData();
        this.loadTestDomainData();
        conf.setBoolean("yarn.acl.enable", false);
        aclsManager = new TimelineACLsManager((Configuration)conf);
        aclsManager.setTimelineStore(this.store);
        this.dataManaer = new TimelineDataManager(this.store, aclsManager);
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "admin");
        this.dataManaer.init((Configuration)conf);
        adminACLsManager = new AdminACLsManager((Configuration)conf);
    }

    @After
    public void tearDown() throws Exception {
        if (this.store != null) {
            this.store.stop();
        }
        if (this.fsContext != null) {
            this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
        }
    }

    @Test
    public void testGetOldEntityWithOutDomainId() throws Exception {
        TimelineEntity entity = this.dataManaer.getEntity("OLD_ENTITY_TYPE_1", "OLD_ENTITY_ID_1", null, UserGroupInformation.getCurrentUser());
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)"OLD_ENTITY_ID_1", (Object)entity.getEntityId());
        Assert.assertEquals((Object)"OLD_ENTITY_TYPE_1", (Object)entity.getEntityType());
        Assert.assertEquals((Object)"DEFAULT", (Object)entity.getDomainId());
    }

    @Test
    public void testGetEntitiesAclEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = aclsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = this.dataManaer.getEntities("ACL_ENTITY_TYPE_1", null, null, null, null, null, null, Long.valueOf(1L), null, UserGroupInformation.createUserForTesting((String)"owner_1", (String[])new String[]{"group1"}));
            Assert.assertEquals((long)1L, (long)entities.getEntities().size());
            Assert.assertEquals((Object)"ACL_ENTITY_ID_11", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityId());
        }
        finally {
            aclsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    @Test
    public void testGetOldEntitiesWithOutDomainId() throws Exception {
        TimelineEntities entities = this.dataManaer.getEntities("OLD_ENTITY_TYPE_1", null, null, null, null, null, null, null, null, UserGroupInformation.getCurrentUser());
        Assert.assertEquals((long)2L, (long)entities.getEntities().size());
        Assert.assertEquals((Object)"OLD_ENTITY_ID_2", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityId());
        Assert.assertEquals((Object)"OLD_ENTITY_TYPE_1", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityType());
        Assert.assertEquals((Object)"DEFAULT", (Object)((TimelineEntity)entities.getEntities().get(0)).getDomainId());
        Assert.assertEquals((Object)"OLD_ENTITY_ID_1", (Object)((TimelineEntity)entities.getEntities().get(1)).getEntityId());
        Assert.assertEquals((Object)"OLD_ENTITY_TYPE_1", (Object)((TimelineEntity)entities.getEntities().get(1)).getEntityType());
        Assert.assertEquals((Object)"DEFAULT", (Object)((TimelineEntity)entities.getEntities().get(1)).getDomainId());
    }

    @Test
    public void testUpdatingOldEntityWithoutDomainId() throws Exception {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityType("OLD_ENTITY_TYPE_1");
        entity.setEntityId("OLD_ENTITY_ID_1");
        entity.setDomainId("DEFAULT");
        entity.addOtherInfo("NEW_OTHER_INFO_KEY", (Object)"NEW_OTHER_INFO_VALUE");
        TimelineEntities entities = new TimelineEntities();
        entities.addEntity(entity);
        TimelinePutResponse response = this.dataManaer.postEntities(entities, UserGroupInformation.getCurrentUser());
        Assert.assertEquals((long)0L, (long)response.getErrors().size());
        entity = this.store.getEntity("OLD_ENTITY_ID_1", "OLD_ENTITY_TYPE_1", null);
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)"DEFAULT", (Object)entity.getDomainId());
        Assert.assertEquals((long)1L, (long)entity.getOtherInfo().size());
        Assert.assertEquals((Object)"NEW_OTHER_INFO_KEY", entity.getOtherInfo().keySet().iterator().next());
        Assert.assertEquals((Object)"NEW_OTHER_INFO_VALUE", entity.getOtherInfo().values().iterator().next());
        entity = new TimelineEntity();
        entity.setEntityType("OLD_ENTITY_TYPE_1");
        entity.setEntityId("OLD_ENTITY_ID_2");
        entity.setDomainId("NON_DEFAULT");
        entity.addOtherInfo("NEW_OTHER_INFO_KEY", (Object)"NEW_OTHER_INFO_VALUE");
        entities = new TimelineEntities();
        entities.addEntity(entity);
        response = this.dataManaer.postEntities(entities, UserGroupInformation.getCurrentUser());
        Assert.assertEquals((long)1L, (long)response.getErrors().size());
        Assert.assertEquals((long)4L, (long)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getErrorCode());
        entity = this.store.getEntity("OLD_ENTITY_ID_2", "OLD_ENTITY_TYPE_1", null);
        Assert.assertNotNull((Object)entity);
        Assert.assertNull((Object)entity.getDomainId());
        Assert.assertEquals((long)0L, (long)entity.getOtherInfo().size());
    }
}

