/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.secure;

import com.sun.security.auth.module.Krb5LoginModule;
import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.registry.client.impl.zk.RegistrySecurity;
import org.apache.hadoop.registry.secure.AbstractSecureRegistryTest;
import org.apache.hadoop.registry.secure.KerberosConfiguration;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.zookeeper.data.ACL;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSecureLogins
extends AbstractSecureRegistryTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestSecureLogins.class);

    @Test
    public void testHasRealm() throws Throwable {
        TestSecureLogins.assertNotNull((Object)TestSecureLogins.getRealm());
        LOG.info("ZK principal = {}", (Object)TestSecureLogins.getPrincipalAndRealm("zookeeper/localhost"));
    }

    @Test
    public void testJaasFileSetup() throws Throwable {
        TestSecureLogins.assertNotNull((String)"jaasFile", (Object)jaasFile);
        String confFilename = System.getProperty("java.security.auth.login.config");
        TestSecureLogins.assertEquals((Object)jaasFile.getAbsolutePath(), (Object)confFilename);
    }

    @Test
    public void testJaasFileBinding() throws Throwable {
        TestSecureLogins.assertNotNull((String)"jaasFile", (Object)jaasFile);
        RegistrySecurity.bindJVMtoJAASFile((File)jaasFile);
        String confFilename = System.getProperty("java.security.auth.login.config");
        TestSecureLogins.assertEquals((Object)jaasFile.getAbsolutePath(), (Object)confFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientLogin() throws Throwable {
        LoginContext client = this.login("alice/localhost", "alice", keytab_alice);
        try {
            TestSecureLogins.logLoginDetails("alice/localhost", client);
            String confFilename = System.getProperty("java.security.auth.login.config");
            TestSecureLogins.assertNotNull((String)"Unset: java.security.auth.login.config", (Object)confFilename);
            String config = FileUtils.readFileToString((File)new File(confFilename));
            LOG.info("{}=\n{}", (Object)confFilename, (Object)config);
            RegistrySecurity.setZKSaslClientProperties((String)"alice", (String)"alice");
        }
        finally {
            client.logout();
        }
    }

    @Test
    public void testZKServerContextLogin() throws Throwable {
        LoginContext client = this.login("zookeeper/localhost", "ZOOKEEPER_SERVER", keytab_zk);
        TestSecureLogins.logLoginDetails("zookeeper/localhost", client);
        client.logout();
    }

    @Test
    public void testServerLogin() throws Throwable {
        LoginContext loginContext = this.createLoginContextZookeeperLocalhost();
        loginContext.login();
        loginContext.logout();
    }

    public LoginContext createLoginContextZookeeperLocalhost() throws LoginException {
        String principalAndRealm = TestSecureLogins.getPrincipalAndRealm("zookeeper/localhost");
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
        principals.add(new KerberosPrincipal("zookeeper/localhost"));
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        return new LoginContext("", subject, null, KerberosConfiguration.createServerConfig("zookeeper/localhost", keytab_zk));
    }

    @Test
    public void testKerberosAuth() throws Throwable {
        File krb5conf = TestSecureLogins.getKdc().getKrb5conf();
        String krbConfig = FileUtils.readFileToString((File)krb5conf);
        LOG.info("krb5.conf at {}:\n{}", (Object)krb5conf, (Object)krbConfig);
        Subject subject = new Subject();
        Krb5LoginModule krb5LoginModule = new Krb5LoginModule();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("keyTab", keytab_alice.getAbsolutePath());
        options.put("principal", "alice/localhost");
        options.put("debug", "true");
        options.put("doNotPrompt", "true");
        options.put("isInitiator", "true");
        options.put("refreshKrb5Config", "true");
        options.put("renewTGT", "true");
        options.put("storeKey", "true");
        options.put("useKeyTab", "true");
        options.put("useTicketCache", "true");
        krb5LoginModule.initialize(subject, null, new HashMap(), options);
        boolean loginOk = krb5LoginModule.login();
        TestSecureLogins.assertTrue((String)"Failed to login", (boolean)loginOk);
        boolean commitOk = krb5LoginModule.commit();
        TestSecureLogins.assertTrue((String)"Failed to Commit", (boolean)commitOk);
    }

    @Test
    public void testDefaultRealmValid() throws Throwable {
        String defaultRealm = KerberosUtil.getDefaultRealm();
        TestSecureLogins.assertNotEmpty("No default Kerberos Realm", defaultRealm);
        LOG.info("Default Realm '{}'", (Object)defaultRealm);
    }

    @Test
    public void testKerberosRulesValid() throws Throwable {
        TestSecureLogins.assertTrue((String)"!KerberosName.hasRulesBeenSet()", (boolean)KerberosName.hasRulesBeenSet());
        String rules = KerberosName.getRules();
        TestSecureLogins.assertEquals((Object)"RULE:[1:$1@$0](.*@EXAMPLE.COM)s/@.*//\nDEFAULT", (Object)rules);
        LOG.info(rules);
    }

    @Test
    public void testValidKerberosName() throws Throwable {
        new HadoopKerberosName("zookeeper").getShortName();
        new HadoopKerberosName("zookeeper/localhost").getShortName();
        new HadoopKerberosName("zookeeper@EXAMPLE.COM").getShortName();
    }

    @Test
    public void testUGILogin() throws Throwable {
        UserGroupInformation ugi = TestSecureLogins.loginUGI("zookeeper", keytab_zk);
        RegistrySecurity.UgiInfo ugiInfo = new RegistrySecurity.UgiInfo(ugi);
        LOG.info("logged in as: {}", (Object)ugiInfo);
        TestSecureLogins.assertTrue((String)("security is not enabled: " + ugiInfo), (boolean)UserGroupInformation.isSecurityEnabled());
        TestSecureLogins.assertTrue((String)("login is keytab based: " + ugiInfo), (boolean)ugi.isFromKeytab());
        ACL acl = (ACL)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ACL>(){

            @Override
            public ACL run() throws Exception {
                return AbstractSecureRegistryTest.registrySecurity.createSaslACLFromCurrentUser(0);
            }
        });
        TestSecureLogins.assertEquals((Object)"zookeeper@EXAMPLE.COM", (Object)acl.getId().getId());
        TestSecureLogins.assertEquals((Object)"sasl", (Object)acl.getId().getScheme());
        registrySecurity.addSystemACL(acl);
    }
}

