/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.util.resource.TestResourceUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestResources {
    private static final String INVALID_RESOURCE_MSG = "Invalid resource value";
    private static final String EXTRA_RESOURCE_TYPE = "resource2";
    private String resourceTypesFile;

    private void setupExtraResourceType() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        this.resourceTypesFile = TestResourceUtils.setupResourceTypes((Configuration)conf, "resource-types-3.xml");
    }

    private void unsetExtraResourceType() {
        this.deleteResourceTypesFile();
        ResourceUtils.resetResourceTypes();
    }

    private void deleteResourceTypesFile() {
        if (this.resourceTypesFile != null && !this.resourceTypesFile.isEmpty()) {
            File resourceFile = new File(this.resourceTypesFile);
            resourceFile.delete();
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        this.setupExtraResourceType();
    }

    @AfterEach
    public void teardown() {
        this.deleteResourceTypesFile();
    }

    public Resource createResource(long memory, int vCores) {
        return Resource.newInstance((long)memory, (int)vCores);
    }

    public Resource createResource(long memory, int vCores, long resource2) {
        Resource ret = Resource.newInstance((long)memory, (int)vCores);
        ret.setResourceInformation(EXTRA_RESOURCE_TYPE, ResourceInformation.newInstance((String)EXTRA_RESOURCE_TYPE, (long)resource2));
        return ret;
    }

    @Test
    @Timeout(value=10000L)
    void testCompareToWithUnboundedResource() {
        this.unsetExtraResourceType();
        Resource unboundedClone = Resources.clone((Resource)ExtendedResources.unbounded());
        Assertions.assertTrue((unboundedClone.compareTo(this.createResource(Long.MAX_VALUE, Integer.MAX_VALUE)) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((unboundedClone.compareTo(this.createResource(Long.MAX_VALUE, 0)) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((unboundedClone.compareTo(this.createResource(0L, Integer.MAX_VALUE)) > 0 ? 1 : 0) != 0);
    }

    @Test
    @Timeout(value=10000L)
    void testCompareToWithNoneResource() {
        Assertions.assertTrue((Resources.none().compareTo(this.createResource(0L, 0)) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((Resources.none().compareTo(this.createResource(1L, 0)) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((Resources.none().compareTo(this.createResource(0L, 1)) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((Resources.none().compareTo(this.createResource(0L, 0, 0L)) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((Resources.none().compareTo(this.createResource(1L, 0, 0L)) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((Resources.none().compareTo(this.createResource(0L, 1, 0L)) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((Resources.none().compareTo(this.createResource(0L, 0, 1L)) < 0 ? 1 : 0) != 0);
    }

    @Test
    @Timeout(value=1000L)
    void testFitsIn() {
        Assertions.assertTrue((boolean)Resources.fitsIn((Resource)this.createResource(1L, 1), (Resource)this.createResource(2L, 2)));
        Assertions.assertTrue((boolean)Resources.fitsIn((Resource)this.createResource(2L, 2), (Resource)this.createResource(2L, 2)));
        Assertions.assertFalse((boolean)Resources.fitsIn((Resource)this.createResource(2L, 2), (Resource)this.createResource(1L, 1)));
        Assertions.assertFalse((boolean)Resources.fitsIn((Resource)this.createResource(1L, 2), (Resource)this.createResource(2L, 1)));
        Assertions.assertFalse((boolean)Resources.fitsIn((Resource)this.createResource(2L, 1), (Resource)this.createResource(1L, 2)));
        Assertions.assertTrue((boolean)Resources.fitsIn((Resource)this.createResource(1L, 1, 1L), (Resource)this.createResource(2L, 2, 2L)));
        Assertions.assertTrue((boolean)Resources.fitsIn((Resource)this.createResource(1L, 1, 0L), (Resource)this.createResource(2L, 2, 0L)));
        Assertions.assertTrue((boolean)Resources.fitsIn((Resource)this.createResource(1L, 1, 1L), (Resource)this.createResource(2L, 2, 2L)));
    }

    @Test
    @Timeout(value=1000L)
    void testComponentwiseMin() {
        Assertions.assertEquals((Object)this.createResource(1L, 1), (Object)Resources.componentwiseMin((Resource)this.createResource(1L, 1), (Resource)this.createResource(2L, 2)));
        Assertions.assertEquals((Object)this.createResource(1L, 1), (Object)Resources.componentwiseMin((Resource)this.createResource(2L, 2), (Resource)this.createResource(1L, 1)));
        Assertions.assertEquals((Object)this.createResource(1L, 1), (Object)Resources.componentwiseMin((Resource)this.createResource(1L, 2), (Resource)this.createResource(2L, 1)));
        Assertions.assertEquals((Object)this.createResource(1L, 1, 1L), (Object)Resources.componentwiseMin((Resource)this.createResource(1L, 1, 1L), (Resource)this.createResource(2L, 2, 2L)));
        Assertions.assertEquals((Object)this.createResource(1L, 1, 0L), (Object)Resources.componentwiseMin((Resource)this.createResource(2L, 2, 2L), (Resource)this.createResource(1L, 1)));
        Assertions.assertEquals((Object)this.createResource(1L, 1, 2L), (Object)Resources.componentwiseMin((Resource)this.createResource(1L, 2, 2L), (Resource)this.createResource(2L, 1, 3L)));
    }

    @Test
    void testComponentwiseMax() {
        Assertions.assertEquals((Object)this.createResource(2L, 2), (Object)Resources.componentwiseMax((Resource)this.createResource(1L, 1), (Resource)this.createResource(2L, 2)));
        Assertions.assertEquals((Object)this.createResource(2L, 2), (Object)Resources.componentwiseMax((Resource)this.createResource(2L, 2), (Resource)this.createResource(1L, 1)));
        Assertions.assertEquals((Object)this.createResource(2L, 2), (Object)Resources.componentwiseMax((Resource)this.createResource(1L, 2), (Resource)this.createResource(2L, 1)));
        Assertions.assertEquals((Object)this.createResource(2L, 2, 2L), (Object)Resources.componentwiseMax((Resource)this.createResource(1L, 1, 1L), (Resource)this.createResource(2L, 2, 2L)));
        Assertions.assertEquals((Object)this.createResource(2L, 2, 2L), (Object)Resources.componentwiseMax((Resource)this.createResource(2L, 2, 2L), (Resource)this.createResource(1L, 1)));
        Assertions.assertEquals((Object)this.createResource(2L, 2, 3L), (Object)Resources.componentwiseMax((Resource)this.createResource(1L, 2, 2L), (Resource)this.createResource(2L, 1, 3L)));
        Assertions.assertEquals((Object)this.createResource(2L, 2, 1L), (Object)Resources.componentwiseMax((Resource)this.createResource(2L, 2, 0L), (Resource)this.createResource(2L, 1, 1L)));
    }

    @Test
    void testAdd() {
        Assertions.assertEquals((Object)this.createResource(2L, 3), (Object)Resources.add((Resource)this.createResource(1L, 1), (Resource)this.createResource(1L, 2)));
        Assertions.assertEquals((Object)this.createResource(3L, 2), (Object)Resources.add((Resource)this.createResource(1L, 1), (Resource)this.createResource(2L, 1)));
        Assertions.assertEquals((Object)this.createResource(2L, 2, 0L), (Object)Resources.add((Resource)this.createResource(1L, 1, 0L), (Resource)this.createResource(1L, 1, 0L)));
        Assertions.assertEquals((Object)this.createResource(2L, 2, 3L), (Object)Resources.add((Resource)this.createResource(1L, 1, 1L), (Resource)this.createResource(1L, 1, 2L)));
    }

    @Test
    void testSubtract() {
        Assertions.assertEquals((Object)this.createResource(1L, 0), (Object)Resources.subtract((Resource)this.createResource(2L, 1), (Resource)this.createResource(1L, 1)));
        Assertions.assertEquals((Object)this.createResource(0L, 1), (Object)Resources.subtract((Resource)this.createResource(1L, 2), (Resource)this.createResource(1L, 1)));
        Assertions.assertEquals((Object)this.createResource(2L, 2, 0L), (Object)Resources.subtract((Resource)this.createResource(3L, 3, 0L), (Resource)this.createResource(1L, 1, 0L)));
        Assertions.assertEquals((Object)this.createResource(1L, 1, 2L), (Object)Resources.subtract((Resource)this.createResource(2L, 2, 3L), (Resource)this.createResource(1L, 1, 1L)));
    }

    @Test
    void testClone() {
        Assertions.assertEquals((Object)this.createResource(1L, 1), (Object)Resources.clone((Resource)this.createResource(1L, 1)));
        Assertions.assertEquals((Object)this.createResource(1L, 1, 0L), (Object)Resources.clone((Resource)this.createResource(1L, 1)));
        Assertions.assertEquals((Object)this.createResource(1L, 1), (Object)Resources.clone((Resource)this.createResource(1L, 1, 0L)));
        Assertions.assertEquals((Object)this.createResource(1L, 1, 2L), (Object)Resources.clone((Resource)this.createResource(1L, 1, 2L)));
    }

    @Test
    void testMultiply() {
        Assertions.assertEquals((Object)this.createResource(4L, 2), (Object)Resources.multiply((Resource)this.createResource(2L, 1), (double)2.0));
        Assertions.assertEquals((Object)this.createResource(4L, 2, 0L), (Object)Resources.multiply((Resource)this.createResource(2L, 1), (double)2.0));
        Assertions.assertEquals((Object)this.createResource(2L, 4), (Object)Resources.multiply((Resource)this.createResource(1L, 2), (double)2.0));
        Assertions.assertEquals((Object)this.createResource(2L, 4, 0L), (Object)Resources.multiply((Resource)this.createResource(1L, 2), (double)2.0));
        Assertions.assertEquals((Object)this.createResource(6L, 6, 0L), (Object)Resources.multiply((Resource)this.createResource(3L, 3, 0L), (double)2.0));
        Assertions.assertEquals((Object)this.createResource(4L, 4, 6L), (Object)Resources.multiply((Resource)this.createResource(2L, 2, 3L), (double)2.0));
    }

    @Test
    @Timeout(value=10000L)
    void testMultiplyRoundUp() {
        double by = 0.5;
        String memoryErrorMsg = "Invalid memory size.";
        String vcoreErrorMsg = "Invalid virtual core number.";
        Resource resource = Resources.createResource((int)1, (int)1);
        Resource result = Resources.multiplyAndRoundUp((Resource)resource, (double)0.5);
        Assertions.assertEquals((long)result.getMemorySize(), (long)1L, (String)"Invalid memory size.");
        Assertions.assertEquals((int)result.getVirtualCores(), (int)1, (String)"Invalid virtual core number.");
        resource = Resources.createResource((int)2, (int)2);
        result = Resources.multiplyAndRoundUp((Resource)resource, (double)0.5);
        Assertions.assertEquals((long)result.getMemorySize(), (long)1L, (String)"Invalid memory size.");
        Assertions.assertEquals((int)result.getVirtualCores(), (int)1, (String)"Invalid virtual core number.");
        resource = Resources.createResource((int)0, (int)0);
        result = Resources.multiplyAndRoundUp((Resource)resource, (double)0.5);
        Assertions.assertEquals((long)result.getMemorySize(), (long)0L, (String)"Invalid memory size.");
        Assertions.assertEquals((int)result.getVirtualCores(), (int)0, (String)"Invalid virtual core number.");
    }

    @Test
    void testMultiplyAndRoundUpCustomResources() {
        Assertions.assertEquals((Object)this.createResource(5L, 2, 8L), (Object)Resources.multiplyAndRoundUp((Resource)this.createResource(3L, 1, 5L), (double)1.5), (String)INVALID_RESOURCE_MSG);
        Assertions.assertEquals((Object)this.createResource(5L, 2, 0L), (Object)Resources.multiplyAndRoundUp((Resource)this.createResource(3L, 1, 0L), (double)1.5), (String)INVALID_RESOURCE_MSG);
        Assertions.assertEquals((Object)this.createResource(5L, 5, 0L), (Object)Resources.multiplyAndRoundUp((Resource)this.createResource(3L, 3, 0L), (double)1.5), (String)INVALID_RESOURCE_MSG);
        Assertions.assertEquals((Object)this.createResource(8L, 3, 13L), (Object)Resources.multiplyAndRoundUp((Resource)this.createResource(3L, 1, 5L), (double)2.5), (String)INVALID_RESOURCE_MSG);
        Assertions.assertEquals((Object)this.createResource(8L, 3, 0L), (Object)Resources.multiplyAndRoundUp((Resource)this.createResource(3L, 1, 0L), (double)2.5), (String)INVALID_RESOURCE_MSG);
        Assertions.assertEquals((Object)this.createResource(8L, 8, 0L), (Object)Resources.multiplyAndRoundUp((Resource)this.createResource(3L, 3, 0L), (double)2.5), (String)INVALID_RESOURCE_MSG);
    }

    @Test
    void testMultiplyAndRoundDown() {
        Assertions.assertEquals((Object)this.createResource(4L, 1), (Object)Resources.multiplyAndRoundDown((Resource)this.createResource(3L, 1), (double)1.5), (String)INVALID_RESOURCE_MSG);
        Assertions.assertEquals((Object)this.createResource(4L, 1, 0L), (Object)Resources.multiplyAndRoundDown((Resource)this.createResource(3L, 1), (double)1.5), (String)INVALID_RESOURCE_MSG);
        Assertions.assertEquals((Object)this.createResource(1L, 4), (Object)Resources.multiplyAndRoundDown((Resource)this.createResource(1L, 3), (double)1.5), (String)INVALID_RESOURCE_MSG);
        Assertions.assertEquals((Object)this.createResource(1L, 4, 0L), (Object)Resources.multiplyAndRoundDown((Resource)this.createResource(1L, 3), (double)1.5), (String)INVALID_RESOURCE_MSG);
        Assertions.assertEquals((Object)this.createResource(7L, 7, 0L), (Object)Resources.multiplyAndRoundDown((Resource)this.createResource(3L, 3, 0L), (double)2.5), (String)INVALID_RESOURCE_MSG);
        Assertions.assertEquals((Object)this.createResource(2L, 2, 7L), (Object)Resources.multiplyAndRoundDown((Resource)this.createResource(1L, 1, 3L), (double)2.5), (String)INVALID_RESOURCE_MSG);
    }

    @Test
    void testMultiplyAndAddTo() throws Exception {
        this.unsetExtraResourceType();
        this.setupExtraResourceType();
        Assertions.assertEquals((Object)this.createResource(6L, 4), (Object)Resources.multiplyAndAddTo((Resource)this.createResource(3L, 1), (Resource)this.createResource(2L, 2), (double)1.5));
        Assertions.assertEquals((Object)this.createResource(6L, 4, 0L), (Object)Resources.multiplyAndAddTo((Resource)this.createResource(3L, 1), (Resource)this.createResource(2L, 2), (double)1.5));
        Assertions.assertEquals((Object)this.createResource(4L, 7), (Object)Resources.multiplyAndAddTo((Resource)this.createResource(1L, 1), (Resource)this.createResource(2L, 4), (double)1.5));
        Assertions.assertEquals((Object)this.createResource(4L, 7, 0L), (Object)Resources.multiplyAndAddTo((Resource)this.createResource(1L, 1), (Resource)this.createResource(2L, 4), (double)1.5));
        Assertions.assertEquals((Object)this.createResource(6L, 4, 0L), (Object)Resources.multiplyAndAddTo((Resource)this.createResource(3L, 1, 0L), (Resource)this.createResource(2L, 2, 0L), (double)1.5));
        Assertions.assertEquals((Object)this.createResource(6L, 4, 6L), (Object)Resources.multiplyAndAddTo((Resource)this.createResource(3L, 1, 2L), (Resource)this.createResource(2L, 2, 3L), (double)1.5));
    }

    @Test
    void testCreateResourceWithSameLongValue() throws Exception {
        this.unsetExtraResourceType();
        this.setupExtraResourceType();
        Resource res = ResourceUtils.createResourceWithSameValue((long)11L);
        Assertions.assertEquals((long)11L, (long)res.getMemorySize());
        Assertions.assertEquals((int)11, (int)res.getVirtualCores());
        Assertions.assertEquals((long)11L, (long)res.getResourceInformation(EXTRA_RESOURCE_TYPE).getValue());
    }

    @Test
    void testCreateResourceWithSameIntValue() throws Exception {
        this.unsetExtraResourceType();
        this.setupExtraResourceType();
        Resource res = ResourceUtils.createResourceWithSameValue((long)11L);
        Assertions.assertEquals((long)11L, (long)res.getMemorySize());
        Assertions.assertEquals((int)11, (int)res.getVirtualCores());
        Assertions.assertEquals((long)11L, (long)res.getResourceInformation(EXTRA_RESOURCE_TYPE).getValue());
    }

    @Test
    void testCreateSimpleResourceWithSameLongValue() {
        Resource res = ResourceUtils.createResourceWithSameValue((long)11L);
        Assertions.assertEquals((long)11L, (long)res.getMemorySize());
        Assertions.assertEquals((int)11, (int)res.getVirtualCores());
    }

    @Test
    void testCreateSimpleResourceWithSameIntValue() {
        Resource res = ResourceUtils.createResourceWithSameValue((long)11L);
        Assertions.assertEquals((long)11L, (long)res.getMemorySize());
        Assertions.assertEquals((int)11, (int)res.getVirtualCores());
    }

    static class ExtendedResources
    extends Resources {
        ExtendedResources() {
        }

        public static Resource unbounded() {
            return new Resources.FixedValueResource("UNBOUNDED", Long.MAX_VALUE);
        }

        public static Resource none() {
            return new Resources.FixedValueResource("NONE", 0L);
        }
    }
}

