/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.yarn.util.TimelineServiceHelper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTimelineServiceHelper {
    @Test
    void testMapCastToHashMap() {
        Map nullMap = null;
        org.junit.jupiter.api.Assertions.assertNull((Object)TimelineServiceHelper.mapCastToHashMap(nullMap));
        HashMap emptyHashMap = new HashMap();
        org.junit.jupiter.api.Assertions.assertEquals((int)TimelineServiceHelper.mapCastToHashMap(emptyHashMap).size(), (int)0);
        TreeMap emptyTreeMap = new TreeMap();
        org.junit.jupiter.api.Assertions.assertEquals((int)TimelineServiceHelper.mapCastToHashMap(emptyTreeMap).size(), (int)0);
        HashMap<String, String> firstHashMap = new HashMap<String, String>();
        String key = "KEY";
        String value = "VALUE";
        firstHashMap.put(key, value);
        org.junit.jupiter.api.Assertions.assertEquals((Object)TimelineServiceHelper.mapCastToHashMap(firstHashMap), firstHashMap);
        TreeMap<String, String> firstTreeMap = new TreeMap<String, String>();
        firstTreeMap.put(key, value);
        HashMap alternateHashMap = TimelineServiceHelper.mapCastToHashMap(firstTreeMap);
        org.junit.jupiter.api.Assertions.assertEquals((int)firstTreeMap.size(), (int)alternateHashMap.size());
        Assertions.assertThat((String)((String)alternateHashMap.get(key))).isEqualTo((Object)value);
        HashMap complicatedHashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(value);
        complicatedHashMap.put(key, hashSet);
        org.junit.jupiter.api.Assertions.assertEquals((Object)TimelineServiceHelper.mapCastToHashMap(complicatedHashMap), complicatedHashMap);
        TreeMap<String, HashSet<String>> complicatedTreeMap = new TreeMap<String, HashSet<String>>();
        complicatedTreeMap.put(key, hashSet);
        org.junit.jupiter.api.Assertions.assertEquals(TimelineServiceHelper.mapCastToHashMap(complicatedTreeMap).get(key), hashSet);
    }
}

