/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.yarn.util.RackResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRackResolver {
    private static final Logger LOG = LoggerFactory.getLogger(TestRackResolver.class);
    private static final String invalidHost = "invalidHost";

    @BeforeEach
    public void setUp() {
        RackResolver.reset();
    }

    @Test
    void testCaching() {
        Configuration conf = new Configuration();
        conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
        RackResolver.init((Configuration)conf);
        try {
            InetAddress iaddr = InetAddress.getByName("host1");
            MyResolver.resolvedHost1 = iaddr.getHostAddress();
        }
        catch (UnknownHostException iaddr) {
            // empty catch block
        }
        Node node = RackResolver.resolve((String)"host1");
        Assertions.assertEquals((Object)"/rack1", (Object)node.getNetworkLocation());
        node = RackResolver.resolve((String)"host1");
        Assertions.assertEquals((Object)"/rack1", (Object)node.getNetworkLocation());
        node = RackResolver.resolve((String)invalidHost);
        Assertions.assertEquals((Object)"/default-rack", (Object)node.getNetworkLocation());
    }

    @Test
    void testMultipleHosts() {
        Configuration conf = new Configuration();
        conf.setClass("net.topology.node.switch.mapping.impl", MultipleResolver.class, DNSToSwitchMapping.class);
        RackResolver.init((Configuration)conf);
        List nodes = RackResolver.resolve(Arrays.asList("host1", invalidHost, "host2"));
        Assertions.assertEquals((Object)"/rack1", (Object)((Node)nodes.get(0)).getNetworkLocation());
        Assertions.assertEquals((Object)"/default-rack", (Object)((Node)nodes.get(1)).getNetworkLocation());
        Assertions.assertEquals((Object)"/rack2", (Object)((Node)nodes.get(2)).getNetworkLocation());
    }

    public static final class MultipleResolver
    implements DNSToSwitchMapping {
        public List<String> resolve(List<String> hostList) {
            ArrayList<String> returnList = new ArrayList<String>();
            if (hostList.isEmpty()) {
                return returnList;
            }
            for (String host : hostList) {
                if (host.equals(TestRackResolver.invalidHost)) {
                    returnList.add("");
                }
                LOG.info("Received resolve request for " + host);
                if (!host.startsWith("host")) continue;
                returnList.add("/" + host.replace("host", "rack"));
            }
            Assertions.assertEquals((int)returnList.size(), (int)hostList.size());
            return returnList;
        }

        public void reloadCachedMappings() {
        }

        public void reloadCachedMappings(List<String> names) {
        }
    }

    public static final class MyResolver
    implements DNSToSwitchMapping {
        int numHost1 = 0;
        public static String resolvedHost1 = "host1";

        public List<String> resolve(List<String> hostList) {
            Assertions.assertTrue((hostList.size() <= 1 ? 1 : 0) != 0, (String)("hostList size is " + hostList.size()));
            ArrayList<String> returnList = new ArrayList<String>();
            if (hostList.isEmpty()) {
                return returnList;
            }
            if (hostList.get(0).equals(TestRackResolver.invalidHost)) {
                return null;
            }
            LOG.info("Received resolve request for " + hostList.get(0));
            if (hostList.get(0).equals("host1") || hostList.get(0).equals(resolvedHost1)) {
                ++this.numHost1;
                returnList.add("/rack1");
            }
            Assertions.assertTrue((this.numHost1 <= 1 ? 1 : 0) != 0);
            return returnList;
        }

        public void reloadCachedMappings() {
        }

        public void reloadCachedMappings(List<String> names) {
        }
    }
}

